/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.grindstone;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.GrindstoneScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.GrindstoneMenu;
import net.minecraft.world.inventory.Slot;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.util.LegacySprites;

@Mixin(value={GrindstoneScreen.class})
public abstract class GrindstoneScreenMixin
extends AbstractContainerScreen<GrindstoneMenu> {
    private static final LegacySlotDisplay SLOTS_DISPLAY = new LegacySlotDisplay(){

        @Override
        public int getWidth() {
            return 30;
        }
    };

    public GrindstoneScreenMixin(GrindstoneMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
    }

    protected void init() {
        this.imageWidth = 207;
        this.imageHeight = 215;
        this.inventoryLabelX = 10;
        this.inventoryLabelY = 105;
        this.titleLabelX = 10;
        this.titleLabelY = 11;
        super.init();
        for (int i = 0; i < ((GrindstoneMenu)this.menu).slots.size(); ++i) {
            Slot s = (Slot)((GrindstoneMenu)this.menu).slots.get(i);
            if (i == 0) {
                LegacySlotDisplay.override(s, 41, 30, SLOTS_DISPLAY);
                continue;
            }
            if (i == 1) {
                LegacySlotDisplay.override(s, 41, 65, SLOTS_DISPLAY);
                continue;
            }
            if (i == 2) {
                LegacySlotDisplay.override(s, 138, 46, SLOTS_DISPLAY);
                continue;
            }
            if (i < ((GrindstoneMenu)this.menu).slots.size() - 9) {
                LegacySlotDisplay.override(s, 10 + (s.getContainerSlot() - 9) % 9 * 21, 116 + (s.getContainerSlot() - 9) / 9 * 21);
                continue;
            }
            LegacySlotDisplay.override(s, 10 + s.getContainerSlot() * 21, 185);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBg(guiGraphics, f, i, j);
    }

    @Inject(method={"renderBg"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderBg(GuiGraphics guiGraphics, float f, int i, int j, CallbackInfo ci) {
        ci.cancel();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite((ResourceLocation)UIAccessor.of((Screen)this).getElementValue("imageSprite", (Object)LegacySprites.SMALL_PANEL, ResourceLocation.class), this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)(this.leftPos + 85), (float)(this.topPos + 50), 0.0f);
        guiGraphics.pose().scale(1.5f, 1.5f, 1.5f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.ARROW, 0, 0, 22, 15);
        if ((((GrindstoneMenu)this.menu).getSlot(0).hasItem() || ((GrindstoneMenu)this.menu).getSlot(1).hasItem()) && !((GrindstoneMenu)this.menu).getSlot(2).hasItem()) {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.ERROR_CROSS, 2, 0, 15, 15);
        }
        guiGraphics.pose().popPose();
    }
}

