/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.inventory;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.HorseInventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.HorseInventoryMenu;
import net.minecraft.world.inventory.Slot;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

@Mixin(value={HorseInventoryScreen.class})
public abstract class HorseInventoryScreenMixin
extends AbstractContainerScreen<HorseInventoryMenu> {
    @Shadow
    @Final
    private AbstractHorse horse;

    public HorseInventoryScreenMixin(HorseInventoryMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
    }

    public void init() {
        this.imageWidth = 215;
        this.imageHeight = 203;
        this.inventoryLabelX = 14;
        this.inventoryLabelY = 91;
        this.titleLabelX = 14;
        this.titleLabelY = 8;
        super.init();
        for (int i = 0; i < ((HorseInventoryMenu)this.menu).slots.size(); ++i) {
            final Slot s = (Slot)((HorseInventoryMenu)this.menu).slots.get(i);
            if (i == 0) {
                LegacySlotDisplay.override(s, 14, 21, new LegacySlotDisplay(){

                    @Override
                    public ResourceLocation getIconSprite() {
                        return s.getItem().isEmpty() ? LegacySprites.SADDLE_SLOT : null;
                    }
                });
                continue;
            }
            if (i == 1) {
                LegacySlotDisplay.override(s, 14, 42, new LegacySlotDisplay(){

                    @Override
                    public ResourceLocation getIconSprite() {
                        return s.getItem().isEmpty() ? (HorseInventoryScreenMixin.this.horse instanceof Llama ? LegacySprites.LLAMA_ARMOR_SLOT : LegacySprites.ARMOR_SLOT) : null;
                    }
                });
                continue;
            }
            if (i < ((HorseInventoryMenu)this.menu).slots.size() - 36) {
                int slotOffset = s.getContainerSlot() - 2;
                LegacySlotDisplay.override(s, 98 + slotOffset % ((AbstractChestedHorse)this.horse).getInventoryColumns() * 21, 21 + slotOffset / ((AbstractChestedHorse)this.horse).getInventoryColumns() * 21);
                continue;
            }
            if (i < ((HorseInventoryMenu)this.menu).slots.size() - 9) {
                LegacySlotDisplay.override(s, 14 + (s.getContainerSlot() - 9) % 9 * 21, 104 + (s.getContainerSlot() - 9) / 9 * 21);
                continue;
            }
            LegacySlotDisplay.override(s, 14 + s.getContainerSlot() * 21, 174);
        }
    }

    @Inject(method={"renderBg"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderBg(GuiGraphics graphics, float f, int i, int j, CallbackInfo ci) {
        ci.cancel();
        FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite((ResourceLocation)UIAccessor.of((Screen)this).getElementValue("imageSprite", (Object)LegacySprites.SMALL_PANEL, ResourceLocation.class), this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(LegacySprites.SQUARE_ENTITY_PANEL, this.leftPos + 34, this.topPos + 20, 63, 63);
        FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.leftPos + 97, this.topPos + 20, 105, 63);
        ScreenUtil.renderEntityInInventoryFollowsMouse(graphics, this.leftPos + 35, this.topPos + 21, this.leftPos + 95, this.topPos + 81, 25, 0.0625f, i, j, (LivingEntity)this.horse);
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBg(guiGraphics, f, i, j);
    }
}

