/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.loom;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.LoomScreen;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.LoomMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BannerPattern;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

@Mixin(value={LoomScreen.class})
public abstract class LoomScreenMixin
extends AbstractContainerScreen<LoomMenu> {
    @Shadow
    private boolean hasMaxPatterns;
    @Shadow
    private boolean displayPatterns;
    @Shadow
    private int startRow;
    @Shadow
    private ModelPart flag;
    @Shadow
    private boolean scrolling;
    @Shadow
    @Nullable
    private List<Pair<Holder<BannerPattern>, DyeColor>> resultBannerPatterns;
    private LegacyScrollRenderer scrollRenderer = new LegacyScrollRenderer();

    @Shadow
    protected abstract void renderPattern(GuiGraphics var1, Holder<BannerPattern> var2, int var3, int var4);

    @Shadow
    protected abstract int totalRowCount();

    public LoomScreenMixin(LoomMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
    }

    @Inject(method={"init"}, at={@At(value="HEAD")}, cancellable=true)
    public void init(CallbackInfo ci) {
        ci.cancel();
        this.imageWidth = 215;
        this.imageHeight = 217;
        this.inventoryLabelX = 14;
        this.inventoryLabelY = 104;
        this.titleLabelX = 14;
        this.titleLabelY = 10;
        super.init();
        for (int i = 0; i < ((LoomMenu)this.menu).slots.size(); ++i) {
            final Slot s = (Slot)((LoomMenu)this.menu).slots.get(i);
            if (i == 0) {
                LegacySlotDisplay.override(s, 19, 41, new LegacySlotDisplay(){

                    @Override
                    public int getWidth() {
                        return 23;
                    }

                    @Override
                    public ResourceLocation getIconSprite() {
                        return s.hasItem() ? null : LegacySprites.BANNER_SLOT;
                    }
                });
                continue;
            }
            if (i == 1) {
                LegacySlotDisplay.override(s, 45, 41, new LegacySlotDisplay(){

                    @Override
                    public int getWidth() {
                        return 23;
                    }

                    @Override
                    public ResourceLocation getIconSprite() {
                        return s.hasItem() ? null : LegacySprites.DYE_SLOT;
                    }
                });
                continue;
            }
            if (i == 2) {
                LegacySlotDisplay.override(s, 32, 66, new LegacySlotDisplay(){

                    @Override
                    public int getWidth() {
                        return 23;
                    }

                    @Override
                    public ResourceLocation getIconSprite() {
                        return s.hasItem() ? null : LegacySprites.PATTERN_SLOT;
                    }
                });
                continue;
            }
            if (i == 3) {
                LegacySlotDisplay.override(s, 166, 75, new LegacySlotDisplay(){

                    @Override
                    public int getWidth() {
                        return 32;
                    }
                });
                continue;
            }
            if (i < ((LoomMenu)this.menu).slots.size() - 9) {
                LegacySlotDisplay.override(s, 14 + (s.getContainerSlot() - 9) % 9 * 21, 115 + (s.getContainerSlot() - 9) / 9 * 21);
                continue;
            }
            LegacySlotDisplay.override(s, 14 + s.getContainerSlot() * 21, 185);
        }
        this.flag = this.minecraft.getEntityModels().bakeLayer(ModelLayers.BANNER).getChild("flag");
    }

    @Redirect(method={"renderPattern"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;scale(FFF)V", ordinal=1))
    private void renderPattern(PoseStack instance, float posestack$pose, float f, float f1) {
        instance.scale(1.0f, -1.0f, -1.0f);
    }

    @Redirect(method={"renderPattern"}, at=@At(value="NEW", target="()Lcom/mojang/blaze3d/vertex/PoseStack;"))
    private PoseStack renderPattern(GuiGraphics graphics) {
        return graphics.pose();
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBg(guiGraphics, f, i, j);
    }

    @Inject(method={"renderBg"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderBg(GuiGraphics guiGraphics, float f, int i, int j, CallbackInfo ci) {
        ci.cancel();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite((ResourceLocation)UIAccessor.of((Screen)this).getElementValue("imageSprite", (Object)LegacySprites.SMALL_PANEL, ResourceLocation.class), this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.leftPos + 72, this.topPos + 18, 75, 75);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.leftPos + 164.5f, (float)(this.topPos + 7), 0.0f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, 0, 0, 32, 64);
        guiGraphics.pose().popPose();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((double)this.leftPos + 149.5, (double)(this.topPos + 18), 0.0);
        if (this.displayPatterns && ((LoomMenu)this.menu).getSelectablePatterns().size() > 4) {
            if (this.startRow != this.totalRowCount() - 4) {
                this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.DOWN, 0, 79);
            }
            if (this.startRow > 0) {
                this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.UP, 0, -11);
            }
        } else {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setColor(1.0f, 1.0f, 1.0f, 0.5f);
        }
        FactoryScreenUtil.enableBlend();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, 0, 0, 13, 75);
        guiGraphics.pose().translate(-2.0f, -1.0f + (((LoomMenu)this.menu).getSelectablePatterns().size() > 4 && this.displayPatterns ? 61.5f * (float)this.startRow / (float)(this.totalRowCount() - 4) : 0.0f), 0.0f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.PANEL, 0, 0, 16, 16);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        FactoryScreenUtil.disableBlend();
        guiGraphics.pose().popPose();
        Lighting.setupForFlatItems();
        if (this.resultBannerPatterns != null && !this.hasMaxPatterns) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)this.leftPos + 168.5f, (float)(this.topPos + 69), 0.0f);
            guiGraphics.pose().scale(24.0f, -24.0f, 1.0f);
            guiGraphics.pose().translate(0.5f, 0.5f, 0.5f);
            guiGraphics.pose().scale(1.0f, -1.0f, -1.0f);
            this.flag.xRot = 0.0f;
            this.flag.y = -32.0f;
            BannerRenderer.renderPatterns((PoseStack)guiGraphics.pose(), (MultiBufferSource)FactoryGuiGraphics.of((GuiGraphics)guiGraphics).getBufferSource(), (int)0xF000F0, (int)OverlayTexture.NO_OVERLAY, (ModelPart)this.flag, (Material)ModelBakery.BANNER_BASE, (boolean)true, this.resultBannerPatterns);
            guiGraphics.pose().popPose();
            guiGraphics.flush();
        } else if (this.hasMaxPatterns) {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.LOOM_ERROR, this.leftPos + ((Slot)((LoomMenu)this.menu).slots.get((int)3)).x - 5, this.topPos + ((Slot)((LoomMenu)this.menu).slots.get((int)3)).y - 5, 26, 26);
        }
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.leftPos + 73.5f, (float)this.topPos + 19.5f, 0.0f);
        if (this.displayPatterns) {
            List list = ((LoomMenu)this.menu).getSelectablePatterns();
            block0: for (int p = 0; p < 4; ++p) {
                for (int q = 0; q < 4; ++q) {
                    int r = p + this.startRow;
                    int s = r * 4 + q;
                    if (s >= list.size()) break block0;
                    int t = q * 18;
                    int u = p * 18;
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(s == ((LoomMenu)this.menu).getSelectedBannerPatternIndex() ? LegacySprites.BUTTON_SLOT_SELECTED : (ScreenUtil.isMouseOver(i, j, (float)this.leftPos + 73.5f + (float)t, (float)this.topPos + 19.5f + (float)u, 18, 18) ? LegacySprites.BUTTON_SLOT_HIGHLIGHTED : LegacySprites.BUTTON_SLOT), t, u, 18, 18);
                    guiGraphics.pose().pushPose();
                    this.renderPattern(guiGraphics, (Holder<BannerPattern>)((Holder)list.get(s)), t + 3, u + 3);
                    guiGraphics.pose().popPose();
                }
            }
        }
        guiGraphics.pose().popPose();
        Lighting.setupFor3DItems();
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    public void mouseClicked(double d, double e, int i, CallbackInfoReturnable<Boolean> cir) {
        this.scrolling = false;
        if (this.displayPatterns) {
            double j = (float)this.leftPos + 73.5f;
            double k = (float)this.topPos + 19.5f;
            for (int l = 0; l < 4; ++l) {
                for (int m = 0; m < 4; ++m) {
                    double f = d - (j + (double)(m * 18));
                    double g = e - (k + (double)(l * 18));
                    int n = l + this.startRow;
                    int o = n * 4 + m;
                    if (!(f >= 0.0 && g >= 0.0 && f < 18.0 && g < 18.0 && ((LoomMenu)this.menu).clickMenuButton((Player)this.minecraft.player, o))) continue;
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_LOOM_SELECT_PATTERN, (float)1.0f));
                    this.minecraft.gameMode.handleInventoryButtonClick(((LoomMenu)this.menu).containerId, o);
                    cir.setReturnValue((Object)true);
                    return;
                }
            }
            if (ScreenUtil.isMouseOver(d, e, (double)this.leftPos + 149.5, this.topPos + 18, 13, 75)) {
                this.scrolling = true;
            }
        }
        cir.setReturnValue((Object)super.mouseClicked(d, e, i));
    }

    @Inject(method={"mouseDragged"}, at={@At(value="HEAD")}, cancellable=true)
    public void mouseDragged(double d, double e, int i, double f, double g, CallbackInfoReturnable<Boolean> cir) {
        int j = this.totalRowCount() - 4;
        if (this.scrolling && this.displayPatterns && j > 0) {
            int oldRow = this.startRow;
            this.startRow = (int)Math.max(Math.round((double)j * Math.min(1.0, (e - (double)(this.topPos + 18)) / 75.0)), 0L);
            if (oldRow != this.startRow) {
                this.scrollRenderer.updateScroll(oldRow - this.startRow > 0 ? ScreenDirection.UP : ScreenDirection.DOWN);
            }
            cir.setReturnValue((Object)true);
            return;
        }
        cir.setReturnValue((Object)super.mouseDragged(d, e, i, f, g));
    }

    @Redirect(method={"mouseScrolled"}, at=@At(value="FIELD", target="Lnet/minecraft/client/gui/screens/inventory/LoomScreen;startRow:I"))
    private void mouseScrolled(LoomScreen instance, int value) {
        if (this.startRow != value) {
            this.scrollRenderer.updateScroll(this.startRow - value > 0 ? ScreenDirection.UP : ScreenDirection.DOWN);
            this.startRow = value;
        }
    }
}

