/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.smithing;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CyclingSlotBackground;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.ItemCombinerScreen;
import net.minecraft.client.gui.screens.inventory.SmithingScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SmithingMenu;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.util.LegacySprites;

@Mixin(value={SmithingScreen.class})
public abstract class SmithingScreenMixin
extends ItemCombinerScreen<SmithingMenu> {
    @Shadow
    @Final
    private static Vector3f ARMOR_STAND_TRANSLATION;
    @Shadow
    @Final
    private static Quaternionf ARMOR_STAND_ANGLE;
    @Shadow
    private ArmorStand armorStandPreview;
    @Shadow
    @Final
    private CyclingSlotBackground templateIcon;
    @Shadow
    @Final
    private CyclingSlotBackground baseIcon;
    @Shadow
    @Final
    private CyclingSlotBackground additionalIcon;
    private static final LegacySlotDisplay SLOTS_DISPLAY;

    @Shadow
    protected abstract boolean hasRecipeError();

    public SmithingScreenMixin(SmithingMenu itemCombinerMenu, Inventory inventory, Component component, ResourceLocation resourceLocation) {
        super((ItemCombinerMenu)itemCombinerMenu, inventory, component, resourceLocation);
    }

    public void init() {
        this.imageWidth = 207;
        this.imageHeight = 215;
        this.inventoryLabelX = 10;
        this.inventoryLabelY = 105;
        this.titleLabelX = 56;
        this.titleLabelY = 25;
        super.init();
        for (int i = 0; i < ((SmithingMenu)this.menu).slots.size(); ++i) {
            Slot s = (Slot)((SmithingMenu)this.menu).slots.get(i);
            if (i == 0) {
                LegacySlotDisplay.override(s, 10, 60);
                continue;
            }
            if (i == 1) {
                LegacySlotDisplay.override(s, 31, 60);
                continue;
            }
            if (i == 2) {
                LegacySlotDisplay.override(s, 52, 60);
                continue;
            }
            if (i == 3) {
                LegacySlotDisplay.override(s, 127, 56, SLOTS_DISPLAY);
                continue;
            }
            if (i < ((SmithingMenu)this.menu).slots.size() - 9) {
                LegacySlotDisplay.override(s, 10 + (s.getContainerSlot() - 9) % 9 * 21, 116 + (s.getContainerSlot() - 9) / 9 * 21);
                continue;
            }
            LegacySlotDisplay.override(s, 10 + s.getContainerSlot() * 21, 185);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBg(guiGraphics, f, i, j);
    }

    @Inject(method={"renderBg"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderBg(GuiGraphics guiGraphics, float f, int i, int j, CallbackInfo ci) {
        ci.cancel();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite((ResourceLocation)UIAccessor.of((Screen)this).getElementValue("imageSprite", (Object)LegacySprites.SMALL_PANEL, ResourceLocation.class), this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((double)this.leftPos + 13.5, (double)this.topPos + 9.5, 0.0);
        guiGraphics.pose().scale(2.5f, 2.5f, 2.5f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SMITHING_HAMMER, 0, 0, 15, 15);
        guiGraphics.pose().popPose();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)(this.leftPos + 82), (float)(this.topPos + 59), 0.0f);
        guiGraphics.pose().scale(1.5f, 1.5f, 1.5f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.ARROW, 0, 0, 22, 15);
        if (this.hasRecipeError()) {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.ERROR_CROSS, 4, 0, 15, 15);
        }
        guiGraphics.pose().popPose();
        InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (float)(this.leftPos + 182), (float)(this.topPos + 95), (int)35, (Vector3f)ARMOR_STAND_TRANSLATION, (Quaternionf)ARMOR_STAND_ANGLE, null, (LivingEntity)this.armorStandPreview);
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/ItemCombinerScreen;render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", shift=At.Shift.AFTER)})
    public void render(GuiGraphics guiGraphics, int i, int j, float f, CallbackInfo ci) {
        this.templateIcon.render(this.menu, guiGraphics, f, this.leftPos, this.topPos);
        this.baseIcon.render(this.menu, guiGraphics, f, this.leftPos, this.topPos);
        this.additionalIcon.render(this.menu, guiGraphics, f, this.leftPos, this.topPos);
    }

    static {
        SLOTS_DISPLAY = new LegacySlotDisplay(){

            @Override
            public int getWidth() {
                return 30;
            }
        };
    }
}

