/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.piston;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.util.CompoundTagUtil;
import wily.legacy.inventory.LegacyPistonMovingBlockEntity;

@Mixin(value={PistonMovingBlockEntity.class})
public class PistonMovingBlockEntityMixin
extends BlockEntity
implements LegacyPistonMovingBlockEntity {
    @Shadow
    private boolean isSourcePiston;
    @Shadow
    private BlockState movedState;
    @Unique
    CompoundTag movedBeTag;
    @Unique
    BlockEntity movingRendererBlockEntity;
    @Unique
    BlockEntityType<?> movingBlockEntityType;

    public PistonMovingBlockEntityMixin(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;I)Z", shift=At.Shift.AFTER)})
    private static void tick(Level level, BlockPos blockPos, BlockState blockState, PistonMovingBlockEntity pistonMovingBlockEntity, CallbackInfo ci) {
        if (pistonMovingBlockEntity instanceof LegacyPistonMovingBlockEntity) {
            LegacyPistonMovingBlockEntity be = (LegacyPistonMovingBlockEntity)pistonMovingBlockEntity;
            be.load();
        }
    }

    @Inject(method={"finalTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;I)Z", shift=At.Shift.AFTER)})
    private void tick(CallbackInfo ci) {
        if (!this.isSourcePiston) {
            this.load();
        }
    }

    @Inject(method={"load"}, at={@At(value="RETURN")})
    protected void load(CompoundTag compoundTag, CallbackInfo ci) {
        CompoundTag newMovedBeTag = CompoundTagUtil.getCompoundTagOrEmpty((CompoundTag)compoundTag, (String)"movedBlockEntityTag");
        CompoundTagUtil.getString((CompoundTag)compoundTag, (String)"movedBlockEntityType").map(FactoryAPI::createLocation).ifPresent(beTypeId -> {
            this.movingBlockEntityType = (BlockEntityType)FactoryAPIPlatform.getRegistryValue((ResourceLocation)beTypeId, (Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE);
        });
        if (!newMovedBeTag.isEmpty()) {
            this.movedBeTag = newMovedBeTag;
            if (this.hasLevel() && this.getLevel().isClientSide() && this.movingBlockEntityType != null) {
                this.createRenderingBlockEntity(this.getLevel());
            }
        }
    }

    @Inject(method={"saveAdditional"}, at={@At(value="RETURN")})
    protected void saveAdditional(CompoundTag compoundTag, CallbackInfo ci) {
        if (this.movedBeTag != null) {
            compoundTag.put("movedBlockEntityTag", (Tag)this.movedBeTag);
        }
        if (this.movingBlockEntityType != null) {
            compoundTag.putString("movedBlockEntityType", BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey(this.movingBlockEntityType).toString());
        }
    }

    @Override
    public CompoundTag getMovedBlockEntityTag() {
        return this.movedBeTag;
    }

    @Override
    public void setMovedBlockEntityTag(CompoundTag tag) {
        this.movedBeTag = tag;
    }

    @Override
    public BlockEntity getRenderingBlockEntity() {
        return this.movingRendererBlockEntity;
    }

    @Override
    public void setRenderingBlockEntity(BlockEntity entity) {
        this.movingRendererBlockEntity = entity;
        this.load(this.movingRendererBlockEntity);
    }

    @Override
    public BlockEntityType<?> getMovingBlockEntityType() {
        return this.movingBlockEntityType;
    }

    @Override
    public void setMovingBlockEntityType(BlockEntityType<?> type) {
        this.movingBlockEntityType = type;
    }

    @Override
    public void createRenderingBlockEntity(Level level) {
        BlockEntity entity = this.movingBlockEntityType.create(this.getBlockPos(), this.movedState);
        entity.setLevel(level);
        this.setRenderingBlockEntity(entity);
    }
}

