/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import wily.factoryapi.base.network.CommonNetwork;
import wily.legacy.Legacy4J;

public record ClientAnimalInLoveSyncPayload(int entityID, int inLove, int age) implements CommonNetwork.Payload
{
    public static final CommonNetwork.Identifier<ClientAnimalInLoveSyncPayload> ID = CommonNetwork.Identifier.create((ResourceLocation)Legacy4J.createModLocation("client_in_love"), ClientAnimalInLoveSyncPayload::new);

    public ClientAnimalInLoveSyncPayload(CommonNetwork.PlayBuf buf) {
        this(((FriendlyByteBuf)buf.get()).readVarInt(), ((FriendlyByteBuf)buf.get()).readVarInt(), ((FriendlyByteBuf)buf.get()).readVarInt());
    }

    public static ClientAnimalInLoveSyncPayload of(Animal animal) {
        return new ClientAnimalInLoveSyncPayload(animal.getId(), animal.getInLoveTime(), animal.getAge());
    }

    public static void sync(Animal entity) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            ClientAnimalInLoveSyncPayload packet = null;
            for (ServerPlayer player : l.getServer().getPlayerList().getPlayers()) {
                if (player.level() != entity.level() || !(player.distanceTo((Entity)entity) < (float)(l.getServer().getPlayerList().getViewDistance() * 16))) continue;
                CommonNetwork.sendToPlayer((ServerPlayer)player, packet == null ? ClientAnimalInLoveSyncPayload.of(entity) : packet);
            }
        }
    }

    public void encode(CommonNetwork.PlayBuf buf) {
        ((FriendlyByteBuf)buf.get()).writeVarInt(this.entityID());
        ((FriendlyByteBuf)buf.get()).writeVarInt(this.inLove);
        ((FriendlyByteBuf)buf.get()).writeVarInt(this.age);
    }

    public void apply(CommonNetwork.Payload.Context context) {
        Entity entity = context.player().level().getEntity(this.entityID);
        if (entity instanceof Animal) {
            Animal e = (Animal)entity;
            e.setInLoveTime(this.inLove);
            e.setAge(this.age);
        }
    }

    public CommonNetwork.Identifier<? extends CommonNetwork.Payload> identifier() {
        return ID;
    }
}

