/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.google.common.hash.Hashing;
import com.google.common.io.ByteSource;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.util.DynamicUtil;
import wily.legacy.Legacy4J;
import wily.legacy.util.JsonUtil;

public record LegacyWorldTemplate(Component buttonMessage, ResourceLocation icon, String worldTemplate, String folderName, boolean directJoin, boolean isLocked, boolean isGamePath, Optional<URI> downloadURI, Optional<String> checkSum) {
    public static final Codec<LegacyWorldTemplate> CODEC = RecordCodecBuilder.create(i -> i.group((App)DynamicUtil.getComponentCodec().fieldOf("buttonMessage").forGetter(LegacyWorldTemplate::buttonMessage), (App)ResourceLocation.CODEC.fieldOf("icon").forGetter(LegacyWorldTemplate::icon), (App)Codec.STRING.fieldOf("templateLocation").forGetter(LegacyWorldTemplate::worldTemplate), (App)Codec.STRING.fieldOf("folderName").forGetter(LegacyWorldTemplate::folderName), (App)Codec.BOOL.fieldOf("directJoin").orElse((Object)false).forGetter(LegacyWorldTemplate::directJoin), (App)Codec.BOOL.fieldOf("isLocked").orElse((Object)true).forGetter(LegacyWorldTemplate::isLocked), (App)Codec.BOOL.fieldOf("isGamePath").orElse((Object)false).forGetter(LegacyWorldTemplate::isGamePath), (App)Codec.STRING.xmap(URI::create, URI::toString).optionalFieldOf("downloadURI").forGetter(LegacyWorldTemplate::downloadURI)).apply((Applicative)i, LegacyWorldTemplate::create));
    public static final List<LegacyWorldTemplate> list = new ArrayList<LegacyWorldTemplate>();
    private static final String TEMPLATES = "world_templates.json";

    public static LegacyWorldTemplate create(Component buttonMessage, ResourceLocation icon, String worldTemplate, String folderName, boolean directJoin, boolean isLocked, boolean isGamePath, Optional<URI> compoundDownloadURI) {
        Optional<String[]> splitURI = compoundDownloadURI.map(u -> u.toString().split("\\?checksum="));
        return new LegacyWorldTemplate(buttonMessage, icon, worldTemplate, folderName, directJoin, isLocked, isGamePath, splitURI.map(s -> URI.create(s[0])), splitURI.map(s -> ((String[])s).length < 2 ? null : s[1]));
    }

    public Path getPath() {
        return Minecraft.getInstance().gameDirectory.toPath().resolve(this.worldTemplate);
    }

    public InputStream open() {
        try {
            return this.isGamePath ? new FileInputStream(this.getPath().toString()) : Minecraft.getInstance().getResourceManager().open(FactoryAPI.createLocation((String)this.worldTemplate));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void downloadToPathIfPossible() {
        String checksum;
        if (!this.isGamePath || this.downloadURI.isEmpty()) {
            return;
        }
        Path path = this.getPath();
        boolean exists = Files.exists(path, new LinkOption[0]);
        if (exists && this.checkSum().isEmpty() || exists && this.checkSum().get().equals(this.readFileCheckSum(path)) || (checksum = this.readCheckSum(path)) == null || !this.checkSum().get().equals(checksum)) {
            return;
        }
        try (InputStream stream = this.downloadURI.get().toURL().openStream();){
            if (exists) {
                Files.delete(path);
            }
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.copy(stream, path, new CopyOption[0]);
        }
        catch (IOException e) {
            Legacy4J.LOGGER.warn("Error when downloading world template to path {}: {}", (Object)path, (Object)e.getMessage());
        }
    }

    public String readCheckSum(Path path) {
        String string;
        BufferedReader reader = new BufferedReader(new InputStreamReader(URI.create(String.valueOf(this.downloadURI.get()) + ".md5").toURL().openStream()));
        try {
            string = reader.readLine().trim();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Legacy4J.LOGGER.warn("Error when reading checksum from world template {}: {}", (Object)path, (Object)e.getMessage());
                return null;
            }
        }
        reader.close();
        return string;
    }

    public String readFileCheckSum(Path path) {
        ByteSource byteSource = com.google.common.io.Files.asByteSource((File)path.toFile());
        try {
            return byteSource.hash(Hashing.md5()).toString();
        }
        catch (IOException e) {
            Legacy4J.LOGGER.warn("Error when reading existing checksum from world template {}: {}", (Object)path, (Object)e.getMessage());
            return null;
        }
    }

    public static class Manager
    implements ResourceManagerReloadListener {
        public void onResourceManagerReload(ResourceManager resourceManager) {
            list.clear();
            JsonUtil.getOrderedNamespaces(resourceManager).forEach(name -> resourceManager.getResource(FactoryAPI.createLocation((String)name, (String)LegacyWorldTemplate.TEMPLATES)).ifPresent(r -> {
                try (BufferedReader bufferedReader = r.openAsReader();){
                    JsonElement element = JsonParser.parseReader((Reader)bufferedReader);
                    if (element instanceof JsonObject) {
                        JsonObject obj = (JsonObject)element;
                        Legacy4J.LOGGER.warn("The World Template {} is using a deprecated syntax, please contact this resource creator or try updating it.", (Object)(name + ":world_templates.json"));
                        obj.asMap().forEach((s, e) -> {
                            if (e instanceof JsonObject) {
                                JsonObject tabObj = (JsonObject)e;
                                list.add(LegacyWorldTemplate.create((Component)Component.translatable((String)s), FactoryAPI.createLocation((String)GsonHelper.getAsString((JsonObject)tabObj, (String)"icon")), GsonHelper.getAsString((JsonObject)tabObj, (String)"templateLocation"), GsonHelper.getAsString((JsonObject)tabObj, (String)"folderName"), GsonHelper.getAsBoolean((JsonObject)tabObj, (String)"directJoin", (boolean)false), true, false, Optional.empty()));
                            }
                        });
                    } else if (element instanceof JsonArray) {
                        JsonArray a = (JsonArray)element;
                        a.forEach(e -> CODEC.parse((DynamicOps)JsonOps.INSTANCE, e).result().ifPresent(w -> {
                            w.downloadToPathIfPossible();
                            list.add((LegacyWorldTemplate)w);
                        }));
                    }
                }
                catch (IOException var8) {
                    Legacy4J.LOGGER.warn(var8.getMessage());
                }
            }));
        }

        public String getName() {
            return "legacy:world_template";
        }
    }
}

