/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ReferenceLinkedOpenHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ItemSteerable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.EggItem;
import net.minecraft.world.item.EmptyMapItem;
import net.minecraft.world.item.EnderEyeItem;
import net.minecraft.world.item.EnderpearlItem;
import net.minecraft.world.item.ExperienceBottleItem;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.FoodOnAStickItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LeadItem;
import net.minecraft.world.item.NameTagItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SnowballItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.SpyglassItem;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipePropertySet;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DropperBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.PumpkinBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import wily.factoryapi.FactoryEvent;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.util.FactoryItemUtil;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.ControlType;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacyTipManager;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.controller.LegacyKeyMapping;
import wily.legacy.client.screen.LegacyMenuAccess;
import wily.legacy.util.JsonUtil;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.ScreenUtil;

public interface ControlTooltip {
    public static final String CONTROL_TOOLTIPS = "control_tooltips";
    public static final BiFunction<String, Style, ComponentIcon> CONTROL_ICON_FUNCTION = Util.memoize((s, style) -> ComponentIcon.of((Component)Component.literal((String)s).withStyle(style)));
    public static final Function<Icon[], Icon> COMPOUND_ICON_FUNCTION = Util.memoize(Icon::createCompound);
    public static final Function<ComponentIcon[], ComponentIcon> COMPOUND_COMPONENT_ICON_FUNCTION = Util.memoize(ComponentIcon::createCompound);
    public static final String MOUSE_BASE_CHAR = "\uc002";
    public static final String MOUSE_BASE_FOCUSED_CHAR = "\uc003";
    public static final String KEY_CHAR = "\uc000";
    public static final String KEY_PRESSED_CHAR = "\uc001";
    public static final Component MORE = Component.literal((String)"...").withStyle(ChatFormatting.GRAY);
    public static final Component SPACE = Component.literal((String)"  ");
    public static final Component PLUS = Component.literal((String)"+");
    public static final ComponentIcon SPACE_ICON = ComponentIcon.of(SPACE);
    public static final ComponentIcon PLUS_ICON = ComponentIcon.of(PLUS);
    public static final Function<String, MutableComponent> CONTROL_ACTION_CACHE = Util.memoize(s -> Component.translatable((String)s));
    public static final Map<String, ArbitrarySupplier<ComponentIcon>> commonIcons = new HashMap<String, ArbitrarySupplier<ComponentIcon>>();
    public static final ArbitrarySupplier<ComponentIcon> PRESS = ControlTooltip.registerCommonComponentIcon("press", (ArbitrarySupplier<ComponentIcon>)((ArbitrarySupplier)() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(257) : ControllerBinding.DOWN_BUTTON.getIcon()));
    public static final ArbitrarySupplier<ComponentIcon> OPTION = ControlTooltip.registerCommonComponentIcon("option", (ArbitrarySupplier<ComponentIcon>)((ArbitrarySupplier)() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(79) : ControllerBinding.UP_BUTTON.getIcon()));
    public static final ArbitrarySupplier<ComponentIcon> EXTRA = ControlTooltip.registerCommonComponentIcon("extra", (ArbitrarySupplier<ComponentIcon>)((ArbitrarySupplier)() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(88) : ControllerBinding.LEFT_BUTTON.getIcon()));
    public static final ArbitrarySupplier<ComponentIcon> PLAYER_MOVEMENT = ControlTooltip.registerCommonComponentIcon("player_movement", (ArbitrarySupplier<ComponentIcon>)((ArbitrarySupplier)() -> ControlType.getActiveType().isKbm() ? COMPOUND_COMPONENT_ICON_FUNCTION.apply(new ComponentIcon[]{ControlTooltip.getKeyIcon(87), ControlTooltip.getKeyIcon(65), ControlTooltip.getKeyIcon(83), ControlTooltip.getKeyIcon(68)}) : ControllerBinding.LEFT_STICK.getIcon()));
    public static final ArbitrarySupplier<ComponentIcon> POINTER_MOVEMENT = ControlTooltip.registerCommonComponentIcon("pointer_movement", (ArbitrarySupplier<ComponentIcon>)((ArbitrarySupplier)() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKbmIcon(MOUSE_BASE_CHAR) : ControllerBinding.LEFT_STICK.getIcon()));
    public static final ArbitrarySupplier<ComponentIcon> CAMERA_MOVEMENT = ControlTooltip.registerCommonComponentIcon("camera_movement", (ArbitrarySupplier<ComponentIcon>)((ArbitrarySupplier)() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKbmIcon(MOUSE_BASE_CHAR) : ControllerBinding.LEFT_STICK.getIcon()));
    public static final ArbitrarySupplier<ComponentIcon> MENU_MAIN_ACTION = ControlTooltip.registerCommonComponentIcon("menu_main_action", (ArbitrarySupplier<ComponentIcon>)((ArbitrarySupplier)() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(0) : ControllerBinding.DOWN_BUTTON.getIcon()));
    public static final ArbitrarySupplier<ComponentIcon> MENU_OFF_ACTION = ControlTooltip.registerCommonComponentIcon("menu_off_action", (ArbitrarySupplier<ComponentIcon>)((ArbitrarySupplier)() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(1) : ControllerBinding.LEFT_BUTTON.getIcon()));
    public static final ArbitrarySupplier<ComponentIcon> MENU_QUICK_ACTION = ControlTooltip.registerCommonComponentIcon("menu_quick_action", (ArbitrarySupplier<ComponentIcon>)((ArbitrarySupplier)() -> ControlType.getActiveType().isKbm() ? COMPOUND_COMPONENT_ICON_FUNCTION.apply(new ComponentIcon[]{ControlTooltip.getKeyIcon(0), PLUS_ICON, ControlTooltip.getKeyIcon(340)}) : ControllerBinding.UP_BUTTON.getIcon()));
    public static final ArbitrarySupplier<ComponentIcon> NAVIGATION = ControlTooltip.registerCommonComponentIcon("navigation", (ArbitrarySupplier<ComponentIcon>)((ArbitrarySupplier)() -> ControlType.getActiveType().isKbm() ? COMPOUND_COMPONENT_ICON_FUNCTION.apply(new ComponentIcon[]{ControlTooltip.getKeyIcon(265), ControlTooltip.getKeyIcon(263), ControlTooltip.getKeyIcon(264), ControlTooltip.getKeyIcon(262)}) : ControllerBinding.LEFT_STICK.getIcon()));
    public static final ArbitrarySupplier<ComponentIcon> HORIZONTAL_NAVIGATION = ControlTooltip.registerCommonComponentIcon("horizontal_navigation", (ArbitrarySupplier<ComponentIcon>)((ArbitrarySupplier)() -> ControlType.getActiveType().isKbm() ? COMPOUND_COMPONENT_ICON_FUNCTION.apply(new ComponentIcon[]{ControlTooltip.getKeyIcon(263), ControlTooltip.getKeyIcon(262)}) : ControllerBinding.LEFT_STICK.getIcon()));
    public static final ArbitrarySupplier<ComponentIcon> VERTICAL_NAVIGATION = ControlTooltip.registerCommonComponentIcon("vertical_navigation", (ArbitrarySupplier<ComponentIcon>)((ArbitrarySupplier)() -> ControlType.getActiveType().isKbm() ? COMPOUND_COMPONENT_ICON_FUNCTION.apply(new ComponentIcon[]{ControlTooltip.getKeyIcon(265), ControlTooltip.getKeyIcon(264)}) : ControllerBinding.LEFT_STICK.getIcon()));
    public static final ArbitrarySupplier<ComponentIcon> LEFT_TAB = ControlTooltip.registerCommonComponentIcon("left_tab", (ArbitrarySupplier<ComponentIcon>)((ArbitrarySupplier)() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(91) : ControllerBinding.LEFT_BUMPER.getIcon()));
    public static final ArbitrarySupplier<ComponentIcon> RIGHT_TAB = ControlTooltip.registerCommonComponentIcon("right_tab", (ArbitrarySupplier<ComponentIcon>)((ArbitrarySupplier)() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(93) : ControllerBinding.RIGHT_BUMPER.getIcon()));
    public static final ArbitrarySupplier<ComponentIcon> LEFT_CRAFTING_TYPE = ControlTooltip.registerCommonComponentIcon("left_crafting_type", (ArbitrarySupplier<ComponentIcon>)((ArbitrarySupplier)() -> ControlType.getActiveType().isKbm() ? COMPOUND_COMPONENT_ICON_FUNCTION.apply(new ComponentIcon[]{ControlTooltip.getKeyIcon(340), PLUS_ICON, ControlTooltip.getKeyIcon(91)}) : ControllerBinding.LEFT_TRIGGER.getIcon()));
    public static final ArbitrarySupplier<ComponentIcon> RIGHT_CRAFTING_TYPE = ControlTooltip.registerCommonComponentIcon("right_crafting_type", (ArbitrarySupplier<ComponentIcon>)((ArbitrarySupplier)() -> ControlType.getActiveType().isKbm() ? COMPOUND_COMPONENT_ICON_FUNCTION.apply(new ComponentIcon[]{ControlTooltip.getKeyIcon(340), PLUS_ICON, ControlTooltip.getKeyIcon(93)}) : ControllerBinding.RIGHT_TRIGGER.getIcon()));
    public static final ArbitrarySupplier<ComponentIcon> CANCEL_BINDING = ControlTooltip.registerCommonComponentIcon("cancel_binding", (ArbitrarySupplier<ComponentIcon>)((ArbitrarySupplier)() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(256) : ControllerBinding.BACK.getIcon()));

    public static ComponentIcon getControlIcon(String s, ControlType type) {
        return CONTROL_ICON_FUNCTION.apply(s, type.getStyle());
    }

    public static MutableComponent getAction(String key) {
        return CONTROL_ACTION_CACHE.apply(key);
    }

    public static Component getSelectAction(GuiEventListener listener, ActionHolder.Context context) {
        ActionHolder.KeyContext c;
        return listener.isFocused() && context instanceof ActionHolder.KeyContext && (c = (ActionHolder.KeyContext)context).key() == 257 ? LegacyComponents.SELECT : null;
    }

    public Icon getIcon();

    @Nullable
    public Component getAction();

    public static ArbitrarySupplier<ComponentIcon> registerCommonComponentIcon(String key, ArbitrarySupplier<ComponentIcon> supplier) {
        commonIcons.put(key, supplier);
        return supplier;
    }

    public static Component getKeyMessage(int key, Screen screen) {
        for (GuiEventListener child : screen.children()) {
            ActionHolder accessor;
            Component component;
            if (!(child instanceof ActionHolder) || (component = (accessor = (ActionHolder)child).getAction(new ActionHolder.KeyContext(key, screen))) == null) continue;
            return component;
        }
        return null;
    }

    public static Component getKeyboardAction(ActionHolder.KeyContext keyContext) {
        return keyContext.key == 335 && ControlType.getActiveType().isKbm() || keyContext.key == 257 && !ControlType.getActiveType().isKbm() ? LegacyComponents.SHOW_KEYBOARD : null;
    }

    public static Renderer setupDefaultButtons(Renderer renderer, Screen screen) {
        return renderer.add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(335) : ControllerBinding.DOWN_BUTTON.getIcon(), () -> ControlTooltip.getKeyMessage(335, screen)).add(() -> PRESS.get(), () -> ControlTooltip.getKeyMessage(257, screen));
    }

    public static Renderer setupDefaultScreen(Renderer renderer, Screen screen) {
        return ControlTooltip.setupDefaultButtons(renderer, screen).add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(257) : ControllerBinding.DOWN_BUTTON.getIcon(), () -> ControlTooltip.getKeyMessage(257, screen)).add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(256) : ControllerBinding.RIGHT_BUTTON.getIcon(), () -> screen.shouldCloseOnEsc() ? CommonComponents.GUI_BACK : null);
    }

    public static Renderer setupDefaultContainerScreen(Renderer renderer, LegacyMenuAccess<?> a) {
        return renderer.add(() -> MENU_MAIN_ACTION.get(), () -> a.isOutsideClick(0) && !a.getMenu().getCarried().isEmpty() ? (a.getMenu().getCarried().getCount() > 1 ? LegacyComponents.DROP_ALL : LegacyComponents.DROP) : (a.getHoveredSlot() != null && (a.getHoveredSlot().hasItem() || !a.getMenu().getCarried().isEmpty()) ? (a.getHoveredSlot().hasItem() && !FactoryItemUtil.equalItems((ItemStack)a.getHoveredSlot().getItem(), (ItemStack)a.getMenu().getCarried()) && !ControlTooltip.isBundleAndAcceptItem(a.getHoveredSlot().getItem(), a.getMenu().getCarried()) ? (a.getMenu().getCarried().isEmpty() ? LegacyComponents.TAKE : (ControlTooltip.isBundleAndAcceptItem(a.getMenu().getCarried(), a.getHoveredSlot().getItem()) ? LegacyComponents.PICK_UP : LegacyComponents.SWAP)) : LegacyComponents.PLACE) : null)).add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(256) : ControllerBinding.RIGHT_BUTTON.getIcon(), () -> LegacyComponents.EXIT).add(() -> MENU_OFF_ACTION.get(), () -> ControlTooltip.getMenuOffAction(a)).add(() -> MENU_QUICK_ACTION.get(), () -> a.getHoveredSlot() != null && a.getHoveredSlot().hasItem() ? LegacyComponents.QUICK_MOVE : null).add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(87) : ControllerBinding.RIGHT_TRIGGER.getIcon(), () -> a.getHoveredSlot() != null && a.getHoveredSlot().hasItem() && LegacyTipManager.hasTip(a.getHoveredSlot().getItem()) ? LegacyComponents.WHATS_THIS : null).add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(0) : ControllerBinding.LEFT_TRIGGER.getIcon(), () -> a.getMenu().getCarried().getCount() > 1 ? LegacyComponents.DISTRIBUTE : null);
    }

    public static Component getIconComponentFromKeyMapping(LegacyKeyMapping mapping) {
        LegacyIcon icon = ControlTooltip.getIconFromKeyMapping(mapping);
        return icon == null ? LegacyComponents.NONE : icon.getComponent();
    }

    public static LegacyIcon getIconFromKeyMapping(LegacyKeyMapping mapping) {
        return ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(mapping.getKey().getValue()) : (mapping.getBinding() == null ? null : mapping.getBinding().getIcon());
    }

    public static Component getMenuOffAction(LegacyMenuAccess<?> a) {
        if (a.isOutsideClick(1) && !a.getMenu().getCarried().isEmpty()) {
            return a.getMenu().getCarried().getCount() > 1 ? LegacyComponents.DROP_ONE : LegacyComponents.DROP;
        }
        if (a.getHoveredSlot() != null) {
            if (a.getMenu().getCarried().isEmpty()) {
                if (ControlTooltip.isBundle(a.getHoveredSlot().getItem()) && BundleItem.getFullnessDisplay((ItemStack)a.getHoveredSlot().getItem()) > 0.0f) {
                    return LegacyComponents.PICK_UP;
                }
                if (a.getHoveredSlot().getItem().getCount() > 1) {
                    return LegacyComponents.TAKE_HALF;
                }
            } else {
                if (a.getHoveredSlot().hasItem() && Legacy4JClient.hasModOnServer() && Legacy4J.canRepair(a.getHoveredSlot().getItem(), a.getMenu().getCarried())) {
                    return LegacyComponents.REPAIR;
                }
                if (a.getHoveredSlot().hasItem() && Legacy4JClient.hasModOnServer() && Legacy4J.isDyeableItem((Holder<Item>)a.getHoveredSlot().getItem().getItemHolder()) && a.getMenu().getCarried().getItem() instanceof DyeItem) {
                    return LegacyComponents.DYE;
                }
                if (ControlTooltip.isBundle(a.getMenu().getCarried()) && BundleItem.getFullnessDisplay((ItemStack)a.getMenu().getCarried()) > 0.0f && !a.getHoveredSlot().hasItem()) {
                    return LegacyComponents.RELEASE;
                }
                if (a.getHoveredSlot().hasItem() && !a.getMenu().getCarried().isEmpty() && !FactoryItemUtil.equalItems((ItemStack)a.getMenu().getCarried(), (ItemStack)a.getHoveredSlot().getItem())) {
                    return LegacyComponents.SWAP;
                }
                if (!a.getHoveredSlot().hasItem()) {
                    return a.getMenu().getCarried().getCount() > 1 ? LegacyComponents.PLACE_ONE : LegacyComponents.PLACE;
                }
            }
        }
        return null;
    }

    public static boolean isBundle(ItemStack stack) {
        return stack.is(ItemTags.BUNDLES);
    }

    public static boolean isBundleAndAcceptItem(ItemStack stack, ItemStack itemToAccept) {
        return ControlTooltip.isBundle(stack) && BundleItem.getFullnessDisplay((ItemStack)stack) <= 1.0f - (float)itemToAccept.getCount() / (float)itemToAccept.getMaxStackSize() && !itemToAccept.isEmpty() && itemToAccept.getItem().canFitInsideContainerItems();
    }

    public static ControlTooltip create(final Supplier<Icon> icon, final Supplier<Component> action) {
        return new ControlTooltip(){

            @Override
            public Icon getIcon() {
                return (Icon)icon.get();
            }

            @Override
            public Component getAction() {
                return (Component)action.get();
            }
        };
    }

    public static ControlTooltip create(LegacyKeyMapping mapping, Supplier<Component> action) {
        return ControlTooltip.create(() -> ControlTooltip.getIconFromKeyMapping(mapping), action);
    }

    public static ComponentIcon getKbmIcon(String key) {
        return ControlTooltip.getControlIcon(key, ControlType.getKbmActiveType());
    }

    public static LegacyIcon getKeyIcon(int i) {
        InputConstants.Type type;
        InputConstants.Type type2 = i >= 0 ? (i <= 9 ? InputConstants.Type.MOUSE : InputConstants.Type.KEYSYM) : (type = null);
        if (type == null) {
            return null;
        }
        InputConstants.Key key = type.getOrCreate(i);
        return ControlType.getKbmActiveType().getIcons().computeIfAbsent(key.getName(), i2 -> LegacyIcon.create(key, (InputConstants.Key k, BooleanSupplier b) -> new LegacyIcon((InputConstants.Key)k, (BooleanSupplier)b){
            final /* synthetic */ InputConstants.Key val$k;
            final /* synthetic */ BooleanSupplier val$b;
            {
                this.val$k = key;
                this.val$b = booleanSupplier;
            }

            @Override
            public Component getComponent(boolean allowPressed) {
                return ControlTooltip.getControlIcon(this.val$k.getType() == InputConstants.Type.MOUSE ? (this.val$b.getAsBoolean() && allowPressed ? ControlTooltip.MOUSE_BASE_FOCUSED_CHAR : ControlTooltip.MOUSE_BASE_CHAR) : (this.val$b.getAsBoolean() && allowPressed ? ControlTooltip.KEY_PRESSED_CHAR : ControlTooltip.KEY_CHAR), ControlType.getKbmActiveType()).getComponent();
            }

            @Override
            public Component getOverlayComponent(boolean allowPressed) {
                return this.val$k.getDisplayName();
            }

            @Override
            public boolean pressed() {
                return this.val$b.getAsBoolean();
            }

            @Override
            public boolean canLoop() {
                return this.val$k.getType() != InputConstants.Type.MOUSE;
            }
        }));
    }

    public static Component getPickAction(Minecraft minecraft) {
        BlockState b;
        BlockHitResult h;
        EntityHitResult r;
        ItemStack result;
        HitResult hitResult = minecraft.hitResult;
        if ((hitResult instanceof EntityHitResult && (result = (r = (EntityHitResult)hitResult).getEntity().getPickResult()) != null || (hitResult = minecraft.hitResult) instanceof BlockHitResult && (h = (BlockHitResult)hitResult).getType() != HitResult.Type.MISS && !(result = (b = minecraft.level.getBlockState(h.getBlockPos())).getCloneItemStack((LevelReader)minecraft.level, h.getBlockPos(), true)).isEmpty()) && (Legacy4JClient.playerHasInfiniteMaterials() || minecraft.player.getInventory().findSlotMatchingItem(result) != -1)) {
            return minecraft.hitResult instanceof EntityHitResult ? LegacyComponents.PICK_ENTITY : ((LegacyKeyMapping)minecraft.options.keyPickItem).getDisplayName();
        }
        return null;
    }

    public static Component getMainAction(Minecraft minecraft) {
        BlockHitResult r;
        if (minecraft.hitResult != null && minecraft.hitResult.getType() != HitResult.Type.MISS && !minecraft.level.getWorldBorder().isWithinBounds(minecraft.hitResult.getLocation().x(), minecraft.hitResult.getLocation().z())) {
            return null;
        }
        HitResult hitResult = minecraft.hitResult;
        if (hitResult instanceof BlockHitResult && (r = (BlockHitResult)hitResult).getType() != HitResult.Type.MISS) {
            BlockState state = minecraft.level.getBlockState(r.getBlockPos());
            if (state.getBlock() instanceof NoteBlock && !minecraft.player.getAbilities().instabuild) {
                return LegacyComponents.PLAY;
            }
            if (minecraft.player.getAbilities().instabuild || state.getBlock().defaultDestroyTime() >= 0.0f && !minecraft.player.blockActionRestricted((Level)minecraft.level, r.getBlockPos(), minecraft.gameMode.getPlayerMode())) {
                return LegacyComponents.MINE;
            }
        }
        return null;
    }

    public static Component getActualUse(Minecraft minecraft) {
        block62: {
            block63: {
                AbstractHorse h2;
                Villager v2;
                AbstractVillager m2;
                EntityHitResult r;
                BlockState blockState;
                if (minecraft.hitResult != null && minecraft.hitResult.getType() != HitResult.Type.MISS && !minecraft.level.getWorldBorder().isWithinBounds(minecraft.hitResult.getLocation().x(), minecraft.hitResult.getLocation().z())) {
                    return null;
                }
                if (minecraft.player.isSleeping()) {
                    return LegacyComponents.WAKE_UP;
                }
                HitResult hitResult = minecraft.hitResult;
                if (hitResult instanceof BlockHitResult && ((blockState = minecraft.level.getBlockState((r = (EntityHitResult)hitResult).getBlockPos())).getBlock() instanceof ButtonBlock || blockState.getBlock() instanceof LeverBlock || blockState.getBlock() instanceof DoorBlock || blockState.getBlock() instanceof TrapDoorBlock || blockState.getBlock() instanceof SignBlock || blockState.getBlock() instanceof FenceGateBlock || blockState.getMenuProvider((Level)minecraft.level, r.getBlockPos()) != null || minecraft.level.getBlockEntity(r.getBlockPos()) instanceof MenuProvider)) {
                    return blockState.getBlock() instanceof AbstractChestBlock || blockState.getBlock() instanceof ShulkerBoxBlock || blockState.getBlock() instanceof BarrelBlock || blockState.getBlock() instanceof HopperBlock || blockState.getBlock() instanceof DropperBlock ? LegacyComponents.OPEN : LegacyComponents.USE;
                }
                HitResult hitResult2 = minecraft.hitResult;
                if (!(!(hitResult2 instanceof EntityHitResult) || !((hitResult2 = (r = (EntityHitResult)hitResult2).getEntity()) instanceof AbstractVillager) || (m2 = (AbstractVillager)hitResult2) instanceof Villager && (v2 = (Villager)m2).getVillagerData().profession().is(VillagerProfession.NONE) || m2.isTrading())) {
                    return LegacyComponents.TRADE;
                }
                r = InteractionHand.values();
                int m2 = ((EntityHitResult)r).length;
                for (int v2 = 0; v2 < m2; ++v2) {
                    Mob s;
                    EntityHitResult r2;
                    BucketItem i;
                    HitResult bucketHitResult;
                    BlockHitResult r3;
                    HitResult s2;
                    HitResult hitResult3;
                    Mob m3;
                    HitResult e;
                    HitResult b;
                    TamableAnimal a;
                    IronGolem g;
                    HitResult hitResult4;
                    BlockHitResult r4;
                    EntityHitResult hand = r[v2];
                    ItemStack actualItem = minecraft.player.getItemInHand((InteractionHand)hand);
                    HitResult hitResult5 = minecraft.hitResult;
                    if (hitResult5 instanceof BlockHitResult && minecraft.level.getBlockState((r4 = (BlockHitResult)hitResult5).getBlockPos()).getBlock() instanceof BedBlock) {
                        return LegacyComponents.SLEEP;
                    }
                    hitResult5 = minecraft.hitResult;
                    if (hitResult5 instanceof BlockHitResult) {
                        r4 = (BlockHitResult)hitResult5;
                        if (minecraft.hitResult.getType() != HitResult.Type.MISS && minecraft.level.getBlockState(r4.getBlockPos()).getBlock() instanceof NoteBlock) {
                            return LegacyComponents.CHANGE_PITCH;
                        }
                    }
                    if (ControlTooltip.canPlace(minecraft, (InteractionHand)hand)) {
                        BlockItem b2;
                        hitResult5 = actualItem.getItem();
                        return hitResult5 instanceof BlockItem && ControlTooltip.isPlant((b2 = (BlockItem)hitResult5).getBlock()) ? LegacyComponents.PLANT : LegacyComponents.PLACE;
                    }
                    if (ControlTooltip.canFeed(minecraft, (InteractionHand)hand)) {
                        return LegacyComponents.FEED;
                    }
                    if (actualItem.is(Items.IRON_INGOT) && (hitResult4 = minecraft.hitResult) instanceof EntityHitResult && (hitResult4 = (r4 = (EntityHitResult)hitResult4).getEntity()) instanceof IronGolem && (g = (IronGolem)hitResult4).getHealth() < g.getMaxHealth()) {
                        return LegacyComponents.REPAIR;
                    }
                    hitResult4 = minecraft.hitResult;
                    if (hitResult4 instanceof EntityHitResult && (hitResult4 = (r4 = (EntityHitResult)hitResult4).getEntity()) instanceof TamableAnimal && (a = (TamableAnimal)hitResult4).isTame() && a.isFood(actualItem) && a.getHealth() < a.getMaxHealth()) {
                        return LegacyComponents.HEAL;
                    }
                    hitResult4 = minecraft.hitResult;
                    if (hitResult4 instanceof EntityHitResult && (hitResult4 = (r4 = (EntityHitResult)hitResult4).getEntity()) instanceof TamableAnimal && (a = (TamableAnimal)hitResult4).isTame() && a.isOwnedBy((LivingEntity)minecraft.player)) {
                        return a.isInSittingPose() ? LegacyComponents.FOLLOW_ME : LegacyComponents.SIT;
                    }
                    if (ControlTooltip.canTame(minecraft, (InteractionHand)hand)) {
                        return LegacyComponents.TAME;
                    }
                    if (ControlTooltip.canSetLoveMode(minecraft, (InteractionHand)hand)) {
                        return LegacyComponents.LOVE_MODE;
                    }
                    hitResult4 = minecraft.hitResult;
                    if (hitResult4 instanceof BlockHitResult) {
                        r4 = (BlockHitResult)hitResult4;
                        if (actualItem.getItem() instanceof BoneMealItem && (hitResult4 = (blockState = minecraft.level.getBlockState(r4.getBlockPos())).getBlock()) instanceof BonemealableBlock && (b = (BonemealableBlock)hitResult4).isValidBonemealTarget((LevelReader)minecraft.level, r4.getBlockPos(), blockState)) {
                            return LegacyComponents.GROW;
                        }
                    }
                    if ((b = minecraft.hitResult) instanceof BlockHitResult && (blockState = minecraft.level.getBlockState((r4 = (BlockHitResult)b).getBlockPos())).getBlock() instanceof ComposterBlock) {
                        if ((Integer)blockState.getValue((Property)ComposterBlock.LEVEL) == 8) {
                            return LegacyComponents.COLLECT;
                        }
                        if ((Integer)blockState.getValue((Property)ComposterBlock.LEVEL) < 7 && ComposterBlock.COMPOSTABLES.containsKey((Object)actualItem.getItem())) {
                            return LegacyComponents.FILL;
                        }
                    }
                    if ((hitResult4 = minecraft.hitResult) instanceof BlockHitResult) {
                        r4 = (BlockHitResult)hitResult4;
                        if (!actualItem.isEmpty() && (hitResult4 = minecraft.level.getBlockEntity(r4.getBlockPos())) instanceof CampfireBlockEntity) {
                            e = (CampfireBlockEntity)hitResult4;
                            if (minecraft.level.recipeAccess().propertySet(RecipePropertySet.FURNACE_INPUT).test(actualItem)) {
                                return LegacyComponents.COOK;
                            }
                        }
                    }
                    if (actualItem.getItem() instanceof BrushItem && (e = minecraft.hitResult) instanceof BlockHitResult && (r4 = (BlockHitResult)e).getType() != HitResult.Type.MISS && minecraft.level.getBlockState(r4.getBlockPos()).getBlock() instanceof BrushableBlock) {
                        return LegacyComponents.BRUSH;
                    }
                    if (actualItem.getUseAnimation().equals((Object)ItemUseAnimation.BLOCK)) {
                        return LegacyComponents.BLOCK;
                    }
                    if (actualItem.has(DataComponents.EQUIPPABLE) && (!((Equippable)actualItem.get(DataComponents.EQUIPPABLE)).slot().equals((Object)EquipmentSlot.BODY) || (hitResult4 = minecraft.hitResult) instanceof EntityHitResult && (hitResult4 = (r4 = (EntityHitResult)hitResult4).getEntity()) instanceof Mob && (m3 = (Mob)hitResult4).isEquippableInSlot(actualItem, EquipmentSlot.BODY))) {
                        return LegacyComponents.EQUIP;
                    }
                    if (actualItem.getItem() instanceof EmptyMapItem || actualItem.getItem() instanceof FishingRodItem) {
                        return LegacyComponents.USE;
                    }
                    if (actualItem.getItem() instanceof FireworkRocketItem && (minecraft.player.isFallFlying() || minecraft.hitResult instanceof BlockHitResult && minecraft.hitResult.getType() != HitResult.Type.MISS)) {
                        return LegacyComponents.LAUNCH;
                    }
                    if (actualItem.getItem() instanceof ShearsItem) {
                        hitResult3 = minecraft.hitResult;
                        if (hitResult3 instanceof EntityHitResult && (hitResult3 = (r4 = (EntityHitResult)hitResult3).getEntity()) instanceof Sheep && !(s2 = (Sheep)hitResult3).isBaby() && !s2.isSheared()) {
                            return LegacyComponents.SHEAR;
                        }
                        hitResult3 = minecraft.hitResult;
                        if (hitResult3 instanceof BlockHitResult && (r3 = (BlockHitResult)hitResult3).getType() != HitResult.Type.MISS && minecraft.level.getBlockState(r3.getBlockPos()).getBlock() instanceof PumpkinBlock) {
                            return LegacyComponents.CARVE;
                        }
                    }
                    if ((s2 = minecraft.hitResult) instanceof BlockHitResult) {
                        r4 = (BlockHitResult)s2;
                        if (minecraft.hitResult.getType() != HitResult.Type.MISS && (blockState = minecraft.level.getBlockState(r4.getBlockPos())).getBlock() instanceof JukeboxBlock && ((Boolean)blockState.getValue((Property)JukeboxBlock.HAS_RECORD)).booleanValue()) {
                            return LegacyComponents.EJECT;
                        }
                    }
                    if ((s2 = actualItem.getItem()) instanceof FoodOnAStickItem) {
                        FoodOnAStickItem i2 = (FoodOnAStickItem)s2;
                        if (minecraft.player.getControlledVehicle() instanceof ItemSteerable && minecraft.player.getControlledVehicle().getType() == i2.canInteractWith) {
                            return LegacyComponents.BOOST;
                        }
                    }
                    if (actualItem.getItem() instanceof LeadItem) {
                        r3 = minecraft.hitResult;
                        if (r3 instanceof EntityHitResult && (r3 = (r4 = (EntityHitResult)r3).getEntity()) instanceof Mob && (m3 = (Mob)r3).canBeLeashed()) {
                            return LegacyComponents.LEASH;
                        }
                        m3 = minecraft.hitResult;
                        if (m3 instanceof BlockHitResult) {
                            r4 = (BlockHitResult)m3;
                            if (minecraft.hitResult.getType() != HitResult.Type.MISS && minecraft.level.getBlockState(r4.getBlockPos()).is(BlockTags.FENCES)) {
                                return LegacyComponents.ATTACH;
                            }
                        }
                    }
                    if (actualItem.getItem() instanceof NameTagItem && FactoryItemUtil.hasCustomName((ItemStack)actualItem) && (r3 = minecraft.hitResult) instanceof EntityHitResult && (r3 = (r4 = (EntityHitResult)r3).getEntity()) instanceof LivingEntity && !((e = (LivingEntity)r3) instanceof Player) && e.isAlive()) {
                        return LegacyComponents.NAME;
                    }
                    if (actualItem.getItem() instanceof EggItem || actualItem.getItem() instanceof SnowballItem || actualItem.getItem() instanceof EnderpearlItem || actualItem.getItem() instanceof EnderEyeItem || actualItem.getItem() instanceof ThrowablePotionItem || actualItem.getItem() instanceof ExperienceBottleItem) {
                        return LegacyComponents.THROW;
                    }
                    if ((actualItem.getItem() instanceof FlintAndSteelItem || actualItem.getItem() instanceof FireChargeItem) && (e = minecraft.hitResult) instanceof BlockHitResult) {
                        r4 = (BlockHitResult)e;
                        if (minecraft.hitResult.getType() != HitResult.Type.MISS && (BaseFireBlock.canBePlacedAt((Level)minecraft.level, (BlockPos)r4.getBlockPos().relative(r4.getDirection()), (Direction)minecraft.player.getDirection()) || CampfireBlock.canLight((BlockState)(blockState = minecraft.level.getBlockState(r4.getBlockPos()))) || CandleBlock.canLight((BlockState)blockState) || CandleCakeBlock.canLight((BlockState)blockState))) {
                            return LegacyComponents.IGNITE;
                        }
                    }
                    if (actualItem.getItem() instanceof ProjectileWeaponItem && !minecraft.player.getProjectile(actualItem).isEmpty()) {
                        if (minecraft.player.getUseItem() == actualItem) {
                            return LegacyComponents.RELEASE;
                        }
                        return LegacyComponents.DRAW;
                    }
                    if (actualItem.getItem() instanceof TridentItem) {
                        if (minecraft.player.getUseItem() == actualItem) {
                            return LegacyComponents.THROW;
                        }
                        return LegacyComponents.CHARGE;
                    }
                    if (ControlTooltip.isBundle(actualItem) && BundleItem.getFullnessDisplay((ItemStack)actualItem) > 0.0f) {
                        return LegacyComponents.RELEASE;
                    }
                    r3 = actualItem.getItem();
                    if (r3 instanceof BucketItem && ControlTooltip.mayInteractItemAt(minecraft, actualItem, bucketHitResult = (i = (BucketItem)r3).equals(Items.BUCKET) ? Item.getPlayerPOVHitResult((Level)minecraft.level, (Player)minecraft.player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY) : minecraft.hitResult)) {
                        if (!i.equals(Items.BUCKET)) {
                            BlockState state = minecraft.level.getBlockState(((BlockHitResult)bucketHitResult).getBlockPos());
                            return state.getBlock() instanceof LiquidBlockContainer || state.getBlock() instanceof AbstractCauldronBlock && CauldronInteraction.EMPTY.map().containsKey(i) ? LegacyComponents.FILL : LegacyComponents.EMPTY;
                        }
                        if (minecraft.level.getBlockState(((BlockHitResult)bucketHitResult).getBlockPos()).getBlock() instanceof BucketPickup) {
                            return LegacyComponents.COLLECT;
                        }
                    }
                    if ((hitResult3 = minecraft.hitResult) instanceof EntityHitResult && (hitResult3 = (r2 = (EntityHitResult)hitResult3).getEntity()) instanceof Mob && (s = (Mob)hitResult3).isEquippableInSlot(actualItem, EquipmentSlot.SADDLE) && !s.isSaddled()) {
                        return LegacyComponents.SADDLE;
                    }
                    if (ControlTooltip.isEdible(actualItem) && minecraft.player.canEat(false) || actualItem.getItem() instanceof PotionItem) {
                        return actualItem.getUseAnimation() == ItemUseAnimation.DRINK ? LegacyComponents.DRINK : LegacyComponents.EAT;
                    }
                    if (ControlTooltip.canTill(minecraft, (InteractionHand)hand)) {
                        return LegacyComponents.TILL;
                    }
                    if (actualItem.getItem() instanceof AxeItem && (hitResult4 = minecraft.hitResult) instanceof BlockHitResult && AxeItem.STRIPPABLES.get(minecraft.level.getBlockState((r2 = (BlockHitResult)hitResult4).getBlockPos()).getBlock()) != null) {
                        return LegacyComponents.PEEL_BARK;
                    }
                    if (actualItem.getItem() instanceof ShovelItem && (hitResult4 = minecraft.hitResult) instanceof BlockHitResult && ShovelItem.FLATTENABLES.get(minecraft.level.getBlockState((r2 = (BlockHitResult)hitResult4).getBlockPos()).getBlock()) != null) {
                        return LegacyComponents.DIG_PATH;
                    }
                    if (!(actualItem.getItem() instanceof SpyglassItem)) continue;
                    return LegacyComponents.ZOOM;
                }
                HitResult v2 = minecraft.hitResult;
                if (v2 instanceof EntityHitResult && (v2 = (r = (EntityHitResult)v2).getEntity()) instanceof AbstractHorse && (h2 = (AbstractHorse)v2).isTamed() && minecraft.player.isSecondaryUseActive()) {
                    return LegacyComponents.OPEN;
                }
                HitResult h2 = minecraft.hitResult;
                if (!(h2 instanceof EntityHitResult) || !(r = (EntityHitResult)h2).getEntity().canAddPassenger((Entity)minecraft.player) || !minecraft.player.canRide(r.getEntity())) break block62;
                if (r.getEntity() instanceof Boat) {
                    return LegacyComponents.SAIL;
                }
                Entity entity = r.getEntity();
                if (entity instanceof AbstractMinecart && (m = (AbstractMinecart)entity).isRideable()) {
                    return LegacyComponents.RIDE;
                }
                entity = r.getEntity();
                if (!(entity instanceof Mob)) break block62;
                Mob s = (Mob)entity;
                if (r.getEntity().isVehicle()) break block62;
                if (!(r.getEntity() instanceof AbstractHorse) && s.isSaddled()) break block63;
                entity = r.getEntity();
                if (!(entity instanceof AbstractHorse)) break block62;
                AbstractHorse h3 = (AbstractHorse)entity;
                if (minecraft.player.isSecondaryUseActive() || (!h3.isTamed() || h3.isFood(minecraft.player.getMainHandItem())) && !minecraft.player.getMainHandItem().isEmpty()) break block62;
            }
            return LegacyComponents.MOUNT;
        }
        return null;
    }

    public static boolean mayInteractItemAt(Minecraft minecraft, ItemStack usedItem, HitResult result) {
        BlockHitResult r;
        return result instanceof BlockHitResult && (r = (BlockHitResult)result).getType() != HitResult.Type.MISS && minecraft.level.mayInteract((Entity)minecraft.player, r.getBlockPos()) && minecraft.player.mayUseItemAt(r.getBlockPos(), r.getDirection(), usedItem);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canFeed(Minecraft minecraft, InteractionHand hand) {
        ItemStack usedItem = minecraft.player.getItemInHand(hand);
        HitResult hitResult = minecraft.hitResult;
        if (!(hitResult instanceof EntityHitResult)) return false;
        EntityHitResult r = (EntityHitResult)hitResult;
        if (!((hitResult = r.getEntity()) instanceof Animal)) return false;
        Animal a = (Animal)hitResult;
        if (!a.isFood(usedItem)) return false;
        if (!(a instanceof AbstractHorse)) {
            if (a.isBaby()) return true;
        }
        if (!(a instanceof AbstractHorse)) return false;
        AbstractHorse h = (AbstractHorse)a;
        if (!(a instanceof Llama) && !a.isBaby()) {
            if (usedItem.is(Items.HAY_BLOCK)) return false;
        }
        if (!h.isTamed()) return true;
        if (ControlTooltip.isLoveFood(a, usedItem)) return false;
        if (!(a.getHealth() < a.getMaxHealth())) return false;
        if (minecraft.player.isSecondaryUseActive()) return false;
        return true;
    }

    public static boolean canSetLoveMode(Minecraft minecraft, InteractionHand hand) {
        Animal a;
        EntityHitResult r;
        ItemStack usedItem = minecraft.player.getItemInHand(hand);
        HitResult hitResult = minecraft.hitResult;
        return hitResult instanceof EntityHitResult && (hitResult = (r = (EntityHitResult)hitResult).getEntity()) instanceof Animal && !(a = (Animal)hitResult).isBaby() && a.isFood(minecraft.player.getItemInHand(hand)) && a.canFallInLove() && !a.isInLove() && (!(a instanceof AbstractHorse) || ControlTooltip.isLoveFood(a, usedItem));
    }

    public static boolean isLoveFood(Animal a, ItemStack stack) {
        return a instanceof Llama && stack.is(Items.HAY_BLOCK) || a instanceof Horse && (stack.is(Items.GOLDEN_CARROT) || stack.is(Items.GOLDEN_APPLE) || stack.is(Items.ENCHANTED_GOLDEN_APPLE));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canPlace(Minecraft minecraft, InteractionHand hand) {
        ItemStack usedItem = minecraft.player.getItemInHand(hand);
        if (minecraft.hitResult == null) return false;
        if (minecraft.hitResult.getType() == HitResult.Type.MISS) return false;
        if (usedItem.isEmpty()) return false;
        Item item = usedItem.getItem();
        if (item instanceof SpawnEggItem) {
            SpawnEggItem e = (SpawnEggItem)item;
            item = minecraft.hitResult;
            if (!(item instanceof EntityHitResult)) return true;
            EntityHitResult r = (EntityHitResult)item;
            if (r.getEntity().getType() == e.getType((HolderLookup.Provider)minecraft.level.registryAccess(), usedItem)) return true;
        }
        if (!((item = minecraft.hitResult) instanceof BlockHitResult)) return false;
        BlockHitResult r = (BlockHitResult)item;
        item = usedItem.getItem();
        if (!(item instanceof BlockItem)) return false;
        BlockItem b = (BlockItem)item;
        BlockPlaceContext c = new BlockPlaceContext((Player)minecraft.player, hand, usedItem, r);
        if (!c.canPlace()) return false;
        if (b.getPlacementState(c) == null) return false;
        return true;
    }

    public static boolean canTill(Minecraft minecraft, InteractionHand hand) {
        HitResult hitResult;
        if (!(minecraft.player.getItemInHand(hand).getItem() instanceof HoeItem) || !((hitResult = minecraft.hitResult) instanceof BlockHitResult)) {
            return false;
        }
        BlockHitResult r = (BlockHitResult)hitResult;
        Pair use = (Pair)HoeItem.TILLABLES.get(minecraft.level.getBlockState(r.getBlockPos()).getBlock());
        return use != null && ((Predicate)use.getFirst()).test(new UseOnContext((Player)minecraft.player, hand, r));
    }

    public static boolean canTame(Minecraft minecraft, InteractionHand hand) {
        AbstractHorse h;
        TamableAnimal t;
        EntityHitResult e;
        ItemStack usedItem = minecraft.player.getItemInHand(hand);
        HitResult hitResult = minecraft.hitResult;
        return hitResult instanceof EntityHitResult && ((hitResult = (e = (EntityHitResult)hitResult).getEntity()) instanceof TamableAnimal && !(t = (TamableAnimal)hitResult).isTame() && (t instanceof Wolf && usedItem.is(Items.BONE) || !(t instanceof Wolf) && t.isFood(usedItem)) || hand == InteractionHand.MAIN_HAND && (hitResult = e.getEntity()) instanceof AbstractHorse && !(h = (AbstractHorse)hitResult).isTamed() && !minecraft.player.isSecondaryUseActive() && usedItem.isEmpty());
    }

    public static boolean isPlant(Block block) {
        return block instanceof BushBlock || block instanceof SugarCaneBlock || block instanceof GrowingPlantBlock || block instanceof BambooStalkBlock;
    }

    public static boolean isEdible(ItemStack stack) {
        return stack.has(DataComponents.FOOD);
    }

    public static interface ComponentIcon
    extends Icon {
        public Component getComponent();

        public static ComponentIcon of(final Component component) {
            return new ComponentIcon(){

                @Override
                public Component getComponent() {
                    return component;
                }

                @Override
                public int render(GuiGraphics graphics, int x, int y, boolean allowPressed, boolean simulate) {
                    Font font = Minecraft.getInstance().font;
                    if (!simulate) {
                        graphics.drawString(font, this.getComponent(), x, y, 0xFFFFFF, false);
                    }
                    return font.width((FormattedText)this.getComponent());
                }
            };
        }

        public static ComponentIcon createCompound(ComponentIcon[] componentIcons) {
            MutableComponent allIcons = Component.empty();
            for (ComponentIcon componentIcon : componentIcons) {
                allIcons.append(componentIcon.getComponent());
            }
            return ComponentIcon.of((Component)allIcons);
        }

        public static ComponentIcon createCompound(Component[] components) {
            MutableComponent allIcons = Component.empty();
            for (Component component : components) {
                allIcons.append(component);
            }
            return ComponentIcon.of((Component)allIcons);
        }

        public static ComponentIcon compoundOf(ComponentIcon ... componentIcons) {
            return COMPOUND_COMPONENT_ICON_FUNCTION.apply(componentIcons);
        }
    }

    public static interface ActionHolder {
        @Nullable
        public Component getAction(Context var1);

        @Nullable
        default public Component getAction(Screen screen) {
            return this.getAction(() -> screen);
        }

        public static interface ScreenContext
        extends Context {
            public Screen screen();
        }

        public static interface Context {
            default public <C extends Context> Component actionOfContext(Class<C> contextClass, Function<C, Component> toAction) {
                if (contextClass.isInstance(this)) {
                    return toAction.apply((Context)contextClass.cast(this));
                }
                return null;
            }
        }

        public record KeyContext(int key, Screen screen) implements ScreenContext
        {
        }
    }

    public static class Renderer
    implements Renderable {
        public static final FactoryEvent<BiConsumer<Screen, Renderer>> SCREEN_EVENT = new FactoryEvent(e -> (screen, event) -> e.invokeAll(c -> c.accept(screen, event)));
        public static final FactoryEvent<BiConsumer<Gui, Renderer>> GUI_EVENT = new FactoryEvent(e -> (screen, event) -> e.invokeAll(c -> c.accept(screen, event)));
        static final Renderer INSTANCE = new Renderer();
        private final Minecraft minecraft = Minecraft.getInstance();
        public final List<ControlTooltip> tooltips = new ArrayList<ControlTooltip>();
        protected final Map<Component, Icon> renderTooltips = new Object2ReferenceLinkedOpenHashMap();

        public static Renderer getInstance() {
            return INSTANCE;
        }

        public static Renderer of(Object o) {
            Renderer renderer;
            if (o instanceof Event) {
                Event e = (Event)o;
                renderer = e.getControlTooltips();
            } else {
                renderer = Renderer.getInstance();
            }
            return renderer;
        }

        public Renderer clear() {
            this.tooltips.clear();
            return this;
        }

        public Renderer set(int ordinal, Supplier<Icon> control, Supplier<Component> action) {
            return this.set(ordinal, ControlTooltip.create(control, action));
        }

        public Renderer set(int ordinal, ControlTooltip tooltip) {
            this.tooltips.set(ordinal, tooltip);
            return this;
        }

        public Renderer replace(int ordinal, Function<Icon, Icon> control, Function<Component, Component> action) {
            ControlTooltip old = this.tooltips.get(ordinal);
            return this.set(ordinal, ControlTooltip.create(() -> (Icon)control.apply(old.getIcon()), () -> (Component)action.apply(old.getAction())));
        }

        public Renderer add(KeyMapping mapping) {
            return this.add(LegacyKeyMapping.of(mapping));
        }

        public Renderer add(KeyMapping mapping, Supplier<Component> action) {
            return this.add(ControlTooltip.create(LegacyKeyMapping.of(mapping), action));
        }

        public Renderer add(LegacyKeyMapping mapping) {
            return this.add(mapping, mapping::getDisplayName);
        }

        public Renderer add(LegacyKeyMapping mapping, Supplier<Component> action) {
            return this.add(ControlTooltip.create(mapping, action));
        }

        public Renderer addCompound(Supplier<Icon[]> control, Supplier<Component> action) {
            return this.add(ControlTooltip.create(() -> COMPOUND_ICON_FUNCTION.apply((Icon[])control.get()), action));
        }

        public Renderer add(Supplier<Icon> control, Supplier<Component> action) {
            return this.add(ControlTooltip.create(control, action));
        }

        public Renderer add(ControlTooltip tooltip) {
            this.tooltips.add(tooltip);
            return this;
        }

        public boolean allowPressed() {
            return this.minecraft.screen != null;
        }

        public void render(GuiGraphics guiGraphics, int i, int j, float f) {
            if (!((Boolean)LegacyOptions.inGameTooltips.get()).booleanValue() && this.minecraft.screen == null || !((Boolean)LegacyOptions.displayControlTooltips.get()).booleanValue()) {
                return;
            }
            this.renderTooltips.clear();
            for (ControlTooltip tooltip : this.tooltips) {
                Icon icon2;
                Component action2 = tooltip.getAction();
                if (action2 == null || (icon2 = tooltip.getIcon()) == null) continue;
                this.renderTooltips.compute(action2, (k, existingIcon) -> existingIcon == null ? icon2 : (existingIcon.equals(icon2) || (Boolean)LegacyOptions.displayMultipleControlsFromAction.get() == false ? existingIcon : COMPOUND_ICON_FUNCTION.apply(new Icon[]{existingIcon, SPACE_ICON, icon2})));
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.max(this.minecraft.screen == null ? 0.0f : 0.2f, ScreenUtil.getHUDOpacity()));
            guiGraphics.pose().pushPose();
            boolean left = ((LegacyOptions.ControlTooltipDisplay)((Object)LegacyOptions.controlTooltipDisplay.get())).isLeft();
            double hudDiff = (1.0 - (Double)LegacyOptions.hudDistance.get()) * 60.0;
            double xDiff = -Math.min(hudDiff, 30.0);
            guiGraphics.pose().translate(left ? xDiff : (double)guiGraphics.guiWidth() - xDiff, Math.min(hudDiff, 16.0), 1000.0);
            int baseHeight = guiGraphics.guiHeight() - 29;
            this.renderTooltips.forEach((action, icon) -> {
                if (left) {
                    int controlWidth = icon.render(guiGraphics, 32, baseHeight, this.allowPressed(), false);
                    if (controlWidth > 0) {
                        guiGraphics.drawString(this.minecraft.font, action, 34 + controlWidth, baseHeight, ((Integer)CommonColor.ACTION_TEXT.get()).intValue());
                        guiGraphics.pose().translate((float)(controlWidth + this.minecraft.font.width((FormattedText)action) + 12), 0.0f, 0.0f);
                        guiGraphics.flush();
                    }
                } else {
                    int controlWidth = icon.render(guiGraphics, -32, baseHeight, this.allowPressed(), true);
                    if (controlWidth > 0) {
                        guiGraphics.pose().translate((float)(-controlWidth - this.minecraft.font.width((FormattedText)action)), 0.0f, 0.0f);
                        icon.render(guiGraphics, -32, baseHeight, this.allowPressed(), false);
                        guiGraphics.drawString(this.minecraft.font, action, -30 + controlWidth, baseHeight, ((Integer)CommonColor.ACTION_TEXT.get()).intValue());
                        guiGraphics.pose().translate(-12.0f, 0.0f, 0.0f);
                        guiGraphics.flush();
                    }
                }
            });
            guiGraphics.pose().popPose();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            FactoryScreenUtil.disableBlend();
        }
    }

    public static abstract class LegacyIcon
    implements ComponentIcon {
        boolean lastPressed = false;
        long startPressTime = 0L;

        public abstract Component getComponent(boolean var1);

        public abstract Component getOverlayComponent(boolean var1);

        @Override
        public Component getComponent() {
            return this.getComponent(false);
        }

        public abstract boolean pressed();

        public abstract boolean canLoop();

        public float getPressInterval() {
            return (float)(Util.getMillis() - this.startPressTime) / 280.0f;
        }

        public Component getActualIcon(char[] chars, boolean allowPressed, ControlType type) {
            return chars == null ? null : ControlTooltip.getControlIcon(String.valueOf(chars[chars.length > 1 && allowPressed && this.startPressTime != 0L && (this.canLoop() || this.getPressInterval() <= 1.0f) ? 1 + Math.round((this.getPressInterval() / 2.0f <= 1.4f ? this.getPressInterval() / 2.0f % 1.0f : 0.4f) * (float)(chars.length - 2)) : 0]), type).getComponent();
        }

        @Override
        public int render(GuiGraphics graphics, int x, int y, boolean allowPressed, boolean simulate) {
            int cow;
            Component c = this.getComponent(allowPressed);
            Component co = this.getOverlayComponent(allowPressed);
            Font font = Minecraft.getInstance().font;
            int cw = c == null ? 0 : font.width((FormattedText)c);
            int n = cow = co == null ? 0 : font.width((FormattedText)co);
            if (!this.pressed() && (double)(this.getPressInterval() % 1.0f) < 0.1) {
                this.startPressTime = 0L;
            }
            if (allowPressed && this.pressed() && !this.lastPressed && this.startPressTime == 0L) {
                this.startPressTime = Util.getMillis();
            }
            this.lastPressed = this.pressed();
            if (!simulate && c != null) {
                graphics.drawString(font, c, x + (co == null || cw > cow ? 0 : (cow - cw) / 2), y, 0xFFFFFF, false);
            }
            if (!simulate && co != null) {
                float rel = this.startPressTime == 0L ? 0.0f : (this.canLoop() ? this.getPressInterval() % 1.0f : Math.min(this.getPressInterval(), 1.0f));
                float d = 1.0f - Math.max(0.0f, (rel >= 0.5f ? 1.0f - rel : rel) * 2.0f / 5.0f);
                graphics.pose().pushPose();
                graphics.pose().translate((float)x + (c == null || cow > cw ? ((float)cow - (float)cow * d) / 2.0f : ((float)cw - (float)cow * d) / 2.0f), (float)y + (9.0f - 9.0f * d) / 2.0f, 0.0f);
                graphics.pose().scale(d, d, d);
                float alpha = FactoryGuiGraphics.of((GuiGraphics)graphics).getColor()[3];
                FactoryGuiGraphics.of((GuiGraphics)graphics).setColor(1.0f, 1.0f, 1.0f, alpha * (0.8f + (rel >= 0.5f ? 0.2f : 0.0f)));
                graphics.drawString(font, co, 0, 0, 0xFFFFFF, false);
                FactoryGuiGraphics.of((GuiGraphics)graphics).setColor(1.0f, 1.0f, 1.0f, alpha);
                graphics.pose().popPose();
            }
            return Math.max(cw, cow);
        }

        public static LegacyIcon create(InputConstants.Key key, char[] iconChars, char[] iconOverlayChars, Character tipIcon) {
            return LegacyIcon.create(key, (k, b) -> LegacyIcon.create(b, iconChars, iconOverlayChars, tipIcon, () -> k.getType() != InputConstants.Type.MOUSE, ControlType::getKbmActiveType));
        }

        public static LegacyIcon create(final BooleanSupplier pressed, final char[] iconChars, final char[] iconOverlayChars, final Character tipIcon, final BooleanSupplier loop, final Supplier<ControlType> type) {
            return new LegacyIcon(){

                @Override
                public Component getComponent(boolean allowPressed) {
                    return this.getActualIcon(iconChars, allowPressed, (ControlType)type.get());
                }

                @Override
                public Component getOverlayComponent(boolean allowPressed) {
                    return this.getActualIcon(iconOverlayChars, allowPressed, (ControlType)type.get());
                }

                @Override
                public Component getComponent() {
                    return tipIcon == null ? (super.getComponent() == null ? this.getOverlayComponent(false) : super.getComponent()) : ControlTooltip.getControlIcon(String.valueOf(tipIcon), ControlType.getActiveControllerType()).getComponent();
                }

                @Override
                public boolean pressed() {
                    return pressed.getAsBoolean();
                }

                @Override
                public boolean canLoop() {
                    return loop.getAsBoolean();
                }
            };
        }

        public static LegacyIcon create(InputConstants.Key key, BiFunction<InputConstants.Key, BooleanSupplier, LegacyIcon> iconGetter) {
            long window = Minecraft.getInstance().getWindow().getWindow();
            return iconGetter.apply(key, () -> key.getType() == InputConstants.Type.KEYSYM ? InputConstants.isKeyDown((long)window, (int)key.getValue()) : GLFW.glfwGetMouseButton((long)window, (int)key.getValue()) == 1);
        }
    }

    public static class GuiManager
    implements ResourceManagerReloadListener {
        public static final List<ControlTooltip> controlTooltips = new ArrayList<ControlTooltip>();

        public static void applyGUIControlTooltips(Renderer renderer, Minecraft minecraft) {
            renderer.add(minecraft.options.keyJump, () -> minecraft.player.isUnderWater() ? LegacyComponents.SWIM_UP : null).add(Minecraft.getInstance().options.keyInventory).add(Legacy4JClient.keyCrafting).add(Minecraft.getInstance().options.keyUse, () -> ControlTooltip.getActualUse(minecraft)).add(Minecraft.getInstance().options.keyAttack, () -> ControlTooltip.getMainAction(minecraft));
            renderer.tooltips.addAll(controlTooltips);
            renderer.add(minecraft.options.keyShift, () -> minecraft.player.isPassenger() ? (minecraft.player.getVehicle() instanceof LivingEntity ? LegacyComponents.DISMOUNT : LegacyComponents.EXIT) : (minecraft.player.getInBlockState().is(Blocks.SCAFFOLDING) ? LegacyComponents.HOLD_TO_DESCEND : null)).add(minecraft.options.keyPickItem, () -> ControlTooltip.getPickAction(minecraft));
        }

        protected ControlTooltip guiControlTooltipFromJson(JsonObject o) {
            Component component;
            Predicate<Object> predicate;
            Predicate<Block> blockPredicate;
            BiPredicate<Item, DataComponentPatch> itemPredicate;
            LegacyKeyMapping mapping = LegacyKeyMapping.of((KeyMapping)KeyMapping.ALL.get(GsonHelper.getAsString((JsonObject)o, (String)"keyMapping")));
            if (o.has("heldItem")) {
                JsonElement jsonElement = o.get("heldItem");
                if (jsonElement instanceof JsonObject) {
                    JsonObject obj = (JsonObject)jsonElement;
                    v0 = JsonUtil.registryMatchesItem(obj);
                } else {
                    v0 = o.get("heldItem").getAsBoolean() ? (i, t) -> i != null && i != Items.AIR : (i, t) -> false;
                }
            } else {
                v0 = itemPredicate = (i, t) -> true;
            }
            if (o.has("hitBlock")) {
                JsonElement jsonElement = o.get("hitBlock");
                if (jsonElement instanceof JsonObject) {
                    JsonObject obj = (JsonObject)jsonElement;
                    v1 = JsonUtil.registryMatches(BuiltInRegistries.BLOCK, obj);
                } else {
                    v1 = o.get("hitBlock").getAsBoolean() ? b -> !b.defaultBlockState().isAir() : b -> false;
                }
            } else {
                v1 = blockPredicate = b -> true;
            }
            if (o.has("hitEntity")) {
                JsonElement jsonElement = o.get("hitEntity");
                if (jsonElement instanceof JsonObject) {
                    JsonObject obj = (JsonObject)jsonElement;
                    predicate = JsonUtil.registryMatches(BuiltInRegistries.ENTITY_TYPE, obj);
                } else {
                    predicate = GuiManager.staticPredicate(o.get("hitEntity").getAsBoolean());
                }
            } else {
                predicate = e -> true;
            }
            Predicate<EntityType> entityPredicate = predicate;
            Minecraft minecraft = Minecraft.getInstance();
            JsonElement jsonElement = o.get("action");
            if (jsonElement instanceof JsonPrimitive) {
                JsonPrimitive p = (JsonPrimitive)jsonElement;
                component = Component.translatable((String)p.getAsString());
            } else {
                component = mapping.getDisplayName();
            }
            Component c = component;
            return ControlTooltip.create(mapping, () -> {
                EntityHitResult er;
                HitResult patt1$temp;
                BlockHitResult r;
                HitResult patt0$temp;
                return minecraft.player != null && itemPredicate.test(minecraft.player.getMainHandItem().getItem(), minecraft.player.getMainHandItem().getComponentsPatch()) && ((patt0$temp = minecraft.hitResult) instanceof BlockHitResult && blockPredicate.test(minecraft.level.getBlockState((r = (BlockHitResult)patt0$temp).getBlockPos()).getBlock()) || (patt1$temp = minecraft.hitResult) instanceof EntityHitResult && entityPredicate.test((er = (EntityHitResult)patt1$temp).getEntity().getType())) ? c : null;
            });
        }

        public static <T> Predicate<T> staticPredicate(boolean b) {
            return o -> b;
        }

        public void onResourceManagerReload(ResourceManager manager) {
            controlTooltips.clear();
            manager.listResources("control_tooltips/gui", string -> string.getPath().endsWith(".json")).forEach((location, resource) -> {
                try {
                    BufferedReader bufferedReader = resource.openAsReader();
                    JsonObject obj = GsonHelper.parse((Reader)bufferedReader);
                    JsonElement ioElement = obj.get("tooltips");
                    if (ioElement instanceof JsonArray) {
                        JsonArray array = (JsonArray)ioElement;
                        array.forEach(e -> {
                            if (e instanceof JsonObject) {
                                JsonObject o = (JsonObject)e;
                                controlTooltips.add(this.guiControlTooltipFromJson(o));
                            }
                        });
                    } else if (ioElement instanceof JsonObject) {
                        JsonObject o = (JsonObject)ioElement;
                        controlTooltips.add(this.guiControlTooltipFromJson(o));
                    }
                    bufferedReader.close();
                }
                catch (IOException exception) {
                    Legacy4J.LOGGER.warn(exception.getMessage());
                }
            });
        }

        public String getName() {
            return "legacy:control_tooltip_gui";
        }
    }

    public static interface Event {
        public static final Event EMPTY = new Event(){};

        public static Event of(Object o) {
            Event e;
            return o instanceof Event ? (e = (Event)o) : EMPTY;
        }

        default public Renderer getControlTooltips() {
            return Renderer.getInstance();
        }

        default public void setupControlTooltips() {
            this.addControlTooltips(this.getControlTooltips().clear());
        }

        default public void addControlTooltips(Renderer renderer) {
            Event event;
            if (this instanceof Gui) {
                GuiManager.applyGUIControlTooltips(renderer, Minecraft.getInstance());
            }
            if ((event = this) instanceof Screen) {
                Screen s = (Screen)event;
                Event event2 = this;
                if (event2 instanceof LegacyMenuAccess) {
                    LegacyMenuAccess a = (LegacyMenuAccess)((Object)event2);
                    ControlTooltip.setupDefaultContainerScreen(renderer, a);
                } else {
                    ControlTooltip.setupDefaultScreen(renderer, s);
                }
            }
        }
    }

    public static interface Icon {
        public int render(GuiGraphics var1, int var2, int var3, boolean var4, boolean var5);

        public static Icon createCompound(Icon[] icons) {
            return (graphics, x, y, allowPressed, simulate) -> {
                int totalWidth = 0;
                for (Icon icon : icons) {
                    totalWidth += icon.render(graphics, x + totalWidth, y, allowPressed, simulate);
                }
                return totalWidth;
            };
        }
    }
}

