/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.legacy.Legacy4J;

@Mixin(value={AbstractContainerMenu.class})
public abstract class AbstractContainerMenuMixin {
    @Shadow
    @Final
    public NonNullList<Slot> slots;

    @Shadow
    public abstract ItemStack getCarried();

    @Shadow
    public abstract void setCarried(ItemStack var1);

    @Inject(method={"doClick"}, at={@At(value="HEAD")}, cancellable=true)
    private void doClick(int i, int j, ClickType clickType, Player player, CallbackInfo ci) {
        Slot slot;
        if ((clickType == ClickType.PICKUP || clickType == ClickType.QUICK_MOVE) && j == 1 && i >= 0 && i < this.slots.size() && (slot = (Slot)this.slots.get(i)).hasItem() && !this.getCarried().isEmpty()) {
            Item item;
            if (Legacy4J.canRepair(slot.getItem(), this.getCarried())) {
                ItemStack item2 = slot.getItem().getItem().getDefaultInstance();
                item2.setDamageValue(slot.getItem().getDamageValue() - (item2.getMaxDamage() - this.getCarried().getDamageValue()));
                slot.set(item2);
                if (!player.hasInfiniteMaterials()) {
                    this.setCarried(ItemStack.EMPTY);
                }
                ci.cancel();
            } else if (Legacy4J.isDyeableItem((Holder<Item>)slot.getItem().getItemHolder()) && (item = this.getCarried().getItem()) instanceof DyeItem) {
                DyeItem d = (DyeItem)item;
                Legacy4J.dyeItem(slot.getItem(), Legacy4J.getDyeColor(d.getDyeColor()));
                slot.setChanged();
                if (!player.hasInfiniteMaterials()) {
                    this.getCarried().shrink(1);
                }
                ci.cancel();
            }
        }
    }
}

