/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemUseAnimation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.base.client.FactoryRenderStateExtension;
import wily.legacy.client.LegacyLivingEntityRenderState;

@Mixin(value={HumanoidModel.class})
public abstract class HumanoidModelMixin {
    @Shadow
    @Final
    public ModelPart rightArm;
    @Shadow
    @Final
    public ModelPart leftArm;

    @Inject(method={"setupAnim(Lnet/minecraft/client/renderer/entity/state/HumanoidRenderState;)V"}, at={@At(value="TAIL")})
    private void setupAnim(HumanoidRenderState humanoidRenderState, CallbackInfo info) {
        HumanoidArm mainArm = humanoidRenderState.mainArm;
        float ageInTicks = humanoidRenderState.ageInTicks;
        if (humanoidRenderState.getMainHandItem().isEmpty() && humanoidRenderState.isDiscrete && humanoidRenderState.isFallFlying) {
            (mainArm == HumanoidArm.RIGHT ? this.rightArm : this.leftArm).xRot = (float)Math.PI + (mainArm == HumanoidArm.RIGHT ? 1.0f : -1.0f) * Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
        }
        HumanoidArm useArm = humanoidRenderState.useItemHand == InteractionHand.MAIN_HAND ? mainArm : mainArm.getOpposite();
        ItemUseAnimation useAnim = ((LegacyLivingEntityRenderState)FactoryRenderStateExtension.Accessor.of((EntityRenderState)humanoidRenderState).getExtension(LegacyLivingEntityRenderState.class)).useAnim;
        if (humanoidRenderState.isUsingItem && (useAnim == ItemUseAnimation.EAT || useAnim == ItemUseAnimation.DRINK)) {
            boolean isRightHand = useArm == HumanoidArm.RIGHT;
            ModelPart armModel = isRightHand ? this.rightArm : this.leftArm;
            float r = Math.min(((float)humanoidRenderState.ticksUsingItem + FactoryAPIClient.getGamePartialTick((boolean)humanoidRenderState.isFullyFrozen)) / (float)((LegacyLivingEntityRenderState)FactoryRenderStateExtension.Accessor.of((EntityRenderState)humanoidRenderState).getExtension(LegacyLivingEntityRenderState.class)).itemUseDuration * 6.0f, 1.0f);
            armModel.xRot = r * -1.4f + (r > 0.8f ? Mth.cos((float)(ageInTicks * 1.7f)) * 0.08f : 0.0f);
            armModel.yRot = (isRightHand ? -0.45f : 0.45f) * r;
        }
    }

    @Redirect(method={"setupAnim(Lnet/minecraft/client/renderer/entity/state/HumanoidRenderState;)V"}, at=@At(value="FIELD", target="Lnet/minecraft/client/model/geom/ModelPart;xRot:F", opcode=181, ordinal=1))
    public void setupAnim(ModelPart instance, float value, HumanoidRenderState humanoidRenderState) {
        if (humanoidRenderState.hasPose(Pose.FALL_FLYING)) {
            instance.xRot = value;
        }
    }
}

