/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.packs.PackSelectionModel;
import net.minecraft.client.gui.screens.packs.PackSelectionScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.sounds.SoundEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.legacy.client.CommonColor;
import wily.legacy.client.ControlType;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.MultilineTooltip;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.RenderableVList;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

@Mixin(value={PackSelectionScreen.class})
public abstract class PackSelectionScreenMixin
extends Screen
implements ControlTooltip.Event,
RenderableVList.Access {
    private static final Component INCOMPATIBLE_TITLE = Component.translatable((String)"pack.incompatible").withStyle(ChatFormatting.RED);
    private static final Component INCOMPATIBLE_CONFIRM_TITLE = Component.translatable((String)"pack.incompatible.confirm.title");
    private static final Component AVAILABLE_PACK = Component.translatable((String)"pack.selected.title");
    private static final Component SELECTED_PACK = Component.translatable((String)"pack.available.title");
    @Shadow
    @Final
    private PackSelectionModel model;
    @Shadow
    private Button doneButton;
    @Shadow
    @Final
    private Path packDir;
    @Unique
    private Panel panel = Panel.centered((Screen)this, 410, 240);
    @Unique
    private RenderableVList selectedPacksList = new RenderableVList(this).layoutSpacing(l -> 0);
    @Unique
    private RenderableVList unselectedPacksList = new RenderableVList(this).layoutSpacing(l -> 0);
    @Unique
    private final List<RenderableVList> renderableVLists = List.of(this.unselectedPacksList, this.selectedPacksList);

    @Shadow
    protected abstract void reload();

    protected PackSelectionScreenMixin(Component component) {
        super(component);
    }

    private PackSelectionScreen self() {
        return (PackSelectionScreen)this;
    }

    @Inject(method={"init"}, at={@At(value="HEAD")}, cancellable=true)
    public void init(CallbackInfo ci) {
        ci.cancel();
        super.init();
        this.panel.init();
        this.unselectedPacksList.init(this.panel.x + 15, this.panel.y + 30, 180, 192);
        this.selectedPacksList.init(this.panel.x + 215, this.panel.y + 30, 180, 192);
        this.doneButton = Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).build();
    }

    @Inject(method={"repositionElements"}, at={@At(value="HEAD")}, cancellable=true)
    public void repositionElements(CallbackInfo ci) {
        super.repositionElements();
        ci.cancel();
    }

    public void added() {
        super.added();
        ControlTooltip.Renderer.of(this).add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(79) : ControllerBinding.UP_BUTTON.getIcon(), () -> LegacyComponents.OPEN_DIRECTORY);
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void initConstruct(CallbackInfo info) {
        this.reload();
    }

    @Inject(method={"populateLists"}, at={@At(value="HEAD")}, cancellable=true)
    private void populateLists(CallbackInfo ci) {
        ci.cancel();
        this.addPacks(this.unselectedPacksList, this.model.getUnselected());
        this.addPacks(this.selectedPacksList, this.model.getSelected());
        this.repositionElements();
    }

    @Inject(method={"onClose"}, at={@At(value="RETURN")})
    public void onClose(CallbackInfo info) {
        ScreenUtil.playSimpleUISound((SoundEvent)LegacyRegistries.BACK.get(), 1.0f);
    }

    private void addPacks(RenderableVList list, Stream<PackSelectionModel.Entry> stream) {
        list.renderables.clear();
        stream.forEach(e -> {
            ArrayList<Component> description = new ArrayList<Component>();
            if (!e.getCompatibility().isCompatible()) {
                description.add(INCOMPATIBLE_TITLE);
                description.add(e.getCompatibility().getDescription());
            }
            if (!e.getExtendedDescription().getString().isEmpty()) {
                description.add(e.getExtendedDescription());
            }
            AbstractButton button = new AbstractButton(0, 0, 180, 30, e.getTitle(), (PackSelectionModel.Entry)e){
                final /* synthetic */ PackSelectionModel.Entry val$e;
                {
                    this.val$e = entry;
                    super(i, j, k, l, arg);
                }

                protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
                    super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
                    FactoryScreenUtil.enableBlend();
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(this.val$e.getIconTexture(), this.getX() + 5, this.getY() + 5, 0.0f, 0.0f, 20, 20, 20, 20);
                    FactoryScreenUtil.disableBlend();
                    if ((((Boolean)((PackSelectionScreenMixin)PackSelectionScreenMixin.this).minecraft.options.touchscreen().get()).booleanValue() || this.isHovered) && this.showHoverOverlay()) {
                        guiGraphics.fill(this.getX() + 5, this.getY() + 5, this.getX() + 25, this.getY() + 25, -1601138544);
                        int p = mouseX - this.getX();
                        int q = mouseY - this.getY();
                        if (this.val$e.canSelect()) {
                            if (p < 32) {
                                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.JOIN_HIGHLIGHTED, this.getX() + 5, this.getY() + 5, 20, 20);
                            } else {
                                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.JOIN, this.getX() + 5, this.getY() + 5, 20, 20);
                            }
                        } else {
                            if (this.val$e.canUnselect()) {
                                if (p < 16) {
                                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.UNSELECT_HIGHLIGHTED, this.getX() + 5, this.getY() + 5, 20, 20);
                                } else {
                                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.UNSELECT, this.getX() + 5, this.getY() + 5, 20, 20);
                                }
                            }
                            if (this.val$e.canMoveUp()) {
                                if (p < 32 && p > 16 && q < 16) {
                                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.TRANSFER_MOVE_UP_HIGHLIGHTED, this.getX(), this.getY(), 32, 32);
                                } else {
                                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.TRANSFER_MOVE_UP, this.getX(), this.getY(), 32, 32);
                                }
                            }
                            if (this.val$e.canMoveDown()) {
                                if (p < 32 && p > 16 && q > 16) {
                                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.TRANSFER_MOVE_DOWN_HIGHLIGHTED, this.getX(), this.getY(), 32, 32);
                                } else {
                                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.TRANSFER_MOVE_DOWN, this.getX(), this.getY(), 32, 32);
                                }
                            }
                        }
                    }
                }

                protected void renderScrollingString(GuiGraphics guiGraphics, Font font, int i, int j) {
                    ScreenUtil.renderScrollingString(guiGraphics, font, this.getMessage(), this.getX() + 30, this.getY(), this.getX() + this.width - 2, this.getY() + this.height, this.val$e.getCompatibility().isCompatible() ? ScreenUtil.getDefaultTextColor(!this.isHoveredOrFocused()) : 0xFF0000, true);
                }

                public void onClick(double i, double j) {
                    double f = i - (double)this.getX();
                    double g = j - (double)this.getY();
                    if (this.showHoverOverlay() && f <= 32.0) {
                        if (this.val$e.canSelect()) {
                            this.onPress();
                            return;
                        }
                        if (f < 16.0 && this.val$e.canUnselect()) {
                            this.val$e.unselect();
                            return;
                        }
                        if (f > 16.0 && g < 16.0 && this.val$e.canMoveUp()) {
                            this.val$e.moveUp();
                            return;
                        }
                        if (f > 16.0 && g > 16.0 && this.val$e.canMoveDown()) {
                            this.val$e.moveDown();
                            return;
                        }
                    }
                    if (this.isFocused()) {
                        this.onPress();
                    }
                }

                private boolean showHoverOverlay() {
                    return !this.val$e.isFixedPosition() || !this.val$e.isRequired();
                }

                public void onPress() {
                    if (this.val$e.isSelected() && this.val$e.canUnselect()) {
                        this.val$e.unselect();
                        return;
                    }
                    if (this.val$e.getCompatibility().isCompatible()) {
                        this.val$e.select();
                    } else {
                        PackSelectionScreenMixin.this.minecraft.setScreen((Screen)new ConfirmationScreen((Screen)PackSelectionScreenMixin.this.self(), INCOMPATIBLE_CONFIRM_TITLE, this.val$e.getCompatibility().getConfirmation(), b -> {
                            this.val$e.select();
                            if (((PackSelectionScreenMixin)PackSelectionScreenMixin.this).minecraft.screen != null) {
                                ((PackSelectionScreenMixin)PackSelectionScreenMixin.this).minecraft.screen.onClose();
                            }
                        }));
                    }
                }

                public boolean keyPressed(int i, int j, int k) {
                    if (Screen.hasShiftDown() || ControllerBinding.LEFT_BUTTON.state().pressed) {
                        switch (i) {
                            case 265: {
                                int oldFocused;
                                int n = oldFocused = PackSelectionScreenMixin.this.getFocused() == null ? -1 : PackSelectionScreenMixin.this.children().indexOf(PackSelectionScreenMixin.this.getFocused());
                                if (this.val$e.canMoveUp()) {
                                    this.val$e.moveUp();
                                }
                                if (oldFocused >= 0 && oldFocused < PackSelectionScreenMixin.this.children.size()) {
                                    PackSelectionScreenMixin.this.setFocused((GuiEventListener)PackSelectionScreenMixin.this.children().get(oldFocused));
                                }
                                return false;
                            }
                            case 264: {
                                int oldFocused;
                                int n = oldFocused = PackSelectionScreenMixin.this.getFocused() == null ? -1 : PackSelectionScreenMixin.this.children().indexOf(PackSelectionScreenMixin.this.getFocused());
                                if (this.val$e.canMoveDown()) {
                                    this.val$e.moveDown();
                                }
                                if (oldFocused >= 0 && oldFocused < PackSelectionScreenMixin.this.children.size()) {
                                    PackSelectionScreenMixin.this.setFocused((GuiEventListener)PackSelectionScreenMixin.this.children().get(oldFocused));
                                }
                                return false;
                            }
                        }
                    }
                    return super.keyPressed(i, j, k);
                }

                protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
                    this.defaultButtonNarrationText(narrationElementOutput);
                }
            };
            if (!description.isEmpty()) {
                button.setTooltip((Tooltip)new MultilineTooltip(description, 161));
            }
            list.addRenderable((Renderable)button);
        });
    }

    @Override
    public RenderableVList getRenderableVList() {
        return this.unselectedPacksList;
    }

    @Override
    public List<RenderableVList> getRenderableVLists() {
        return this.renderableVLists;
    }

    public boolean mouseScrolled(double d, double e, double f, double g) {
        RenderableVList vList = this.getRenderableVListAt(d, e);
        if (vList != null) {
            vList.mouseScrolled(g);
        }
        return super.mouseScrolled(d, e, f, g);
    }

    public boolean keyPressed(int i, int j, int k) {
        for (RenderableVList renderableVList : this.getRenderableVLists()) {
            if (!renderableVList.keyPressed(i)) continue;
            return true;
        }
        if (i == 79) {
            Util.getPlatform().openPath(this.packDir);
            return true;
        }
        return super.keyPressed(i, j, k);
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        ScreenUtil.renderDefaultBackground(UIAccessor.of((Screen)this), guiGraphics, false);
        this.panel.render(guiGraphics, i, j, f);
        FactoryScreenUtil.enableBlend();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setColor(1.0f, 1.0f, 1.0f, 0.6f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.PANEL_RECESS, this.panel.x + 10, this.panel.y + 10, 190, 220);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).clearColor();
        FactoryScreenUtil.disableBlend();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.PANEL_RECESS, this.panel.x + 210, this.panel.y + 10, 190, 220);
        guiGraphics.drawString(this.font, SELECTED_PACK, this.panel.x + 10 + (190 - this.font.width((FormattedText)SELECTED_PACK)) / 2, this.panel.y + 18, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        guiGraphics.drawString(this.font, AVAILABLE_PACK, this.panel.x + 210 + (190 - this.font.width((FormattedText)AVAILABLE_PACK)) / 2, this.panel.y + 18, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        super.render(guiGraphics, i, j, f);
    }
}

