/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.SkyRenderer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacyRenderPipelines;

@Mixin(value={SkyRenderer.class})
public class SkyLevelRendererMixin {
    @Unique
    private boolean legacySkyShape = (Boolean)LegacyOptions.legacySkyShape.get();

    @ModifyVariable(method={"buildStars"}, at=@At(value="STORE"), ordinal=4)
    private float drawStars(float original) {
        return original - 0.05f;
    }

    @ModifyArg(method={"<init>"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/ByteBufferBuilder;<init>(I)V"))
    private int changeSkyBufferVertexCount(int vertices) {
        return this.legacySkyShape ? 576 * DefaultVertexFormat.POSITION.getVertexSize() : vertices;
    }

    @Inject(method={"renderDarkDisc", "renderSkyDisc"}, at={@At(value="HEAD")})
    private void addShareParams(CallbackInfo ci, @Share(value="autoStorageIndexBuffer") LocalRef<RenderSystem.AutoStorageIndexBuffer> autoStorageIndexBuffer, @Share(value="gpuBuffer") LocalRef<GpuBuffer> gpuBuffer) {
        if (this.legacySkyShape) {
            autoStorageIndexBuffer.set((Object)RenderSystem.getSequentialBuffer((VertexFormat.Mode)VertexFormat.Mode.QUADS));
            gpuBuffer.set((Object)((RenderSystem.AutoStorageIndexBuffer)autoStorageIndexBuffer.get()).getBuffer(864));
        }
    }

    @WrapOperation(method={"renderDarkDisc", "renderSkyDisc"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderPass;draw(II)V", remap=false)})
    private void changeSkyRenderVertexCount(RenderPass instance, int i, int size, Operation<Void> original, @Local RenderPass renderPass, @Share(value="autoStorageIndexBuffer") LocalRef<RenderSystem.AutoStorageIndexBuffer> autoStorageIndexBuffer, @Share(value="gpuBuffer") LocalRef<GpuBuffer> gpuBuffer) {
        if (this.legacySkyShape) {
            instance.setIndexBuffer((GpuBuffer)gpuBuffer.get(), ((RenderSystem.AutoStorageIndexBuffer)autoStorageIndexBuffer.get()).type());
            instance.drawIndexed(0, 864);
        } else {
            original.call(new Object[]{instance, i, size});
        }
    }

    @ModifyArg(method={"renderDarkDisc", "renderSkyDisc"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderPass;setPipeline(Lcom/mojang/blaze3d/pipeline/RenderPipeline;)V", remap=false))
    private RenderPipeline changeSkyRenderPipeline(RenderPipeline renderPipeline) {
        return this.legacySkyShape ? LegacyRenderPipelines.LEGACY_SKY : renderPipeline;
    }

    @Inject(method={"buildSkyDisc"}, at={@At(value="HEAD")}, cancellable=true)
    private void buildSkyDisc(VertexConsumer vertexConsumer, float f, CallbackInfo ci) {
        if (this.legacySkyShape) {
            Legacy4JClient.buildLegacySkyDisc(vertexConsumer, f);
            ci.cancel();
        }
    }
}

