/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.anvil;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AnvilScreen;
import net.minecraft.client.gui.screens.inventory.ItemCombinerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.Slot;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.client.CommonColor;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.util.LegacySprites;

@Mixin(value={AnvilScreen.class})
public abstract class AnvilScreenMixin
extends ItemCombinerScreen<AnvilMenu> {
    @Shadow
    private EditBox name;
    @Shadow
    @Final
    private static Component TOO_EXPENSIVE_TEXT;
    @Shadow
    @Final
    private Player player;
    private static final LegacySlotDisplay SLOTS_DISPLAY;

    @Shadow
    protected abstract void onNameChanged(String var1);

    public void init() {
        this.imageWidth = 207;
        this.imageHeight = 215;
        this.inventoryLabelX = 10;
        this.inventoryLabelY = 105;
        this.titleLabelX = 73;
        this.titleLabelY = 11;
        super.init();
        for (int i = 0; i < ((AnvilMenu)this.menu).slots.size(); ++i) {
            Slot s = (Slot)((AnvilMenu)this.menu).slots.get(i);
            if (i == 0) {
                LegacySlotDisplay.override(s, 15, 56, SLOTS_DISPLAY);
                continue;
            }
            if (i == 1) {
                LegacySlotDisplay.override(s, 84, 56, SLOTS_DISPLAY);
                continue;
            }
            if (i == 2) {
                LegacySlotDisplay.override(s, 167, 56, SLOTS_DISPLAY);
                continue;
            }
            if (i < ((AnvilMenu)this.menu).slots.size() - 9) {
                LegacySlotDisplay.override(s, 10 + (s.getContainerSlot() - 9) % 9 * 21, 116 + (s.getContainerSlot() - 9) / 9 * 21);
                continue;
            }
            LegacySlotDisplay.override(s, 10 + s.getContainerSlot() * 21, 185);
        }
    }

    public AnvilScreenMixin(AnvilMenu itemCombinerMenu, Inventory inventory, Component component, ResourceLocation resourceLocation) {
        super((ItemCombinerMenu)itemCombinerMenu, inventory, component, resourceLocation);
    }

    @Inject(method={"setInitialFocus"}, at={@At(value="HEAD")}, cancellable=true)
    protected void setInitialFocus(CallbackInfo ci) {
        ci.cancel();
        super.setInitialFocus();
    }

    public void repositionElements() {
        String string = this.name.getValue();
        super.repositionElements();
        this.name.setValue(string);
    }

    @Inject(method={"renderLabels"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderLabels(GuiGraphics guiGraphics, int i, int j, CallbackInfo ci) {
        ci.cancel();
        super.renderLabels(guiGraphics, i, j);
        int k = ((AnvilMenu)this.menu).getCost();
        if (k > 0) {
            Component component;
            int l = (Integer)CommonColor.EXPERIENCE_TEXT.get();
            if (k >= 40 && !this.minecraft.player.getAbilities().instabuild) {
                component = TOO_EXPENSIVE_TEXT;
                l = (Integer)CommonColor.ANVIL_ERROR_TEXT.get();
            } else if (!((AnvilMenu)this.menu).getSlot(2).hasItem()) {
                component = null;
            } else {
                component = Component.translatable((String)"container.repair.cost", (Object[])new Object[]{k});
                if (!((AnvilMenu)this.menu).getSlot(2).mayPickup(this.player)) {
                    l = (Integer)CommonColor.ANVIL_ERROR_TEXT.get();
                }
            }
            if (component != null) {
                int m = this.imageWidth - 8 - this.font.width((FormattedText)component) - 2;
                guiGraphics.drawString(this.font, component, m, 90, l);
            }
        }
    }

    @Inject(method={"subInit"}, at={@At(value="HEAD")}, cancellable=true)
    public void subInit(CallbackInfo ci) {
        ci.cancel();
        this.name = new EditBox(this.font, this.leftPos + 72, this.topPos + 26, 120, 18, (Component)Component.translatable((String)"container.repair"));
        this.name.setCanLoseFocus(false);
        this.name.setTextColor(-1);
        this.name.setTextColorUneditable(-1);
        this.name.setMaxLength(50);
        this.name.setResponder(this::onNameChanged);
        this.name.setValue("");
        this.addWidget((GuiEventListener)this.name);
        this.setInitialFocus((GuiEventListener)this.name);
        this.name.setEditable(((AnvilMenu)this.menu).getSlot(0).hasItem());
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBg(guiGraphics, f, i, j);
    }

    @Inject(method={"renderBg"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderBg(GuiGraphics guiGraphics, float f, int i, int j, CallbackInfo ci) {
        ci.cancel();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite((ResourceLocation)UIAccessor.of((Screen)this).getElementValue("imageSprite", (Object)LegacySprites.SMALL_PANEL, ResourceLocation.class), this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((double)this.leftPos + 13.5, (double)this.topPos + 9.5, 0.0);
        guiGraphics.pose().scale(2.5f, 2.5f, 2.5f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.ANVIL_HAMMER, 0, 0, 15, 15);
        guiGraphics.pose().popPose();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)(this.leftPos + 53), (float)(this.topPos + 60), 0.0f);
        guiGraphics.pose().scale(1.5f, 1.5f, 1.5f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.COMBINER_PLUS, 0, 0, 13, 13);
        guiGraphics.pose().popPose();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)(this.leftPos + 122), (float)(this.topPos + 59), 0.0f);
        guiGraphics.pose().scale(1.5f, 1.5f, 1.5f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.ARROW, 0, 0, 22, 15);
        if ((((AnvilMenu)this.menu).getSlot(0).hasItem() || ((AnvilMenu)this.menu).getSlot(1).hasItem()) && !((AnvilMenu)this.menu).getSlot(((AnvilMenu)this.menu).getResultSlot()).hasItem()) {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.ERROR_CROSS, 4, 0, 15, 15);
        }
        guiGraphics.pose().popPose();
    }

    static {
        SLOTS_DISPLAY = new LegacySlotDisplay(){

            @Override
            public int getWidth() {
                return 30;
            }
        };
    }
}

