/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.block;

import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import wily.factoryapi.base.config.FactoryMixinToggle;
import wily.legacy.block.ColoredWaterCauldronBlock;
import wily.legacy.block.entity.WaterCauldronBlockEntity;
import wily.legacy.config.LegacyMixinToggles;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.util.LegacyItemUtil;

public class LegacyBlockBehaviors {
    public static void setup() {
        DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior(){

            public ItemStack execute(BlockSource blockSource, ItemStack itemStack) {
                Direction direction = (Direction)blockSource.state().getValue((Property)DispenserBlock.FACING);
                EntityType entityType = ((SpawnEggItem)itemStack.getItem()).getType(itemStack);
                try {
                    if (entityType.spawn(blockSource.level(), itemStack, null, blockSource.pos().relative(direction), EntitySpawnReason.DISPENSER, direction != Direction.UP, false) != null) {
                        itemStack.shrink(1);
                        blockSource.level().gameEvent(null, (Holder)GameEvent.ENTITY_PLACE, blockSource.pos());
                    }
                }
                catch (Exception var6) {
                    LOGGER.error("Error while dispensing spawn egg from dispenser at {}", (Object)blockSource.pos(), (Object)var6);
                    return ItemStack.EMPTY;
                }
                return itemStack;
            }
        };
        for (SpawnEggItem spawnEggItem : SpawnEggItem.eggs()) {
            DispenserBlock.registerBehavior((ItemLike)spawnEggItem, (DispenseItemBehavior)defaultDispenseItemBehavior);
        }
        Map emptyCauldron = CauldronInteraction.EMPTY.map();
        Map waterCauldron = CauldronInteraction.WATER.map();
        Map powderSnowCauldron = CauldronInteraction.POWDER_SNOW.map();
        Map lavaCauldron = CauldronInteraction.LAVA.map();
        CauldronInteraction emptyCauldronPotion = (blockState, level, blockPos, player, interactionHand, itemStack) -> {
            Holder p = ((PotionContents)itemStack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).potion().orElse(null);
            if (p == null) {
                return LegacyBlockBehaviors.defaultPassInteraction();
            }
            level.setBlockAndUpdate(blockPos, Blocks.WATER_CAULDRON.defaultBlockState());
            level.getBlockEntity(blockPos, (BlockEntityType)LegacyRegistries.WATER_CAULDRON_BLOCK_ENTITY.get()).ifPresent(be -> {
                be.potion = p;
                be.lastPotionItemUsed = itemStack.getItemHolder();
                be.setChanged();
                if (be.hasWater()) {
                    LegacyBlockBehaviors.sendCauldronBubblesParticles(level, blockPos);
                }
            });
            if (!level.isClientSide()) {
                Item item = itemStack.getItem();
                player.setItemInHand(interactionHand, ItemUtils.createFilledResult((ItemStack)itemStack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.GLASS_BOTTLE)));
                player.awardStat(Stats.USE_CAULDRON);
                player.awardStat(Stats.ITEM_USED.get((Object)item));
                level.playSound(null, blockPos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.gameEvent(null, (Holder)GameEvent.FLUID_PLACE, blockPos);
                return LegacyBlockBehaviors.consumeInteraction();
            }
            return LegacyBlockBehaviors.successInteraction();
        };
        LegacyBlockBehaviors.putInteractionOrFallback(emptyCauldron, Items.POTION, emptyCauldronPotion);
        LegacyBlockBehaviors.putInteractionOrFallback(emptyCauldron, Items.SPLASH_POTION, emptyCauldronPotion);
        LegacyBlockBehaviors.putInteractionOrFallback(emptyCauldron, Items.LINGERING_POTION, emptyCauldronPotion);
        LegacyBlockBehaviors.putInteractionOrFallback(waterCauldron, Items.GLASS_BOTTLE, (blockState, level, blockPos, player, interactionHand, itemStack) -> {
            WaterCauldronBlockEntity be;
            block5: {
                block4: {
                    BlockEntity patt0$temp = level.getBlockEntity(blockPos);
                    if (!(patt0$temp instanceof WaterCauldronBlockEntity)) break block4;
                    be = (WaterCauldronBlockEntity)patt0$temp;
                    if (be.waterColor == null) break block5;
                }
                return LegacyBlockBehaviors.defaultPassInteraction();
            }
            if (!level.isClientSide()) {
                Item item = itemStack.getItem();
                player.setItemInHand(interactionHand, ItemUtils.createFilledResult((ItemStack)itemStack, (Player)player, (ItemStack)LegacyItemUtil.setItemStackPotion(new ItemStack(be.lastPotionItemUsed), be.potion)));
                player.awardStat(Stats.USE_CAULDRON);
                player.awardStat(Stats.ITEM_USED.get((Object)item));
                LayeredCauldronBlock.lowerFillLevel((BlockState)blockState, (Level)level, (BlockPos)blockPos);
                LegacyBlockBehaviors.sendCauldronSplashParticles(level, blockPos);
                level.playSound(null, blockPos, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.gameEvent(null, (Holder)GameEvent.FLUID_PICKUP, blockPos);
                return LegacyBlockBehaviors.consumeInteraction();
            }
            return LegacyBlockBehaviors.successInteraction();
        });
        CauldronInteraction waterCauldronPotion = (blockState, level, blockPos, player, interactionHand, itemStack) -> {
            Holder<Potion> p;
            WaterCauldronBlockEntity be;
            block12: {
                block11: {
                    BlockEntity patt0$temp = level.getBlockEntity(blockPos);
                    if (!(patt0$temp instanceof WaterCauldronBlockEntity)) break block11;
                    be = (WaterCauldronBlockEntity)patt0$temp;
                    p = LegacyItemUtil.getPotionContent(itemStack);
                    if (p != null && ((Integer)blockState.getValue((Property)LayeredCauldronBlock.LEVEL) != 3 || !be.potion.equals(p))) break block12;
                }
                return LegacyBlockBehaviors.defaultPassInteraction();
            }
            if (!be.potion.equals(p)) {
                level.setBlockAndUpdate(blockPos, Blocks.CAULDRON.defaultBlockState());
                if (!be.potion.equals(p) && !level.isClientSide()) {
                    level.playSound(null, blockPos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            } else {
                level.setBlockAndUpdate(blockPos, (BlockState)blockState.cycle((Property)LayeredCauldronBlock.LEVEL));
                if (be.waterColor != null) {
                    be.setWaterColor(null);
                    level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(1)));
                    be.setRemoved();
                }
                be.lastPotionItemUsed = itemStack.getItemHolder();
                if (!level.isClientSide()) {
                    level.playSound(null, blockPos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
            if (!level.isClientSide()) {
                player.setItemInHand(interactionHand, ItemUtils.createFilledResult((ItemStack)itemStack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.GLASS_BOTTLE)));
                player.awardStat(Stats.USE_CAULDRON);
                player.awardStat(Stats.ITEM_USED.get((Object)itemStack.getItem()));
                level.gameEvent(null, (Holder)GameEvent.FLUID_PLACE, blockPos);
                if (be.hasWater() && !be.isRemoved()) {
                    LegacyBlockBehaviors.sendCauldronBubblesParticles(level, blockPos);
                }
                return LegacyBlockBehaviors.consumeInteraction();
            }
            return LegacyBlockBehaviors.successInteraction();
        };
        LegacyBlockBehaviors.putInteractionOrFallback(waterCauldron, Items.POTION, waterCauldronPotion);
        LegacyBlockBehaviors.putInteractionOrFallback(waterCauldron, Items.SPLASH_POTION, waterCauldronPotion);
        LegacyBlockBehaviors.putInteractionOrFallback(waterCauldron, Items.LINGERING_POTION, waterCauldronPotion);
        LegacyBlockBehaviors.putInteractionOrFallback(waterCauldron, Items.ARROW, (blockState, level, blockPos, player, interactionHand, itemStack) -> {
            WaterCauldronBlockEntity be;
            BlockEntity patt0$temp = level.getBlockEntity(blockPos);
            if (!(patt0$temp instanceof WaterCauldronBlockEntity) || (be = (WaterCauldronBlockEntity)patt0$temp).hasWater()) {
                return LegacyBlockBehaviors.defaultPassInteraction();
            }
            if (!level.isClientSide()) {
                int l = (Integer)blockState.getValue((Property)LayeredCauldronBlock.LEVEL);
                int arrowCount = Math.min(itemStack.getCount(), l < 3 ? l * 16 : 64);
                itemStack.consume(arrowCount, (LivingEntity)player);
                ItemStack tippedArrow = LegacyItemUtil.setItemStackPotion(new ItemStack((ItemLike)Items.TIPPED_ARROW, arrowCount), be.potion);
                player.getInventory().placeItemBackInInventory(tippedArrow);
                player.awardStat(Stats.USE_CAULDRON);
                player.awardStat(Stats.ITEM_USED.get((Object)itemStack.getItem()));
                int i = (int)Math.min(3.0, Math.ceil((double)arrowCount / 16.0));
                BlockState blockState2 = l - i == 0 ? Blocks.CAULDRON.defaultBlockState() : (BlockState)blockState.setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(i));
                level.setBlockAndUpdate(blockPos, blockState2);
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockPos, GameEvent.Context.of((BlockState)blockState2));
                return LegacyBlockBehaviors.consumeInteraction();
            }
            return LegacyBlockBehaviors.successInteraction();
        });
        BiFunction<CauldronInteraction, CauldronInteraction, CauldronInteraction> beforeInteraction = (a, b) -> (blockState, level, blockPos, player, interactionHand, itemStack) -> {
            if (((Boolean)LegacyMixinToggles.legacyCauldrons.get()).booleanValue()) {
                b.interact(blockState, level, blockPos, player, interactionHand, itemStack);
            }
            return a.interact(blockState, level, blockPos, player, interactionHand, itemStack);
        };
        CauldronInteraction fillWater = (blockState, level, blockPos, player, interactionHand, itemStack) -> {
            LegacyBlockBehaviors.sendCauldronBubblesParticles(level, blockPos);
            BlockEntity patt0$temp = level.getBlockEntity(blockPos);
            if (patt0$temp instanceof WaterCauldronBlockEntity) {
                WaterCauldronBlockEntity be = (WaterCauldronBlockEntity)patt0$temp;
                be.setWaterColor(null);
                if (!be.hasWater()) {
                    be.potion = be.getDefaultPotion();
                    if (!level.isClientSide()) {
                        level.playSound(null, blockPos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                }
            }
            return LegacyBlockBehaviors.successInteraction();
        };
        waterCauldron.merge(Items.WATER_BUCKET, fillWater, beforeInteraction);
        emptyCauldron.merge(Items.WATER_BUCKET, fillWater, beforeInteraction);
        powderSnowCauldron.merge(Items.WATER_BUCKET, fillWater, beforeInteraction);
        lavaCauldron.merge(Items.WATER_BUCKET, fillWater, beforeInteraction);
        CauldronInteraction fillLava = (blockState, level, blockPos, player, interactionHand, itemStack) -> {
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                Vec3 center = blockPos.getCenter();
                sl.sendParticles((ParticleOptions)ParticleTypes.LAVA, center.x, center.y + 0.5, center.z, 2, 0.2, 0.1, 0.2, (double)0.02f);
            }
            return LegacyBlockBehaviors.successInteraction();
        };
        waterCauldron.merge(Items.LAVA_BUCKET, fillLava, beforeInteraction);
        emptyCauldron.merge(Items.LAVA_BUCKET, fillLava, beforeInteraction);
        powderSnowCauldron.merge(Items.LAVA_BUCKET, fillLava, beforeInteraction);
        lavaCauldron.merge(Items.LAVA_BUCKET, fillLava, beforeInteraction);
        LegacyBlockBehaviors.putInteractionOrFallback(waterCauldron, Items.BUCKET, (blockState, level, blockPos, player, interactionHand, itemStack) -> {
            if (!LegacyRegistries.isInvalidCauldron(blockState, level, blockPos)) {
                LegacyBlockBehaviors.sendCauldronSplashParticles(level, blockPos);
                return CauldronInteraction.fillBucket((BlockState)blockState, (Level)level, (BlockPos)blockPos, (Player)player, (InteractionHand)interactionHand, (ItemStack)itemStack, (ItemStack)new ItemStack((ItemLike)Items.WATER_BUCKET), blockStatex -> (Integer)blockStatex.getValue((Property)LayeredCauldronBlock.LEVEL) == 3, (SoundEvent)SoundEvents.BUCKET_FILL);
            }
            return LegacyBlockBehaviors.consumeInteraction();
        });
        for (DyeColor color : DyeColor.values()) {
            LegacyBlockBehaviors.putInteractionOrFallback(waterCauldron, (Item)DyeItem.byColor((DyeColor)color), (blockState, level, blockPos, player, interactionHand, itemStack) -> {
                WaterCauldronBlockEntity be;
                block7: {
                    block6: {
                        BlockEntity patt0$temp = level.getBlockEntity(blockPos);
                        if (!(patt0$temp instanceof WaterCauldronBlockEntity)) break block6;
                        be = (WaterCauldronBlockEntity)patt0$temp;
                        if (itemStack.getItem() instanceof DyeItem && be.hasWater()) break block7;
                    }
                    return LegacyBlockBehaviors.defaultPassInteraction();
                }
                int dyeColor = LegacyItemUtil.getDyeColor(color);
                if (be.waterColor == null) {
                    be.setWaterColor(dyeColor);
                } else {
                    be.waterColor = LegacyItemUtil.mixColors(List.of(be.waterColor, Integer.valueOf(dyeColor)).iterator());
                    be.setWaterColor(be.waterColor);
                }
                be.setChanged();
                if (!level.isClientSide()) {
                    level.playSound(null, blockPos, SoundEvents.GENERIC_SPLASH, SoundSource.BLOCKS, 0.25f, 1.0f);
                    LegacyBlockBehaviors.sendCauldronBubblesParticles(level, blockPos);
                }
                return level.isClientSide() ? LegacyBlockBehaviors.successInteraction() : LegacyBlockBehaviors.consumeInteraction();
            });
        }
    }

    public static void putInteractionOrFallback(Map<Item, CauldronInteraction> interactionMap, Item item, CauldronInteraction cauldronInteraction) {
        LegacyBlockBehaviors.putInteractionOrFallback(interactionMap, item, cauldronInteraction, () -> ((FactoryMixinToggle)LegacyMixinToggles.legacyCauldrons).get());
    }

    public static void putInteractionOrFallback(Map<Item, CauldronInteraction> interactionMap, Item item, CauldronInteraction cauldronInteraction, BooleanSupplier supplier) {
        interactionMap.merge(item, cauldronInteraction, (a, b) -> (blockState, level, blockPos, player, interactionHand, itemStack) -> {
            if (supplier.getAsBoolean()) {
                return b.interact(blockState, level, blockPos, player, interactionHand, itemStack);
            }
            return a.interact(blockState, level, blockPos, player, interactionHand, itemStack);
        });
    }

    public static void registerDyedWaterCauldronInteraction(Map<Item, CauldronInteraction> waterCauldron) {
        if (!((Boolean)LegacyMixinToggles.legacyCauldrons.get()).booleanValue()) {
            return;
        }
        BuiltInRegistries.ITEM.asHolderIdMap().forEach(i -> {
            if (!LegacyItemUtil.isDyeableItem((Holder<Item>)i)) {
                return;
            }
            waterCauldron.put((Item)i.value(), (blockState, level, blockPos, player, interactionHand, itemStack) -> {
                WaterCauldronBlockEntity be;
                BlockEntity patt0$temp = level.getBlockEntity(blockPos);
                if (!(patt0$temp instanceof WaterCauldronBlockEntity) || !(be = (WaterCauldronBlockEntity)patt0$temp).hasWater() || LegacyItemUtil.isDyedItem(itemStack) && be.waterColor == null) {
                    return LegacyBlockBehaviors.defaultPassInteraction();
                }
                if (!level.isClientSide()) {
                    player.awardStat(Stats.USE_CAULDRON);
                    player.awardStat(Stats.ITEM_USED.get((Object)itemStack.getItem()));
                    if (be.waterColor == null) {
                        itemStack.set(DataComponents.DYED_COLOR, null);
                    } else {
                        LegacyItemUtil.dyeItem(itemStack, be.waterColor);
                        level.playSound(null, blockPos, SoundEvents.GENERIC_SPLASH, SoundSource.BLOCKS, 0.25f, 1.0f);
                        LegacyBlockBehaviors.sendCauldronSplashParticles(level, blockPos);
                    }
                    ColoredWaterCauldronBlock.lowerFillLevel(be);
                }
                return LegacyBlockBehaviors.successInteraction();
            });
        });
    }

    public static void sendCauldronBubblesParticles(Level level, BlockPos blockPos) {
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            Vec3 center = blockPos.getCenter();
            sl.sendParticles((ParticleOptions)ParticleTypes.BUBBLE, center.x, center.y + 0.5, center.z, 2, 0.2, 0.1, 0.2, (double)0.02f);
        }
    }

    public static void sendCauldronSplashParticles(Level level, BlockPos blockPos) {
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            Vec3 center = blockPos.getCenter();
            sl.sendParticles((ParticleOptions)ParticleTypes.SPLASH, center.x, center.y + 0.5, center.z, 2, 0.2, 0.2, 0.2, 1.0);
        }
    }

    public static InteractionResult defaultPassInteraction() {
        return InteractionResult.PASS;
    }

    public static InteractionResult successInteraction() {
        return InteractionResult.SUCCESS;
    }

    public static InteractionResult consumeInteraction() {
        return InteractionResult.CONSUME;
    }
}

