/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.resources.ResourceLocation;
import wily.factoryapi.util.ColorUtil;
import wily.legacy.client.VertexConsumerWrapper;
import wily.legacy.mixin.base.client.BufferSourceAccessor;
import wily.legacy.mixin.base.client.CompositeRenderTypeAccessor;

public class BufferSourceWrapper
extends MultiBufferSource.BufferSource {
    public final MultiBufferSource.BufferSource source;
    private RenderType overrideRenderType;
    private Function<VertexConsumer, VertexConsumer> vertexConsumerFunction = Function.identity();

    public BufferSourceWrapper(MultiBufferSource.BufferSource source) {
        super(((BufferSourceAccessor)source).buffer(), ((BufferSourceAccessor)source).fixedBuffers());
        this.source = source;
    }

    public static BufferSourceWrapper translucent(MultiBufferSource.BufferSource source, float opacity) {
        return new BufferSourceWrapper(source){

            @Override
            public VertexConsumer getBuffer(RenderType renderType) {
                if (renderType == Sheets.cutoutBlockSheet()) {
                    return super.getBuffer(Sheets.translucentItemSheet());
                }
                if (renderType.format() == DefaultVertexFormat.NEW_ENTITY && renderType instanceof RenderType.CompositeRenderType) {
                    RenderType.CompositeRenderType r = (RenderType.CompositeRenderType)renderType;
                    RenderStateShard.EmptyTextureStateShard emptyTextureStateShard = ((CompositeRenderTypeAccessor)r).getState().textureState;
                    if (emptyTextureStateShard instanceof RenderStateShard.TextureStateShard) {
                        RenderStateShard.TextureStateShard s = (RenderStateShard.TextureStateShard)emptyTextureStateShard;
                        if (s.texture.isPresent()) {
                            return super.getBuffer(RenderType.itemEntityTranslucentCull((ResourceLocation)((ResourceLocation)s.texture.get())));
                        }
                    }
                }
                return super.getBuffer(renderType);
            }
        }.setVertexConsumerFunction(consumer -> new VertexConsumerWrapper((VertexConsumer)consumer).setColorMultiplier(ColorUtil.withAlpha((int)0xFFFFFF, (float)opacity)));
    }

    public static BufferSourceWrapper of(MultiBufferSource.BufferSource source, RenderType overrideType) {
        BufferSourceWrapper wrapper = new BufferSourceWrapper(source);
        wrapper.setOverrideRenderType(overrideType);
        return wrapper;
    }

    public void endLastBatch() {
        this.source.endLastBatch();
    }

    public void endBatch() {
        this.source.endBatch();
    }

    public void endBatch(RenderType renderType) {
        this.source.endBatch(renderType);
    }

    public BufferSourceWrapper setOverrideRenderType(RenderType overrideRenderTpe) {
        this.overrideRenderType = overrideRenderTpe;
        return this;
    }

    public BufferSourceWrapper setVertexConsumerFunction(Function<VertexConsumer, VertexConsumer> vertexConsumerFunction) {
        this.vertexConsumerFunction = vertexConsumerFunction;
        return this;
    }

    public VertexConsumer getBuffer(RenderType renderType) {
        return this.vertexConsumerFunction.apply(this.source.getBuffer(this.overrideRenderType == null ? renderType : this.overrideRenderType));
    }
}

