/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import wily.legacy.client.LoyaltyLinesRenderState;

public class LoyaltyLinesRenderer {
    public static void renderLoyaltyLines(LoyaltyLinesRenderState renderState, VertexConsumer vertexConsumer, PoseStack.Pose pose, int light) {
        if (renderState.canRender) {
            double d1 = Math.cos(renderState.horizontalMovementFactor);
            double d2 = Math.sin(renderState.horizontalMovementFactor);
            double d6 = d1 - d2;
            double d7 = d2 + d1;
            double d14 = Math.sqrt(renderState.x * renderState.x + renderState.y * renderState.y + renderState.z * renderState.z);
            double d15 = (double)renderState.uniqueAge * -0.1;
            double d16 = Math.min(0.5, d14 / 30.0);
            int k = 7 - (int)renderState.uniqueAge % 7;
            LoyaltyLinesRenderer.renderLoyaltyLine(renderState, pose, vertexConsumer, k, d6, d7, d15, d16, 0.02, light);
            LoyaltyLinesRenderer.renderLoyaltyLine(renderState, pose, vertexConsumer, k, d6, d7, d15, d16, 0.01, light);
        }
    }

    public static void renderLoyaltyLine(LoyaltyLinesRenderState renderState, PoseStack.Pose pose, VertexConsumer consumer, int k, double d6, double d7, double d15, double d16, double lineYD, int light) {
        for (int l = 0; l <= 37; ++l) {
            float d18 = (float)l / 37.0f;
            float f = 1.0f - (float)((l + k) % 7) / 7.0f;
            double d19 = (double)d18 * 2.0 - 1.0;
            d19 = (float)((1.0 - d19 * d19) * d16);
            double d20 = renderState.x * (double)d18 + Math.sin((double)d18 * Math.PI * 8.0 + d15) * d6 * d19;
            double d21 = renderState.y * (double)d18 + Math.cos((double)d18 * Math.PI * 8.0 + d15) * lineYD + (0.1 + d19);
            double d22 = renderState.z * (double)d18 + Math.sin((double)d18 * Math.PI * 8.0 + d15) * d7 * d19;
            float f1 = 0.2f * f + 0.34f;
            float f2 = 0.07f * f + 0.18f;
            float f3 = 0.14f * f + 0.52f;
            consumer.addVertex(pose, (float)d20, (float)d21, (float)d22).setColor(f1, f2, f3, 1.0f).setLight(light);
            consumer.addVertex(pose, (float)(d20 + (double)0.1f * d19), (float)(d21 + (double)0.1f * d19), (float)d22).setColor(f1, f2, f3, 1.0f).setLight(light);
            if (l > renderState.clientSideReturnTridentTickCount * 2) break;
        }
    }

    public record Submit(LoyaltyLinesRenderState renderState) implements SubmitNodeCollector.CustomGeometryRenderer
    {
        public void render(PoseStack.Pose pose, VertexConsumer vertexConsumer) {
            LoyaltyLinesRenderer.renderLoyaltyLines(this.renderState, vertexConsumer, pose, 240);
        }
    }
}

