/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.google.common.base.Charsets;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.util.ListMap;
import wily.legacy.Legacy4J;
import wily.legacy.client.IdValueInfo;
import wily.legacy.util.IOUtil;

public record MapIdValueManager<T extends IdValueInfo<T>, M extends Map<ResourceLocation, T>>(ResourceLocation name, Codec<List<T>> codec, M map, boolean removeInvalid) implements ResourceManagerReloadListener
{
    public static boolean DEBUG = false;

    public static <T extends IdValueInfo<T>> MapIdValueManager<T, LinkedHashMap<ResourceLocation, T>> createWithListCodec(ResourceLocation name, Codec<List<T>> codec) {
        return new MapIdValueManager(name, codec, new LinkedHashMap(), false);
    }

    public static <T extends IdValueInfo<T>> MapIdValueManager<T, LinkedHashMap<ResourceLocation, T>> create(ResourceLocation name, Codec<T> codec) {
        return MapIdValueManager.createWithListCodec(name, codec.listOf());
    }

    public static <T extends IdValueInfo<T>> MapIdValueManager<T, ListMap<ResourceLocation, T>> createListMap(ResourceLocation name, Codec<T> codec) {
        return new MapIdValueManager<T, ListMap>(name, codec.listOf(), new ListMap(), true);
    }

    public String getName() {
        return this.name.toString();
    }

    public void onResourceManagerReload(ResourceManager manager) {
        this.map.clear();
        IOUtil.getOrderedNamespaces(manager).forEach(name -> manager.getResource(FactoryAPI.createLocation((String)name, (String)(this.name().getPath() + ".json"))).ifPresent(r -> {
            try (BufferedReader bufferedReader = r.openAsReader();){
                this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)bufferedReader)).resultOrPartial(error -> Legacy4J.LOGGER.warn("Failed to parse {}: {}", (Object)this.getName(), error)).ifPresent(listings -> {
                    for (IdValueInfo listing : listings) {
                        this.map.put((ResourceLocation)listing.id(), (IdValueInfo)(this.map.containsKey(listing.id()) ? ((IdValueInfo)this.map.get(listing.id())).copyFrom(listing) : listing));
                    }
                });
            }
            catch (IOException exception) {
                Legacy4J.LOGGER.warn(exception.getMessage());
            }
            if (DEBUG) {
                new File(Minecraft.getInstance().gameDirectory, "debug_map_id_values").mkdirs();
                try (JsonWriter w = new JsonWriter((Writer)Files.newBufferedWriter(Minecraft.getInstance().gameDirectory.toPath().resolve("debug_map_id_values/" + this.name().getPath() + ".json"), Charsets.UTF_8, new OpenOption[0]));){
                    w.setSerializeNulls(false);
                    w.setIndent("  ");
                    GsonHelper.writeValue((JsonWriter)w, (JsonElement)((JsonElement)this.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, List.copyOf(this.map.values())).resultOrPartial(error -> Legacy4J.LOGGER.warn("Failed to write {}: {}", (Object)this.getName(), error)).orElseThrow()), null);
                }
                catch (IOException exception) {
                    Legacy4J.LOGGER.warn(exception.getMessage());
                }
            }
        }));
    }
}

