/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import wily.factoryapi.base.config.FactoryConfig;
import wily.factoryapi.util.DynamicUtil;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.IdValueInfo;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.OptionHolder;
import wily.legacy.client.screen.OptionsScreen;

public record OptionsPreset(ResourceLocation id, Optional<Component> name, Optional<Component> tooltip, Map<String, Object> legacyOptions, Map<String, Object> vanillaOptions) implements IdValueInfo<OptionsPreset>
{
    public static final Map<String, OptionInstance<?>> VANILLA_OPTIONS_MAP = new HashMap();
    public static final Codec<Map<String, Object>> LEGACY_OPTIONS_CODEC = Codec.dispatchedMap((Codec)Codec.STRING.validate(s -> LegacyOptions.CLIENT_STORAGE.configMap.containsKey(s) ? DataResult.success((Object)s) : DataResult.error(() -> "Can't find legacy option named as " + s)), s -> ((FactoryConfig)LegacyOptions.CLIENT_STORAGE.configMap.get(s)).control().codec());
    public static final Codec<Map<String, Object>> VANILLA_OPTIONS_CODEC = Codec.dispatchedMap((Codec)Codec.STRING.validate(s -> VANILLA_OPTIONS_MAP.containsKey(s) ? DataResult.success((Object)s) : DataResult.error(() -> "Can't find vanilla option named as " + s)), s -> VANILLA_OPTIONS_MAP.get(s).codec());
    public static final Codec<OptionsPreset> CODEC = RecordCodecBuilder.create(i -> i.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(OptionsPreset::id), (App)DynamicUtil.getComponentCodec().optionalFieldOf("name").forGetter(OptionsPreset::name), (App)DynamicUtil.getComponentCodec().optionalFieldOf("tooltip").forGetter(OptionsPreset::tooltip), (App)LEGACY_OPTIONS_CODEC.optionalFieldOf("legacy", Collections.emptyMap()).forGetter(OptionsPreset::legacyOptions), (App)VANILLA_OPTIONS_CODEC.optionalFieldOf("vanilla", Collections.emptyMap()).forGetter(OptionsPreset::vanillaOptions)).apply((Applicative)i, OptionsPreset::new));
    public static final Codec<OptionHolder<OptionsPreset>> OPTION_CODEC = OptionHolder.createCodec(r -> (OptionsPreset)Legacy4JClient.optionPresetsManager.map().get(r));

    @Override
    public OptionsPreset copyFrom(OptionsPreset other) {
        return new OptionsPreset(this.id, other.name().or(this::name), other.tooltip().or(this::tooltip), (Map<String, Object>)ImmutableMap.builder().putAll(this.legacyOptions).putAll(other.legacyOptions).build(), (Map<String, Object>)ImmutableMap.builder().putAll(this.vanillaOptions).putAll(other.vanillaOptions).build());
    }

    public void apply() {
        this.vanillaOptions.forEach((key, value) -> this.setVanillaOption(VANILLA_OPTIONS_MAP.get(key), value));
        this.legacyOptions.forEach((key, value) -> this.setConfig((FactoryConfig)LegacyOptions.CLIENT_STORAGE.configMap.get(key), value));
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof OptionsScreen) {
            OptionsScreen screen2 = (OptionsScreen)screen;
            screen2.updateWidgets(true);
        }
    }

    public boolean isApplied() {
        for (Map.Entry<String, Object> e : this.vanillaOptions.entrySet()) {
            OptionInstance<?> option = VANILLA_OPTIONS_MAP.get(e.getKey());
            if (option == null || option.get().equals(e.getValue())) continue;
            return false;
        }
        for (Map.Entry<String, Object> e : this.legacyOptions.entrySet()) {
            FactoryConfig config = (FactoryConfig)LegacyOptions.CLIENT_STORAGE.configMap.get(e.getKey());
            if (config == null || config.get().equals(e.getValue())) continue;
            return false;
        }
        return true;
    }

    public void saveIfNeeded() {
        if (!this.vanillaOptions.isEmpty()) {
            Minecraft.getInstance().options.save();
        }
        if (!this.legacyOptions.isEmpty()) {
            LegacyOptions.CLIENT_STORAGE.save();
        }
    }

    public void applyAndSave() {
        this.apply();
        this.saveIfNeeded();
    }

    public <T> void setVanillaOption(OptionInstance<T> option, Object value) {
        if (option != null) {
            OptionInstance.ValueSet valueSet = option.values();
            if (valueSet instanceof OptionInstance.CycleableValueSet) {
                OptionInstance.CycleableValueSet set = (OptionInstance.CycleableValueSet)valueSet;
                set.valueSetter().set(option, value);
            } else {
                option.set(value);
            }
        }
    }

    public <T> void setConfig(FactoryConfig<T> config, Object value) {
        if (config != null) {
            config.set(value);
        }
    }

    @Override
    public boolean isValid() {
        return !this.legacyOptions.isEmpty() || !this.vanillaOptions.isEmpty();
    }
}

