/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.PlayerSkin;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.legacy.Legacy4J;
import wily.legacy.client.CommonColor;
import wily.legacy.client.ControlType;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.CreationList;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PanelVListScreen;
import wily.legacy.client.screen.SaveRenderableList;
import wily.legacy.client.screen.TickBox;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyRenderUtil;
import wily.legacy.util.client.MCAccount;

public class ChooseUserScreen
extends PanelVListScreen {
    public static final Component CHOOSE_USER = Component.translatable((String)"legacy.menu.choose_user");
    public static final Component CHOOSE_USER_MESSAGE = Component.translatable((String)"legacy.menu.choose_user_message");
    public static final Component ADD_ACCOUNT = Component.translatable((String)"legacy.menu.choose_user.add");
    public static final Component ACCOUNT_OPTIONS = Component.translatable((String)"legacy.menu.choose_user.account_options");
    public static final Component DIRECT_LOGIN = Component.translatable((String)"legacy.menu.choose_user.direct_login");
    public static final Component ACCOUNT_OPTIONS_MESSAGE = Component.translatable((String)"legacy.menu.choose_user.account_options_message");
    public static final Component EDIT_ACCOUNT = Component.translatable((String)"legacy.menu.choose_user.account_options.edit");
    public static final Component DELETE_ACCOUNT = Component.translatable((String)"legacy.menu.choose_user.account_options.delete");
    public static final Component ACCOUNT_ENCRYPTION = Component.translatable((String)"legacy.menu.choose_user.add.encryption");
    public static final Component ACCOUNT_ENCRYPTION_MESSAGE = Component.translatable((String)"legacy.menu.choose_user.add.encryption_message");
    public static final Component ADD_WITH_ENCRYPTION = Component.translatable((String)"legacy.menu.choose_user.add.encryption.present");
    public static final Component ADD_WITHOUT_ENCRYPTION = Component.translatable((String)"legacy.menu.choose_user.add.encryption.absent");
    public static final Component VISIBLE_PASSWORD = Component.translatable((String)"legacy.menu.choose_user.add.encryption.visible_password");
    public static final Pattern usernamePattern = Pattern.compile("[A-Za-z0-9_]{2,16}");
    protected final Panel panelRecess;

    public ChooseUserScreen(Screen parent) {
        super(parent, (PanelVListScreen s) -> Panel.centered(s, 260, 215, 0, 10), CHOOSE_USER);
        this.renderableVList.layoutSpacing(i -> 0);
        this.addAccountButtons();
        this.panelRecess = Panel.createPanel(this, p -> p.appearance(LegacySprites.PANEL_RECESS, this.panel.getWidth() - 20, this.panel.getHeight() - 26), p -> p.pos(this.panel.getX() + 10, this.panel.getY() + 13));
    }

    public static ConfirmationScreen passwordScreen(Screen parent, Consumer<String> pass) {
        final EditBox passWordBox = new EditBox(Minecraft.getInstance().font, 0, 0, 200, 20, (Component)Component.translatable((String)"legacy.menu.choose_user.add.encryption.password"));
        final TickBox tickBox = new TickBox(0, 0, true, bol -> VISIBLE_PASSWORD, bol -> null, t -> {});
        passWordBox.addFormatter((s, i) -> FormattedCharSequence.forward((String)(tickBox.selected ? s : "*".repeat(s.length())), (Style)Style.EMPTY));
        tickBox.onPress((InputWithModifiers)new KeyEvent(257, 0, 0));
        return new ConfirmationScreen(parent, ConfirmationScreen::getPanelWidth, () -> LegacyOptions.getUIMode().isSD() ? 98 : 120, passWordBox.getMessage(), (Component)Component.translatable((String)"legacy.menu.choose_user.add.encryption.password_message"), b1 -> pass.accept(passWordBox.getValue())){

            @Override
            protected void addButtons() {
                super.addButtons();
                this.okButton.active = false;
            }

            @Override
            protected void init() {
                super.init();
                boolean sd = LegacyOptions.getUIMode().isSD();
                int layoutX = this.panel.x + (this.panel.width - this.renderableVList.listWidth) / 2;
                passWordBox.setPosition(layoutX, this.panel.getY() + (sd ? 32 : 45));
                passWordBox.setWidth(this.renderableVList.listWidth);
                passWordBox.setHeight(sd ? 16 : 20);
                passWordBox.setResponder(s -> {
                    this.okButton.active = !s.isEmpty();
                });
                this.addRenderableWidget((GuiEventListener)passWordBox);
                tickBox.setPosition(layoutX, this.panel.getY() + (sd ? 51 : 68));
                tickBox.setWidth(this.renderableVList.listWidth);
                tickBox.updateHeight();
                this.addRenderableWidget((GuiEventListener)tickBox);
            }
        };
    }

    public static ConfirmationScreen accountScreen(Component title, Screen parent, final boolean allowEncryption, final Consumer<MCAccount> press) {
        return new ConfirmationScreen(parent, ConfirmationScreen::getPanelWidth, () -> LegacyOptions.getUIMode().isSD() ? 80 : 120, title, CHOOSE_USER_MESSAGE){

            @Override
            protected void addButtons() {
                this.renderableVList.addRenderable((Renderable)Button.builder((Component)Component.translatable((String)"gui.cancel"), b -> this.onClose()).build());
                this.renderableVList.addRenderable((Renderable)Button.builder((Component)Component.translatable((String)"legacy.menu.choose_user.microsoft"), b -> {
                    if (allowEncryption) {
                        this.minecraft.setScreen((Screen)new ConfirmationScreen(this, this, ACCOUNT_ENCRYPTION, ACCOUNT_ENCRYPTION_MESSAGE){

                            @Override
                            protected void addButtons() {
                                this.renderableVList.addRenderable((Renderable)Button.builder((Component)ADD_WITH_ENCRYPTION, b -> this.minecraft.setScreen((Screen)ChooseUserScreen.passwordScreen(this, s -> MCAccount.create(() -> this.minecraft.setScreen((Screen)this), s).thenAcceptAsync(press, (Executor)this.minecraft)))).build());
                                this.renderableVList.addRenderable((Renderable)Button.builder((Component)ADD_WITHOUT_ENCRYPTION, b -> MCAccount.create(() -> this.minecraft.setScreen((Screen)this), null).thenAcceptAsync(press, (Executor)this.minecraft)).build());
                            }
                        });
                    } else {
                        MCAccount.create(() -> this.minecraft.setScreen((Screen)this), null).thenAcceptAsync(press, (Executor)this.minecraft);
                    }
                }).build());
                this.renderableVList.addRenderable((Renderable)Button.builder((Component)Component.translatable((String)"legacy.menu.choose_user.offline"), b -> {
                    final EditBox usernameBox = new EditBox(Minecraft.getInstance().font, 0, 0, 200, 20, (Component)Component.translatable((String)"legacy.menu.choose_user.offline.username"));
                    this.minecraft.setScreen((Screen)new ConfirmationScreen(this, this, ConfirmationScreen::getPanelWidth, () -> LegacyOptions.getUIMode().isSD() ? 87 : 120, usernameBox.getMessage(), (Component)Component.translatable((String)"legacy.menu.choose_user.offline.username_message"), b1 -> press.accept(MCAccount.create(new GameProfile(UUID.nameUUIDFromBytes(("offline:" + usernameBox.getValue()).getBytes()), usernameBox.getValue()), false, null, null))){

                        @Override
                        protected void addButtons() {
                            super.addButtons();
                            this.okButton.active = false;
                        }

                        @Override
                        protected void init() {
                            super.init();
                            boolean sd = LegacyOptions.getUIMode().isSD();
                            int layoutX = this.panel.x + (this.panel.width - this.renderableVList.listWidth) / 2;
                            usernameBox.setPosition(layoutX, this.panel.getY() + (sd ? 32 : 45));
                            usernameBox.setResponder(s -> {
                                boolean matches = usernamePattern.matcher((CharSequence)s).matches();
                                usernameBox.setTextColor(matches ? -1 : -43691);
                                this.okButton.active = matches;
                            });
                            usernameBox.setWidth(this.renderableVList.listWidth);
                            usernameBox.setHeight(sd ? 16 : 20);
                            this.addRenderableWidget((GuiEventListener)usernameBox);
                        }
                    });
                }).build());
            }
        };
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        super.addControlTooltips(renderer);
        renderer.add(() -> this.getFocused() == null || this.renderableVList.renderables.indexOf(this.getFocused()) <= 0 ? null : (ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(79) : ControllerBinding.UP_BUTTON.getIcon()), () -> ACCOUNT_OPTIONS);
        renderer.add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(88) : ControllerBinding.LEFT_BUTTON.getIcon(), () -> DIRECT_LOGIN);
    }

    @Override
    public boolean keyPressed(KeyEvent keyEvent) {
        if (keyEvent.key() == 88) {
            this.minecraft.setScreen((Screen)ChooseUserScreen.accountScreen(DIRECT_LOGIN, this, false, this::manageLogin));
            return true;
        }
        return super.keyPressed(keyEvent);
    }

    public void reloadAccountButtons() {
        int i = this.renderableVList.renderables.indexOf(this.getFocused());
        this.renderableVList.renderables.clear();
        this.addAccountButtons();
        this.repositionElements();
        if (i >= 0 && i < this.renderableVList.renderables.size()) {
            this.setFocused((GuiEventListener)this.renderableVList.renderables.get(i));
        }
    }

    @Override
    protected void panelInit() {
        super.panelInit();
        this.panelRecess.init("panelRecess");
        this.addRenderableOnly((Renderable)this.panelRecess);
        this.addRenderableOnly((guiGraphics, i, j, f) -> guiGraphics.drawString(this.font, this.getTitle(), this.panel.getX() + (this.panel.getWidth() - this.font.width((FormattedText)this.getTitle())) / 2, this.panel.y + 20, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false));
    }

    @Override
    public void renderableVListInit() {
        this.initRenderableVListHeight(30);
        this.getRenderableVList().init(this.panel.x + 15, this.panel.y + 32, this.panel.width - 30, this.panel.height - 50);
    }

    public void manageLogin(MCAccount account) {
        if (account.isEncrypted()) {
            this.minecraft.setScreen((Screen)ChooseUserScreen.passwordScreen(this, s -> account.login(this, (String)s)));
        } else {
            account.login(this, null);
        }
    }

    protected void addAccountButtons() {
        final Minecraft minecraft = Minecraft.getInstance();
        CreationList.addIconButton(this.renderableVList, Legacy4J.createModLocation("icon/add_user"), ADD_ACCOUNT, b -> minecraft.setScreen((Screen)ChooseUserScreen.accountScreen(ADD_ACCOUNT, this, true, a -> {
            MCAccount.list.add((MCAccount)a);
            MCAccount.saveAll();
            this.reloadAccountButtons();
            minecraft.setScreen((Screen)this);
        })));
        for (final MCAccount account : MCAccount.list) {
            this.renderableVList.addRenderable((Renderable)new CreationList.ContentButton(this.renderableVList, 0, 0, 230, 30, (Component)(account.getMSARefreshToken(null).isEmpty() ? Component.translatable((String)"legacy.menu.offline_user", (Object[])new Object[]{account.getProfile().name()}) : Component.literal((String)account.getProfile().name()))){

                @Override
                public void renderIcon(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y, int width, int height) {
                    PlayerFaceRenderer.draw((GuiGraphics)guiGraphics, (PlayerSkin)((PlayerSkin)minecraft.getSkinManager().createLookup(account.getProfile(), true).get()), (int)(this.getX() + x), (int)(this.getY() + y), (int)Math.max(width, height));
                }

                @Override
                public void renderIconHighlight(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y, int width, int height) {
                    super.renderIconHighlight(guiGraphics, mouseX, mouseY, x, y, width, height);
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacyRenderUtil.isMouseOver(mouseX, mouseY, this.getX() + x, this.getY() + y, width, height) ? SaveRenderableList.JOIN_HIGHLIGHTED : SaveRenderableList.JOIN, this.getX() + x, this.getY() + y, width, height);
                }

                public boolean mouseClicked(MouseButtonEvent event, boolean bl) {
                    int iconWidth = this.list.accessor.getInteger(this.list.name + ".buttonIcon.width", 20);
                    int iconHeight = this.list.accessor.getInteger(this.list.name + ".buttonIcon.height", 20);
                    int iconPos = (this.height - iconHeight) / 2;
                    if (LegacyRenderUtil.isMouseOver(event.x(), event.y(), this.getX() + iconPos, this.getY() + iconPos, iconWidth, iconHeight)) {
                        ChooseUserScreen.this.manageLogin(account);
                    }
                    return super.mouseClicked(event, bl);
                }

                public boolean keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.key() == 79) {
                        minecraft.setScreen((Screen)new ConfirmationScreen(ChooseUserScreen.this, ConfirmationScreen::getPanelWidth, () -> LegacyOptions.getUIMode().isSD() ? 87 : 120, ACCOUNT_OPTIONS, ACCOUNT_OPTIONS_MESSAGE, b -> {}){

                            @Override
                            protected void addButtons() {
                                this.renderableVList.addRenderable((Renderable)Button.builder((Component)CommonComponents.GUI_CANCEL, b -> this.onClose()).build());
                                this.renderableVList.addRenderable((Renderable)Button.builder((Component)EDIT_ACCOUNT, b -> this.minecraft.setScreen((Screen)ChooseUserScreen.accountScreen(EDIT_ACCOUNT, this, true, a -> {
                                    MCAccount.list.set(MCAccount.list.indexOf(account), (MCAccount)a);
                                    MCAccount.saveAll();
                                    ChooseUserScreen.this.reloadAccountButtons();
                                    this.minecraft.setScreen((Screen)ChooseUserScreen.this);
                                }))).build());
                                this.renderableVList.addRenderable((Renderable)Button.builder((Component)DELETE_ACCOUNT, b -> {
                                    MCAccount.list.remove(account);
                                    MCAccount.saveAll();
                                    ChooseUserScreen.this.reloadAccountButtons();
                                    this.minecraft.setScreen((Screen)ChooseUserScreen.this);
                                }).build());
                            }
                        });
                        return true;
                    }
                    return super.keyPressed(keyEvent);
                }

                public void onPress(InputWithModifiers input) {
                    if (this.isFocused()) {
                        ChooseUserScreen.this.manageLogin(account);
                    }
                }
            });
        }
    }
}

