/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FontDescription;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.LegacyTip;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyFontUtil;
import wily.legacy.util.client.LegacyRenderUtil;

public class LegacyLoadingRenderer
implements Renderable {
    private static final LegacyLoadingRenderer INSTANCE = new LegacyLoadingRenderer();
    public Minecraft minecraft;
    public float progress;
    public Component loadingHeader;
    public Component loadingStage;
    public boolean genericLoading;
    public UIAccessor accessor;

    public static LegacyLoadingRenderer getInstance() {
        return INSTANCE;
    }

    public void prepareRender(Minecraft minecraft, Component loadingHeader, Component loadingStage, float progress, boolean genericLoading) {
        this.minecraft = minecraft;
        this.accessor = UIAccessor.of((Screen)minecraft.screen);
        this.loadingHeader = (Component)this.accessor.getElementValue("loadingHeader.component", (Object)loadingHeader, Component.class);
        this.loadingStage = (Component)this.accessor.getElementValue("loadingStage.component", (Object)loadingStage, Component.class);
        this.progress = this.accessor.getFloat("progress", progress);
        this.genericLoading = this.accessor.getBoolean("genericLoading", Boolean.valueOf(genericLoading));
    }

    public void prepareRender(Minecraft minecraft) {
        this.prepareRender(minecraft, this.loadingHeader, this.loadingStage, this.progress, this.genericLoading);
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        LegacyRenderUtil.renderDefaultBackground(this.accessor, guiGraphics, true, true, false);
    }

    public void renderForeground(GuiGraphics guiGraphics, int i, int j, float f) {
        int width = guiGraphics.guiWidth();
        int height = guiGraphics.guiHeight();
        ArbitrarySupplier fontOverride = this.accessor.getElement("fontOverride", ResourceLocation.class);
        if (!this.genericLoading) {
            if (this.progress != -1.0f) {
                LegacyTip tip;
                int loadingBarX = this.accessor.getInteger("loadingBar.x", width / 2 - 160);
                int loadingBarY = this.accessor.getInteger("loadingBar.y", height / 2 + 15);
                if (this.loadingStage != null) {
                    LegacyFontUtil.applySmallerFont((FontDescription)fontOverride.map(FontDescription.Resource::new).orElse((Object)FontDescription.DEFAULT), b -> guiGraphics.drawString(this.minecraft.font, this.loadingStage, this.accessor.getInteger("loadingStage.x", loadingBarX + 1), this.accessor.getInteger("loadingStage.y", height / 2 + 5), ((Integer)CommonColor.STAGE_TEXT.get()).intValue()));
                }
                try (SpriteContents contents = FactoryGuiGraphics.getSprites().getSprite(LegacySprites.LOADING_BACKGROUND).contents();){
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.LOADING_BACKGROUND, loadingBarX, loadingBarY, 320, 320 * contents.height() / contents.width());
                }
                if (this.progress >= 0.0f) {
                    contents = FactoryGuiGraphics.getSprites().getSprite(LegacySprites.LOADING_BAR).contents();
                    try {
                        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.LOADING_BAR, 318, 318 * contents.height() / contents.width(), 0, 0, loadingBarX + 1, loadingBarY + 1, 0, (int)(318.0f * Math.max(0.0f, Math.min(this.progress, 1.0f))), 318 * contents.height() / contents.width());
                    }
                    finally {
                        if (contents != null) {
                            contents.close();
                        }
                    }
                }
                if ((tip = Legacy4JClient.legacyTipManager.getLoadingTip()) != null) {
                    tip.setX(this.accessor.getInteger("loadingTip.x", (width - tip.width) / 2));
                    tip.setY(this.accessor.getInteger("loadingTip.y", loadingBarY + 10 + (height - (loadingBarY + 10) - tip.height) / 2));
                    tip.render(guiGraphics, i, j, f);
                }
            }
        } else {
            LegacyRenderUtil.drawGenericLoading(guiGraphics, (width - 75) / 2, height / 2);
        }
        if (this.loadingHeader != null) {
            LegacyFontUtil.applySmallerFont((FontDescription)fontOverride.map(FontDescription.Resource::new).orElse((Object)FontDescription.DEFAULT), b -> {
                guiGraphics.pose().pushMatrix();
                float scaleX = this.accessor.getFloat("loadingHeader.scaleX", 2.0f);
                guiGraphics.pose().translate(this.accessor.getFloat("loadingHeader.x", ((float)width - (float)this.minecraft.font.width((FormattedText)this.loadingHeader) * scaleX) / 2.0f), this.accessor.getFloat("loadingHeader.y", (float)(height / 2 - 23)));
                guiGraphics.pose().scale(scaleX, this.accessor.getFloat("loadingHeader.scaleY", 2.0f));
                LegacyRenderUtil.drawOutlinedString(guiGraphics, this.minecraft.font, this.loadingHeader, 0, 0, (int)((Integer)CommonColor.TITLE_TEXT.get()), (int)((Integer)CommonColor.TITLE_TEXT_OUTLINE.get()), this.accessor.getFloat("loadingHeader.outline", 0.5f));
                guiGraphics.pose().popMatrix();
            });
        }
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBackground(guiGraphics, i, j, f);
        this.renderForeground(guiGraphics, i, j, f);
    }
}

