/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import net.minecraft.Util;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyLoading;
import wily.legacy.client.screen.LegacyLoadingRenderer;
import wily.legacy.network.TopMessage;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.client.LegacySoundUtil;

public class LegacyLoadingScreen
extends Screen
implements LegacyLoading,
ControlTooltip.Event {
    private final LegacyLoadingRenderer renderer = new LegacyLoadingRenderer();

    public LegacyLoadingScreen() {
        super(GameNarrator.NO_TITLE);
    }

    public LegacyLoadingScreen(Component loadingHeader, Component loadingStage) {
        this();
        this.setLoadingHeader(loadingHeader);
        this.setLoadingStage(loadingStage);
    }

    public static LegacyLoadingScreen getDimensionChangeScreen(final BooleanSupplier levelReady, ResourceKey<Level> lastLevel, ResourceKey<Level> newLevel) {
        final long createdTime = Util.getMillis();
        boolean lastOd = LegacyLoadingScreen.isOtherDimension(lastLevel);
        boolean od = LegacyLoadingScreen.isOtherDimension(newLevel);
        LegacyLoadingScreen screen = new LegacyLoadingScreen((Component)(od || lastOd ? Component.translatable((String)("legacy.menu." + (lastOd ? "leaving" : "entering")), (Object[])new Object[]{LegacyComponents.getDimensionName(lastOd ? lastLevel : newLevel)}) : Component.empty()), (Component)Component.empty()){

            public void tick() {
                if (levelReady.getAsBoolean() || Util.getMillis() - createdTime >= 30000L) {
                    this.minecraft.setScreen(null);
                }
            }

            public boolean isPauseScreen() {
                return false;
            }
        };
        if (od || lastOd) {
            screen.setGenericLoading(true);
        }
        return screen;
    }

    public static boolean isOtherDimension(ResourceKey<Level> level) {
        return level != null && level != Level.OVERWORLD;
    }

    public static LegacyLoadingScreen getRespawningScreen(final BooleanSupplier levelReady) {
        final long createdTime = Util.getMillis();
        LegacyLoadingScreen screen = new LegacyLoadingScreen(LegacyComponents.RESPAWNING, (Component)Component.empty()){

            public void tick() {
                if (levelReady.getAsBoolean() || Util.getMillis() - createdTime >= 30000L) {
                    this.minecraft.setScreen(null);
                }
            }

            public boolean isPauseScreen() {
                return false;
            }
        };
        screen.setGenericLoading(true);
        return screen;
    }

    public static void startFakeAutoSave() {
        if (!((Boolean)LegacyOptions.fakeAutosaveScreen.get()).booleanValue()) {
            return;
        }
        Minecraft.getInstance().gui.autosaveIndicatorValue = 0.0f;
        TopMessage.setMedium(null);
        Minecraft.getInstance().setScreen((Screen)LegacyLoadingScreen.getFakeAutoSaveScreen());
    }

    public static LegacyLoadingScreen getFakeAutoSaveScreen() {
        return new LegacyLoadingScreen(LegacyComponents.PREPARING_AUTOSAVE, LegacyComponents.PREPARING_CHUNKS){
            int finalizingTicks = -1;

            public void tick() {
                this.minecraft.gui.autosaveIndicatorValue = 0.0f;
                super.tick();
                if (this.finalizingTicks < 0) {
                    this.setProgress(this.getProgress() + 0.02f);
                    if ((double)this.getProgress() >= 1.0) {
                        this.finalizingTicks = 80;
                        this.setProgress(0.0f);
                        this.setLoadingStage(LegacyComponents.FINALIZING);
                    }
                } else if (this.finalizingTicks > 0) {
                    --this.finalizingTicks;
                } else {
                    this.onClose();
                    LegacySoundUtil.playBackSound();
                    this.minecraft.gui.autosaveIndicatorValue = 1.0f;
                }
            }
        };
    }

    public static LegacyLoadingScreen createWithExecutor(Component header, final Runnable onClose, final ExecutorService executor) {
        return new LegacyLoadingScreen(header, (Component)Component.empty()){

            public void onClose() {
                onClose.run();
                4.closeExecutor(executor);
            }

            @Override
            public boolean shouldCloseOnEsc() {
                return true;
            }
        };
    }

    public static void closeExecutor(ExecutorService executor) {
        boolean bl;
        executor.shutdown();
        try {
            bl = executor.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException var3) {
            bl = false;
        }
        if (!bl) {
            executor.shutdownNow();
        }
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderer.prepareRender(this.minecraft);
        this.renderer.renderBackground(guiGraphics, i, j, f);
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        super.render(guiGraphics, i, j, f);
        this.renderer.renderForeground(guiGraphics, i, j, f);
    }

    @Override
    public LegacyLoadingRenderer getLoadingRenderer() {
        return this.renderer;
    }
}

