/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.Comparator;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenAxis;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.controller.Controller;
import wily.legacy.client.screen.LegacyIconHolder;
import wily.legacy.client.screen.TabList;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.util.client.LegacyRenderUtil;

public interface LegacyMenuAccess<T extends AbstractContainerMenu>
extends MenuAccess<T>,
GuiEventListener,
Controller.Event {
    default public boolean movePointerToSlotIn(ScreenDirection direction) {
        return this.movePointerToSlotIn(direction, false, false);
    }

    default public boolean movePointerToSlotIn(ScreenDirection direction, boolean allowCyclic, boolean needsHovered) {
        if (this.getMenu().slots.isEmpty() || this.findHoveredSlot() == null && needsHovered) {
            return false;
        }
        double pointerX = Legacy4JClient.controllerManager.getPointerX();
        double pointerY = Legacy4JClient.controllerManager.getPointerY();
        int height = this.getRectangle().height();
        int width = this.getRectangle().width();
        boolean horizontal = direction.getAxis() == ScreenAxis.HORIZONTAL;
        boolean positive = direction.isPositive();
        if (this.getMenu().slots.size() == 1 && this.movePointerToSlot((Slot)this.getMenu().slots.get(0), false)) {
            return true;
        }
        int part = this.getMenu().slots.stream().map(s -> Math.round((float)LegacyRenderUtil.iconHolderRenderer.slotBounds((Slot)s).getMinSize() / 2.0f)).sorted().findFirst().orElse(9);
        double r = horizontal ? (double)height - pointerY : (double)width - pointerX;
        double l = horizontal ? pointerY : pointerX;
        int i = 0;
        while ((double)i < Math.max(r, l)) {
            if ((double)i <= r && this.movePointerToSlotIn(positive, horizontal, horizontal ? width : height, i, (int)pointerX, (int)pointerY, part)) {
                return true;
            }
            if ((double)i <= l && this.movePointerToSlotIn(positive, horizontal, horizontal ? width : height, -i, (int)pointerX, (int)pointerY, part)) {
                return true;
            }
            i += part;
        }
        if (allowCyclic) {
            i = 0;
            while ((double)i < Math.max(r, l)) {
                if ((double)i <= r && this.movePointerToSlotInReverse(positive, horizontal, horizontal ? width : height, i, (int)pointerX, (int)pointerY, part)) {
                    return true;
                }
                if ((double)i <= l && this.movePointerToSlotInReverse(positive, horizontal, horizontal ? width : height, -i, (int)pointerX, (int)pointerY, part)) {
                    return true;
                }
                i += part;
            }
        }
        return false;
    }

    default public boolean movePointerToSlotIn(boolean positive, boolean horizontal, int size, int pos, int pointerX, int pointerY, int part) {
        if (positive) {
            for (int j = part * 2; j < size - (horizontal ? pointerX : pointerY); j += part) {
                if (!this.movePointerToSlot(this.findSlotAt(pointerX + (horizontal ? j : pos), pointerY + (horizontal ? pos : j)), false)) continue;
                return true;
            }
        } else {
            for (int j = -part * 2; j >= -(horizontal ? pointerX : pointerY); j -= part) {
                if (!this.movePointerToSlot(this.findSlotAt(pointerX + (horizontal ? j : pos), pointerY + (horizontal ? pos : j)), false)) continue;
                return true;
            }
        }
        return false;
    }

    default public boolean movePointerToSlotInReverse(boolean positive, boolean horizontal, int size, int pos, int pointerX, int pointerY, int part) {
        if (positive) {
            for (int j = -(horizontal ? pointerX : pointerY) + part * 2; j < 0; j += part) {
                if (!this.movePointerToSlot(this.findSlotAt(pointerX + (horizontal ? j : pos), pointerY + (horizontal ? pos : j)), false)) continue;
                return true;
            }
        } else {
            for (int j = size - (horizontal ? pointerX : pointerY) - part * 2; j >= 0; j -= part) {
                if (!this.movePointerToSlot(this.findSlotAt(pointerX + (horizontal ? j : pos), pointerY + (horizontal ? pos : j)), false)) continue;
                return true;
            }
        }
        return false;
    }

    default public boolean movePointerToSlot(Slot s) {
        return this.movePointerToSlot(s, true);
    }

    default public boolean movePointerToSlot(Slot s, boolean allowHovered) {
        if (s == null || !allowHovered && s == this.findHoveredSlot() || !LegacySlotDisplay.isVisibleAndActive(s)) {
            return false;
        }
        LegacyIconHolder holder = LegacyRenderUtil.iconHolderRenderer.slotBounds(this.getMenuRectangle().left(), this.getMenuRectangle().top(), s);
        Legacy4JClient.controllerManager.setPointerPos(holder.getMiddleX(), holder.getMiddleY());
        return true;
    }

    default public void movePointerToNextSlot() {
        if (this.getMenu().slots.isEmpty() || Legacy4JClient.controllerManager.isCursorDisabled || this.getHoveredSlot() == null) {
            return;
        }
        double pointerX = Legacy4JClient.controllerManager.getPointerX();
        double pointerY = Legacy4JClient.controllerManager.getPointerY();
        if (this.getMenu().slots.size() == 1 && this.movePointerToSlot((Slot)this.getMenu().slots.get(0))) {
            return;
        }
        this.getMenu().slots.stream().min(Comparator.comparingInt(s -> {
            LegacyIconHolder holder = LegacyRenderUtil.iconHolderRenderer.slotBounds(this.getMenuRectangle().left(), this.getMenuRectangle().top(), (Slot)s);
            double deltaX = pointerX - holder.getMiddleX();
            double deltaY = pointerY - holder.getMiddleY();
            return (int)(deltaX * deltaX + deltaY * deltaY);
        })).ifPresent(this::movePointerToSlot);
    }

    public ScreenRectangle getMenuRectangle();

    public ScreenRectangle getMenuRectangleLimit();

    public static ScreenRectangle createMenuRectangleLimit(LegacyMenuAccess<?> menu, int x, int y, int width, int height) {
        return LegacyMenuAccess.createMenuRectangleLimit(menu, x, y, width, height, 20, 10);
    }

    public static ScreenRectangle createMenuRectangleLimit(LegacyMenuAccess<?> menu, int x, int y, int width, int height, int paddingH, int paddingV) {
        if (menu instanceof TabList.Access) {
            TabList.Access tabList = (TabList.Access)((Object)menu);
            x -= tabList.getTabXOffset();
            width += tabList.getTabXOffset();
            y -= tabList.getTabYOffset();
            height += tabList.getTabYOffset();
        }
        return new ScreenRectangle(x - paddingH, y - paddingV, width + paddingH * 2, height + paddingV * 2);
    }

    public boolean isOutsideClick(int var1);

    public Slot getHoveredSlot();

    default public Slot findSlotAt(double d, double e) {
        ScreenRectangle rectangle = this.getMenuRectangle();
        for (Slot slot : this.getMenu().slots) {
            if (!LegacyRenderUtil.isHovering(slot, rectangle.left(), rectangle.top(), d, e)) continue;
            return slot;
        }
        return null;
    }

    default public Slot findHoveredSlot() {
        return this.findSlotAt(Legacy4JClient.controllerManager.getPointerX(), Legacy4JClient.controllerManager.getPointerY());
    }

    default public int getTipXDiff() {
        return -132;
    }

    default public boolean allowItemPopping() {
        return false;
    }

    default public boolean isMouseDragging() {
        return false;
    }
}

