/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.client.controller.BindingState;
import wily.legacy.client.controller.Controller;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyIconHolder;
import wily.legacy.client.screen.LegacyScrollRenderer;

public abstract class RecipesScreen<T extends AbstractContainerMenu, H extends LegacyIconHolder>
extends AbstractContainerScreen<T>
implements Controller.Event,
ControlTooltip.Event {
    protected final UIAccessor accessor = UIAccessor.of((Screen)this);
    protected final List<H> recipeButtons = new ArrayList<H>();
    protected final Inventory inventory;
    protected int selectedRecipeButton;
    protected final Stocker.Sizeable recipeButtonsOffset = new Stocker.Sizeable(Integer.valueOf(0));
    protected final LegacyScrollRenderer scrollRenderer = new LegacyScrollRenderer();
    private int timesInventoryChanged;
    private int updateTimer = 0;

    public RecipesScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
        this.inventory = inventory;
        this.addRecipeButtons();
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        ControlTooltip.setupDefaultButtons(renderer, (Screen)this);
        ControlTooltip.Event.super.addControlTooltips(renderer);
    }

    @Override
    public boolean disableCursorOnInit() {
        return true;
    }

    @Override
    public boolean onceClickBindings(BindingState state) {
        return !state.is(ControllerBinding.DOWN_BUTTON) && Controller.Event.super.onceClickBindings(state);
    }

    protected abstract void updateRecipes();

    protected void updateRecipesAndResetTimer() {
        this.updateRecipes();
        this.updateTimer = 0;
    }

    protected void containerTick() {
        super.containerTick();
        ++this.updateTimer;
        if (this.timesInventoryChanged != this.inventory.getTimesChanged()) {
            this.updateRecipesAndResetTimer();
            this.timesInventoryChanged = this.inventory.getTimesChanged();
        }
        if (this.updateTimer >= 20) {
            this.updateRecipesAndResetTimer();
        }
    }

    public void renderRecipesScroll(GuiGraphics guiGraphics, int x, int y) {
        if ((Integer)this.recipeButtonsOffset.get() > 0) {
            this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.LEFT, this.leftPos + this.accessor.getInteger("horizontalScroll.x", x), this.topPos + this.accessor.getInteger("horizontalScroll.y", y));
        }
        if (this.recipeButtonsOffset.max > 0 && (Integer)this.recipeButtonsOffset.get() < this.recipeButtonsOffset.max) {
            this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.RIGHT, this.leftPos + this.imageWidth - 6 - this.accessor.getInteger("horizontalScroll.x", x), this.topPos + this.accessor.getInteger("horizontalScroll.y", y));
        }
    }

    protected abstract H createRecipeButton(int var1);

    protected void addRecipeButtons() {
        int max;
        int lastSize = this.recipeButtons.size();
        if (lastSize == (max = this.getMaxRecipeButtons())) {
            return;
        }
        if (max > lastSize) {
            for (int i = lastSize; i < max; ++i) {
                this.recipeButtons.add(this.createRecipeButton(i));
            }
        } else {
            while (this.recipeButtons.size() != max) {
                this.recipeButtons.remove(this.recipeButtons.size() - 1);
            }
            if (this.selectedRecipeButton >= this.recipeButtons.size()) {
                this.selectedRecipeButton = this.recipeButtons.size() - 1;
            }
        }
    }

    public abstract int getMaxRecipeButtons();

    public List<? extends LegacyIconHolder> getRecipeButtons() {
        return this.recipeButtons;
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        super.render(guiGraphics, i, j, f);
        this.getRecipeButtons().forEach(h -> h.renderTooltip(this.minecraft, guiGraphics, i, j));
        this.renderTooltip(guiGraphics, i, j);
    }

    public void renderContents(GuiGraphics guiGraphics, int i, int j, float f) {
        super.renderContents(guiGraphics, i, j, f);
        this.getRecipeButtons().forEach(b -> b.render(guiGraphics, i, j, 0.0f));
        if (this.selectedRecipeButton < this.getRecipeButtons().size()) {
            this.getRecipeButtons().get(this.selectedRecipeButton).renderSelection(guiGraphics, i, j, 0.0f);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBg(guiGraphics, f, i, j);
    }

    public boolean mouseScrolled(double d, double e, double f, double g) {
        if (this.getChildAt(d, e).filter(guiEventListener -> guiEventListener.mouseScrolled(d, e, f, g)).isPresent()) {
            return true;
        }
        if (super.mouseScrolled(d, e, f, g)) {
            return true;
        }
        int scroll = (int)Math.signum(g);
        if (((Integer)this.recipeButtonsOffset.get() > 0 && scroll < 0 || scroll > 0 && this.recipeButtonsOffset.max > 0) && this.recipeButtonsOffset.add(scroll, false) != 0) {
            this.updateRecipesAndResetTimer();
            return true;
        }
        return false;
    }

    protected void init() {
        super.init();
        this.addRecipeButtons();
    }
}

