/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen.compat;

import io.github.gaming32.worldhost.WorldHost;
import io.github.gaming32.worldhost.WorldHostComponents;
import io.github.gaming32.worldhost.gui.screen.AddFriendScreen;
import io.github.gaming32.worldhost.gui.screen.FriendsScreen;
import io.github.gaming32.worldhost.gui.widget.UserListWidget;
import io.github.gaming32.worldhost.plugin.FriendAdder;
import io.github.gaming32.worldhost.plugin.FriendListFriend;
import io.github.gaming32.worldhost.plugin.ProfileInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.legacy.Legacy4J;
import wily.legacy.client.CommonColor;
import wily.legacy.client.ControlType;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.CreationList;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PanelVListScreen;
import wily.legacy.client.screen.TickBox;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyRenderUtil;

public class WorldHostFriendsScreen
extends PanelVListScreen {
    public static final Tooltip ADD_SILENTLY_TEXT_TOOLTIP = Tooltip.create((Component)Component.translatable((String)"world-host.friends.add_silently.tooltip"));
    public static final Component INVITE = Component.translatable((String)"legacy.menu.invite");
    public static final Component INVITE_FRIENDS = Component.translatable((String)"legacy.menu.invite_friends");
    public static final Component FRIENDS = Component.translatable((String)"world-host.friends");
    public static final Component WORLD_HOST_FRIENDS = WorldHostComponents.FRIENDS;
    public static final Component WORLD_HOST_REMOVE_FRIEND = Component.translatable((String)"world-host.friends.remove");
    public static final Component WORLD_HOST_FRIEND_USERNAME_TEXT = Component.translatable((String)"world-host.add_friend.enter_username");

    public WorldHostFriendsScreen(Screen parent) {
        this(parent, 250, 190);
    }

    public WorldHostFriendsScreen(Screen parent, int imageWidth, int imageHeight) {
        super(parent, (PanelVListScreen s) -> Panel.centered(s, LegacySprites.PANEL, imageWidth, imageHeight), WORLD_HOST_FRIENDS);
        this.renderableVList.layoutSpacing(i -> 0);
        this.addFriendButtons(() -> {});
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        super.addControlTooltips(renderer);
        renderer.add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(88) : ControllerBinding.LEFT_BUTTON.getIcon(), () -> ControlTooltip.getKeyMessage(88, this));
    }

    public void reloadFriendButtons() {
        int i = this.renderableVList.renderables.indexOf(this.getFocused());
        this.renderableVList.renderables.clear();
        this.addFriendButtons(() -> {
            if (i >= 0 && i < this.renderableVList.renderables.size()) {
                this.setFocused((GuiEventListener)this.renderableVList.renderables.get(i));
            }
            this.repositionElements();
        });
    }

    @Override
    public void renderableVListInit() {
        this.renderableVList.init(this.panel.x + 10, this.panel.y + 22, this.panel.width - 20, this.panel.height - 28);
    }

    @Override
    protected void panelInit() {
        super.panelInit();
        this.addRenderableOnly((guiGraphics, i, j, f) -> guiGraphics.drawString(this.font, this.getTitle(), this.panel.x + 11, this.panel.y + this.panel.height - 182, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false));
    }

    @Override
    public void renderDefaultBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        if (this.minecraft.level == null) {
            LegacyRenderUtil.renderDefaultBackground(this.accessor, guiGraphics, false);
        }
    }

    protected void addFriendButtons(Runnable afterButtonsAdd) {
        CreationList.addIconButton(this.renderableVList, Legacy4J.createModLocation("icon/add_user_portal"), FriendsScreen.ADD_FRIEND_TEXT, b -> this.minecraft.setScreen((Screen)new WorldHostFriendsScreen(this, 250, 234){
            final List<FriendListFriend> addableFriends;
            final List<FriendListFriend> friendsToAdd;
            final TickBox silentAddBox;
            final EditBox friendBox;
            final List<FriendAdder> friendAdders;
            long lastTyping;
            private Runnable delayedLookup;
            {
                this.addableFriends = new ArrayList<FriendListFriend>();
                this.friendsToAdd = new ArrayList<FriendListFriend>();
                this.silentAddBox = new TickBox(0, 0, 200, false, b1 -> AddFriendScreen.ADD_FRIEND_SILENT_TEXT, b1 -> ADD_SILENTLY_TEXT_TOOLTIP, t -> {});
                this.friendBox = new EditBox(Minecraft.getInstance().font, this.width / 2 - 100, 0, 200, 20, WORLD_HOST_FRIEND_USERNAME_TEXT);
                this.friendAdders = WorldHost.getFriendAdders();
                this.lastTyping = -1L;
            }

            @Override
            protected void addFriendButtons(Runnable afterButtonsAdd) {
                if (this.addableFriends == null) {
                    return;
                }
                this.addableFriends.forEach(this::addFriendButton);
                this.friendsToAdd.forEach(this::addFriendButton);
                afterButtonsAdd.run();
            }

            private void addFriendButton(FriendListFriend friend) {
                this.renderableVList.addRenderable((Renderable)new FriendButton(0, 0, 230, 30, friend){

                    @Override
                    protected void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
                        super.renderWidget(guiGraphics, i, j, f);
                        FactoryScreenUtil.enableBlend();
                        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(this.isHoveredOrFocused() ? LegacySprites.TICKBOX_HOVERED : LegacySprites.TICKBOX, this.getX() + 30, this.getY() + (this.height - 12) / 2, 12, 12);
                        if (friendsToAdd.contains(this.friend)) {
                            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.TICK, this.getX() + 30, this.getY() + (this.height - 12) / 2, 14, 12);
                        }
                        FactoryScreenUtil.disableBlend();
                    }

                    @Override
                    protected void renderScrollingString(GuiGraphics guiGraphics, Font font, int i, int j) {
                        LegacyRenderUtil.renderScrollingString(guiGraphics, font, this.getMessage(), this.getX() + 45, this.getY(), this.getX() + this.getWidth() - 2, this.getY() + this.getHeight(), j, true);
                    }

                    @Override
                    public void onPress(InputWithModifiers input) {
                        if (friendsToAdd.contains(this.friend)) {
                            friendsToAdd.remove(this.friend);
                            addableFriends.add(this.friend);
                        } else {
                            friendsToAdd.add(this.friend);
                            addableFriends.remove(this.friend);
                        }
                        this.reloadFriendButtons();
                    }

                    @Override
                    public boolean supportsRemoving() {
                        return false;
                    }
                });
            }

            @Override
            public void onClose() {
                this.friendsToAdd.forEach(f -> f.addFriend(!this.silentAddBox.selected, WorldHostFriendsScreen.this::reloadFriendButtons));
                super.onClose();
            }

            @Override
            protected void init() {
                super.init();
                this.friendBox.setPosition(this.panel.x + (this.panel.getWidth() - this.friendBox.getWidth()) / 2, this.panel.y + 5);
                this.friendBox.setMaxLength(36);
                this.friendBox.setResponder(s -> {
                    this.lastTyping = Util.getMillis();
                    this.addableFriends.clear();
                    ArrayList<FriendAdder> delayedAdders = new ArrayList<FriendAdder>();
                    for (FriendAdder adder : this.friendAdders) {
                        if (s.length() > adder.maxValidNameLength()) continue;
                        if (adder.delayLookup(s)) {
                            delayedAdders.add(adder);
                            continue;
                        }
                        adder.searchFriends(s, 16 - this.addableFriends.size(), f -> {
                            if (this.friendsToAdd.stream().anyMatch(f1 -> f1.fallbackProfileInfo().name().equals(f.fallbackProfileInfo().name()))) {
                                return;
                            }
                            this.addableFriends.add((FriendListFriend)f);
                            this.reloadFriendButtons();
                        });
                    }
                    this.delayedLookup = delayedAdders.isEmpty() ? null : () -> delayedAdders.forEach(adder -> adder.searchFriends(s, 16 - this.addableFriends.size(), f -> {
                        if (this.friendsToAdd.stream().anyMatch(f1 -> f1.fallbackProfileInfo().name().equals(f.fallbackProfileInfo().name()))) {
                            return;
                        }
                        this.addableFriends.add((FriendListFriend)f);
                        this.reloadFriendButtons();
                    }));
                });
                this.addRenderableWidget((GuiEventListener)this.friendBox);
                this.silentAddBox.setPosition(this.panel.getX() + (this.panel.getWidth() - 200) / 2, this.panel.y + 30);
                this.addRenderableWidget((GuiEventListener)this.silentAddBox);
            }

            public void tick() {
                if (this.lastTyping != -1L && Util.getMillis() - 300L > this.lastTyping) {
                    this.lastTyping = -1L;
                    this.delayedLookup.run();
                    this.delayedLookup = null;
                }
            }

            @Override
            public void renderableVListInit() {
                this.renderableVList.init(this.panel.x + 10, this.panel.y + 66, this.panel.width - 20, this.panel.height - 72);
            }
        }));
        WorldHost.getPlugins().forEach(p -> p.plugin().listFriends(f -> this.renderableVList.addRenderable((Renderable)new FriendButton(0, 0, 230, 30, (FriendListFriend)f))));
        afterButtonsAdd.run();
    }

    public class FriendButton
    extends AbstractButton
    implements ControlTooltip.ActionHolder {
        public final FriendListFriend friend;
        public ProfileInfo profileInfo;

        public FriendButton(int x, int y, int width, int height, FriendListFriend friend) {
            super(x, y, width, height, (Component)Component.empty());
            this.friend = friend;
            this.profileInfo = friend.fallbackProfileInfo();
            ((CompletableFuture)friend.profileInfo().thenAcceptAsync(ready -> {
                this.profileInfo = ready;
            }, (Executor)Minecraft.getInstance())).exceptionally(t -> {
                WorldHost.LOGGER.error("Failed to request profile info for {}", (Object)friend, t);
                return null;
            });
        }

        public Component getMessage() {
            return UserListWidget.getNameWithTag((FriendListFriend)this.friend, (ProfileInfo)this.profileInfo);
        }

        protected void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
            super.renderWidget(guiGraphics, i, j, f);
            this.profileInfo.iconRenderer().draw(guiGraphics, this.getX() + 5, this.getY() + 5, 20, 20);
        }

        protected void renderScrollingString(GuiGraphics guiGraphics, Font font, int i, int j) {
            LegacyRenderUtil.renderScrollingString(guiGraphics, font, this.getMessage(), this.getX() + 30, this.getY(), this.getX() + this.getWidth() - 2, this.getY() + this.getHeight(), j, true);
        }

        public boolean keyPressed(KeyEvent keyEvent) {
            if (keyEvent.key() == 88) {
                WorldHostFriendsScreen.this.minecraft.setScreen((Screen)new ConfirmationScreen((Screen)WorldHostFriendsScreen.this, WORLD_HOST_REMOVE_FRIEND, (Component)Component.translatable((String)"world-host.friends.remove.title"), b -> this.friend.removeFriend(() -> {
                    WorldHostFriendsScreen.this.minecraft.setScreen((Screen)WorldHostFriendsScreen.this);
                    WorldHostFriendsScreen.this.reloadFriendButtons();
                })));
                return true;
            }
            return super.keyPressed(keyEvent);
        }

        public void onPress(InputWithModifiers input) {
            this.friend.showFriendInfo((Screen)WorldHostFriendsScreen.this);
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
            this.defaultButtonNarrationText(narrationElementOutput);
        }

        public boolean supportsRemoving() {
            return true;
        }

        @Override
        @Nullable
        public Component getAction(ControlTooltip.ActionHolder.Context context) {
            return context.actionOfContext(ControlTooltip.ActionHolder.KeyContext.class, k -> this.isFocused() && k.key() == 88 && this.supportsRemoving() ? WORLD_HOST_REMOVE_FRIEND : ControlTooltip.getSelectAction((GuiEventListener)this, context));
        }
    }
}

