/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.base.config.FactoryConfig;
import wily.factoryapi.util.FactoryItemUtil;
import wily.legacy.Legacy4JClient;
import wily.legacy.config.LegacyCommonOptions;
import wily.legacy.init.LegacyGameRules;
import wily.legacy.util.LegacyItemUtil;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity {
    protected PlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract Abilities getAbilities();

    @Inject(method={"getFlyingSpeed"}, at={@At(value="RETURN")}, cancellable=true)
    protected void getFlyingSpeed(CallbackInfoReturnable<Float> cir) {
        if (!LegacyGameRules.getSidedBooleanGamerule((Entity)this, LegacyGameRules.LEGACY_FLIGHT)) {
            return;
        }
        cir.setReturnValue((Object)Float.valueOf(cir.getReturnValueF() * (float)(this.getAbilities().flying ? (this.isSprinting() ? 6 : 2) : 1)));
    }

    @Inject(method={"resetAttackStrengthTicker"}, at={@At(value="HEAD")}, cancellable=true)
    protected void resetAttackStrengthTicker(CallbackInfo ci) {
        if (FactoryConfig.hasCommonConfigEnabled(LegacyCommonOptions.legacyCombat)) {
            ci.cancel();
        }
    }

    @Inject(method={"getCurrentItemAttackStrengthDelay"}, at={@At(value="HEAD")}, cancellable=true)
    protected void getCurrentItemAttackStrengthDelay(CallbackInfoReturnable<Float> cir) {
        if (FactoryConfig.hasCommonConfigEnabled(LegacyCommonOptions.legacyCombat)) {
            cir.setReturnValue((Object)Float.valueOf(1.0f));
        }
    }

    @ModifyExpressionValue(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getAttributeValue(Lnet/minecraft/core/Holder;)D", ordinal=0)})
    protected double modifyAttackDamage(double original) {
        return original + (double)LegacyItemUtil.getItemDamageModifier(this.getMainHandItem());
    }

    @ModifyVariable(method={"attack"}, at=@At(value="STORE"), ordinal=3)
    protected boolean modifyAttackDamage(boolean original) {
        return (!FactoryConfig.hasCommonConfigEnabled(LegacyCommonOptions.legacyCombat) || FactoryItemUtil.getEnchantmentLevel((ItemStack)this.getMainHandItem(), (ResourceKey)Enchantments.SWEEPING_EDGE, (RegistryAccess)this.level().registryAccess()) > 0) && original;
    }

    @ModifyExpressionValue(method={"getDestroySpeed(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;)F"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;onGround()Z")})
    protected boolean getDestroySpeed(boolean original) {
        return !FactoryAPI.isClient() || original || Legacy4JClient.hasModOnServer();
    }

    @ModifyExpressionValue(method={"travel"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/material/FluidState;isEmpty()Z")})
    protected boolean travel(boolean original) {
        if (LegacyGameRules.getSidedBooleanGamerule((Entity)this, LegacyGameRules.LEGACY_SWIMMING)) {
            if (original) {
                double diff = this.getY() - (double)this.getBlockY();
                this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.0, 1.0));
                return diff > 0.8;
            }
        } else {
            return original;
        }
        return false;
    }

    @ModifyExpressionValue(method={"updateSwimming", "isSwimming"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/player/Abilities;flying:Z", ordinal=0)})
    protected boolean updateSwimming(boolean original) {
        return !LegacyGameRules.getSidedBooleanGamerule((Entity)this, LegacyGameRules.LEGACY_SWIMMING) && original;
    }

    @ModifyArg(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/core/BlockPos;containing(DDD)Lnet/minecraft/core/BlockPos;"), index=1)
    protected double travel(double original) {
        return LegacyGameRules.getSidedBooleanGamerule((Entity)this, LegacyGameRules.LEGACY_SWIMMING) ? original + (double)0.1f : original;
    }
}

