/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.biome.Biome;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.legacy.client.LegacyBiomeOverride;

@Mixin(value={Biome.class})
public class ClientBiomeMixin {
    @Unique
    private Biome self() {
        return (Biome)this;
    }

    @Unique
    private LegacyBiomeOverride biomeOverride() {
        ClientPacketListener l = Minecraft.getInstance().getConnection();
        return LegacyBiomeOverride.getOrDefault(l != null ? l.registryAccess().lookupOrThrow(Registries.BIOME).getResourceKey((Object)this.self()) : Optional.empty());
    }

    @Inject(method={"getWaterColor"}, at={@At(value="HEAD")}, cancellable=true)
    private void getWaterColor(CallbackInfoReturnable<Integer> cir) {
        this.biomeOverride().waterColor().ifPresent(arg_0 -> cir.setReturnValue(arg_0));
    }

    @Inject(method={"getWaterFogColor"}, at={@At(value="HEAD")}, cancellable=true)
    private void getWaterFogColor(CallbackInfoReturnable<Integer> cir) {
        LegacyBiomeOverride o = this.biomeOverride();
        if (o.waterFogColor().isPresent() || o.waterColor().isPresent()) {
            cir.setReturnValue((Object)(o.waterFogColor().isEmpty() ? o.waterColor().get() : o.waterFogColor().get()));
        }
    }

    @Inject(method={"getFogColor"}, at={@At(value="HEAD")}, cancellable=true)
    private void getFogColor(CallbackInfoReturnable<Integer> cir) {
        this.biomeOverride().fogColor().ifPresent(arg_0 -> cir.setReturnValue(arg_0));
    }

    @Inject(method={"getSkyColor"}, at={@At(value="HEAD")}, cancellable=true)
    private void getSkyColor(CallbackInfoReturnable<Integer> cir) {
        this.biomeOverride().skyColor().ifPresent(arg_0 -> cir.setReturnValue(arg_0));
    }
}

