/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.screen.LegacyLoading;
import wily.legacy.mixin.base.client.LevelLoadingScreenAccessor;
import wily.legacy.util.LegacyComponents;

@Mixin(value={LevelLoadingScreen.class, ProgressScreen.class, ConnectScreen.class})
public class LegacyLoadingScreenMixin
extends Screen
implements LegacyLoading {
    protected LegacyLoadingScreenMixin(Component component) {
        super(component);
    }

    @Unique
    private Screen self() {
        return this;
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    public void render(GuiGraphics guiGraphics, int i, int j, float f, CallbackInfo ci) {
        if (((Boolean)LegacyOptions.legacyLoadingAndConnecting.get()).booleanValue()) {
            ProgressScreen p;
            ci.cancel();
            Component lastLoadingHeader = null;
            Component lastLoadingStage = null;
            boolean genericLoading = false;
            float progress = 0.0f;
            Screen screen = this.self();
            if (screen instanceof LevelLoadingScreen) {
                LevelLoadingScreen loading = (LevelLoadingScreen)screen;
                lastLoadingHeader = LegacyComponents.INITIALIZING;
                lastLoadingStage = LegacyComponents.LOADING_SPAWN_AREA;
                progress = ((LevelLoadingScreenAccessor)loading).getSmoothedProgress();
            }
            if ((screen = this.self()) instanceof ProgressScreen) {
                p = (ProgressScreen)screen;
                lastLoadingHeader = p.header;
                lastLoadingStage = p.stage;
                if (this.minecraft.level != null && this.minecraft.level.dimension() != Level.OVERWORLD) {
                    genericLoading = true;
                }
            }
            if ((screen = this.self()) instanceof ConnectScreen) {
                p = (ConnectScreen)screen;
                lastLoadingHeader = p.status;
            }
            this.getLoadingRenderer().prepareRender(this.minecraft, lastLoadingHeader, lastLoadingStage, progress, genericLoading);
            this.getLoadingRenderer().render(guiGraphics, i, j, f);
        }
    }
}

