/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.legacy.inventory.LegacySlot;
import wily.legacy.inventory.LegacySlotDisplay;

@Mixin(value={Slot.class})
public abstract class SlotMixin
implements LegacySlot {
    @Mutable
    @Shadow
    @Final
    public int x;
    @Mutable
    @Shadow
    @Final
    public int y;
    @Unique
    private int defaultX;
    @Unique
    private int defaultY;
    private LegacySlotDisplay display = LegacySlotDisplay.VANILLA;

    @Shadow
    public abstract ItemStack getItem();

    @Override
    public LegacySlotDisplay getDisplay() {
        return this.display;
    }

    @Override
    public void setDisplay(LegacySlotDisplay slot) {
        this.display = slot;
        if (slot == LegacySlotDisplay.VANILLA) {
            this.x = this.defaultX;
            this.y = this.defaultY;
        }
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(Container container, int i, int j, int k, CallbackInfo ci) {
        this.defaultX = this.x;
        this.defaultY = this.y;
    }

    @ModifyReturnValue(method={"getItem"}, at={@At(value="RETURN")})
    public ItemStack getItem(ItemStack original) {
        ItemStack override = this.display.getItemOverride();
        return override == null ? original : override;
    }

    @Override
    public void setX(int x) {
        this.x = x;
    }

    @Override
    public void setY(int y) {
        this.y = y;
    }
}

