/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.util.client;

import com.google.common.collect.Ordering;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.LogoRenderer;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerSkin;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2ic;
import org.joml.Vector3f;
import org.lwjgl.glfw.GLFW;
import oshi.SystemInfo;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.GuiAccessor;
import wily.factoryapi.base.client.MinecraftAccessor;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.util.ColorUtil;
import wily.factoryapi.util.FactoryGuiElement;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.CommonValue;
import wily.legacy.client.ControlType;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacyTip;
import wily.legacy.client.LegacyTipManager;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyIconHolder;
import wily.legacy.client.screen.MultilineTooltip;
import wily.legacy.network.TopMessage;
import wily.legacy.util.LegacyItemUtil;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyFontUtil;
import wily.legacy.util.client.LegacyGuiElements;
import wily.legacy.util.client.MCAccount;

public class LegacyRenderUtil {
    public static final boolean isNvidia;
    public static final LegacyIconHolder iconHolderRenderer;
    public static final ResourceLocation MINECRAFT;
    public static final ResourceLocation PANORAMA_DAY;
    public static final ResourceLocation PANORAMA_NIGHT;
    public static final ResourceLocation MENU_BACKGROUND;
    public static final ResourceLocation LOADING_BACKGROUND;
    protected static final LogoRenderer logoRenderer;
    private static final Minecraft mc;

    public static void renderPointerPanel(GuiGraphics graphics, int x, int y, int width, int height) {
        LegacyRenderUtil.blitTranslucentOverlaySprite(graphics, LegacySprites.POINTER_PANEL, x, y, width, height);
    }

    public static void blitTranslucentOverlaySprite(GuiGraphics graphics, ResourceLocation sprite, int x, int y, int width, int height) {
        LegacyRenderUtil.blitTranslucentSprite(graphics, sprite, x, y, width, height);
    }

    public static void blitTranslucentSprite(GuiGraphics graphics, ResourceLocation sprite, int x, int y, int width, int height) {
        FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(sprite, x, y, width, height);
    }

    public static void renderPanelTranslucentRecess(GuiGraphics graphics, int x, int y, int width, int height) {
        LegacyRenderUtil.blitTranslucentSprite(graphics, LegacySprites.PANEL_TRANSLUCENT_RECESS, x, y, width, height);
    }

    public static void drawAutoSavingIcon(GuiGraphics graphics, int x, int y) {
        FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(LegacySprites.SAVE_CHEST, x, y, 24, 24);
        graphics.pose().pushMatrix();
        float heightAnim = (float)Util.getMillis() / 50.0f % 11.0f;
        graphics.pose().translate((float)x + 5.5f, (float)(y - 8) - (heightAnim > 5.0f ? 10.0f - heightAnim : heightAnim));
        FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(LegacySprites.SAVE_ARROW, 0, 0, 13, 16);
        graphics.pose().popMatrix();
    }

    public static void renderDefaultBackground(UIAccessor accessor, GuiGraphics guiGraphics) {
        LegacyRenderUtil.renderDefaultBackground(accessor, guiGraphics, true);
    }

    public static void renderDefaultBackground(UIAccessor accessor, GuiGraphics guiGraphics, boolean title) {
        LegacyRenderUtil.renderDefaultBackground(accessor, guiGraphics, false, title, true);
    }

    public static boolean isVisualNight() {
        return LegacyRenderUtil.mc.level != null && LegacyRenderUtil.mc.level.isDarkOutside();
    }

    public static void renderDefaultBackground(UIAccessor accessor, GuiGraphics guiGraphics, boolean forcePanorama, boolean title, boolean username) {
        if (LegacyRenderUtil.mc.level == null || accessor.getBoolean("forcePanorama", Boolean.valueOf(forcePanorama)).booleanValue()) {
            LegacyRenderUtil.renderPanorama(guiGraphics);
        } else {
            accessor.getScreen().renderTransparentBackground(guiGraphics);
        }
        if (accessor.getBoolean("hasTitle", Boolean.valueOf(title)).booleanValue()) {
            LegacyRenderUtil.renderLogo(guiGraphics);
        }
        if (accessor.getBoolean("hasUsername", Boolean.valueOf(username)).booleanValue()) {
            LegacyRenderUtil.renderUsername(guiGraphics);
        }
    }

    public static void renderLogo(GuiGraphics guiGraphics) {
        logoRenderer.renderLogo(guiGraphics, guiGraphics.guiWidth(), 1.0f);
    }

    public static float getLogoScale() {
        return LegacyOptions.getUIMode().isSD() ? 0.56217164f : 1.0f;
    }

    public static boolean hasLegacyLogo() {
        return ControlType.getActiveType().minecraftLogo().flatMap(arg_0 -> ((ResourceManager)mc.getResourceManager()).getResource(arg_0)).isPresent() || mc.getResourceManager().getResource(MINECRAFT).isPresent();
    }

    public static void renderLegacyLogo(GuiGraphics guiGraphics, int y) {
        FactoryScreenUtil.enableBlend();
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate(((float)guiGraphics.guiWidth() - 285.5f * LegacyRenderUtil.getLogoScale()) / 2.0f, (float)y);
        guiGraphics.pose().scale(0.5f * LegacyRenderUtil.getLogoScale(), 0.5f * LegacyRenderUtil.getLogoScale());
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(mc.getResourceManager().getResource(MINECRAFT).isPresent() ? MINECRAFT : ControlType.getActiveType().minecraftLogo().get(), 0, 0, 0.0f, 0.0f, 571, 138, 571, 138);
        guiGraphics.pose().popMatrix();
        FactoryScreenUtil.disableBlend();
    }

    public static void renderTransparentBackground(GuiGraphics graphics) {
        FactoryScreenUtil.enableBlend();
        FactoryGuiGraphics.of((GuiGraphics)graphics).blit(MENU_BACKGROUND, 0, 0, 0.0f, 0.0f, graphics.guiWidth(), graphics.guiHeight(), graphics.guiWidth(), graphics.guiHeight());
        FactoryScreenUtil.disableBlend();
    }

    public static void renderUsername(GuiGraphics graphics) {
        if (LegacyRenderUtil.mc.level != null) {
            return;
        }
        String username = MCAccount.isOfflineUser() ? I18n.get((String)"legacy.menu.offline_user", (Object[])new Object[]{mc.getUser().getName()}) : mc.getUser().getName();
        graphics.drawString(LegacyRenderUtil.mc.font, username, graphics.guiWidth() - 33 - LegacyRenderUtil.mc.font.width(username), graphics.guiHeight() - 27, -1);
    }

    public static void renderPanorama(GuiGraphics guiGraphics) {
        LegacyRenderUtil.mc.gameRenderer.getPanorama().render(guiGraphics, guiGraphics.guiWidth(), guiGraphics.guiHeight(), true);
    }

    public static void renderLegacyPanorama(GuiGraphics guiGraphics) {
        LegacyRenderUtil.renderLegacyPanorama(guiGraphics, LegacyRenderUtil.isVisualNight());
    }

    public static void renderLegacyPanorama(GuiGraphics guiGraphics, boolean isNight) {
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(isNight ? PANORAMA_NIGHT : PANORAMA_DAY, 0, 0, ((Double)LegacyRenderUtil.mc.options.panoramaSpeed().get()).floatValue() * (float)Util.getMillis() * (float)guiGraphics.guiHeight() / 360.0f / 66.32f, 1.0f, guiGraphics.guiWidth(), guiGraphics.guiHeight() + 2, guiGraphics.guiHeight() * 820 / 144, guiGraphics.guiHeight() + 2);
    }

    public static void drawOutlinedString(GuiGraphics graphics, Font font, Component component, int x, int y, int color, int outlineColor, float outline) {
        LegacyRenderUtil.drawOutlinedString(graphics, font, component.getVisualOrderText(), x, y, color, outlineColor, outline);
    }

    public static void drawOutlinedString(GuiGraphics graphics, Font font, FormattedCharSequence formattedCharSequence, int x, int y, int color, int outlineColor, float outline) {
        LegacyRenderUtil.drawStringOutline(graphics, font, formattedCharSequence, x, y, outlineColor, outline);
        graphics.drawString(font, formattedCharSequence, x, y, color, false);
    }

    public static void drawStringOutline(GuiGraphics graphics, Font font, FormattedCharSequence formattedCharSequence, int x, int y, int outlineColor, float outline) {
        float[] translations;
        for (float t : translations = new float[]{0.0f, outline, -outline}) {
            for (float t1 : translations) {
                if (t == 0.0f && t1 == 0.0f) continue;
                graphics.pose().pushMatrix();
                graphics.pose().translate(t, t1);
                graphics.drawString(font, formattedCharSequence, x, y, outlineColor, false);
                graphics.pose().popMatrix();
            }
        }
    }

    public static boolean isMouseOver(double mouseX, double mouseY, double x, double y, int width, int height) {
        return mouseX >= x && mouseX < x + (double)width && mouseY >= y && mouseY < y + (double)height;
    }

    public static void applyHUDScale(GuiGraphics graphics) {
        graphics.pose().scale(3.0f / LegacyRenderUtil.getHUDScale(), 3.0f / LegacyRenderUtil.getHUDScale());
    }

    public static void prepareHUDRender(GuiGraphics graphics) {
        graphics.pose().pushMatrix();
        FactoryGuiGraphics.of((GuiGraphics)graphics).setBlitColor(1.0f, 1.0f, 1.0f, LegacyRenderUtil.getHUDOpacity());
        graphics.pose().translate(0.0f, LegacyRenderUtil.getHUDDistance());
        FactoryScreenUtil.enableBlend();
    }

    public static void finalizeHUDRender(GuiGraphics graphics) {
        graphics.pose().popMatrix();
        FactoryGuiGraphics.of((GuiGraphics)graphics).setBlitColor(1.0f, 1.0f, 1.0f, 1.0f);
        FactoryScreenUtil.disableBlend();
    }

    public static float getHUDScale() {
        return switch ((Integer)LegacyOptions.hudSize.get()) {
            case 2 -> {
                if (LegacyOptions.getUIMode().isFHD()) {
                    yield 1.474f;
                }
                if (LegacyOptions.getUIMode().isSD()) {
                    yield 1.0f;
                }
                yield 1.5f;
            }
            case 3 -> {
                if (LegacyOptions.getUIMode().isSD()) {
                    yield 1.324f;
                }
                yield 2.0f;
            }
            default -> LegacyOptions.getUIMode().isSD() ? 0.8f : 1.0f;
        };
    }

    public static float getHUDSize() {
        return 6.0f + LegacyRenderUtil.getHUDScale() * (float)(35 + (LegacyRenderUtil.mc.gameMode.canHurtPlayer() ? Math.max(2, Mth.ceil((double)((Math.max(LegacyRenderUtil.mc.player.getAttributeValue(Attributes.MAX_HEALTH), (double)Math.max((float)LegacyRenderUtil.mc.gui.displayHealth, LegacyRenderUtil.mc.player.getHealth())) + (double)LegacyRenderUtil.mc.player.getAbsorptionAmount()) / 20.0)) + (LegacyRenderUtil.mc.player.getArmorValue() > 0 ? 1 : 0)) * 10 : 0));
    }

    public static float getHUDDistance() {
        return -((Double)LegacyOptions.hudDistance.get()).floatValue() * (22.4f + ((Boolean)LegacyOptions.inGameTooltips.get() != false ? 17.6f : 0.0f));
    }

    public static float getHUDOpacity() {
        float f = (float)(Util.getMillis() - LegacyGuiElements.lastHotbarSelectionChange) / 1200.0f;
        return LegacyRenderUtil.getInterfaceOpacity() <= 0.8f ? Math.min(0.8f, LegacyRenderUtil.getInterfaceOpacity() + (1.0f - LegacyRenderUtil.getInterfaceOpacity()) * (f >= 3.0f ? Math.max(4.0f - f, 0.0f) : 1.0f)) : LegacyRenderUtil.getInterfaceOpacity();
    }

    public static boolean hasTooltipBoxes() {
        return (Boolean)LegacyOptions.tooltipBoxes.get();
    }

    public static boolean hasTooltipBoxes(UIAccessor accessor) {
        return LegacyRenderUtil.hasTooltipBoxes() && accessor.getBoolean("hasTooltipBox", Boolean.valueOf(true)) != false;
    }

    public static float getInterfaceOpacity() {
        return ((Double)LegacyOptions.hudOpacity.get()).floatValue();
    }

    public static int getDefaultTextColor(boolean forceWhite) {
        return !forceWhite ? (Integer)CommonColor.HIGHLIGHTED_WIDGET_TEXT.get() : (Integer)CommonColor.WIDGET_TEXT.get();
    }

    public static int getDefaultTextColor() {
        return LegacyRenderUtil.getDefaultTextColor(false);
    }

    public static boolean hasProgrammerArt() {
        return mc.getResourcePackRepository().getSelectedPacks().stream().anyMatch(p -> p.getId().equals("programmer_art"));
    }

    public static void drawGenericLoading(GuiGraphics graphics, int x, int y) {
        LegacyRenderUtil.drawGenericLoading(graphics, x, y, 21, 6);
    }

    public static void drawGenericLoading(GuiGraphics graphics, int x, int y, int blockSize, int blockDistance) {
        int blockD = blockSize + blockDistance;
        for (int i = 0; i < 8; ++i) {
            float alpha;
            int v = (i + 1) * 100;
            int n = (i + 3) * 100;
            float l = (float)Util.getMillis() / 4.0f % 1000.0f;
            float f = l >= (float)(v - 100) ? (l <= (float)v ? l / (float)v : ((float)n - l) / 200.0f) : (alpha = 0.0f);
            if (!(alpha > 0.0f)) continue;
            FactoryGuiGraphics.of((GuiGraphics)graphics).setBlitColor(1.0f, 1.0f, 1.0f, alpha);
            FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(LegacySprites.LOADING_BLOCK, x + (i <= 2 ? i : (i >= 4 ? (i == 7 ? 0 : 6 - i) : 2)) * blockD, y + (i <= 2 ? 0 : (i == 3 || i == 7 ? 1 : 2)) * blockD, blockSize, blockSize);
        }
        FactoryGuiGraphics.of((GuiGraphics)graphics).clearBlitColor();
    }

    public static void renderScrollingString(GuiGraphics guiGraphics, Font font, Component component, int j, int k, int l, int m, int n, boolean shadow) {
        LegacyRenderUtil.renderScrollingString(guiGraphics, font, component.getVisualOrderText(), j, k, l, m, n, shadow);
    }

    public static void renderScrollingString(GuiGraphics guiGraphics, Font font, FormattedCharSequence charSequence, int j, int k, int l, int m, int n, boolean shadow) {
        LegacyRenderUtil.renderScrollingString(guiGraphics, font, charSequence, j, k, l, m, n, shadow, font.width(charSequence));
    }

    public static void renderScrollingString(GuiGraphics guiGraphics, Font font, FormattedCharSequence charSequence, int j, int k, int l, int m, int n, boolean shadow, int stringWidth) {
        Objects.requireNonNull(font);
        int p = (k + m - 9) / 2 + 1;
        int q = l - j;
        if (stringWidth > q) {
            int r = stringWidth - q;
            double d = (double)Util.getMillis() / 1000.0;
            double e = Math.max((double)r * 0.5, 3.0);
            double f = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d / e)) / 2.0 + 0.5;
            double g = Mth.lerp((double)f, (double)0.0, (double)r);
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).enableScissor(j, k, l, m);
            guiGraphics.drawString(font, charSequence, j - (int)g, p, n, shadow && (Boolean)CommonValue.WIDGET_TEXT_SHADOW.get() != false);
            guiGraphics.disableScissor();
        } else {
            guiGraphics.drawString(font, charSequence, j, p, n, shadow && (Boolean)CommonValue.WIDGET_TEXT_SHADOW.get() != false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isHovering(Slot slot, int leftPos, int topPos, double d, double e) {
        double d2;
        double d3;
        LegacyIconHolder holder = iconHolderRenderer.slotBounds(slot);
        int width = holder.getWidth();
        int height = holder.getHeight();
        double xCorner = holder.getXCorner() + holder.offset.x;
        double yCorner = holder.getYCorner() + holder.offset.y;
        d -= (double)leftPos;
        if (!(d3 >= xCorner)) return false;
        if (!(d < xCorner + (double)width)) return false;
        e -= (double)topPos;
        if (!(d2 >= yCorner)) return false;
        if (!(e < yCorner + (double)height)) return false;
        return true;
    }

    public static void renderEntityInInventoryFollowsMouse(GuiGraphics guiGraphics, int i, int j, int k, int l, int m, float f, float g, float h, LivingEntity livingEntity) {
        guiGraphics.enableScissor(i, j, k, l);
        float n = (float)(i + k) / 2.0f;
        float o = (float)(j + l) / 2.0f;
        float p = (float)Math.atan((n - g) / 40.0f);
        float q = (float)Math.atan((o - h) / 40.0f);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf2 = new Quaternionf().rotateX(q * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf2);
        float r = livingEntity.yBodyRot;
        float s = livingEntity.getYRot();
        float t = livingEntity.getXRot();
        float u = livingEntity.yHeadRotO;
        float v = livingEntity.yHeadRot;
        livingEntity.yBodyRot = 180.0f + p * 20.0f;
        livingEntity.setYRot(180.0f + p * 40.0f);
        livingEntity.setXRot(-q * 20.0f);
        livingEntity.yHeadRot = livingEntity.getYRot();
        livingEntity.yHeadRotO = livingEntity.getYRot();
        float w = livingEntity.getScale();
        Vector3f vector3f = new Vector3f(0.0f, livingEntity.getBbHeight() / 2.0f + f * w, 0.0f);
        float x = (float)m / w;
        InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (int)(i - guiGraphics.guiWidth()), (int)(j - guiGraphics.guiHeight()), (int)(k + guiGraphics.guiWidth()), (int)(l + guiGraphics.guiHeight()), (float)x, (Vector3f)vector3f, (Quaternionf)quaternionf, (Quaternionf)quaternionf2, (LivingEntity)livingEntity);
        livingEntity.yBodyRot = r;
        livingEntity.setYRot(s);
        livingEntity.setXRot(t);
        livingEntity.yHeadRotO = u;
        livingEntity.yHeadRot = v;
        guiGraphics.disableScissor();
    }

    public static void renderEntity(GuiGraphics guiGraphics, int x, int y, int x0, int y0, int size, Vector3f vector3f, Quaternionf quaternionf, @Nullable Quaternionf quaternionf2, Entity entity) {
        LegacyRenderUtil.renderEntity(guiGraphics, x, y, x0, y0, size, vector3f, quaternionf, quaternionf2, entity, false);
    }

    public static void renderEntity(GuiGraphics guiGraphics, int x, int y, int x0, int y0, int size, Vector3f vector3f, Quaternionf quaternionf, @Nullable Quaternionf quaternionf2, Entity entity, boolean forceSize) {
        float h;
        float f = h = forceSize ? (float)size / Math.max(1.0f, Math.max(entity.getBbWidth(), entity.getBbHeight())) : (float)size;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            h /= living.getScale();
        }
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        EntityRenderer entityRenderer = entityRenderDispatcher.getRenderer(entity);
        EntityRenderState entityRenderState = entityRenderer.createRenderState(entity, 1.0f);
        entityRenderState.lightCoords = 0xF000F0;
        entityRenderState.hitboxesRenderState = null;
        entityRenderState.shadowPieces.clear();
        entityRenderState.outlineColor = 0;
        guiGraphics.submitEntityRenderState(entityRenderState, h, vector3f, quaternionf, quaternionf2, x, y, x0, y0);
    }

    public static void renderLocalPlayerHead(GuiGraphics guiGraphics, int x, int y, int size) {
        if (LegacyRenderUtil.mc.player == null) {
            return;
        }
        PlayerFaceRenderer.draw((GuiGraphics)guiGraphics, (PlayerSkin)LegacyRenderUtil.mc.player.getSkin(), (int)x, (int)y, (int)size);
    }

    public static float getAutoGuiScale() {
        return (float)LegacyRenderUtil.getStandardHeight() / (LegacyOptions.getUIMode().isSD() ? 240.0f : 360.0f);
    }

    public static int getStandardHeight() {
        return Math.round((float)mc.getWindow().getHeight() / 180.0f) * 180;
    }

    public static boolean is720p() {
        return LegacyRenderUtil.getStandardHeight() <= 720;
    }

    public static float getTooltipScale() {
        return (Boolean)LegacyOptions.legacyItemTooltipScaling.get() != false && LegacyOptions.getUIMode().isFHD() ? 0.6666667f : 1.0f;
    }

    public static float getChatSafeZone() {
        return 29.0f * ((Double)LegacyOptions.hudDistance.get()).floatValue();
    }

    public static int getSelectedItemTooltipLines() {
        return (Integer)LegacyOptions.selectedItemTooltipLines.get() == 0 ? 0 : (Integer)LegacyOptions.selectedItemTooltipLines.get() + ((Boolean)LegacyOptions.itemTooltipEllipsis.get() != false ? 1 : 0);
    }

    public static boolean canDisplayHUD() {
        int hudDelay = (Integer)LegacyOptions.hudDelay.get();
        return LegacyRenderUtil.mc.screen == null && (hudDelay == 0 || Util.getMillis() - LegacyGuiElements.lastGui > (long)hudDelay);
    }

    public static void renderContainerEffects(GuiGraphics guiGraphics, int leftPos, int topPos, int imageWidth, int imageHeight, int mouseX, int mouseY) {
        int x = leftPos + imageWidth + 3;
        int l = guiGraphics.guiWidth() - x;
        Collection collection = LegacyRenderUtil.mc.player.getActiveEffects();
        if (collection.isEmpty() || l < 32) {
            return;
        }
        boolean bl = l >= 129;
        int m = 31;
        if (imageHeight < collection.size() * 28) {
            m = imageHeight / collection.size();
        }
        List iterable = Ordering.natural().sortedCopy((Iterable)collection);
        int y = topPos + imageHeight - 28;
        for (MobEffectInstance mobEffectInstance : iterable) {
            LegacyRenderUtil.renderPointerPanel(guiGraphics, x, y, bl ? 129 : 28, 28);
            if (bl) {
                guiGraphics.pose().pushMatrix();
                guiGraphics.pose().translate((float)(x + 25), (float)(y + 7));
                LegacyFontUtil.applySmallerFont(LegacyFontUtil.MOJANGLES_11_FONT, b -> {
                    Component effect = LegacyRenderUtil.getEffectName(mobEffectInstance);
                    if (!b.booleanValue()) {
                        guiGraphics.pose().scale(0.6666667f, 0.6666667f);
                    }
                    guiGraphics.drawString(LegacyRenderUtil.mc.font, effect, 0, 0, -1);
                    guiGraphics.pose().translate(0.0f, 10.0f * (b != false ? 1.0f : 1.5f));
                    guiGraphics.drawString(LegacyRenderUtil.mc.font, MobEffectUtil.formatDuration((MobEffectInstance)mobEffectInstance, (float)1.0f, (float)LegacyRenderUtil.mc.level.tickRateManager().tickrate()), 0, 0, -8421505);
                });
                guiGraphics.pose().popMatrix();
            }
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(Gui.getMobEffectSprite((Holder)mobEffectInstance.getEffect()), x + (bl ? 3 : 5), y + 5, 18, 18);
            y -= m;
        }
        if (!bl && mouseX >= x && mouseX <= x + 28) {
            MobEffectInstance mobEffectInstance;
            int n = topPos + imageHeight - 28;
            mobEffectInstance = null;
            for (MobEffectInstance mobEffectInstance2 : iterable) {
                if (mouseY >= n && mouseY <= n + m) {
                    mobEffectInstance = mobEffectInstance2;
                }
                n -= m;
            }
            if (mobEffectInstance != null) {
                List<Component> list = List.of(LegacyRenderUtil.getEffectName(mobEffectInstance), MobEffectUtil.formatDuration((MobEffectInstance)mobEffectInstance, (float)1.0f, (float)LegacyRenderUtil.mc.level.tickRateManager().tickrate()));
                guiGraphics.setTooltipForNextFrame(LegacyRenderUtil.mc.font, list, Optional.empty(), mouseX, mouseY);
            }
        }
    }

    public static Component getEffectName(MobEffectInstance mobEffectInstance) {
        MutableComponent mutableComponent = ((MobEffect)mobEffectInstance.getEffect().value()).getDisplayName().copy();
        if (mobEffectInstance.getAmplifier() >= 1 && mobEffectInstance.getAmplifier() <= 9) {
            mutableComponent.append(CommonComponents.SPACE).append((Component)Component.translatable((String)("enchantment.level." + (mobEffectInstance.getAmplifier() + 1))));
        }
        return mutableComponent;
    }

    public static List<Component> getTooltip(ItemStack stack) {
        return stack.getTooltipLines(Item.TooltipContext.of((Level)LegacyRenderUtil.mc.level), (Player)LegacyRenderUtil.mc.player, (TooltipFlag)((Boolean)LegacyOptions.advancedHeldItemTooltip.get() != false ? TooltipFlag.ADVANCED : TooltipFlag.NORMAL));
    }

    public static List<FormattedCharSequence> getTooltip(ItemStack stack, int width) {
        return new MultilineTooltip(LegacyRenderUtil.getTooltip(stack), width).toCharSequence(mc);
    }

    public static void renderHUDTooltip(GuiGraphics guiGraphics, int shift) {
        if (!FactoryGuiElement.SELECTED_ITEM_NAME.isVisible(FactoryScreenUtil.getGuiAccessor()) || LegacyRenderUtil.getSelectedItemTooltipLines() == 0) {
            return;
        }
        LegacyRenderUtil.prepareHUDRender(guiGraphics);
        guiGraphics.pose().translate(0.0f, (float)guiGraphics.guiHeight() - Math.max((float)shift, LegacyRenderUtil.getHUDSize()));
        FactoryAPIClient.getProfiler().push("selectedItemName");
        LegacyFontUtil.applySDFont(sd -> {
            if (GuiAccessor.getInstance().getToolHighlightTimer() > 0 && !GuiAccessor.getInstance().getLastToolHighlight().isEmpty()) {
                Font font = Objects.requireNonNullElse(IClientItemExtensions.of((ItemStack)GuiAccessor.getInstance().getLastToolHighlight()).getFont(GuiAccessor.getInstance().getLastToolHighlight(), IClientItemExtensions.FontContext.SELECTED_ITEM_NAME), LegacyRenderUtil.mc.font);
                List<Component> tooltip = LegacyRenderUtil.getTooltip(GuiAccessor.getInstance().getLastToolHighlight());
                tooltip.removeIf(c -> c.getString().isBlank());
                Object2IntMap tooltipLines = (Object2IntMap)tooltip.stream().limit(LegacyRenderUtil.getSelectedItemTooltipLines()).map(c -> tooltip.indexOf(c) == LegacyRenderUtil.getSelectedItemTooltipLines() - 1 && (Boolean)LegacyOptions.itemTooltipEllipsis.get() != false ? ControlTooltip.MORE : c).collect(Collectors.toMap(Function.identity(), arg_0 -> ((Font)font).width(arg_0), (a, b) -> b, Object2IntLinkedOpenHashMap::new));
                int l = Math.min((int)((float)GuiAccessor.getInstance().getToolHighlightTimer() * 256.0f / 10.0f), 255);
                if (l > 0) {
                    int color = -1 + (Math.round((float)l * LegacyRenderUtil.getHUDOpacity()) << 24);
                    int height = (Integer)LegacyOptions.selectedItemTooltipSpacing.get() * (tooltipLines.size() - 1);
                    guiGraphics.pose().translate(0.0f, (float)(-height));
                    if (!((Boolean)LegacyRenderUtil.mc.options.backgroundForChatOnly().get()).booleanValue()) {
                        int backgroundWidth = tooltipLines.values().intStream().max().orElse(0) + 4;
                        int backgroundX = (guiGraphics.guiWidth() - backgroundWidth) / 2;
                        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setBlitColor(1.0f, 1.0f, 1.0f, (float)l / 255.0f);
                        LegacyRenderUtil.renderPointerPanel(guiGraphics, backgroundX, -4, backgroundWidth, height + 15);
                        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).clearBlitColor();
                    }
                    tooltipLines.forEach((mutableComponent, width) -> {
                        int x = (guiGraphics.guiWidth() - width) / 2;
                        guiGraphics.drawString(font, mutableComponent, x, 0, color);
                        guiGraphics.pose().translate(0.0f, (float)((Integer)LegacyOptions.selectedItemTooltipSpacing.get()).intValue());
                    });
                }
            }
        });
        FactoryAPIClient.getProfiler().pop();
        LegacyRenderUtil.finalizeHUDRender(guiGraphics);
    }

    public static void renderGuiEffects(GuiGraphics guiGraphics) {
        Collection collection = LegacyRenderUtil.mc.player.getActiveEffects();
        if (!FactoryGuiElement.EFFECTS.isVisible(FactoryScreenUtil.getGuiAccessor()) || collection.isEmpty()) {
            return;
        }
        int i = 0;
        int j = 0;
        float backAlpha = LegacyRenderUtil.getHUDOpacity();
        for (MobEffectInstance mobEffectInstance : Ordering.natural().reverse().sortedCopy((Iterable)collection)) {
            Holder mobEffect = mobEffectInstance.getEffect();
            if (!mobEffectInstance.showIcon()) continue;
            int k = guiGraphics.guiWidth() - 55;
            int l = 18;
            if (mc.isDemo()) {
                l += 15;
            }
            if (((MobEffect)mobEffect.value()).isBeneficial()) {
                k -= 24 * ++i;
            } else {
                k -= 24 * ++j;
                l += 24;
            }
            float f = 1.0f;
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setBlitColor(1.0f, 1.0f, 1.0f, backAlpha);
            LegacyRenderUtil.renderPointerPanel(guiGraphics, k, l, 24, 24);
            if (mobEffectInstance.endsWithin(200)) {
                int m = mobEffectInstance.getDuration();
                f = Mth.clamp((float)((float)m / 10.0f / 5.0f * 0.5f), (float)0.0f, (float)0.5f) + Mth.cos((float)((float)m * (float)Math.PI / 5.0f)) * Mth.clamp((float)((float)(10 - m / 20) / 10.0f * 0.25f), (float)0.0f, (float)0.25f);
            }
            FactoryScreenUtil.enableBlend();
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setBlitColor(1.0f, 1.0f, 1.0f, f * backAlpha);
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(Gui.getMobEffectSprite((Holder)mobEffect), k + 3, l + 3, 18, 18);
            FactoryScreenUtil.disableBlend();
        }
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setBlitColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void renderTooltipInternal(GuiGraphics graphics, Font font, List<ClientTooltipComponent> list, int i, int j, ClientTooltipPositioner clientTooltipPositioner, ItemStack tooltipStack) {
        ClientTooltipComponent tooltipComponent;
        int t;
        if (list.isEmpty()) {
            return;
        }
        RenderTooltipEvent.Pre preEvent = ForgeHooksClient.onRenderTooltipPre((ItemStack)tooltipStack, (GuiGraphics)graphics, (int)i, (int)j, (int)graphics.guiWidth(), (int)graphics.guiHeight(), list, (Font)font, (ClientTooltipPositioner)clientTooltipPositioner, null);
        if (preEvent == null) {
            return;
        }
        font = preEvent.getFont();
        i = preEvent.getX();
        j = preEvent.getY();
        int k = 0;
        int l = 0;
        for (ClientTooltipComponent tooltipComponent2 : list) {
            k = Math.max(tooltipComponent2.getWidth(font), k);
            l += tooltipComponent2.getHeight(font);
        }
        Vector2ic vector2ic = clientTooltipPositioner.positionTooltip(graphics.guiWidth(), graphics.guiHeight(), i, j, (int)((float)k * LegacyRenderUtil.getTooltipScale()), (int)((float)l * LegacyRenderUtil.getTooltipScale()));
        int p = vector2ic.x();
        int q = vector2ic.y();
        graphics.pose().pushMatrix();
        if (p == (int)Legacy4JClient.controllerManager.getPointerX() && q == (int)Legacy4JClient.controllerManager.getPointerY()) {
            graphics.pose().translate((float)(Legacy4JClient.controllerManager.getPointerX() - (double)i), (float)(Legacy4JClient.controllerManager.getPointerY() - (double)j));
        }
        int scaledWidth = Math.round(LegacyRenderUtil.getTooltipScale() * (float)k);
        int scaledHeight = Math.round(LegacyRenderUtil.getTooltipScale() * (float)l);
        switch (LegacyOptions.getUIMode()) {
            case FHD: {
                LegacyRenderUtil.renderPointerPanel(graphics, p - 3, q - 6, scaledWidth + 7, scaledHeight + 9);
                break;
            }
            case SD: {
                LegacyRenderUtil.renderPointerPanel(graphics, p - 3, q - 4, scaledWidth + 7, scaledHeight + 6);
                break;
            }
            default: {
                LegacyRenderUtil.renderPointerPanel(graphics, p - 5, q - 9, scaledWidth + 11, scaledHeight + 13);
            }
        }
        graphics.pose().translate((float)p, (float)q);
        FactoryScreenUtil.disableDepthTest();
        graphics.pose().scale(LegacyRenderUtil.getTooltipScale(), LegacyRenderUtil.getTooltipScale());
        int s = 0;
        for (t = 0; t < list.size(); ++t) {
            tooltipComponent = list.get(t);
            tooltipComponent.renderText(graphics, font, 0, s);
            s += tooltipComponent.getHeight(font);
        }
        s = 0;
        for (t = 0; t < list.size(); ++t) {
            tooltipComponent = list.get(t);
            tooltipComponent.renderImage(font, 0, s, k, l, graphics);
            s += tooltipComponent.getHeight(font);
        }
        FactoryScreenUtil.enableDepthTest();
        graphics.pose().popMatrix();
    }

    public static void renderTopText(GuiGraphics guiGraphics, TopMessage topMessage, int y, float scale, int ticks) {
        if (topMessage != null && ticks < topMessage.ticksOnScreen()) {
            FactoryScreenUtil.disableDepthTest();
            guiGraphics.pose().pushMatrix();
            guiGraphics.pose().translate((float)guiGraphics.guiWidth() / 2.0f, (float)y);
            guiGraphics.pose().scale(scale, scale);
            if (topMessage.pulse()) {
                float pulse = (float)Util.getMillis() / 400.0f % 1.0f;
                pulse = 1.0f + (pulse > 0.5f ? 1.0f - pulse : pulse) / 10.0f;
                guiGraphics.pose().scale(pulse, pulse);
            }
            guiGraphics.pose().translate((float)(-LegacyRenderUtil.mc.font.width((FormattedText)topMessage.message())) / 2.0f, 0.0f);
            float maxFade = Math.min(topMessage.ticksOnScreen(), 20);
            float fade = topMessage.fade() ? Math.min(1.0f, ((float)topMessage.ticksOnScreen() - ((float)ticks + FactoryAPIClient.getPartialTick())) / maxFade) : 1.0f;
            guiGraphics.drawString(LegacyRenderUtil.mc.font, topMessage.message(), 0, 0, fade < 1.0f ? ColorUtil.withAlpha((int)topMessage.baseColor(), (float)fade) : topMessage.baseColor(), topMessage.shadow());
            guiGraphics.pose().popMatrix();
            FactoryScreenUtil.enableDepthTest();
        }
    }

    public static float getFlyingViewRollingRotation(float original) {
        if (((Boolean)LegacyOptions.flyingViewRolling.get()).booleanValue() && LegacyRenderUtil.mc.player != null && LegacyRenderUtil.mc.player.isFallFlying()) {
            float f = FactoryAPIClient.getGamePartialTick((boolean)false);
            Vec3 vec3 = LegacyRenderUtil.mc.player.getViewVector(f);
            Vec3 vec32 = LegacyRenderUtil.mc.player.avatarState().deltaMovementOnPreviousTick().lerp(LegacyRenderUtil.mc.player.getDeltaMovement(), (double)f);
            double d = vec32.horizontalDistanceSqr();
            double e = vec3.horizontalDistanceSqr();
            if (d > 0.0 && e > 0.0) {
                int dir = (int)(-Math.signum(vec32.x * vec3.z - vec32.z * vec3.x));
                float z = (float)Math.min(0.39269908169872414, Math.acos((vec32.x * vec3.x + vec32.z * vec3.z) / Math.sqrt(d * e)) / 2.5);
                if (z > 0.0f) {
                    return (float)dir * z;
                }
            }
        }
        return original;
    }

    public static void renderGameOverlay(GuiGraphics graphics) {
        if (!MinecraftAccessor.getInstance().hasGameLoaded()) {
            return;
        }
        float partialTick = FactoryAPIClient.getPartialTick();
        boolean canRenderElement = LegacyRenderUtil.mc.screen != null || !LegacyRenderUtil.mc.options.hideGui;
        LegacyTip tip = LegacyTipManager.getActualTip();
        if ((!LegacyTipManager.tips.isEmpty() || tip != null) && canRenderElement) {
            if (tip == null) {
                tip = LegacyTipManager.updateTip();
            }
            tip.setX(graphics.guiWidth() - tip.getWidth() - 30);
            tip.render(graphics, 0, 0, partialTick);
            if (tip.visibility == Toast.Visibility.HIDE) {
                LegacyTipManager.updateTip();
            }
        }
        if (((Boolean)LegacyRenderUtil.mc.options.showAutosaveIndicator().get()).booleanValue() && canRenderElement && (LegacyRenderUtil.mc.gui.autosaveIndicatorValue > 0.0f || LegacyRenderUtil.mc.gui.lastAutosaveIndicatorValue > 0.0f) && (double)Mth.clamp((float)Mth.lerp((float)FactoryAPIClient.getPartialTick(), (float)LegacyRenderUtil.mc.gui.lastAutosaveIndicatorValue, (float)LegacyRenderUtil.mc.gui.autosaveIndicatorValue), (float)0.0f, (float)1.0f) > 0.02) {
            FactoryScreenUtil.disableDepthTest();
            LegacyRenderUtil.drawAutoSavingIcon(graphics, graphics.guiWidth() - 66, 44);
            FactoryScreenUtil.enableDepthTest();
        }
        if (GLFW.glfwGetInputMode((long)mc.getWindow().handle(), (int)208897) == 212994 && !Legacy4JClient.controllerManager.isCursorDisabled && !LegacyOptions.hasSystemCursor()) {
            graphics.pose().pushMatrix();
            graphics.pose().translate(Legacy4JClient.controllerManager.getVisualPointerX() + LegacyTipManager.getTipXDiff(), Legacy4JClient.controllerManager.getVisualPointerY());
            FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(LegacyOptions.getUIMode().isFHD() ? LegacySprites.POINTER : LegacySprites.SMALL_POINTER, -8, -8, 16, 16);
            graphics.pose().popMatrix();
        }
    }

    public static void renderPotionLevel(GuiGraphics graphics, int i, int j, ItemStack itemStack) {
        if (!((Boolean)LegacyOptions.legacyPotionsBar.get()).booleanValue()) {
            return;
        }
        int potionLevel = LegacyItemUtil.getPotionLevel(itemStack);
        if (potionLevel > 0) {
            int x = i + 3;
            int y = j + 13;
            graphics.fill(x, y, x + 11, y + 2, -16777216);
            for (int k = 0; k < potionLevel; ++k) {
                graphics.fill(x + k * 3, y, x + k * 3 + 2, y + 2, -16720411);
            }
        }
    }

    public static Screen getInitialScreen() {
        TitleScreen titleScreen = new TitleScreen(((Boolean)LegacyOptions.titleScreenFade.get()).booleanValue());
        if (((Boolean)LegacyOptions.skipInitialSaveWarning.get()).booleanValue()) {
            return titleScreen;
        }
        return ConfirmationScreen.createSaveInfoScreen((Screen)titleScreen);
    }

    public static ScreenDirection getScreenDirection(double x, double y) {
        if (Math.abs(x) > Math.abs(y)) {
            if (x > 0.0) {
                return ScreenDirection.RIGHT;
            }
            if (x < 0.0) {
                return ScreenDirection.LEFT;
            }
        }
        if (y > 0.0) {
            return ScreenDirection.DOWN;
        }
        if (y < 0.0) {
            return ScreenDirection.UP;
        }
        return null;
    }

    public static boolean hasHorizontalArtifacts() {
        return isNvidia;
    }

    static {
        iconHolderRenderer = new LegacyIconHolder();
        MINECRAFT = Legacy4J.createModLocation("textures/gui/title/minecraft.png");
        PANORAMA_DAY = Legacy4J.createModLocation("textures/gui/title/panorama_day.png");
        PANORAMA_NIGHT = Legacy4J.createModLocation("textures/gui/title/panorama_night.png");
        MENU_BACKGROUND = Legacy4J.createModLocation("textures/gui/menu_background.png");
        LOADING_BACKGROUND = Legacy4J.createModLocation("textures/gui/loading_background.png");
        logoRenderer = new LogoRenderer(false);
        mc = Minecraft.getInstance();
        isNvidia = new SystemInfo().getHardware().getGraphicsCards().stream().anyMatch(s -> s.getVendor().contains("nvidia") || s.getVendor().contains("NVIDIA"));
    }
}

