/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.GsonHelper;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIPlatform;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.CommonValue;
import wily.legacy.client.ControlType;
import wily.legacy.client.LegacyIntro;
import wily.legacy.client.PlayerIdentifier;
import wily.legacy.client.controller.BindingState;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.controller.ControllerManager;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.KeyboardScreen;
import wily.legacy.util.JsonUtil;

public class LegacyResourceManager
implements ResourceManagerReloadListener {
    public static final ResourceLocation GAMEPAD_MAPPINGS = Legacy4J.createModLocation("gamepad_mappings.txt");
    public static final ResourceLocation INTRO_LOCATION = Legacy4J.createModLocation("intro.json");
    public static final ResourceLocation GAMMA_LOCATION = Legacy4J.createModLocation("post_effect/gamma.json");
    public static final ResourceLocation DEFAULT_KEYBOARD_LAYOUT_LOCATION = Legacy4J.createModLocation("keyboard_layout/en_us.json");
    public static final ResourceLocation PLAYER_IDENTIFIERS_LOCATION = Legacy4J.createModLocation("player_identifiers.json");
    public static final String CONTROL_TYPES = "control_types.json";
    public static final String COMMON_COLORS = "common_colors.json";
    public static final String COMMON_VALUES = "common_values.json";
    public static final String DEFAULT_KBM_ICONS = "control_tooltips/icons/kbm.json";
    public static final String DEFAULT_CONTROLLER_ICONS = "control_tooltips/icons/controller.json";
    public static LegacyIntro intro = LegacyIntro.EMPTY;
    public static final List<KeyboardScreen.CharButtonBuilder> keyboardButtonBuilders = new ArrayList<KeyboardScreen.CharButtonBuilder>();
    public static ControllerBinding<?> shiftBinding;

    public void m_6213_(ResourceManager resourceManager) {
        Minecraft minecraft = Minecraft.m_91087_();
        resourceManager.m_213713_(GAMEPAD_MAPPINGS).ifPresent(r -> {
            try {
                ControllerManager.getHandler().applyGamePadMappingsFromBuffer(r.m_215508_());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        if (Legacy4JClient.gammaEffect != null) {
            Legacy4JClient.gammaEffect.close();
        }
        try {
            Legacy4JClient.gammaEffect = new PostChain(minecraft.m_91097_(), resourceManager, minecraft.m_91385_(), GAMMA_LOCATION);
            Legacy4JClient.gammaEffect.m_110025_(minecraft.m_91268_().m_85441_(), minecraft.m_91268_().m_85442_());
        }
        catch (IOException iOException) {
            Legacy4J.LOGGER.warn("Failed to load gamma: {}", (Object)GAMMA_LOCATION, (Object)iOException);
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            Legacy4J.LOGGER.warn("Failed to parse shader: {}", (Object)GAMMA_LOCATION, (Object)jsonSyntaxException);
        }
        PlayerIdentifier.list.clear();
        resourceManager.m_213829_(PLAYER_IDENTIFIERS_LOCATION).forEach(r -> {
            try {
                GsonHelper.m_144765_((Reader)r.m_215508_()).forEach(e -> PlayerIdentifier.CODEC.parse((DynamicOps)JsonOps.INSTANCE, e).result().ifPresent(p -> PlayerIdentifier.list.put(p.index(), p)));
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        });
        ControlType.types.clear();
        CommonValue.COMMON_VALUES.forEach((s, c) -> c.reset());
        CommonColor.COMMON_COLORS.forEach((s, c) -> c.reset());
        resourceManager.m_213713_(DEFAULT_KEYBOARD_LAYOUT_LOCATION).ifPresent(LegacyResourceManager::setKeyboardLayout);
        JsonUtil.getOrderedNamespaces(resourceManager).forEach(name -> {
            resourceManager.m_213713_(FactoryAPI.createLocation((String)name, (String)CONTROL_TYPES)).ifPresent(r -> {
                try {
                    GsonHelper.m_144765_((Reader)r.m_215508_()).forEach(e -> {
                        ControlType type;
                        ResourceLocation id;
                        if (e instanceof JsonPrimitive) {
                            JsonPrimitive p = (JsonPrimitive)e;
                            id = FactoryAPI.createLocation((String)p.getAsString());
                            if (ControlType.types.containsKey((Object)id.toString()) && ControlType.defaultTypes.contains(ControlType.types.get((Object)id.toString()))) {
                                return;
                            }
                            for (ControlType defaultType : ControlType.defaultTypes) {
                                if (!defaultType.getId().equals((Object)id)) continue;
                                ControlType.types.put((Object)id.toString(), (Object)defaultType);
                                return;
                            }
                            type = ControlType.create(id, null, false);
                        } else {
                            JsonObject o = e.getAsJsonObject();
                            id = FactoryAPI.createLocation((String)GsonHelper.m_13906_((JsonObject)o, (String)"id"));
                            type = ControlType.create(id, (Component)JsonUtil.getJsonStringOrNull(o, "displayName", Component::m_237115_), GsonHelper.m_13855_((JsonObject)o, (String)"isKbm", (boolean)false));
                        }
                        ControlType.types.put((Object)id.toString(), (Object)type);
                    });
                }
                catch (IOException e2) {
                    Legacy4J.LOGGER.warn(e2.getMessage());
                }
            });
            resourceManager.m_213713_(FactoryAPI.createLocation((String)name, (String)COMMON_COLORS)).ifPresent(r -> {
                try {
                    JsonObject obj = GsonHelper.m_13859_((Reader)r.m_215508_());
                    obj.asMap().forEach((s, e) -> {
                        ResourceLocation id = FactoryAPI.createLocation((String)s);
                        if (CommonColor.COMMON_COLORS.containsKey((Object)id)) {
                            ((CommonColor)((Object)((Object)((Object)((Object)CommonColor.COMMON_COLORS.get((Object)id)))))).parse(new Dynamic((DynamicOps)JsonOps.INSTANCE, e));
                        }
                    });
                }
                catch (IOException e2) {
                    Legacy4J.LOGGER.warn(e2.getMessage());
                }
            });
            resourceManager.m_213713_(FactoryAPI.createLocation((String)name, (String)COMMON_VALUES)).ifPresent(r -> {
                try {
                    JsonObject obj = GsonHelper.m_13859_((Reader)r.m_215508_());
                    obj.asMap().forEach((s, e) -> {
                        ResourceLocation id = FactoryAPI.createLocation((String)s);
                        if (CommonColor.COMMON_VALUES.containsKey((Object)id)) {
                            ((CommonValue)((Object)((Object)((Object)((Object)CommonColor.COMMON_VALUES.get((Object)id)))))).parse(new Dynamic((DynamicOps)JsonOps.INSTANCE, e));
                        }
                    });
                }
                catch (IOException e2) {
                    Legacy4J.LOGGER.warn(e2.getMessage());
                }
            });
            LegacyResourceManager.addKbmIcons(resourceManager, FactoryAPI.createLocation((String)name, (String)DEFAULT_KBM_ICONS), (s, b) -> {
                for (ControlType value : ControlType.types.values()) {
                    if (!value.isKbm()) continue;
                    value.getIcons().put((String)s, (ControlTooltip.LegacyIcon)b);
                }
            });
            LegacyResourceManager.addControllerIcons(resourceManager, FactoryAPI.createLocation((String)name, (String)DEFAULT_CONTROLLER_ICONS), (s, b) -> {
                for (ControlType value : ControlType.types.values()) {
                    if (value.isKbm()) continue;
                    value.getIcons().put((String)s, (ControlTooltip.LegacyIcon)b);
                }
            });
            for (ControlType value : ControlType.types.values()) {
                ResourceLocation location = FactoryAPI.createLocation((String)value.getId().m_135827_(), (String)"control_tooltips/icons/%s.json".formatted(value.getId().m_135815_()));
                if (value.isKbm()) {
                    LegacyResourceManager.addKbmIcons(resourceManager, location, value.getIcons()::put);
                    continue;
                }
                LegacyResourceManager.addControllerIcons(resourceManager, location, value.getIcons()::put);
            }
            String langKey = minecraft.m_91102_().m_118976_(minecraft.m_91102_().m_264236_()) != null ? minecraft.m_91102_().m_264236_() : "en_us";
            resourceManager.m_213713_(FactoryAPI.createLocation((String)name, (String)"keyboard_layout/%s.json".formatted(langKey))).ifPresent(LegacyResourceManager::setKeyboardLayout);
        });
    }

    public static void setKeyboardLayout(Resource resource) {
        try {
            JsonObject obj = GsonHelper.m_13859_((Reader)resource.m_215508_());
            keyboardButtonBuilders.clear();
            shiftBinding = obj.has("shiftBinding") ? ControllerBinding.map.get(obj.get("shiftBinding").getAsString()) : ControllerBinding.LEFT_STICK_BUTTON;
            obj.getAsJsonArray("layout").forEach(e -> {
                if (e instanceof JsonObject) {
                    JsonObject o = (JsonObject)e;
                    keyboardButtonBuilders.add(new KeyboardScreen.CharButtonBuilder(GsonHelper.m_13824_((JsonObject)o, (String)"width", (int)25), GsonHelper.m_13906_((JsonObject)o, (String)"chars"), GsonHelper.m_13851_((JsonObject)o, (String)"shiftChars", null), JsonUtil.getJsonStringOrNull(o, "binding", ControllerBinding.map::get), JsonUtil.getJsonStringOrNull(o, "icon", FactoryAPI::createLocation), JsonUtil.getJsonStringOrNull(o, "soundEvent", s -> (SoundEvent)FactoryAPIPlatform.getRegistryValue((ResourceLocation)FactoryAPI.createLocation((String)s), (Registry)BuiltInRegistries.f_256894_))));
                } else if (e instanceof JsonPrimitive) {
                    JsonPrimitive p = (JsonPrimitive)e;
                    keyboardButtonBuilders.add(new KeyboardScreen.CharButtonBuilder(25, p.getAsString(), null, null, null, null));
                }
            });
        }
        catch (IOException e2) {
            Legacy4J.LOGGER.warn(e2.getMessage());
        }
    }

    public static void addIcons(ResourceManager resourceManager, ResourceLocation location, BiConsumer<String, JsonObject> addIcon) {
        resourceManager.m_213713_(location).ifPresent(r -> {
            try {
                GsonHelper.m_13859_((Reader)r.m_215508_()).asMap().forEach((s, o) -> addIcon.accept((String)s, o.getAsJsonObject()));
            }
            catch (IOException e) {
                Legacy4J.LOGGER.warn(e.getMessage());
            }
        });
    }

    public static void addControllerIcons(ResourceManager resourceManager, ResourceLocation location, BiConsumer<String, ControlTooltip.LegacyIcon> addIcon) {
        LegacyResourceManager.addIcons(resourceManager, location, (s, o) -> {
            ControllerBinding<?> binding = ControllerBinding.map.get(s);
            if (binding != null) {
                addIcon.accept((String)s, ControlTooltip.LegacyIcon.create(() -> ((BindingState)binding.getMapped().state()).pressed, JsonUtil.getJsonStringOrNull(o, "icon", String::toCharArray), JsonUtil.getJsonStringOrNull(o, "iconOverlay", String::toCharArray), JsonUtil.getJsonStringOrNull(o, "tipIcon", v -> Character.valueOf(v.charAt(0))), () -> !((BindingState)binding.getMapped().state()).isBlocked(), ControlType::getActiveControllerType));
            }
        });
    }

    public static void addKbmIcons(ResourceManager resourceManager, ResourceLocation location, BiConsumer<String, ControlTooltip.LegacyIcon> addIcon) {
        LegacyResourceManager.addIcons(resourceManager, location, (s, o) -> {
            InputConstants.Key key = InputConstants.m_84851_((String)s);
            ControlTooltip.LegacyIcon icon = ControlTooltip.LegacyIcon.create(key, JsonUtil.getJsonStringOrNull(o, "icon", String::toCharArray), JsonUtil.getJsonStringOrNull(o, "iconOverlay", String::toCharArray), JsonUtil.getJsonStringOrNull(o, "tipIcon", v -> Character.valueOf(v.charAt(0))));
            addIcon.accept(key.m_84874_(), icon);
        });
    }

    public static void loadIntroLocations(ResourceManager resourceManager) {
        try {
            LegacyIntro.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)resourceManager.m_215597_(INTRO_LOCATION))).result().ifPresent(i -> {
                intro = i;
            });
        }
        catch (IOException e) {
            Legacy4J.LOGGER.error(e.getMessage());
        }
    }

    public String m_7812_() {
        return "legacy:resource_manager";
    }
}

