/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.level.block.entity.BannerPattern;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.util.DynamicUtil;
import wily.factoryapi.util.ListMap;
import wily.legacy.Legacy4J;
import wily.legacy.client.LegacyTabInfo;
import wily.legacy.client.screen.LegacyTabButton;
import wily.legacy.util.JsonUtil;

public class LoomTabListing
implements LegacyTabInfo {
    public static final Codec<List<ResourceKey<BannerPattern>>> PATTERNS_CODEC = ResourceKey.m_195966_((ResourceKey)Registries.f_256969_).listOf().xmap(ArrayList::new, Function.identity());
    public static final Codec<LoomTabListing> CODEC = RecordCodecBuilder.create(i -> i.group((App)ResourceLocation.f_135803_.fieldOf("id").forGetter(LoomTabListing::id), (App)DynamicUtil.getComponentCodec().fieldOf("name").forGetter(LoomTabListing::name), (App)LegacyTabButton.ICON_HOLDER_CODEC.fieldOf("icon").forGetter(LoomTabListing::iconHolder), (App)PATTERNS_CODEC.fieldOf("listing").forGetter(LoomTabListing::patterns)).apply((Applicative)i, LoomTabListing::new));
    public static final ListMap<ResourceLocation, LoomTabListing> map = new ListMap();
    private static final String LOOM_TAB_LISTING = "loom_tab_listing.json";
    private final ResourceLocation id;
    private Component name;
    private LegacyTabButton.IconHolder<?> iconHolder;
    private final List<ResourceKey<BannerPattern>> patterns;

    public LoomTabListing(ResourceLocation id, Component displayName, LegacyTabButton.IconHolder<?> iconHolder, List<ResourceKey<BannerPattern>> patterns) {
        this.id = id;
        this.name = displayName;
        this.iconHolder = iconHolder;
        this.patterns = patterns;
    }

    @Override
    public boolean isValid() {
        return LegacyTabInfo.super.isValid() && !this.patterns.isEmpty();
    }

    @Override
    public ResourceLocation id() {
        return this.id;
    }

    @Override
    public Component name() {
        return this.name;
    }

    @Override
    public LegacyTabButton.IconHolder<?> iconHolder() {
        return this.iconHolder;
    }

    public List<ResourceKey<BannerPattern>> patterns() {
        return this.patterns;
    }

    public void addFrom(LoomTabListing otherListing) {
        if (otherListing.name != null) {
            this.name = otherListing.name;
        }
        if (otherListing.iconHolder != null) {
            this.iconHolder = otherListing.iconHolder;
        }
        this.patterns.addAll(otherListing.patterns);
    }

    public static class Manager
    implements ResourceManagerReloadListener {
        public String m_7812_() {
            return "legacy:loom_tab_listing";
        }

        public void m_6213_(ResourceManager resourceManager) {
            map.clear();
            ResourceManager manager = Minecraft.m_91087_().m_91098_();
            JsonUtil.getOrderedNamespaces(manager).forEach(name -> manager.m_213713_(FactoryAPI.createLocation((String)name, (String)LoomTabListing.LOOM_TAB_LISTING)).ifPresent(r -> {
                try (BufferedReader bufferedReader = r.m_215508_();){
                    JsonElement element = JsonParser.parseReader((Reader)bufferedReader);
                    if (element instanceof JsonArray) {
                        JsonArray a = (JsonArray)element;
                        a.forEach(e -> CODEC.parse((DynamicOps)JsonOps.INSTANCE, e).result().ifPresent(listing -> {
                            if (map.containsKey((Object)listing.id)) {
                                ((LoomTabListing)map.get((Object)listing.id)).addFrom((LoomTabListing)listing);
                            } else if (listing.isValid()) {
                                map.put((Object)listing.id, listing);
                            }
                        }));
                    }
                }
                catch (IOException exception) {
                    Legacy4J.LOGGER.warn(exception.getMessage());
                }
            }));
        }

        public static void addBannerPatternsFromJson(List<ResourceKey<BannerPattern>> groups, JsonElement element) {
            if (element instanceof JsonArray) {
                JsonArray a = (JsonArray)element;
                a.forEach(e -> {
                    JsonPrimitive p;
                    if (e instanceof JsonPrimitive && (p = (JsonPrimitive)e).isString()) {
                        groups.add(ResourceKey.m_135785_((ResourceKey)Registries.f_256969_, (ResourceLocation)FactoryAPI.createLocation((String)p.getAsString())));
                    }
                });
            }
        }
    }
}

