/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.legacy.Legacy4J;
import wily.legacy.client.CommonColor;
import wily.legacy.client.ControlType;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.CreationList;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PanelVListScreen;
import wily.legacy.client.screen.SaveRenderableList;
import wily.legacy.client.screen.TickBox;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.MCAccount;
import wily.legacy.util.ScreenUtil;

public class ChooseUserScreen
extends PanelVListScreen {
    public static final Component CHOOSE_USER = Component.m_237115_((String)"legacy.menu.choose_user");
    public static final Component CHOOSE_USER_MESSAGE = Component.m_237115_((String)"legacy.menu.choose_user_message");
    public static final Component ADD_ACCOUNT = Component.m_237115_((String)"legacy.menu.choose_user.add");
    public static final Component ACCOUNT_OPTIONS = Component.m_237115_((String)"legacy.menu.choose_user.account_options");
    public static final Component DIRECT_LOGIN = Component.m_237115_((String)"legacy.menu.choose_user.direct_login");
    public static final Component ACCOUNT_OPTIONS_MESSAGE = Component.m_237115_((String)"legacy.menu.choose_user.account_options_message");
    public static final Component EDIT_ACCOUNT = Component.m_237115_((String)"legacy.menu.choose_user.account_options.edit");
    public static final Component DELETE_ACCOUNT = Component.m_237115_((String)"legacy.menu.choose_user.account_options.delete");
    public static final Component ACCOUNT_ENCRYPTION = Component.m_237115_((String)"legacy.menu.choose_user.add.encryption");
    public static final Component ACCOUNT_ENCRYPTION_MESSAGE = Component.m_237115_((String)"legacy.menu.choose_user.add.encryption_message");
    public static final Component ADD_WITH_ENCRYPTION = Component.m_237115_((String)"legacy.menu.choose_user.add.encryption.present");
    public static final Component ADD_WITHOUT_ENCRYPTION = Component.m_237115_((String)"legacy.menu.choose_user.add.encryption.absent");
    public static final Component VISIBLE_PASSWORD = Component.m_237115_((String)"legacy.menu.choose_user.add.encryption.visible_password");
    public static final Pattern usernamePattern = Pattern.compile("[A-Za-z0-9_]{2,16}");

    public ChooseUserScreen(Screen parent) {
        super(parent, s -> Panel.centered(s, 260, 215, 0, 10), CHOOSE_USER);
        this.renderableVList.layoutSpacing(i -> 0);
        this.addAccountButtons();
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        super.addControlTooltips(renderer);
        renderer.add(() -> this.m_7222_() == null || this.renderableVList.renderables.indexOf(this.m_7222_()) <= 0 ? null : (ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(79) : ControllerBinding.UP_BUTTON.getIcon()), () -> ACCOUNT_OPTIONS);
        renderer.add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(88) : ControllerBinding.LEFT_BUTTON.getIcon(), () -> DIRECT_LOGIN);
    }

    @Override
    public boolean m_7933_(int i, int j, int k) {
        if (i == 88) {
            this.f_96541_.m_91152_((Screen)ChooseUserScreen.accountScreen(DIRECT_LOGIN, this, false, this::manageLogin));
            return true;
        }
        return super.m_7933_(i, j, k);
    }

    public void reloadAccountButtons() {
        int i = this.renderableVList.renderables.indexOf(this.m_7222_());
        this.renderableVList.renderables.clear();
        this.addAccountButtons();
        this.m_267719_();
        if (i >= 0 && i < this.renderableVList.renderables.size()) {
            this.m_7522_((GuiEventListener)this.renderableVList.renderables.get(i));
        }
    }

    @Override
    public void renderableVListInit() {
        this.m_169394_((guiGraphics, i, j, f) -> {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.PANEL_RECESS, this.panel.m_252754_() + 10, this.panel.m_252907_() + 13, this.panel.m_5711_() - 20, this.panel.m_93694_() - 26);
            guiGraphics.m_280614_(this.f_96547_, this.m_96636_(), this.panel.m_252754_() + (this.panel.m_5711_() - this.f_96547_.m_92852_((FormattedText)this.m_96636_())) / 2, this.panel.y + 20, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        });
        this.getRenderableVList().init(this.panel.x + 15, this.panel.y + 32, this.panel.width - 30, this.panel.height - 50);
    }

    public static ConfirmationScreen passwordScreen(Screen parent, Consumer<String> pass) {
        final EditBox passWordBox = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, 200, 20, (Component)Component.m_237115_((String)"legacy.menu.choose_user.add.encryption.password"));
        final TickBox tickBox = new TickBox(0, 0, true, bol -> VISIBLE_PASSWORD, bol -> null, t -> passWordBox.m_94149_((s, i) -> FormattedCharSequence.m_13714_((String)(t.selected ? s : "*".repeat(s.length())), (Style)Style.f_131099_)));
        tickBox.m_5691_();
        return new ConfirmationScreen(parent, 230, 120, passWordBox.m_6035_(), (Component)Component.m_237115_((String)"legacy.menu.choose_user.add.encryption.password_message"), b1 -> pass.accept(passWordBox.m_94155_())){

            @Override
            protected void addButtons() {
                super.addButtons();
                this.okButton.f_93623_ = false;
            }

            @Override
            protected void m_7856_() {
                super.m_7856_();
                tickBox.m_264152_(this.panel.m_252754_() + 15, this.panel.m_252907_() + 68);
                this.m_142416_((GuiEventListener)tickBox);
                passWordBox.m_264152_(this.panel.m_252754_() + 15, this.panel.m_252907_() + 45);
                passWordBox.m_94151_(s -> {
                    this.okButton.f_93623_ = !s.isEmpty();
                });
                this.m_142416_((GuiEventListener)passWordBox);
            }
        };
    }

    public static ConfirmationScreen accountScreen(Component title, Screen parent, final boolean allowEncryption, final Consumer<MCAccount> press) {
        return new ConfirmationScreen(parent, 230, 120, title, CHOOSE_USER_MESSAGE){

            @Override
            protected void addButtons() {
                this.renderableVList.addRenderable((Renderable)Button.m_253074_((Component)Component.m_237115_((String)"gui.cancel"), b -> this.m_7379_()).m_253136_());
                this.renderableVList.addRenderable((Renderable)Button.m_253074_((Component)Component.m_237115_((String)"legacy.menu.choose_user.microsoft"), b -> {
                    if (allowEncryption) {
                        this.f_96541_.m_91152_((Screen)new ConfirmationScreen(this, ACCOUNT_ENCRYPTION, ACCOUNT_ENCRYPTION_MESSAGE){

                            @Override
                            protected void addButtons() {
                                this.renderableVList.addRenderable((Renderable)Button.m_253074_((Component)ADD_WITH_ENCRYPTION, b -> this.f_96541_.m_91152_((Screen)ChooseUserScreen.passwordScreen(this, s -> MCAccount.create(() -> this.f_96541_.m_91152_((Screen)this), s).thenAcceptAsync(press, (Executor)this.f_96541_)))).m_253136_());
                                this.renderableVList.addRenderable((Renderable)Button.m_253074_((Component)ADD_WITHOUT_ENCRYPTION, b -> MCAccount.create(() -> this.f_96541_.m_91152_((Screen)this), null).thenAcceptAsync(press, (Executor)this.f_96541_)).m_253136_());
                            }
                        });
                    } else {
                        MCAccount.create(() -> this.f_96541_.m_91152_((Screen)this), null).thenAcceptAsync(press, (Executor)this.f_96541_);
                    }
                }).m_253136_());
                this.renderableVList.addRenderable((Renderable)Button.m_253074_((Component)Component.m_237115_((String)"legacy.menu.choose_user.offline"), b -> {
                    final EditBox usernameBox = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, 200, 20, (Component)Component.m_237115_((String)"legacy.menu.choose_user.offline.username"));
                    this.f_96541_.m_91152_((Screen)new ConfirmationScreen(this, 230, 120, usernameBox.m_6035_(), (Component)Component.m_237115_((String)"legacy.menu.choose_user.offline.username_message"), b1 -> press.accept(MCAccount.create(new GameProfile(UUID.nameUUIDFromBytes(("offline:" + usernameBox.m_94155_()).getBytes()), usernameBox.m_94155_()), false, null, null))){

                        @Override
                        protected void addButtons() {
                            super.addButtons();
                            this.okButton.f_93623_ = false;
                        }

                        @Override
                        protected void m_7856_() {
                            super.m_7856_();
                            usernameBox.m_264152_(this.panel.m_252754_() + 15, this.panel.m_252907_() + 45);
                            usernameBox.m_94151_(s -> {
                                boolean matches = usernamePattern.matcher((CharSequence)s).matches();
                                usernameBox.m_94202_(matches ? 0xFFFFFF : 0xFF5555);
                                this.okButton.f_93623_ = matches;
                            });
                            this.m_142416_((GuiEventListener)usernameBox);
                        }
                    });
                }).m_253136_());
            }
        };
    }

    public void manageLogin(MCAccount account) {
        if (account.isEncrypted()) {
            this.f_96541_.m_91152_((Screen)ChooseUserScreen.passwordScreen(this, s -> account.login(this, (String)s)));
        } else {
            account.login(this, null);
        }
    }

    protected void addAccountButtons() {
        final Minecraft minecraft = Minecraft.m_91087_();
        CreationList.addIconButton(this.renderableVList, Legacy4J.createModLocation("icon/add_user"), ADD_ACCOUNT, b -> minecraft.m_91152_((Screen)ChooseUserScreen.accountScreen(ADD_ACCOUNT, this, true, a -> {
            MCAccount.list.add((MCAccount)a);
            MCAccount.saveAll();
            this.reloadAccountButtons();
            minecraft.m_91152_((Screen)this);
        })));
        for (final MCAccount account : MCAccount.list) {
            this.renderableVList.addRenderable((Renderable)new AbstractButton(0, 0, 230, 30, (Component)(account.getMSARefreshToken(null).isEmpty() ? Component.m_237110_((String)"legacy.menu.offline_user", (Object[])new Object[]{account.getProfile().getName()}) : Component.m_237113_((String)account.getProfile().getName()))){

                protected void m_87963_(GuiGraphics guiGraphics, int i, int j, float f) {
                    super.m_87963_(guiGraphics, i, j, f);
                    PlayerFaceRenderer.m_280354_((GuiGraphics)guiGraphics, (ResourceLocation)minecraft.m_91109_().m_240306_(account.getProfile()), (int)(this.m_252754_() + 5), (int)(this.m_252907_() + 5), (int)20);
                    if (((Boolean)minecraft.f_91066_.m_231828_().m_231551_()).booleanValue() || this.m_274382_()) {
                        guiGraphics.m_280509_(this.m_252754_() + 5, this.m_252907_() + 5, this.m_252754_() + 25, this.m_252907_() + 25, -1601138544);
                        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(ScreenUtil.isMouseOver(i, j, this.m_252754_() + 5, this.m_252907_() + 5, 20, 20) ? SaveRenderableList.JOIN_HIGHLIGHTED : SaveRenderableList.JOIN, this.m_252754_() + 5, this.m_252907_() + 5, 20, 20);
                    }
                }

                protected void m_280372_(GuiGraphics guiGraphics, Font font, int i, int j) {
                    ScreenUtil.renderScrollingString(guiGraphics, font, this.m_6035_(), this.m_252754_() + 30, this.m_252907_(), this.m_252754_() + this.m_5711_() - 2, this.m_252907_() + this.m_93694_(), j, true);
                }

                public boolean m_6375_(double d, double e, int i) {
                    if (ScreenUtil.isMouseOver(d, e, this.m_252754_() + 5, this.m_252907_() + 5, 20, 20)) {
                        ChooseUserScreen.this.manageLogin(account);
                    }
                    return super.m_6375_(d, e, i);
                }

                public boolean m_7933_(int i, int j, int k) {
                    if (i == 79) {
                        minecraft.m_91152_((Screen)new ConfirmationScreen(ChooseUserScreen.this, 230, 120, ACCOUNT_OPTIONS, ACCOUNT_OPTIONS_MESSAGE, b -> {}){

                            @Override
                            protected void addButtons() {
                                this.renderableVList.addRenderable((Renderable)Button.m_253074_((Component)CommonComponents.f_130656_, b -> this.m_7379_()).m_253136_());
                                this.renderableVList.addRenderable((Renderable)Button.m_253074_((Component)EDIT_ACCOUNT, b -> this.f_96541_.m_91152_((Screen)ChooseUserScreen.accountScreen(EDIT_ACCOUNT, this, true, a -> {
                                    MCAccount.list.set(MCAccount.list.indexOf(account), (MCAccount)a);
                                    MCAccount.saveAll();
                                    ChooseUserScreen.this.reloadAccountButtons();
                                    this.f_96541_.m_91152_((Screen)ChooseUserScreen.this);
                                }))).m_253136_());
                                this.renderableVList.addRenderable((Renderable)Button.m_253074_((Component)DELETE_ACCOUNT, b -> {
                                    MCAccount.list.remove(account);
                                    MCAccount.saveAll();
                                    ChooseUserScreen.this.reloadAccountButtons();
                                    this.f_96541_.m_91152_((Screen)ChooseUserScreen.this);
                                }).m_253136_());
                            }
                        });
                        return true;
                    }
                    return super.m_7933_(i, j, k);
                }

                public void m_5691_() {
                    if (this.m_93696_()) {
                        ChooseUserScreen.this.manageLogin(account);
                    }
                }

                protected void m_168797_(NarrationElementOutput narrationElementOutput) {
                    this.m_168802_(narrationElementOutput);
                }
            });
        }
    }
}

