/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;
import wily.factoryapi.base.Stocker;
import wily.legacy.client.ControlType;
import wily.legacy.client.LegacyTipManager;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyIconHolder;
import wily.legacy.client.screen.LegacyMenuAccess;
import wily.legacy.client.screen.LegacyScroller;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PanelBackgroundScreen;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.ScreenUtil;

public class ItemViewerScreen
extends PanelBackgroundScreen
implements LegacyMenuAccess<AbstractContainerMenu> {
    public static final Container layerSelectionGrid = new SimpleContainer(50);
    public final List<ItemStack> layerItems = new ArrayList<ItemStack>();
    protected final Stocker.Sizeable scrolledList = new Stocker.Sizeable(Integer.valueOf(0));
    protected final AbstractContainerMenu menu;
    protected Slot hoveredSlot = null;
    protected final LegacyScroller scroller = LegacyScroller.create(135, () -> this.scrolledList);

    public ItemViewerScreen(Screen parent, Function<Screen, Panel> panelConstructor, Component component) {
        super(parent, panelConstructor, component);
        this.menu = new AbstractContainerMenu(null, -1){

            public ItemStack m_7648_(Player player, int i) {
                return null;
            }

            public boolean m_6875_(Player player) {
                return false;
            }
        };
        for (int i = 0; i < layerSelectionGrid.m_6643_(); ++i) {
            this.menu.f_38839_.add((Object)LegacySlotDisplay.override(new Slot(layerSelectionGrid, i, 23 + i % 10 * 27, 24 + i / 10 * 27), new LegacySlotDisplay(){

                @Override
                public int getWidth() {
                    return 27;
                }

                @Override
                public int getHeight() {
                    return 27;
                }
            }));
        }
        this.addLayerItems();
        this.scrolledList.max = Math.max(0, (this.layerItems.size() - 1) / layerSelectionGrid.m_6643_());
    }

    protected void addLayerItems() {
        BuiltInRegistries.f_257033_.forEach(i -> {
            if (i != Items.f_41852_) {
                this.layerItems.add(i.m_7968_());
            }
        });
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        ControlTooltip.setupDefaultScreen(renderer, this).add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(87) : ControllerBinding.RIGHT_TRIGGER.getIcon(), () -> this.getHoveredSlot() != null && this.getHoveredSlot().m_6657_() && LegacyTipManager.hasTip(this.getHoveredSlot().m_7993_()) ? LegacyComponents.WHATS_THIS : null);
    }

    @Override
    protected void m_7856_() {
        this.panel.init();
        this.scroller.m_264152_(this.panel.x + 299, this.panel.y + 23);
        this.scroller.offset(new Vec3(0.5, 0.0, 0.0));
        this.fillLayerGrid();
    }

    public void fillLayerGrid() {
        for (int i = 0; i < layerSelectionGrid.m_6643_(); ++i) {
            int index = (Integer)this.scrolledList.get() * 50 + i;
            layerSelectionGrid.m_6836_(i, this.layerItems.size() > index ? this.layerItems.get(index) : ItemStack.f_41583_);
        }
    }

    public boolean m_6050_(double d, double e, double g) {
        if (this.scroller.mouseScrolled(g)) {
            this.fillLayerGrid();
        }
        return super.m_6050_(d, e, g);
    }

    public boolean m_6375_(double d, double e, int i) {
        if (this.scroller.mouseClicked(d, e, i)) {
            this.fillLayerGrid();
        }
        if (this.hoveredSlot != null) {
            this.slotClicked(this.hoveredSlot);
        }
        return super.m_6375_(d, e, i);
    }

    public boolean m_6348_(double d, double e, int i) {
        this.scroller.mouseReleased(d, e, i);
        return super.m_6348_(d, e, i);
    }

    public boolean m_7933_(int i, int j, int k) {
        if (i == 87 && this.hoveredSlot != null && this.hoveredSlot.m_6657_() && LegacyTipManager.setTip(LegacyTipManager.getTip(this.hoveredSlot.m_7993_().m_41777_()))) {
            ScreenUtil.playSimpleUISound((SoundEvent)SoundEvents.f_12490_.m_203334_(), 1.0f);
            return true;
        }
        return super.m_7933_(i, j, k);
    }

    protected void slotClicked(Slot slot) {
    }

    public boolean m_7979_(double d, double e, int i, double f, double g) {
        if (this.scroller.mouseDragged(e)) {
            this.fillLayerGrid();
        }
        return super.m_7979_(d, e, i, f, g);
    }

    public void setHoveredSlot(Slot hoveredSlot) {
        this.hoveredSlot = hoveredSlot;
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int i, int j, float f) {
        super.m_88315_(guiGraphics, i, j, f);
        this.setHoveredSlot(null);
        this.menu.f_38839_.forEach(s -> {
            LegacyIconHolder holder = ScreenUtil.iconHolderRenderer.slotBoundsWithItem(this.panel.x, this.panel.y, (Slot)s);
            holder.m_88315_(guiGraphics, i, j, f);
            if (holder.isHovered) {
                if (s.m_280329_()) {
                    holder.renderHighlight(guiGraphics);
                }
                this.setHoveredSlot((Slot)s);
            }
        });
        if (this.hoveredSlot != null && !this.hoveredSlot.m_7993_().m_41619_()) {
            guiGraphics.m_280153_(this.f_96547_, this.hoveredSlot.m_7993_(), i, j);
        }
    }

    @Override
    public void renderDefaultBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        ScreenUtil.renderDefaultBackground(this.accessor, guiGraphics, false);
        this.panel.m_88315_(guiGraphics, i, j, f);
        this.renderScroll(guiGraphics, i, j, f);
    }

    protected void renderScroll(GuiGraphics guiGraphics, int i, int j, float f) {
        this.scroller.m_88315_(guiGraphics, i, j, f);
    }

    public AbstractContainerMenu m_6262_() {
        return this.menu;
    }

    @Override
    public ScreenRectangle getMenuRectangle() {
        return new ScreenRectangle(this.panel.x, this.panel.y, this.panel.width, this.panel.height);
    }

    @Override
    public boolean isOutsideClick(int i) {
        return false;
    }

    @Override
    public Slot getHoveredSlot() {
        return this.hoveredSlot;
    }

    @Override
    public int getTipXDiff() {
        return 0;
    }
}

