/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.worldselection.WorldCreationUiState;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.flat.FlatLayerInfo;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorPreset;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.legacy.Legacy4J;
import wily.legacy.client.ControlType;
import wily.legacy.client.LegacyBiomeOverride;
import wily.legacy.client.LegacyTipManager;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.FlatWorldLayerSelector;
import wily.legacy.client.screen.LegacyFlatPresetsScreen;
import wily.legacy.client.screen.LegacyTabButton;
import wily.legacy.client.screen.MultilineTooltip;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PanelVListScreen;
import wily.legacy.client.screen.RenderableVList;
import wily.legacy.client.screen.TabList;
import wily.legacy.client.screen.TickBox;
import wily.legacy.client.screen.WorldMoreOptionsScreen;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public class LegacyFlatWorldScreen
extends PanelVListScreen
implements ControlTooltip.Event {
    public final int maxOverworldHeight;
    protected List<FormattedCharSequence> tooltipBoxLabel;
    private final Consumer<FlatLevelGeneratorSettings> applySettings;
    protected final WorldCreationUiState uiState;
    FlatLevelGeneratorSettings generator;
    protected final TabList tabList;
    protected final RenderableVList displayLayers;
    protected final RenderableVList displayBiomes;
    protected final RenderableVList displayProperties;
    protected final List<Holder<StructureSet>> structuresOverrides;
    protected LayerButton movingLayer;

    public LegacyFlatWorldScreen(Screen screen, WorldCreationUiState uiState, HolderLookup.RegistryLookup<Biome> biomeGetter, HolderLookup.RegistryLookup<StructureSet> structureGetter, Consumer<FlatLevelGeneratorSettings> consumer, FlatLevelGeneratorSettings flatLevelGeneratorSettings) {
        super((Screen s) -> Panel.createPanel(s, p -> p.appearance(282, Math.min(s.f_96544_ - 48, 248)), p -> p.pos((s.f_96543_ - (p.width + (ScreenUtil.hasTooltipBoxes(UIAccessor.of((Screen)s)) ? 194 : 0))) / 2, p.centeredTopPos((Screen)s))), (Component)Component.m_237115_((String)"createWorld.customize.flat.title"));
        Screen screen2;
        this.tabList = new TabList(this.accessor).add(30, LegacyTabButton.Type.LEFT, (Component)Component.m_237115_((String)"legacy.menu.create_flat_world.layers"), b -> this.m_232761_()).add(30, LegacyTabButton.Type.MIDDLE, (Component)Component.m_237115_((String)"legacy.menu.create_flat_world.biomes"), b -> this.m_232761_()).add(30, LegacyTabButton.Type.RIGHT, (Component)Component.m_237115_((String)"legacy.menu.create_flat_world.properties"), b -> this.m_232761_());
        this.displayLayers = new RenderableVList(this.accessor).layoutSpacing(l -> 0);
        this.displayBiomes = new RenderableVList(this.accessor).layoutSpacing(l -> 0);
        this.displayProperties = new RenderableVList(this.accessor);
        Screen screen3 = Minecraft.m_91087_().f_91080_;
        if (screen3 instanceof WorldMoreOptionsScreen) {
            WorldMoreOptionsScreen s2 = (WorldMoreOptionsScreen)screen3;
            screen2 = s2;
        } else {
            screen2 = screen;
        }
        this.parent = screen2;
        this.uiState = uiState;
        this.applySettings = consumer;
        this.generator = flatLevelGeneratorSettings;
        this.maxOverworldHeight = uiState.m_267573_().m_246480_().m_255025_(Registries.f_256787_).m_254902_(BuiltinDimensionTypes.f_223538_).map(l -> ((DimensionType)l.m_203334_()).f_156648_()).orElse(384);
        this.structuresOverrides = new ArrayList(((HolderSet)this.generator.m_209810_().orElse(HolderSet.m_205809_((Holder[])new Holder[0]))).m_203614_().toList());
        this.generator.m_70401_().forEach(this::addLayer);
        biomeGetter.m_214062_().forEach(this::addBiome);
        structureGetter.m_214062_().forEach(this::addStructure);
        this.renderableVLists.clear();
        this.renderableVLists.add(this.displayLayers);
        this.renderableVLists.add(this.displayBiomes);
        this.renderableVLists.add(this.displayProperties);
        this.displayProperties.addRenderable((Renderable)new TickBox(0, 0, 260, 12, this.generator.f_70356_, b -> LegacyComponents.DECORATIONS, b -> null, b -> {
            this.generator.f_70356_ = b.selected;
        }));
        this.displayProperties.addRenderable((Renderable)new TickBox(0, 0, 260, 12, this.generator.f_70357_, b -> LegacyComponents.LAVA_LAKES, b -> null, b -> {
            this.generator.f_70357_ = b.selected;
        }));
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        super.addControlTooltips(renderer);
        renderer.add(() -> this.movingLayer != null || this.tabList.selectedTab != 0 || this.m_7222_() == null ? null : (ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(88) : ControllerBinding.LEFT_BUTTON.getIcon()), () -> LegacyComponents.MOVE_LAYER).add(() -> this.movingLayer != null ? null : (ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(79) : ControllerBinding.UP_BUTTON.getIcon()), () -> LegacyComponents.PRESETS).addCompound(() -> new ControlTooltip.Icon[]{ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(91) : ControllerBinding.LEFT_BUMPER.getIcon(), ControlTooltip.SPACE_ICON, ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(93) : ControllerBinding.RIGHT_BUMPER.getIcon()}, () -> this.movingLayer != null ? null : LegacyComponents.SELECT_TAB).add(() -> this.movingLayer == null ? null : (ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(266) : ControllerBinding.LEFT_TRIGGER.getIcon()), () -> LegacyComponents.PAGE_UP).add(() -> this.movingLayer == null ? null : (ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(267) : ControllerBinding.RIGHT_TRIGGER.getIcon()), () -> LegacyComponents.PAGE_DOWN).addCompound(() -> {
            ControlTooltip.Icon[] iconArray;
            if (ControlType.getActiveType().isKbm()) {
                ControlTooltip.Icon[] iconArray2 = new ControlTooltip.Icon[3];
                iconArray2[0] = ControlTooltip.getKeyIcon(265);
                iconArray2[1] = ControlTooltip.SPACE_ICON;
                iconArray = iconArray2;
                iconArray2[2] = ControlTooltip.getKeyIcon(264);
            } else {
                ControlTooltip.Icon[] iconArray3 = new ControlTooltip.Icon[1];
                iconArray = iconArray3;
                iconArray3[0] = ControllerBinding.LEFT_STICK.getIcon();
            }
            return iconArray;
        }, () -> this.movingLayer == null ? null : LegacyComponents.MOVE_UP_DOWN);
    }

    public void addStructure(Holder.Reference<StructureSet> structure) {
        ArrayList<Component> descr = new ArrayList<Component>();
        String nameKey = "structure." + structure.m_205785_().m_135782_().m_214298_();
        String descriptionKey = nameKey + ".description";
        if (LegacyTipManager.hasTip(nameKey)) {
            descr.add((Component)Component.m_237115_((String)nameKey));
        }
        if (LegacyTipManager.hasTip(descriptionKey)) {
            descr.add(ControlTooltip.SPACE);
            descr.add((Component)Component.m_237115_((String)descriptionKey));
        }
        MultilineTooltip t = descr.isEmpty() ? null : new MultilineTooltip(descr, 182);
        this.displayProperties.addRenderable((Renderable)new TickBox(0, 0, 260, 12, this.structuresOverrides.contains(structure), b -> descr.isEmpty() ? Component.m_237115_((String)nameKey) : (Component)descr.get(0), b -> t, b -> {
            if (b.selected) {
                this.structuresOverrides.add((Holder<StructureSet>)structure);
            } else {
                this.structuresOverrides.remove(structure);
            }
        }));
    }

    public void addBiome(final Holder.Reference<Biome> biome) {
        AbstractButton b = new AbstractButton(0, 0, 260, 30, (Component)Component.m_237115_((String)("biome." + biome.m_205785_().m_135782_().m_214298_()))){

            public void m_5691_() {
                LegacyFlatWorldScreen.this.generator.f_70353_ = biome;
            }

            protected void m_87963_(GuiGraphics guiGraphics, int i, int j, float f) {
                super.m_87963_(guiGraphics, i, j, f);
                ItemStack s = LegacyBiomeOverride.getOrDefault(biome.m_203543_()).icon();
                if (!s.m_41619_()) {
                    guiGraphics.m_280168_().m_85836_();
                    guiGraphics.m_280168_().m_252880_((float)(this.m_252754_() + 26), (float)(this.m_252907_() + 5), 0.0f);
                    guiGraphics.m_280168_().m_85841_(1.25f, 1.25f, 1.25f);
                    guiGraphics.m_280480_(s, 0, 0);
                    guiGraphics.m_280168_().m_85849_();
                }
                FactoryScreenUtil.enableBlend();
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(TickBox.SPRITES[this.m_198029_() ? 1 : 0], this.m_252754_() + 6, this.m_252907_() + (this.f_93619_ - 12) / 2, 12, 12);
                if (LegacyFlatWorldScreen.this.generator.f_70353_ == biome) {
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(TickBox.TICK, this.m_252754_() + 6, this.m_252907_() + (this.f_93619_ - 12) / 2, 14, 12);
                }
                FactoryScreenUtil.disableBlend();
            }

            protected void m_280372_(GuiGraphics guiGraphics, Font font, int i, int j) {
                int k = this.m_252754_() + 54;
                int l = this.m_252754_() + this.m_5711_();
                ScreenUtil.renderScrollingString(guiGraphics, font, this.m_6035_(), k, this.m_252907_(), l, this.m_252907_() + this.m_93694_(), j, true);
            }

            protected void m_168797_(NarrationElementOutput narrationElementOutput) {
                this.m_168802_(narrationElementOutput);
            }
        };
        this.displayBiomes.addRenderable((Renderable)b);
        ArrayList<Component> descr = new ArrayList<Component>();
        descr.add(b.m_6035_());
        String descriptionKey = "biome." + biome.m_205785_().m_135782_().m_214298_() + ".description";
        if (LegacyTipManager.hasTip(descriptionKey)) {
            descr.add(ControlTooltip.SPACE);
            descr.add((Component)Component.m_237115_((String)descriptionKey));
        }
        b.m_257544_((Tooltip)new MultilineTooltip(descr, 182));
    }

    public void addLayer(FlatLayerInfo flatLayerInfo) {
        this.addLayer(flatLayerInfo, 0);
    }

    public void addLayer(FlatLayerInfo flatLayerInfo, int index) {
        this.displayLayers.renderables.add(index, (Renderable)new LayerButton(0, 0, 270, 30, flatLayerInfo));
    }

    public int getAllLayersHeight() {
        int height = 0;
        for (Renderable renderable : this.displayLayers.renderables) {
            if (!(renderable instanceof LayerButton)) continue;
            LayerButton layerButton = (LayerButton)renderable;
            height += layerButton.flatLayerInfo.m_70337_();
        }
        return height;
    }

    public void removeLayer(int index) {
        this.displayLayers.renderables.remove(index);
    }

    public void switchLayers(AbstractButton selected, AbstractButton aimPlace) {
        int selectedIndex = this.displayLayers.renderables.indexOf(selected);
        int aimIndex = this.displayLayers.renderables.indexOf(aimPlace);
        this.displayLayers.renderables.set(aimIndex, (Renderable)selected);
        this.displayLayers.renderables.set(selectedIndex, (Renderable)aimPlace);
        this.m_267719_();
        ScreenUtil.playSimpleUISound((SoundEvent)SoundEvents.f_12490_.m_203334_(), 1.0f);
    }

    public void m_262791_(Tooltip tooltip, ClientTooltipPositioner clientTooltipPositioner, boolean bl) {
        if (ScreenUtil.hasTooltipBoxes(this.accessor)) {
            this.tooltipBoxLabel = tooltip.m_257408_(this.f_96541_);
        } else {
            super.m_262791_(tooltip, clientTooltipPositioner, bl);
        }
    }

    public FlatLevelGeneratorSettings settings() {
        return this.generator;
    }

    public void setPreset(FlatLevelGeneratorSettings flatLevelGeneratorSettings) {
        this.generator = flatLevelGeneratorSettings;
        this.displayLayers.renderables.clear();
        this.generator.m_70401_().forEach(this::addLayer);
    }

    @Override
    public void renderDefaultBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        ScreenUtil.renderDefaultBackground(this.accessor, guiGraphics, false);
    }

    @Override
    protected void m_7856_() {
        if (this.movingLayer != null && this.tabList.selectedTab != 0) {
            this.tabList.selectedTab = 0;
        }
        this.m_169394_((guiGraphics, i, j, f) -> {
            if (ScreenUtil.hasTooltipBoxes(this.accessor)) {
                AbstractWidget w;
                GuiEventListener patt0$temp;
                if (this.tooltipBoxLabel != null && this.m_94729_(i, j).map(g -> {
                    Tooltip tooltip;
                    if (g instanceof AbstractWidget) {
                        AbstractWidget w = (AbstractWidget)g;
                        tooltip = w.m_278622_();
                    } else {
                        tooltip = null;
                    }
                    return tooltip;
                }).isEmpty() && (!((patt0$temp = this.m_7222_()) instanceof AbstractWidget) || (w = (AbstractWidget)patt0$temp).m_278622_() == null)) {
                    this.tooltipBoxLabel = null;
                }
                ScreenUtil.renderPointerPanel(guiGraphics, this.panel.x + this.panel.width - 2, this.panel.y + 5, 194, this.panel.height - 10);
                if (this.tooltipBoxLabel != null) {
                    this.tooltipBoxLabel.forEach(c -> guiGraphics.m_280648_(this.f_96547_, c, this.panel.x + this.panel.width + 3, this.panel.y + 13 + 12 * this.tooltipBoxLabel.indexOf(c), 0xFFFFFF));
                }
            }
        });
        this.m_142416_(this.tabList);
        super.m_7856_();
        this.tabList.init(this.panel.x, this.panel.y - 24, this.panel.width);
        this.generator.m_70403_();
    }

    @Override
    protected void panelInit() {
        super.panelInit();
        this.m_169394_((guiGraphics, i, j, f) -> FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.PANEL_RECESS, this.panel.x + 7, this.panel.y + 7, this.panel.width - 14, this.panel.height - 14));
    }

    @Override
    public void renderableVListInit() {
        this.getRenderableVList().init(this.panel.x + 11, this.panel.y + 11, 260, this.panel.height - 22);
    }

    @Override
    public RenderableVList getRenderableVList() {
        return this.getRenderableVLists().get(this.tabList.selectedTab);
    }

    @Override
    public boolean m_6050_(double d, double e, double g) {
        this.getRenderableVList().mouseScrolled(g);
        return super.m_6050_(d, e, g);
    }

    public void m_7522_(@Nullable GuiEventListener guiEventListener) {
        AbstractButton b2;
        GuiEventListener guiEventListener2;
        super.m_7522_(guiEventListener);
        if (this.movingLayer != null && (guiEventListener2 = this.m_7222_()) instanceof AbstractButton && this.displayLayers.renderables.contains(b2 = (AbstractButton)guiEventListener2) && this.m_7222_() != this.movingLayer) {
            super.m_7522_((GuiEventListener)this.movingLayer);
            this.switchLayers(this.movingLayer, b2);
        }
    }

    @Override
    public boolean m_7933_(int i, int j, int k) {
        if (this.movingLayer == null) {
            if (this.tabList.controlTab(i)) {
                return true;
            }
            if (i == 79) {
                this.f_96541_.m_91152_((Screen)new LegacyFlatPresetsScreen((Screen)this, (HolderLookup.RegistryLookup<FlatLevelGeneratorPreset>)this.uiState.m_267573_().m_246480_().m_255025_(Registries.f_256724_), this.uiState.m_267573_().f_243842_().f_243973_(), f -> this.setPreset(((FlatLevelGeneratorPreset)f.m_203334_()).f_226246_())));
            }
        }
        return super.m_7933_(i, j, k);
    }

    @Override
    public void m_7379_() {
        super.m_7379_();
        this.generator.m_70401_().clear();
        this.displayLayers.renderables.forEach(r -> {
            if (r instanceof LayerButton) {
                LayerButton l = (LayerButton)r;
                this.generator.m_70401_().add(0, l.flatLayerInfo);
            }
        });
        this.generator.m_70403_();
        this.applySettings.accept(this.generator);
        this.generator.f_209788_ = Optional.of(HolderSet.m_205800_(this.structuresOverrides));
    }

    public class LayerButton
    extends AbstractButton
    implements ControlTooltip.ActionHolder {
        public final FlatLayerInfo flatLayerInfo;

        public LayerButton(int i, int j, int k, int l, FlatLayerInfo flatLayerInfo) {
            super(i, j, k, l, (Component)flatLayerInfo.m_70344_().m_60734_().m_49954_());
            this.flatLayerInfo = flatLayerInfo;
            ItemStack s = flatLayerInfo.m_70344_().m_60734_().m_5456_().m_7968_();
            ArrayList<Component> descr = new ArrayList<Component>();
            descr.add(this.m_6035_());
            if (LegacyTipManager.hasTip(s)) {
                descr.add(ControlTooltip.SPACE);
                descr.add(LegacyTipManager.getTipComponent(s));
            }
            this.m_257544_(new MultilineTooltip(descr, 182));
        }

        protected void m_87963_(GuiGraphics guiGraphics, int i, int j, float f) {
            super.m_87963_(guiGraphics, i, j, f);
            Font font = LegacyFlatWorldScreen.this.f_96547_;
            MutableComponent mutableComponent = Component.m_237110_((String)"legacy.menu.create_flat_world.layer_count", (Object[])new Object[]{this.flatLayerInfo.m_70337_()});
            int n = this.m_252754_() + 12;
            int n2 = this.m_252907_() + 1;
            Objects.requireNonNull(LegacyFlatWorldScreen.this.f_96547_);
            guiGraphics.m_280430_(font, (Component)mutableComponent, n, n2 + (this.f_93619_ - 9) / 2, 0xFFFFFF);
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)(this.m_252754_() + 39), (float)(this.m_252907_() + 5), 0.0f);
            guiGraphics.m_280168_().m_85841_(1.25f, 1.25f, 1.25f);
            guiGraphics.m_280480_(this.flatLayerInfo.m_70344_().m_60734_().m_5456_().m_7968_(), 0, 0);
            guiGraphics.m_280168_().m_85849_();
        }

        protected void m_280372_(GuiGraphics guiGraphics, Font font, int i, int j) {
            int k = this.m_252754_() + 67;
            int l = this.m_252754_() + this.m_5711_();
            ScreenUtil.renderScrollingString(guiGraphics, font, this.m_6035_(), k, this.m_252907_(), l, this.m_252907_() + this.m_93694_(), j, true);
        }

        public void m_93692_(boolean bl) {
            if (bl && LegacyFlatWorldScreen.this.movingLayer != null && LegacyFlatWorldScreen.this.movingLayer != this) {
                return;
            }
            super.m_93692_(bl);
        }

        public boolean m_7933_(int i, int j, int k) {
            if (i == 88) {
                LegacyFlatWorldScreen.this.movingLayer = this;
                return true;
            }
            return super.m_7933_(i, j, k);
        }

        public void m_5691_() {
            if (LegacyFlatWorldScreen.this.movingLayer != null) {
                if (this.m_93696_()) {
                    LegacyFlatWorldScreen.this.movingLayer = null;
                }
                return;
            }
            final int allHeight = LegacyFlatWorldScreen.this.getAllLayersHeight();
            Legacy4J.LOGGER.warn((Object)allHeight);
            final int layerIndex = LegacyFlatWorldScreen.this.displayLayers.renderables.indexOf(this);
            LegacyFlatWorldScreen.this.f_96541_.m_91152_((Screen)new ConfirmationScreen(LegacyFlatWorldScreen.this, 230, 120, LegacyComponents.LAYER_OPTIONS, LegacyComponents.LAYER_MESSAGE, b -> {}){

                @Override
                protected void addButtons() {
                    this.renderableVList.addRenderable((Renderable)Button.m_253074_((Component)Component.m_237115_((String)"legacy.menu.create_flat_world.edit_layer"), b -> this.f_96541_.m_91152_((Screen)new FlatWorldLayerSelector(LegacyFlatWorldScreen.this, LayerButton.this.flatLayerInfo, f -> {
                        LegacyFlatWorldScreen.this.removeLayer(layerIndex);
                        LegacyFlatWorldScreen.this.addLayer(f.getFlatLayerInfo(), layerIndex);
                    }, LegacyFlatWorldScreen.this.maxOverworldHeight - allHeight + LayerButton.this.flatLayerInfo.m_70337_(), (Component)Component.m_237115_((String)"legacy.menu.create_flat_world.edit_layer")))).m_252987_(this.panel.x + 15, this.panel.y + this.panel.height - 74, 200, 20).m_253136_());
                    Button addButton = Button.m_253074_((Component)Component.m_237115_((String)"legacy.menu.create_flat_world.add_layer"), b -> this.f_96541_.m_91152_((Screen)new FlatWorldLayerSelector((Screen)LegacyFlatWorldScreen.this, f -> LegacyFlatWorldScreen.this.addLayer(f.getFlatLayerInfo(), layerIndex), LegacyFlatWorldScreen.this.maxOverworldHeight - allHeight, (Component)Component.m_237115_((String)"legacy.menu.create_flat_world.add_layer")))).m_252987_(this.panel.x + 15, this.panel.y + this.panel.height - 52, 200, 20).m_253136_();
                    if (allHeight >= LegacyFlatWorldScreen.this.maxOverworldHeight) {
                        addButton.f_93623_ = false;
                    }
                    this.renderableVList.addRenderable((Renderable)addButton);
                    this.renderableVList.addRenderable((Renderable)Button.m_253074_((Component)Component.m_237115_((String)"legacy.menu.create_flat_world.delete_layer"), b -> {
                        LegacyFlatWorldScreen.this.removeLayer(layerIndex);
                        this.m_7379_();
                    }).m_252987_(this.panel.x + 15, this.panel.y + this.panel.height - 30, 200, 20).m_253136_());
                }
            });
        }

        protected void m_168797_(NarrationElementOutput narrationElementOutput) {
            this.m_168802_(narrationElementOutput);
        }

        @Override
        @Nullable
        public Component getAction(ControlTooltip.ActionHolder.Context context) {
            return context.actionOfContext(ControlTooltip.ActionHolder.KeyContext.class, c -> c.key() == 257 ? (LegacyFlatWorldScreen.this.movingLayer != null ? LegacyComponents.PLACE : LegacyComponents.LAYER_OPTIONS) : null);
        }
    }
}

