/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.world.phys.Vec3;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.SimpleLayoutRenderable;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public abstract class LegacyScroller
extends SimpleLayoutRenderable {
    public final LegacyScrollRenderer scrollRenderer;
    public Vec3 offset = Vec3.f_82478_;
    public boolean dragged = false;

    public LegacyScroller(LegacyScrollRenderer scrollRenderer) {
        this.scrollRenderer = scrollRenderer;
    }

    public static LegacyScroller create(int height, Supplier<Stocker.Sizeable> scrollSupplier) {
        return LegacyScroller.create(13, height, scrollSupplier);
    }

    public static LegacyScroller create(int width, int height, final Supplier<Stocker.Sizeable> scrollSupplier) {
        LegacyScroller scroller = new LegacyScroller(new LegacyScrollRenderer()){

            @Override
            public Stocker.Sizeable getScroll() {
                return (Stocker.Sizeable)scrollSupplier.get();
            }
        };
        scroller.size(width, height);
        return scroller;
    }

    public float getScrollerHeight() {
        return (float)this.m_93694_() - 13.5f;
    }

    public void offset(Vec3 offset) {
        this.offset = offset;
    }

    public abstract Stocker.Sizeable getScroll();

    public void m_88315_(GuiGraphics guiGraphics, int i, int j, float f) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85837_((double)this.m_252754_() + this.offset.f_82479_, (double)this.m_252907_() + this.offset.f_82480_, this.offset.f_82481_);
        Stocker.Sizeable scroll = this.getScroll();
        if (scroll.max > 0) {
            if ((Integer)scroll.get() != scroll.max) {
                this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.DOWN, 0, this.m_93694_() + 4);
            }
            if ((Integer)scroll.get() > 0) {
                this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.UP, 0, -11);
            }
        } else {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setColor(1.0f, 1.0f, 1.0f, 0.5f, true);
        }
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, 0, 0, this.width, this.height);
        guiGraphics.m_280168_().m_252880_(-2.0f, -1.0f + (scroll.max > 0 ? (float)((Integer)scroll.get()).intValue() * this.getScrollerHeight() / (float)scroll.max : 0.0f), 0.0f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.PANEL, 0, 0, 16, 16);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).clearColor(true);
        guiGraphics.m_280168_().m_85849_();
    }

    public boolean isHovered(double mouseX, double mouseY) {
        return ScreenUtil.isMouseOver(mouseX, mouseY, (double)this.m_252754_() + this.offset.f_82479_, (double)this.m_252907_() + this.offset.f_82480_, this.m_5711_(), this.m_93694_());
    }

    public boolean mouseScrolled(double g) {
        int i = (int)(-Math.signum(g));
        Stocker.Sizeable scroll = this.getScroll();
        if (scroll.max > 0 || (Integer)scroll.get() > 0) {
            int lastScrolled = (Integer)scroll.get();
            scroll.set(Integer.valueOf(Math.max(0, Math.min((Integer)scroll.get() + i, scroll.max))));
            if (lastScrolled != (Integer)scroll.get()) {
                this.scrollRenderer.updateScroll(i > 0 ? ScreenDirection.DOWN : ScreenDirection.UP);
                return true;
            }
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isHovered(mouseX, mouseY)) {
            this.dragged = true;
            return this.mouseDragged(mouseY);
        }
        return false;
    }

    public void mouseReleased(double mouseX, double mouseY, int button) {
        if (this.dragged) {
            this.dragged = false;
        }
    }

    public boolean mouseDragged(double mouseY) {
        if (this.dragged) {
            Stocker.Sizeable scrolledList = this.getScroll();
            int lastScroll = (Integer)scrolledList.get();
            scrolledList.set(Integer.valueOf((int)Math.round((double)scrolledList.max * (mouseY - (double)this.y) / (double)this.m_93694_())));
            if (lastScroll != (Integer)scrolledList.get()) {
                this.scrollRenderer.updateScroll((Integer)scrolledList.get() - lastScroll > 0 ? ScreenDirection.DOWN : ScreenDirection.UP);
                return true;
            }
        }
        return false;
    }
}

