/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Unique;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.base.network.CommonRecipeManager;
import wily.legacy.client.CommonColor;
import wily.legacy.client.RecipeInfo;
import wily.legacy.client.StoneCuttingGroupManager;
import wily.legacy.client.controller.Controller;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyCraftingScreen;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.client.screen.RecipeIconHolder;
import wily.legacy.inventory.LegacyCraftingMenu;
import wily.legacy.inventory.RecipeMenu;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public class LegacyStonecutterScreen
extends AbstractContainerScreen<LegacyCraftingMenu>
implements Controller.Event,
ControlTooltip.Event {
    public static final Vec3 DISPLAY_OFFSET = new Vec3(0.5, 0.0, 0.0);
    protected List<RecipeIconHolder<StonecutterRecipe>> craftingButtons = new ArrayList<RecipeIconHolder<StonecutterRecipe>>();
    protected List<List<RecipeInfo<StonecutterRecipe>>> recipesByGroup = new ArrayList<List<RecipeInfo<StonecutterRecipe>>>();
    protected List<List<RecipeInfo<StonecutterRecipe>>> filteredRecipesByGroup = Collections.emptyList();
    protected Stocker.Sizeable craftingButtonsOffset = new Stocker.Sizeable(Integer.valueOf(0));
    protected LegacyScrollRenderer scrollRenderer = new LegacyScrollRenderer();
    protected List<Optional<Ingredient>> ingredientSlot = Collections.singletonList(Optional.empty());
    protected int selectedCraftingButton = 0;
    private boolean onlyCraftableRecipes;
    protected final List<ItemStack> compactInventoryList = new ArrayList<ItemStack>();
    private final ContainerListener listener;
    protected final UIAccessor accessor = UIAccessor.of((Screen)this);

    public LegacyStonecutterScreen(LegacyCraftingMenu abstractContainerMenu, final Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
        List<RecipeInfo> allRecipes = CommonRecipeManager.byType((RecipeType)RecipeType.f_44112_).stream().map(h -> RecipeInfo.create(h.m_6423_(), h, LegacyCraftingMenu.getRecipeOptionalIngredients(h), h.m_5874_(null, Minecraft.m_91087_().f_91073_.m_9598_()))).toList();
        StoneCuttingGroupManager.listing.values().forEach(l -> {
            ArrayList group = new ArrayList();
            l.forEach(v -> v.addRecipes(allRecipes.stream().filter(h -> this.recipesByGroup.stream().noneMatch(r -> r.contains(h)))::iterator, group::add));
            if (!group.isEmpty()) {
                this.recipesByGroup.add(group);
            }
        });
        allRecipes.stream().filter(h -> this.recipesByGroup.stream().noneMatch(r -> r.contains(h))).forEach(h -> this.recipesByGroup.add(Collections.singletonList(h)));
        this.addCraftingButtons();
        this.onlyCraftableRecipes = true;
        this.listener = new ContainerListener(){

            public void m_7934_(AbstractContainerMenu abstractContainerMenu, int i, ItemStack itemStack) {
                if (LegacyStonecutterScreen.this.onlyCraftableRecipes) {
                    LegacyStonecutterScreen.this.filteredRecipesByGroup = LegacyStonecutterScreen.this.recipesByGroup.stream().map(l -> l.stream().filter(r -> RecipeMenu.canCraft(r.getOptionalIngredients(), inventory, abstractContainerMenu.m_142621_())).toList()).filter(l -> !l.isEmpty()).toList();
                    LegacyStonecutterScreen.this.craftingButtons.get(LegacyStonecutterScreen.this.selectedCraftingButton).updateRecipeDisplay();
                }
            }

            public void m_142153_(AbstractContainerMenu abstractContainerMenu, int i, int j) {
            }
        };
        this.listener.m_7934_(this.f_97732_, 0, ItemStack.f_41583_);
        this.onlyCraftableRecipes = false;
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        ControlTooltip.setupDefaultButtons(renderer, (Screen)this);
        ControlTooltip.Event.super.addControlTooltips(renderer);
        renderer.add(() -> ControlTooltip.OPTION.get(), () -> this.onlyCraftableRecipes ? LegacyComponents.ALL_RECIPES : LegacyComponents.SHOW_CRAFTABLE_RECIPES);
    }

    @Override
    public boolean disableCursorOnInit() {
        return true;
    }

    @Override
    public boolean onceClickBindings() {
        return false;
    }

    public void m_7856_() {
        this.f_97726_ = 348;
        this.f_97727_ = 215;
        super.m_7856_();
        ((LegacyCraftingMenu)this.f_97732_).m_38893_(this.listener);
        if (this.selectedCraftingButton < this.craftingButtons.size()) {
            this.m_7522_(this.craftingButtons.get(this.selectedCraftingButton));
        }
        this.craftingButtons.forEach(b -> {
            b.setPos(this.f_97735_ + 13 + this.craftingButtons.indexOf(b) * 27, this.f_97736_ + 38);
            this.m_142416_((GuiEventListener)b);
        });
        this.craftingButtonsOffset.max = Math.max(0, this.recipesByGroup.size() - 12);
    }

    public void m_280273_(GuiGraphics guiGraphics) {
    }

    public void m_280003_(GuiGraphics guiGraphics, int i, int j) {
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2, 17, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        guiGraphics.m_280614_(this.f_96547_, this.f_169604_, (515 - this.f_96547_.m_92852_((FormattedText)this.f_169604_)) / 2, 109, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
    }

    public void m_7286_(GuiGraphics guiGraphics, float f, int i, int j) {
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite((ResourceLocation)this.accessor.getElementValue("imageSprite", (Object)LegacySprites.SMALL_PANEL, ResourceLocation.class), this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.f_97735_ + 9, this.f_97736_ + 103, 163, 105);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.f_97735_ + 176, this.f_97736_ + 103, 163, 105);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.ARROW, this.f_97735_ + 79, this.f_97736_ + 158, 22, 15);
        if ((Integer)this.craftingButtonsOffset.get() > 0) {
            this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.LEFT, this.f_97735_ + 5, this.f_97736_ + 45);
        }
        if (this.craftingButtonsOffset.max > 0 && (Integer)this.craftingButtonsOffset.get() < this.craftingButtonsOffset.max) {
            this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.RIGHT, this.f_97735_ + 337, this.f_97736_ + 45);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int i, int j, float f) {
        super.m_88315_(guiGraphics, i, j, f);
        this.craftingButtons.get(this.selectedCraftingButton).renderSelection(guiGraphics, i, j, f);
        this.craftingButtons.forEach(h -> h.renderTooltip(this.f_96541_, guiGraphics, i, j));
        this.m_280072_(guiGraphics, i, j);
    }

    public boolean m_6050_(double d, double e, double g) {
        if (super.m_6050_(d, e, g)) {
            return true;
        }
        int scroll = (int)Math.signum(g);
        if (((Integer)this.craftingButtonsOffset.get() > 0 && scroll < 0 || scroll > 0 && this.craftingButtonsOffset.max > 0) && this.craftingButtonsOffset.add(scroll, false) != 0) {
            this.m_267719_();
            return true;
        }
        return false;
    }

    public void m_7861_() {
        super.m_7861_();
        ((LegacyCraftingMenu)this.f_97732_).m_38943_(this.listener);
    }

    @Unique
    protected void addCraftingButtons() {
        for (int i = 0; i < 12; ++i) {
            final int index = i;
            RecipeIconHolder<StonecutterRecipe> h = new RecipeIconHolder<StonecutterRecipe>(this.f_97735_ + 13 + i * 27, this.f_97736_ + 38){

                @Override
                public void m_88315_(GuiGraphics graphics, int i, int j, float f) {
                    if (this.m_93696_()) {
                        LegacyStonecutterScreen.this.selectedCraftingButton = index;
                    }
                    super.m_88315_(graphics, i, j, f);
                }

                @Override
                protected boolean canCraft(RecipeInfo<StonecutterRecipe> rcp) {
                    if (rcp == null || LegacyStonecutterScreen.this.onlyCraftableRecipes) {
                        return true;
                    }
                    LegacyStonecutterScreen.this.compactInventoryList.clear();
                    RecipeMenu.handleCompactInventoryList(LegacyStonecutterScreen.this.compactInventoryList, Minecraft.m_91087_().f_91074_.m_150109_(), ((LegacyCraftingMenu)LegacyStonecutterScreen.this.f_97732_).m_142621_());
                    return LegacyCraftingScreen.canCraft(LegacyStonecutterScreen.this.compactInventoryList, this.m_93696_() && this.getFocusedRecipe() == rcp ? LegacyStonecutterScreen.this.ingredientSlot : rcp.getOptionalIngredients(), null);
                }

                @Override
                public List<RecipeInfo<StonecutterRecipe>> getFocusedRecipes() {
                    if (!(this.m_93696_() && this.isValidIndex() && this.canScroll())) {
                        this.focusedRecipes = null;
                    } else if (this.focusedRecipes == null) {
                        this.focusedRecipes = new ArrayList<RecipeInfo<StonecutterRecipe>>(this.getRecipes());
                    }
                    return this.focusedRecipes == null ? this.getRecipes() : this.focusedRecipes;
                }

                @Override
                protected List<RecipeInfo<StonecutterRecipe>> getRecipes() {
                    List<List<RecipeInfo<StonecutterRecipe>>> list = LegacyStonecutterScreen.this.onlyCraftableRecipes ? LegacyStonecutterScreen.this.filteredRecipesByGroup : LegacyStonecutterScreen.this.recipesByGroup;
                    return list.size() <= (Integer)LegacyStonecutterScreen.this.craftingButtonsOffset.get() + index ? Collections.emptyList() : list.get((Integer)LegacyStonecutterScreen.this.craftingButtonsOffset.get() + index);
                }

                @Override
                protected void updateRecipeDisplay(RecipeInfo<StonecutterRecipe> rcp) {
                    LegacyStonecutterScreen.this.ingredientSlot = rcp == null ? Collections.singletonList(Optional.empty()) : rcp.getOptionalIngredients();
                }

                @Override
                protected void toggleCraftableRecipes() {
                    LegacyStonecutterScreen.this.listener.m_7934_(LegacyStonecutterScreen.this.f_97732_, 0, ItemStack.f_41583_);
                    LegacyStonecutterScreen.this.onlyCraftableRecipes = !LegacyStonecutterScreen.this.onlyCraftableRecipes;
                }

                @Override
                public boolean m_7933_(int i, int j, int k) {
                    if (this.controlCyclicNavigation(i, index, LegacyStonecutterScreen.this.craftingButtons, LegacyStonecutterScreen.this.craftingButtonsOffset, LegacyStonecutterScreen.this.scrollRenderer, (Screen)LegacyStonecutterScreen.this)) {
                        return true;
                    }
                    return super.m_7933_(i, j, k);
                }

                @Override
                public void renderTooltip(Minecraft minecraft, GuiGraphics graphics, int i, int j) {
                    super.renderTooltip(minecraft, graphics, i, j);
                    if (this.m_93696_()) {
                        if (!LegacyStonecutterScreen.this.ingredientSlot.isEmpty() && ScreenUtil.isMouseOver(i, j, LegacyStonecutterScreen.this.f_97735_ + 38, LegacyStonecutterScreen.this.f_97736_ + 149, 36, 36)) {
                            this.renderTooltip(minecraft, graphics, 2.getActualItem(LegacyStonecutterScreen.this.ingredientSlot.get(0)), i, j);
                        }
                        if (ScreenUtil.isMouseOver(i, j, LegacyStonecutterScreen.this.f_97735_ + 110, LegacyStonecutterScreen.this.f_97736_ + 149, 36, 36)) {
                            this.renderTooltip(minecraft, graphics, this.getFocusedResult(), i, j);
                        }
                    }
                }

                @Override
                public void renderSelection(GuiGraphics graphics, int i, int j, float f) {
                    boolean warning = !this.canCraft(this.getFocusedRecipe());
                    ScreenUtil.iconHolderRenderer.itemHolder(LegacyStonecutterScreen.this.f_97735_ + 38, LegacyStonecutterScreen.this.f_97736_ + 149, 36, 36, 2.getActualItem(LegacyStonecutterScreen.this.ingredientSlot.get(0)), !LegacyStonecutterScreen.this.onlyCraftableRecipes && !LegacyStonecutterScreen.this.ingredientSlot.get(0).isEmpty() && warning, DISPLAY_OFFSET).m_88315_(graphics, i, j, f);
                    ScreenUtil.iconHolderRenderer.itemHolder(LegacyStonecutterScreen.this.f_97735_ + 110, LegacyStonecutterScreen.this.f_97736_ + 149, 36, 36, this.getFocusedResult(), warning, DISPLAY_OFFSET).m_88315_(graphics, i, j, f);
                    if (this.getFocusedRecipe() != null) {
                        Component resultName = this.getFocusedRecipe().getName();
                        ScreenUtil.renderScrollingString(graphics, LegacyStonecutterScreen.this.f_96547_, resultName, LegacyStonecutterScreen.this.f_97735_ + 11 + Math.max(163 - LegacyStonecutterScreen.this.f_96547_.m_92852_((FormattedText)resultName), 0) / 2, LegacyStonecutterScreen.this.f_97736_ + 114, LegacyStonecutterScreen.this.f_97735_ + 170, LegacyStonecutterScreen.this.f_97736_ + 125, (int)((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()), false);
                    }
                    super.renderSelection(graphics, i, j, f);
                }
            };
            this.craftingButtons.add(h);
            h.offset = LegacyCraftingMenu.DEFAULT_INVENTORY_OFFSET;
            h.allowItemDecorations = false;
        }
    }
}

