/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.multiplayer.ServerStatusPinger;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.client.server.LanServer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.storage.LevelSummary;
import org.apache.commons.compress.utils.FileNameUtils;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.ControlType;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.CreationList;
import wily.legacy.client.screen.LegacyTabButton;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PanelVListScreen;
import wily.legacy.client.screen.PatchNotesScreen;
import wily.legacy.client.screen.PublishScreen;
import wily.legacy.client.screen.RenderableVList;
import wily.legacy.client.screen.SaveRenderableList;
import wily.legacy.client.screen.ServerRenderableList;
import wily.legacy.client.screen.TabList;
import wily.legacy.client.screen.compat.FriendsServerRenderableList;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public class PlayGameScreen
extends PanelVListScreen
implements ControlTooltip.Event,
TabList.Access {
    private static final Component SAFETY_TITLE = Component.m_237115_((String)"multiplayerWarning.header").m_130940_(ChatFormatting.BOLD);
    private static final Component SAFETY_CONTENT = Component.m_237115_((String)"multiplayerWarning.message");
    private static final Component SAFETY_CHECK = Component.m_237115_((String)"multiplayerWarning.check");
    public static final Component DIRECT_CONNECTION = Component.m_237115_((String)"selectServer.direct");
    public boolean isLoading = false;
    protected final TabList tabList = new TabList(this.accessor).add(30, LegacyTabButton.Type.LEFT, (Component)Component.m_237115_((String)"legacy.menu.load"), b -> this.m_267719_()).add(30, LegacyTabButton.Type.MIDDLE, (Component)Component.m_237115_((String)"legacy.menu.create"), b -> this.m_267719_()).add(30, LegacyTabButton.Type.RIGHT, (t, guiGraphics, i, j, f) -> t.renderString(guiGraphics, this.f_96547_, this.canNotifyOnlineFriends() ? 0xFFFFFF : (Integer)CommonColor.INVENTORY_GRAY_TEXT.get(), this.canNotifyOnlineFriends()), (Component)Component.m_237115_((String)"legacy.menu.join"), b -> {
        if (this.f_96541_.f_91066_.f_92083_) {
            this.m_267719_();
        } else {
            this.f_96541_.m_91152_((Screen)new ConfirmationScreen(this, SAFETY_TITLE, (Component)Component.m_237115_((String)"legacy.menu.multiplayer_warning").m_130946_("\n").m_7220_(SAFETY_CONTENT)){

                @Override
                protected void addButtons() {
                    this.renderableVList.addRenderable((Renderable)Button.m_253074_((Component)SAFETY_CHECK, b -> {
                        this.f_96541_.f_91066_.f_92083_ = true;
                        this.f_96541_.f_91066_.m_92169_();
                        this.m_7379_();
                    }).m_252987_(this.panel.x + (this.panel.width - 200) / 2, this.panel.y + this.panel.height - 52, 200, 20).m_253136_());
                    this.okButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.ok"), b -> this.okAction.accept(this)).m_252987_(this.panel.x + (this.panel.width - 200) / 2, this.panel.y + this.panel.height - 30, 200, 20).m_253136_();
                    this.renderableVList.addRenderable((Renderable)this.okButton);
                }
            });
        }
    });
    private final ServerStatusPinger pinger = new ServerStatusPinger();
    public final SaveRenderableList saveRenderableList = new SaveRenderableList(this.accessor);
    public final CreationList creationList = new CreationList(this.accessor);
    protected final ServerRenderableList serverRenderableList = PublishScreen.hasWorldHost() ? new FriendsServerRenderableList(this.accessor) : new ServerRenderableList(this.accessor);

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        super.addControlTooltips(renderer);
        renderer.add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(79) : ControllerBinding.UP_BUTTON.getIcon(), () -> ControlTooltip.getKeyMessage(79, this));
        renderer.add(() -> this.tabList.selectedTab != 2 ? null : (ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(88) : ControllerBinding.LEFT_BUTTON.getIcon()), () -> DIRECT_CONNECTION);
    }

    public PlayGameScreen(Screen parent, int initialTab) {
        super((Screen s) -> Panel.centered(s, 300, 256, () -> 0, () -> UIAccessor.of((Screen)s).getBoolean("hasTabList", Boolean.valueOf(true)) != false ? 12 : 0), (Component)Component.m_237115_((String)"legacy.menu.play_game"));
        this.parent = parent;
        this.tabList.selectedTab = initialTab;
        this.renderableVLists.clear();
        this.renderableVLists.add(this.saveRenderableList);
        this.renderableVLists.add(this.creationList);
        this.renderableVLists.add(this.serverRenderableList);
    }

    public boolean hasTabList() {
        return this.accessor.getBoolean("hasTabList", Boolean.valueOf(true));
    }

    public PlayGameScreen(Screen parent) {
        this(parent, 0);
    }

    public static Screen createAndCheckNewerVersions(Screen parent) {
        PlayGameScreen screen = new PlayGameScreen(parent);
        if (Legacy4JClient.isNewerVersion) {
            Legacy4JClient.isNewerVersion = false;
            return PatchNotesScreen.createNewerVersion(PlayGameScreen.createAndCheckNewerVersions(parent));
        }
        if (Legacy4JClient.isNewerMinecraftVersion) {
            Legacy4JClient.isNewerMinecraftVersion = false;
            return PatchNotesScreen.createNewerMinecraftVersion(PlayGameScreen.createAndCheckNewerVersions(parent));
        }
        return screen;
    }

    protected boolean canNotifyOnlineFriends() {
        return this.serverRenderableList.hasOnlineFriends() && Util.m_137550_() % 1000L < 500L;
    }

    @Override
    public TabList getTabList() {
        return this.tabList;
    }

    public void m_274333_() {
        super.m_274333_();
        this.serverRenderableList.added();
    }

    @Override
    protected void m_7856_() {
        this.panel.height = Math.min(256, this.f_96544_ - 52);
        if (this.hasTabList()) {
            this.m_7787_(this.tabList);
        }
        this.panel.init();
        this.renderableVListInit();
        if (this.hasTabList()) {
            this.tabList.init(this.panel.x, this.panel.y - 24, this.panel.width);
        }
    }

    @Override
    public void renderableVListInit() {
        this.getRenderableVList().init(this.panel.x + 15, this.panel.y + 15, 270, this.panel.height - 30 - (this.tabList.selectedTab == 0 ? 21 : 0));
        if (!this.hasTabList()) {
            this.serverRenderableList.init("serverRenderableVList", this.panel.x + 15, this.panel.y + 15, 270, this.panel.height - 30 - (this.tabList.selectedTab == 0 ? 21 : 0));
        }
    }

    @Override
    public void renderDefaultBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        ScreenUtil.renderDefaultBackground(this.accessor, guiGraphics, false);
        if (this.hasTabList()) {
            this.tabList.m_88315_(guiGraphics, i, j, f);
        }
        this.panel.m_88315_(guiGraphics, i, j, f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.PANEL_RECESS, this.accessor.getInteger("panelRecess.x", this.panel.x + 9), this.accessor.getInteger("panelRecess.y", this.panel.y + 9), this.accessor.getInteger("panelRecess.width", this.panel.width - 18), this.accessor.getInteger("panelRecess.height", this.panel.height - 18 - (this.tabList.selectedTab == 0 ? 21 : 0)));
        if (this.hasTabList() && this.tabList.selectedTab == 0) {
            if (this.saveRenderableList.currentlyDisplayedLevels != null) {
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_85837_((double)((float)this.panel.x + 11.25f), (double)(this.panel.y + this.panel.height) - 22.75, 0.0);
                long storage = new File("/").getTotalSpace();
                guiGraphics.m_280588_(0, 0, this.panel.width - 24, this.panel.height - 10);
                for (LevelSummary level : this.saveRenderableList.currentlyDisplayedLevels) {
                    AbstractButton b;
                    Long size = (Long)SaveRenderableList.sizeCache.getIfPresent((Object)level);
                    if (size == null) continue;
                    float scaledSize = Math.max(1.0f, (float)size.longValue() * ((float)this.panel.width - 21.0f) / (float)storage);
                    guiGraphics.m_280168_().m_85836_();
                    guiGraphics.m_280168_().m_85841_(scaledSize, 1.0f, 1.0f);
                    GuiEventListener guiEventListener = this.m_7222_();
                    guiGraphics.m_280509_(0, 0, 1, 11, (guiEventListener instanceof AbstractButton && this.saveRenderableList.renderables.contains(b = (AbstractButton)guiEventListener) && this.saveRenderableList.renderables.indexOf(b) == this.saveRenderableList.currentlyDisplayedLevels.indexOf(level) ? (Integer)CommonColor.SELECTED_STORAGE_SAVE.get() : (Integer)CommonColor.STORAGE_SAVE.get()).intValue());
                    guiGraphics.m_280168_().m_85849_();
                    guiGraphics.m_280168_().m_252880_(scaledSize, 0.0f, 0.0f);
                }
                guiGraphics.m_280168_().m_85849_();
                guiGraphics.m_280618_();
            }
            ScreenUtil.renderPanelTranslucentRecess(guiGraphics, this.panel.x + 9, this.panel.y + this.panel.height - 25, this.panel.width - 18, 16);
        }
        if (this.isLoading) {
            ScreenUtil.drawGenericLoading(guiGraphics, this.panel.x + 112, this.panel.y + 66);
        }
    }

    @Override
    public RenderableVList getRenderableVList() {
        return this.getRenderableVLists().get(this.hasTabList() ? this.tabList.selectedTab : 0);
    }

    public void m_7861_() {
        if (this.saveRenderableList != null) {
            SaveRenderableList.resetIconCache();
        }
        this.serverRenderableList.removed();
        this.pinger.m_105465_();
    }

    public void m_86600_() {
        List list;
        super.m_86600_();
        List<LevelSummary> summaries = this.saveRenderableList.pollLevelsIgnoreErrors();
        if (summaries != this.saveRenderableList.currentlyDisplayedLevels) {
            this.saveRenderableList.fillLevels("", summaries);
            this.m_267719_();
        }
        if (!((list = this.serverRenderableList.lanServerList.m_247578_()) == null || this.serverRenderableList.lanServers != null && new HashSet<LanServer>(this.serverRenderableList.lanServers).containsAll(list))) {
            this.serverRenderableList.lanServers = list;
            this.serverRenderableList.updateServers();
            this.m_232761_();
        }
        this.pinger.m_105453_();
    }

    @Override
    public boolean m_7933_(final int i, int j, int k) {
        if (this.hasTabList() && (this.tabList.controlTab(i) || this.tabList.directionalControlTab(i))) {
            return true;
        }
        if (super.m_7933_(i, j, k)) {
            return true;
        }
        if (i == 294) {
            if (this.tabList.selectedTab == 0) {
                this.saveRenderableList.reloadSaveList();
            } else if (this.tabList.selectedTab == 2) {
                this.serverRenderableList.servers.m_105431_();
                this.serverRenderableList.updateServers();
            }
            this.m_232761_();
            return true;
        }
        if (i == 88 && this.tabList.selectedTab == 2) {
            final EditBox serverBox = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, 200, 20, DIRECT_CONNECTION);
            this.f_96541_.m_91152_((Screen)new ConfirmationScreen(this, 230, 120, serverBox.m_6035_(), (Component)Component.m_237115_((String)"addServer.enterIp"), b1 -> ConnectScreen.m_278792_((Screen)this, (Minecraft)this.f_96541_, (ServerAddress)ServerAddress.m_171864_((String)serverBox.m_94155_()), (ServerData)new ServerData("", "", false), (boolean)false)){
                boolean released;
                {
                    super(parent, imageWidth, baseHeight, title, message, okAction);
                    this.released = false;
                }

                @Override
                protected void addButtons() {
                    super.addButtons();
                    this.okButton.f_93623_ = false;
                }

                public boolean m_5534_(char c, int i2) {
                    if (!this.released) {
                        return false;
                    }
                    return super.m_5534_(c, i2);
                }

                public boolean m_7920_(int i2, int j, int k) {
                    if (i2 == i) {
                        this.released = true;
                    }
                    return super.m_7920_(i2, j, k);
                }

                @Override
                protected void m_7856_() {
                    super.m_7856_();
                    serverBox.m_264152_(this.panel.m_252754_() + 15, this.panel.m_252907_() + 45);
                    serverBox.m_94151_(s -> {
                        this.okButton.f_93623_ = ServerAddress.m_171867_((String)s);
                    });
                    this.m_142416_((GuiEventListener)serverBox);
                }
            });
            return true;
        }
        return false;
    }

    public ServerStatusPinger getPinger() {
        return this.pinger;
    }

    public ServerList getServers() {
        return this.serverRenderableList.servers;
    }

    public void m_7400_(List<Path> list) {
        if (this.tabList.selectedTab == 0) {
            for (Path path : list) {
                if (path.getFileName().toString().endsWith(".mcsave") || path.getFileName().toString().endsWith(".zip")) continue;
                return;
            }
            String string = list.stream().map(Path::getFileName).map(Path::toString).collect(Collectors.joining(", "));
            this.f_96541_.m_91152_((Screen)new ConfirmationScreen((Screen)this, (Component)Component.m_237115_((String)"legacy.menu.import_save"), (Component)Component.m_237110_((String)"legacy.menu.import_save_message", (Object[])new Object[]{string}), b -> {
                list.forEach(p -> {
                    try {
                        Legacy4JClient.importSaveFile(new FileInputStream(p.toFile()), this.f_96541_.m_91392_(), FileNameUtils.getBaseName((String)p.getFileName().toString()));
                    }
                    catch (FileNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                });
                this.f_96541_.m_91152_((Screen)this);
                this.saveRenderableList.reloadSaveList();
            }));
        }
    }
}

