/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.mojang.datafixers.util.Pair;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.commands.PublishCommand;
import net.minecraft.util.HttpUtil;
import net.minecraft.world.level.GameType;
import wily.factoryapi.FactoryAPI;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.LegacyClientWorldSettings;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.LegacySliderButton;
import wily.legacy.client.screen.LoadSaveScreen;

public class PublishScreen
extends ConfirmationScreen {
    public static final Component PORT_INFO_TEXT = Component.m_237115_((String)"lanServer.port");
    public static final Component LAN_SERVER = Component.m_237115_((String)"lanServer.title");
    public static final Component PUBLISH = Component.m_237115_((String)(PublishScreen.hasWorldHost() ? "legacy.menu.online" : "menu.shareToLan"));
    public boolean publish = false;
    protected EditBox portEdit;
    protected final LegacySliderButton<GameType> gameTypeSlider;
    private int port = HttpUtil.m_13939_();

    public static boolean hasWorldHost() {
        return FactoryAPI.isModLoaded((String)(FactoryAPI.getLoader().isForgeLike() ? "world_host" : "world-host"));
    }

    public PublishScreen(Screen parent, GameType gameType, Consumer<PublishScreen> okAction) {
        super(parent, 230, 145, LAN_SERVER, (Component)Component.m_237115_((String)"lanServer.port"), b -> {});
        this.okAction = s -> {
            this.publish = true;
            okAction.accept(this);
            s.m_7379_();
        };
        this.gameTypeSlider = new LegacySliderButton<GameType>(0, 0, 200, 16, b -> b.getDefaultMessage(LoadSaveScreen.GAME_MODEL_LABEL, ((GameType)b.getObjectValue()).m_151499_()), b -> Tooltip.m_257550_((Component)Component.m_237115_((String)("selectWorld.gameMode." + ((GameType)b.getObjectValue()).m_46405_() + ".info"))), gameType, () -> LoadSaveScreen.GAME_TYPES, b -> {});
    }

    public PublishScreen(Screen parent, GameType gameType) {
        this(parent, gameType, (PublishScreen s) -> {});
    }

    public void m_267719_() {
        String string = this.portEdit.m_94155_();
        super.m_267719_();
        this.portEdit.m_94144_(string);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.portEdit = new EditBox(this.f_96547_, this.panel.x + this.panel.width / 2 - 100, this.panel.y + 45, 200, 20, PORT_INFO_TEXT);
        this.portEdit.m_257771_((Component)Component.m_237113_((String)("" + this.port)).m_130940_(ChatFormatting.DARK_GRAY));
        this.portEdit.m_94199_(128);
        this.portEdit.m_94151_(string -> {
            Pair<Integer, Component> p = Legacy4JClient.tryParsePort(string);
            if (p.getFirst() != null) {
                this.port = (Integer)p.getFirst();
            }
            this.portEdit.m_257771_((Component)Component.m_237113_((String)("" + this.port)).m_130940_(ChatFormatting.DARK_GRAY));
            if (p.getSecond() == null) {
                this.portEdit.m_94202_(0xE0E0E0);
                this.portEdit.m_257544_(null);
                this.okButton.f_93623_ = true;
            } else {
                this.portEdit.m_94202_(0xFF5555);
                this.portEdit.m_257544_(Tooltip.m_257550_((Component)((Component)p.getSecond())));
                this.okButton.f_93623_ = false;
            }
        });
        this.m_142416_((GuiEventListener)this.portEdit);
        this.gameTypeSlider.m_264152_(this.panel.x + this.panel.width / 2 - 100, this.panel.y + 69);
        this.m_142416_((GuiEventListener)this.gameTypeSlider);
    }

    public void publish(IntegratedServer server) {
        if (!this.publish) {
            return;
        }
        FactoryAPI.SECURE_EXECUTOR.executeNowIfPossible(() -> this.f_96541_.f_91065_.m_93076_().m_93785_((Component)(server.m_7386_(this.gameTypeSlider.getObjectValue(), server.m_129910_().m_5468_() && LegacyClientWorldSettings.of(server.m_129910_()).trustPlayers(), this.port) ? PublishCommand.m_257556_((int)this.port) : Component.m_237115_((String)"commands.publish.failed"))), () -> Minecraft.m_91087_().f_91074_ != null);
    }
}

