/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.base.config.FactoryConfig;
import wily.legacy.client.screen.LegacyConfigWidgets;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.util.ScreenUtil;

public class RenderableVList {
    protected final Stocker<Integer> scrolledList = Stocker.of((Object)0);
    protected boolean canScrollDown = false;
    public boolean forceWidth = true;
    protected int leftPos;
    protected int topPos;
    protected int listWidth;
    protected int listHeight;
    public final List<Renderable> renderables = new ArrayList<Renderable>();
    public final UIAccessor accessor;
    protected int renderablesCount;
    protected LegacyScrollRenderer scrollRenderer = new LegacyScrollRenderer();
    public boolean cyclic = true;
    protected Function<LayoutElement, Integer> layoutSeparation = w -> 3;

    public RenderableVList(UIAccessor accessor) {
        this.accessor = accessor;
    }

    public RenderableVList(Screen screen) {
        this(UIAccessor.of((Screen)screen));
    }

    public RenderableVList addRenderables(Renderable ... renderables) {
        return this.addRenderables(this.renderables.size(), renderables);
    }

    public RenderableVList addRenderables(int indexOffset, Renderable ... renderables) {
        this.renderables.addAll(indexOffset, List.of(renderables));
        return this;
    }

    public RenderableVList addRenderable(Renderable renderable) {
        this.renderables.add(renderable);
        return this;
    }

    public Screen getScreen() {
        return this.accessor.getScreen();
    }

    public <S> S getScreen(Class<S> screenClass) {
        return screenClass.cast(this.accessor.getScreen());
    }

    public <T> RenderableVList addLinkedOptions(int index, FactoryConfig<T> dependency, Predicate<FactoryConfig<T>> activeDependent, FactoryConfig<?> ... dependents) {
        ArrayList<AbstractWidget> dependentWidgets = new ArrayList<AbstractWidget>();
        for (FactoryConfig<?> dependent : dependents) {
            AbstractWidget dependentWidget = LegacyConfigWidgets.createWidget(dependent);
            dependentWidget.f_93623_ = activeDependent.test(dependency);
            dependentWidgets.add(dependentWidget);
        }
        this.renderables.addAll(index, (Collection<Renderable>)ImmutableList.builder().addAll(dependentWidgets).add((Object)LegacyConfigWidgets.createWidget(dependency, 0, 0, 0, b -> dependentWidgets.forEach(dependentWidget -> {
            dependentWidget.f_93623_ = activeDependent.test(dependency);
        }))).build());
        return this;
    }

    public <T> RenderableVList addLinkedOptions(FactoryConfig<T> dependency, Predicate<FactoryConfig<T>> activeDependent, FactoryConfig<?> ... dependents) {
        return this.addLinkedOptions(this.renderables.size(), dependency, activeDependent, dependents);
    }

    public RenderableVList addDependentOptions(int index, boolean enabled, FactoryConfig<?> ... dependents) {
        if (enabled) {
            this.addOptions(index, dependents);
        } else {
            this.renderables.addAll(index, Arrays.stream(dependents).map(option -> {
                AbstractWidget widget = LegacyConfigWidgets.createWidget(option);
                widget.f_93623_ = false;
                return widget;
            }).toList());
        }
        return this;
    }

    public RenderableVList addDependentOptions(boolean enabled, FactoryConfig<?> ... dependents) {
        return this.addDependentOptions(this.renderables.size(), enabled, dependents);
    }

    public RenderableVList addOptions(FactoryConfig<?> ... optionInstances) {
        return this.addOptions(this.renderables.size(), optionInstances);
    }

    public RenderableVList addOptions(int indexOffset, FactoryConfig<?> ... optionInstances) {
        return this.addOptions(indexOffset, Arrays.stream(optionInstances));
    }

    public RenderableVList addOptions(Stream<FactoryConfig<?>> optionInstances) {
        return this.addOptions(this.renderables.size(), optionInstances);
    }

    public RenderableVList addOptions(int indexOffset, Stream<FactoryConfig<?>> optionInstances) {
        this.renderables.addAll(indexOffset, optionInstances.map(LegacyConfigWidgets::createWidget).toList());
        return this;
    }

    public RenderableVList layoutSpacing(Function<LayoutElement, Integer> layoutSeparation) {
        this.layoutSeparation = layoutSeparation;
        return this;
    }

    public RenderableVList forceWidth(boolean forceWidth) {
        this.forceWidth = forceWidth;
        return this;
    }

    public RenderableVList cyclic(boolean cyclic) {
        this.cyclic = cyclic;
        return this;
    }

    public void focusRenderable(Renderable renderable) {
        Renderable renderable2;
        GuiEventListener l;
        if (this.renderables.isEmpty()) {
            return;
        }
        if (renderable instanceof GuiEventListener) {
            l = (GuiEventListener)renderable;
            if (this.getScreen().m_6702_().contains(l)) {
                this.getScreen().m_7522_(l);
                return;
            }
        }
        if ((Integer)this.scrolledList.get() > 0) {
            this.scrolledList.set((Object)0);
            this.accessor.reloadUI();
        }
        if ((renderable2 = this.renderables.get(0)) instanceof GuiEventListener) {
            l = (GuiEventListener)renderable2;
            if (this.getScreen().m_7222_() != l) {
                this.getScreen().m_7522_(l);
            }
        }
        while (this.getScreen().m_7222_() != renderable) {
            if (this.forceWidth) {
                ComponentPath path = this.getDirectionalNextFocusPath(ScreenDirection.DOWN);
                if (this.isInvalidFocus(path, true)) {
                    if (!this.canScrollDown) break;
                    while (this.canScrollDown && this.isInvalidFocus(this.getDirectionalNextFocusPath(ScreenDirection.DOWN), true)) {
                        this.mouseScrolled(true);
                    }
                    continue;
                }
                this.getScreen().m_7522_(path.m_264222_());
                continue;
            }
            GuiEventListener listener = this.getNextHorizontalRenderable();
            if (listener == null) {
                ComponentPath path = this.getDirectionalNextFocusPath(ScreenDirection.RIGHT);
                if (this.isInvalidFocus(path, true)) break;
                this.getScreen().m_7522_(path.m_264222_());
                continue;
            }
            this.getScreen().m_7522_(listener);
        }
    }

    public void init(int leftPos, int topPos, int listWidth, int listHeight) {
        this.init("renderableVList", leftPos, topPos, listWidth, listHeight);
    }

    public void init(String name, int leftPos, int topPos, int listWidth, int listHeight) {
        boolean allowScroll;
        this.leftPos = this.accessor.getInteger(name + ".x", leftPos);
        this.topPos = this.accessor.getInteger(name + ".y", topPos);
        this.listWidth = this.accessor.getInteger(name + ".width", listWidth);
        this.listHeight = this.accessor.getInteger(name + ".height", listHeight);
        boolean bl = allowScroll = this.listHeight > 0;
        if (allowScroll) {
            this.accessor.getChildrenRenderables().add((guiGraphics, i, j, f) -> {
                if ((Integer)this.scrolledList.get() > 0) {
                    this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.UP, this.leftPos + this.listWidth - 29, this.topPos + this.listHeight - 8);
                }
                if (this.canScrollDown) {
                    this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.DOWN, this.leftPos + this.listWidth - 13, this.topPos + this.listHeight - 8);
                }
            });
        }
        this.canScrollDown = false;
        int yDiff = 0;
        int xDiff = 0;
        this.renderablesCount = 0;
        for (int i2 = ((Integer)this.scrolledList.get()).intValue(); i2 < this.renderables.size(); ++i2) {
            LayoutElement l;
            Renderable r = this.renderables.get(i2);
            if (!allowScroll || !(r instanceof LayoutElement) || yDiff + (l = (LayoutElement)r).m_93694_() + (i2 == this.renderables.size() - 1 && (Integer)this.scrolledList.get() == 0 ? 0 : 12) <= this.listHeight) {
                LayoutElement l2;
                if (r instanceof LayoutElement) {
                    l2 = (LayoutElement)r;
                    boolean changeRow = this.forceWidth || xDiff + l2.m_5711_() > this.listWidth;
                    l2.m_252865_(this.leftPos + xDiff);
                    l2.m_253211_(this.topPos + yDiff);
                    xDiff = changeRow ? 0 : xDiff + l2.m_5711_() + this.layoutSeparation.apply(l2);
                    yDiff += changeRow ? l2.m_93694_() + this.layoutSeparation.apply(l2) : 0;
                    if (changeRow && !this.forceWidth) {
                        --i2;
                        continue;
                    }
                }
                ++this.renderablesCount;
                if (r instanceof AbstractWidget) {
                    AbstractWidget w = (AbstractWidget)r;
                    if (this.forceWidth) {
                        w.m_93674_(this.listWidth);
                    }
                }
                if (r instanceof GuiEventListener) {
                    l2 = (GuiEventListener)r;
                    this.accessor.addChild(this.accessor.getChildren().size(), (GuiEventListener)l2, false, true);
                }
                this.accessor.addRenderable(this.accessor.getChildrenRenderables().size(), r);
                continue;
            }
            this.canScrollDown = true;
            break;
        }
    }

    public int getLineAmount(int scroll) {
        if (this.forceWidth) {
            return scroll;
        }
        int xDiff = 0;
        int rowAmount = 0;
        for (int i = ((Integer)this.scrolledList.get()).intValue(); i < (Integer)this.scrolledList.get() + this.renderablesCount; ++i) {
            Renderable renderable = this.renderables.get(i);
            if (renderable instanceof LayoutElement) {
                LayoutElement e = (LayoutElement)renderable;
                xDiff += (xDiff == 0 ? 0 : this.layoutSeparation.apply(e)) + e.m_5711_();
            }
            rowAmount += scroll;
            if (xDiff + 30 > this.listWidth) break;
        }
        return rowAmount;
    }

    public void mouseScrolled(double g) {
        this.mouseScrolled((int)(-Math.signum(g)) > 0);
    }

    public void mouseScrolled(boolean down) {
        int setScroll;
        if ((this.canScrollDown && down || (Integer)this.scrolledList.get() > 0 && !down) && (setScroll = Math.max(0, (Integer)this.scrolledList.get() + this.getLineAmount(down ? 1 : -1))) != (Integer)this.scrolledList.get()) {
            this.scrollRenderer.updateScroll(down ? ScreenDirection.DOWN : ScreenDirection.UP);
            this.scrolledList.set((Object)setScroll);
            this.accessor.reloadUI();
        }
    }

    public boolean isHovered(double x, double y) {
        return ScreenUtil.isMouseOver(x, y, this.leftPos, this.topPos, this.listWidth, this.listHeight == 0 ? this.getScreen().f_96544_ : this.listHeight);
    }

    public boolean isInvalidFocus(ComponentPath path, boolean allowExternalListener) {
        return path == null || allowExternalListener && !this.renderables.contains(path.m_264222_());
    }

    public boolean isDirectionFocused(ScreenDirection direction, boolean allowExternalListener) {
        return this.isInvalidFocus(this.getDirectionalNextFocusPath(direction), allowExternalListener);
    }

    public boolean isDirectionFocused(ScreenDirection direction) {
        return this.isDirectionFocused(direction, false);
    }

    public ComponentPath getDirectionalNextFocusPath(ScreenDirection direction) {
        return this.getScreen().m_264458_(this.getScreen().m_7222_().m_264198_(), direction, this.getScreen().m_7222_(), (FocusNavigationEvent)new FocusNavigationEvent.ArrowNavigation(direction));
    }

    public void setLastFocusInDirection(ScreenDirection direction) {
        if (this.getScreen().m_7222_() != null) {
            ComponentPath path;
            while (!this.isInvalidFocus(path = this.getDirectionalNextFocusPath(direction), true)) {
                this.getScreen().m_7522_(path.m_264222_());
            }
        }
    }

    public boolean keyPressed(int i) {
        return this.keyPressed(i, this.cyclic);
    }

    public boolean keyPressed(int i, boolean cyclic) {
        if (this.renderables.contains(this.getScreen().m_7222_()) && this.renderablesCount > 1) {
            GuiEventListener nextHorizontalRenderable;
            ComponentPath path;
            if (i == 264 && this.isInvalidFocus(path = this.getDirectionalNextFocusPath(ScreenDirection.DOWN), true)) {
                if (this.canScrollDown) {
                    while (this.canScrollDown && this.isDirectionFocused(ScreenDirection.DOWN, true)) {
                        this.mouseScrolled(true);
                    }
                } else if (cyclic) {
                    if (path == null && (Integer)this.scrolledList.get() > 0) {
                        this.scrolledList.set((Object)0);
                        this.accessor.reloadUI();
                        this.setLastFocusInDirection(ScreenDirection.DOWN);
                    }
                } else if (path == null) {
                    return true;
                }
            }
            if (i == 265 && this.isInvalidFocus(path = this.getDirectionalNextFocusPath(ScreenDirection.UP), true)) {
                if ((Integer)this.scrolledList.get() > 0) {
                    while ((Integer)this.scrolledList.get() > 0 && this.isDirectionFocused(ScreenDirection.UP, true)) {
                        this.mouseScrolled(false);
                    }
                } else if (cyclic) {
                    if (path == null) {
                        while (this.canScrollDown) {
                            this.mouseScrolled(true);
                        }
                    }
                } else if (path == null) {
                    return true;
                }
            }
            if (this.listHeight > 0) {
                GuiEventListener lastFocus = this.getScreen().m_7222_();
                if (i == 267) {
                    if (this.isDirectionFocused(ScreenDirection.DOWN)) {
                        while (this.accessor.getChildren().contains(lastFocus) && this.canScrollDown) {
                            this.mouseScrolled(true);
                        }
                    }
                    this.setLastFocusInDirection(ScreenDirection.DOWN);
                    return true;
                }
                if (i == 266) {
                    if (this.isDirectionFocused(ScreenDirection.UP)) {
                        while (this.accessor.getChildren().contains(lastFocus) && (Integer)this.scrolledList.get() > 0) {
                            this.mouseScrolled(false);
                        }
                    }
                    this.setLastFocusInDirection(ScreenDirection.UP);
                    return true;
                }
            }
            if (!this.forceWidth && (nextHorizontalRenderable = this.getNextHorizontalRenderable(i == 263, i == 262)) != null) {
                this.getScreen().m_264158_(ComponentPath.m_264492_((GuiEventListener)nextHorizontalRenderable, (ContainerEventHandler[])new ContainerEventHandler[]{this.getScreen()}));
                return true;
            }
        }
        return false;
    }

    public GuiEventListener getNextHorizontalRenderable() {
        return this.getNextHorizontalRenderable(false, true);
    }

    public GuiEventListener getNextHorizontalRenderable(boolean left, boolean right) {
        if (right && this.isDirectionFocused(ScreenDirection.RIGHT) || left && this.isDirectionFocused(ScreenDirection.LEFT)) {
            Renderable renderable;
            int focused = this.renderables.indexOf(this.getScreen().m_7222_()) + (right ? 1 : -1);
            if (left && this.isDirectionFocused(ScreenDirection.UP) || right && this.isDirectionFocused(ScreenDirection.DOWN)) {
                this.keyPressed(left ? 265 : 264, false);
            }
            if (focused >= 0 && focused < this.renderables.size() && (renderable = this.renderables.get(focused)) instanceof GuiEventListener) {
                GuiEventListener newFocus = (GuiEventListener)renderable;
                return newFocus;
            }
        }
        return null;
    }

    public static interface Access {
        public void renderableVListInit();

        default public RenderableVList getRenderableVList() {
            return this.getRenderableVLists().get(0);
        }

        default public void focusRenderable(Predicate<Renderable> renderablePredicate, IntConsumer changeSelectedRenderableVList) {
            for (int i = 0; i < this.getRenderableVLists().size(); ++i) {
                RenderableVList renderableVList = this.getRenderableVLists().get(i);
                for (Renderable renderable : renderableVList.renderables) {
                    if (!renderablePredicate.test(renderable)) continue;
                    changeSelectedRenderableVList.accept(i);
                    renderableVList.focusRenderable(renderable);
                    return;
                }
            }
        }

        public List<RenderableVList> getRenderableVLists();

        default public RenderableVList getRenderableVListAt(double x, double y) {
            RenderableVList mainRenderableVList = this.getRenderableVList();
            if (mainRenderableVList.isHovered(x, y)) {
                return mainRenderableVList;
            }
            for (RenderableVList renderableVList : this.getRenderableVLists()) {
                if (renderableVList == mainRenderableVList || !renderableVList.isHovered(x, y)) continue;
                return renderableVList;
            }
            return null;
        }
    }
}

