/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.inventory;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.legacy.inventory.LegacySlot;

public interface LegacySlotDisplay {
    public static final LegacySlotDisplay DEFAULT = new LegacySlotDisplay(){};
    public static final LegacySlotDisplay VANILLA = new LegacySlotDisplay(){

        @Override
        public int getWidth() {
            return 18;
        }

        @Override
        public ArbitrarySupplier<ResourceLocation> getIconHolderOverride() {
            return EMPTY_OVERRIDE;
        }
    };
    public static final ArbitrarySupplier<ResourceLocation> EMPTY_OVERRIDE = ArbitrarySupplier.empty();

    default public int getWidth() {
        return 21;
    }

    default public int getHeight() {
        return this.getWidth();
    }

    default public boolean isVisible() {
        return true;
    }

    default public Vec3 getOffset() {
        return Vec3.f_82478_;
    }

    default public ResourceLocation getIconSprite() {
        return null;
    }

    default public ArbitrarySupplier<ResourceLocation> getIconHolderOverride() {
        return null;
    }

    default public ItemStack getItemOverride() {
        return null;
    }

    default public boolean isWarning() {
        return false;
    }

    public static LegacySlotDisplay of(Slot slot) {
        LegacySlotDisplay legacySlotDisplay;
        if (slot instanceof LegacySlot) {
            LegacySlot legacySlot = (LegacySlot)slot;
            legacySlotDisplay = legacySlot.getDisplay();
        } else {
            legacySlotDisplay = VANILLA;
        }
        return legacySlotDisplay;
    }

    public static boolean isVisibleAndActive(Slot slot) {
        return slot.m_6659_() && LegacySlotDisplay.of(slot).isVisible();
    }

    public static Slot override(Slot slot) {
        return LegacySlotDisplay.override(slot, DEFAULT);
    }

    public static Slot override(Slot slot, int x, int y) {
        return LegacySlotDisplay.override(slot, x, y, DEFAULT);
    }

    public static Slot override(Slot slot, LegacySlotDisplay legacySlot) {
        if (slot instanceof LegacySlot) {
            LegacySlot c = (LegacySlot)slot;
            c.setDisplay(legacySlot);
        }
        return slot;
    }

    public static Slot override(Slot slot, int x, int y, LegacySlotDisplay legacySlot) {
        if (slot instanceof LegacySlot) {
            LegacySlot c = (LegacySlot)slot;
            c.setDisplay(legacySlot);
            c.setX(x);
            c.setY(y);
        }
        return slot;
    }
}

