/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.brewing;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.BrewingStandScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.BrewingStandMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.util.LegacySprites;

@Mixin(value={BrewingStandScreen.class})
public abstract class BrewingStandScreenMixin
extends AbstractContainerScreen<BrewingStandMenu> {
    @Shadow
    @Final
    private static int[] f_98329_;
    private static final Vec3 BREWING_SLOT_OFFSET;
    private static final LegacySlotDisplay FIRST_BREWING_SLOT_DISPLAY;
    private static final LegacySlotDisplay SECOND_BREWING_SLOT_DISPLAY;
    private static final LegacySlotDisplay THIRD_BREWING_SLOT_DISPLAY;
    private static final LegacySlotDisplay FOURTH_BREWING_SLOT_DISPLAY;

    private static LegacySlotDisplay createBrewingSlotDisplay(final Vec3 offset) {
        return new LegacySlotDisplay(){

            @Override
            public Vec3 getOffset() {
                return offset;
            }

            @Override
            public int getWidth() {
                return 27;
            }

            @Override
            public ArbitrarySupplier<ResourceLocation> getIconHolderOverride() {
                return EMPTY_OVERRIDE;
            }
        };
    }

    public BrewingStandScreenMixin(BrewingStandMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
    }

    @Inject(method={"init"}, at={@At(value="HEAD")}, cancellable=true)
    public void init(CallbackInfo ci) {
        ci.cancel();
        this.f_97726_ = 213;
        this.f_97727_ = 225;
        this.f_97730_ = 13;
        this.f_97731_ = 115;
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
        this.f_97729_ = 11;
        super.m_7856_();
        this.f_97736_ -= 20;
        for (int i = 0; i < ((BrewingStandMenu)this.f_97732_).f_38839_.size(); ++i) {
            final Slot s = (Slot)((BrewingStandMenu)this.f_97732_).f_38839_.get(i);
            if (i == 0) {
                LegacySlotDisplay.override(s, 60, 76, FIRST_BREWING_SLOT_DISPLAY);
                continue;
            }
            if (i == 1) {
                LegacySlotDisplay.override(s, 94, 87, SECOND_BREWING_SLOT_DISPLAY);
                continue;
            }
            if (i == 2) {
                LegacySlotDisplay.override(s, 129, 76, THIRD_BREWING_SLOT_DISPLAY);
                continue;
            }
            if (i == 3) {
                LegacySlotDisplay.override(s, 94, 25, FOURTH_BREWING_SLOT_DISPLAY);
                continue;
            }
            if (i == 4) {
                LegacySlotDisplay.override(s, 19, 25, new LegacySlotDisplay(){

                    @Override
                    public Vec3 getOffset() {
                        return BREWING_SLOT_OFFSET;
                    }

                    @Override
                    public int getWidth() {
                        return 27;
                    }

                    @Override
                    public ResourceLocation getIconSprite() {
                        return s.m_7993_().m_41619_() ? LegacySprites.BREWING_FUEL_SLOT : null;
                    }
                });
                continue;
            }
            if (i < ((BrewingStandMenu)this.f_97732_).f_38839_.size() - 9) {
                LegacySlotDisplay.override(s, 14 + (s.m_150661_() - 9) % 9 * 21, 126 + (s.m_150661_() - 9) / 9 * 21);
                continue;
            }
            LegacySlotDisplay.override(s, 14 + s.m_150661_() * 21, 195);
        }
    }

    public void m_280273_(GuiGraphics guiGraphics) {
    }

    protected void m_280003_(GuiGraphics guiGraphics, int i, int j) {
        super.m_280003_(guiGraphics, i, j);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.BREWING_COIL_FLAME, 43, 42, 51, 33);
        int fuel = ((BrewingStandMenu)this.f_97732_).m_39102_();
        int n = Mth.m_14045_((int)((27 * fuel + 20 - 1) / 20), (int)0, (int)27);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(65.5f, 66.0f, 0.0f);
        if (n > 0) {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.FUEL_LENGTH_SPRITE, 27, 6, 0, 0, 0, 0, 0, n, 6);
        }
        guiGraphics.m_280168_().m_85849_();
    }

    @Inject(method={"renderBg"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderBg(GuiGraphics guiGraphics, float f, int i, int j, CallbackInfo ci) {
        ci.cancel();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite((ResourceLocation)UIAccessor.of((Screen)this).getElementValue("imageSprite", (Object)LegacySprites.SMALL_PANEL, ResourceLocation.class), this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85837_((double)((float)this.f_97735_ + 58.5f), (double)this.f_97736_ + 22.5, 0.0);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.BREWING_SLOTS, 0, 0, 96, 96);
        guiGraphics.m_280168_().m_85849_();
        int o = ((BrewingStandMenu)this.f_97732_).m_39103_();
        if (o > 0) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85837_((double)((float)this.f_97735_ + 121.5f), (double)this.f_97736_ + 22.5, 0.0);
            guiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
            int p = (int)(84.0f * (1.0f - (float)o / 400.0f));
            if (p > 0) {
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.BREW_PROGRESS_SPRITE, 27, 84, 0, 0, 0, 0, 0, 27, p);
            }
            guiGraphics.m_280168_().m_85849_();
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)this.f_97735_ + 71.0f, (float)(this.f_97736_ + 21), 0.0f);
            guiGraphics.m_280168_().m_85841_(1.5f, 1.5f, 1.5f);
            p = f_98329_[o / 2 % 7];
            if (p > 0) {
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.BUBBLES_SPRITE, 12, 29, 0, 29 - p, 0, 29 - p, 0, 12, p);
            }
            guiGraphics.m_280168_().m_85849_();
        }
    }

    static {
        BREWING_SLOT_OFFSET = new Vec3(0.0, 0.5, 0.0);
        FIRST_BREWING_SLOT_DISPLAY = BrewingStandScreenMixin.createBrewingSlotDisplay(BREWING_SLOT_OFFSET);
        SECOND_BREWING_SLOT_DISPLAY = BrewingStandScreenMixin.createBrewingSlotDisplay(new Vec3(0.5, 0.0, 0.0));
        THIRD_BREWING_SLOT_DISPLAY = BrewingStandScreenMixin.createBrewingSlotDisplay(BREWING_SLOT_OFFSET);
        FOURTH_BREWING_SLOT_DISPLAY = BrewingStandScreenMixin.createBrewingSlotDisplay(new Vec3(0.5, 0.5, 0.0));
    }
}

