/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import wily.factoryapi.base.network.CommonNetwork;
import wily.factoryapi.util.DynamicUtil;

public class LegacyTipBuilder {
    public static final Codec<LegacyTipBuilder> COMPLETE_CODEC = RecordCodecBuilder.create(i -> i.group((App)DynamicUtil.getComponentCodec().optionalFieldOf("title").forGetter(LegacyTipBuilder::getTitle), (App)DynamicUtil.getComponentCodec().optionalFieldOf("tip").forGetter(LegacyTipBuilder::getTip), (App)DynamicUtil.ITEM_CODEC.fieldOf("itemIcon").orElse((Object)ItemStack.f_41583_).forGetter(LegacyTipBuilder::getItem), (App)Codec.INT.fieldOf("time").orElse((Object)-1).forGetter(LegacyTipBuilder::getTime)).apply((Applicative)i, LegacyTipBuilder::create));
    public static final Codec<LegacyTipBuilder> CODEC = Codec.either((Codec)DynamicUtil.getComponentCodec().xmap(c -> new LegacyTipBuilder().tip((Component)c), b -> b.tip), COMPLETE_CODEC).xmap(e -> e.right().orElseGet(e.left()::get), Either::right);
    public static final Codec<Map<String, LegacyTipBuilder>> MAP_CODEC = Codec.unboundedMap((Codec)Codec.STRING, CODEC).xmap(HashMap::new, Function.identity());
    public static final Codec<List<LegacyTipBuilder>> LIST_CODEC = CODEC.listOf();
    private Component title = null;
    private Component tip = null;
    private ItemStack itemIcon = ItemStack.f_41583_;
    private int time = -1;

    public static LegacyTipBuilder create(Optional<Component> title, Optional<Component> tip, ItemStack itemIcon, int time) {
        return LegacyTipBuilder.create(title.orElse(null), tip.orElse(null), itemIcon, time);
    }

    public static LegacyTipBuilder create(Component title, Component tip, ItemStack itemIcon, int time) {
        return new LegacyTipBuilder().title(title).tip(tip).itemIcon(itemIcon).disappearTime(time);
    }

    public static String getTipId(Item item) {
        return item.m_5524_() + ".tip";
    }

    public static Component getTip(ItemStack stack) {
        ComponentContents componentContents = stack.m_41786_().m_214077_();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents contents = (TranslatableContents)componentContents;
            return Component.m_237115_((String)(contents.m_237508_() + ".tip"));
        }
        return Component.m_237115_((String)LegacyTipBuilder.getTipId(stack.m_41720_()));
    }

    public static String getTipId(EntityType<?> item) {
        return item.m_20675_() + ".tip";
    }

    public LegacyTipBuilder title(Component title) {
        this.title = title;
        return this;
    }

    public LegacyTipBuilder tip(Component tip) {
        this.tip = tip;
        return this;
    }

    public LegacyTipBuilder itemIcon(ItemStack itemIcon) {
        this.itemIcon = itemIcon;
        return this;
    }

    public LegacyTipBuilder item(ItemStack itemIcon) {
        if (!itemIcon.m_41619_()) {
            return this.itemIcon(itemIcon).title(itemIcon.m_41786_()).tip(LegacyTipBuilder.getTip(itemIcon));
        }
        return this;
    }

    public LegacyTipBuilder disappearTime(int time) {
        this.time = time;
        return this;
    }

    public LegacyTipBuilder copyFrom(LegacyTipBuilder builder) {
        return this.copyFrom(builder, false);
    }

    public LegacyTipBuilder copyFrom(LegacyTipBuilder builder, boolean modifier) {
        if (!builder.getItem().m_41619_()) {
            if (modifier) {
                this.itemIcon(builder.getItem());
            } else {
                this.item(builder.getItem());
            }
        }
        if (builder.title != null) {
            this.title(builder.title);
        }
        if (builder.tip != null) {
            this.tip(builder.tip);
        }
        if (builder.getTime() >= 0) {
            this.disappearTime(builder.getTime());
        }
        return this;
    }

    public Optional<Component> getTitle() {
        return Optional.ofNullable(this.title);
    }

    public Optional<Component> getTip() {
        return Optional.ofNullable(this.tip);
    }

    public ItemStack getItem() {
        return this.itemIcon;
    }

    public int getTime() {
        return this.time;
    }

    public static LegacyTipBuilder decode(CommonNetwork.PlayBuf buf) {
        return LegacyTipBuilder.create(((FriendlyByteBuf)buf.get()).m_236860_(b -> CommonNetwork.decodeComponent((CommonNetwork.PlayBuf)buf)), ((FriendlyByteBuf)buf.get()).m_236860_(b -> CommonNetwork.decodeComponent((CommonNetwork.PlayBuf)buf)), CommonNetwork.decodeItemStack((CommonNetwork.PlayBuf)buf), ((FriendlyByteBuf)buf.get()).readInt());
    }

    public void encode(CommonNetwork.PlayBuf buf) {
        ((FriendlyByteBuf)buf.get()).m_236835_(this.getTitle(), (b, t) -> CommonNetwork.encodeComponent((CommonNetwork.PlayBuf)buf, (Component)t));
        ((FriendlyByteBuf)buf.get()).m_236835_(this.getTip(), (b, t) -> CommonNetwork.encodeComponent((CommonNetwork.PlayBuf)buf, (Component)t));
        CommonNetwork.encodeItemStack((CommonNetwork.PlayBuf)buf, (ItemStack)this.itemIcon);
        ((FriendlyByteBuf)buf.get()).writeInt(this.time);
    }
}

