/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BedItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.DecoratedPotPatterns;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.Bearer;
import wily.factoryapi.base.FactoryIngredient;
import wily.factoryapi.base.StackIngredient;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.base.client.UIDefinition;
import wily.factoryapi.base.network.CommonNetwork;
import wily.factoryapi.base.network.CommonRecipeManager;
import wily.factoryapi.util.ModInfo;
import wily.factoryapi.util.PagedList;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.LegacyCraftingTabListing;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacyTipManager;
import wily.legacy.client.RecipeInfo;
import wily.legacy.client.TypeCraftingTab;
import wily.legacy.client.controller.BindingState;
import wily.legacy.client.controller.Controller;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.CustomRecipeIconHolder;
import wily.legacy.client.screen.LegacyIconHolder;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.client.screen.LegacyTabButton;
import wily.legacy.client.screen.ModsScreen;
import wily.legacy.client.screen.RecipeIconHolder;
import wily.legacy.client.screen.ScrollableRenderer;
import wily.legacy.client.screen.TabList;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.inventory.ImpossibleIngredient;
import wily.legacy.inventory.LegacyCraftingMenu;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.inventory.RecipeMenu;
import wily.legacy.mixin.base.FireworkRocketRecipeAccessor;
import wily.legacy.mixin.base.FireworkStarRecipeAccessor;
import wily.legacy.network.ServerMenuCraftPayload;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacyItemUtil;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyFontUtil;
import wily.legacy.util.client.LegacyRenderUtil;
import wily.legacy.util.client.LegacySoundUtil;

public class LegacyCraftingScreen
extends AbstractContainerScreen<LegacyCraftingMenu>
implements Controller.Event,
ControlTooltip.Event,
TabList.Access {
    public static final Item[] VANILLA_CATEGORY_ICONS = new Item[]{Items.BRICKS, Items.REDSTONE, Items.GOLDEN_SWORD, Items.LAVA_BUCKET};
    protected final List<ItemStack> compactItemStackList = new ArrayList<ItemStack>();
    protected final List<Optional<Ingredient>> ingredientsGrid;
    protected final CraftingContainer container;
    protected final UIAccessor accessor = UIAccessor.of((Screen)this);
    protected final List<RecipeIconHolder<CraftingRecipe>> craftingButtons = new PagedList(new Stocker.Sizeable(Integer.valueOf(0), 0), () -> this.accessor.getInteger("maxCraftingButtonsCount", 12));
    protected final List<CustomRecipeIconHolder> dyeItemButtons = new ArrayList<CustomRecipeIconHolder>();
    protected final List<CustomRecipeIconHolder> dyeArmorButtons = new ArrayList<CustomRecipeIconHolder>();
    protected final List<CustomRecipeIconHolder> bannerButtons = new ArrayList<CustomRecipeIconHolder>();
    protected final List<CustomRecipeIconHolder> decorateShieldButtons = new ArrayList<CustomRecipeIconHolder>();
    protected final List<CustomRecipeIconHolder> decoratedPotButtons = new ArrayList<CustomRecipeIconHolder>();
    protected final List<CustomRecipeIconHolder> fireworkStarButtons = new ArrayList<CustomRecipeIconHolder>();
    protected final List<CustomRecipeIconHolder> fireworkStarFadeButtons = new ArrayList<CustomRecipeIconHolder>();
    protected final List<CustomRecipeIconHolder> fireworkButtons = new ArrayList<CustomRecipeIconHolder>();
    protected final List<List<List<RecipeInfo<CraftingRecipe>>>> recipesByTab = new ArrayList<List<List<RecipeInfo<CraftingRecipe>>>>();
    protected final Stocker.Sizeable page = new Stocker.Sizeable(Integer.valueOf(0));
    protected final Stocker.Sizeable craftingButtonsOffset = new Stocker.Sizeable(Integer.valueOf(0));
    protected final TabList craftingTabList = new TabList(this.accessor, (List<LegacyTabButton>)new PagedList(this.page, this::getMaxTabCount));
    protected final List<TabList> typeTabLists = new ArrayList<TabList>();
    protected final List<TypeCraftingTab> typeTabs = new ArrayList<TypeCraftingTab>();
    protected final TabList typeTabList = new TabList(this.accessor);
    protected final LegacyScrollRenderer scrollRenderer = new LegacyScrollRenderer();
    protected final ScrollableRenderer scrollableRenderer = new ScrollableRenderer();
    private final Inventory inventory;
    private final boolean is2x2;
    private final int gridDimension;
    private final boolean[] warningSlots;
    protected Stocker.Sizeable infoType = new Stocker.Sizeable(Integer.valueOf(0), 2);
    protected ItemStack resultStack = ItemStack.EMPTY;
    protected List<List<RecipeInfo<CraftingRecipe>>> filteredRecipesByGroup = Collections.emptyList();
    protected int selectedCraftingButton;
    private boolean onlyCraftableRecipes = false;
    protected final ContainerListener listener = new ContainerListener(){

        public void slotChanged(AbstractContainerMenu abstractContainerMenu, int i, ItemStack itemStack) {
            LegacyIconHolder legacyIconHolder;
            if (LegacyCraftingScreen.this.typeTabList.getIndex() == 0) {
                if (LegacyCraftingScreen.this.onlyCraftableRecipes) {
                    LegacyCraftingScreen.this.filteredRecipesByGroup = LegacyCraftingScreen.this.recipesByTab.get((Integer)LegacyCraftingScreen.this.page.get() * LegacyCraftingScreen.this.getMaxTabCount() + LegacyCraftingScreen.this.craftingTabList.getIndex()).stream().map(l -> l.stream().filter(r -> RecipeMenu.canCraft(r.getOptionalIngredients(), LegacyCraftingScreen.this.inventory, abstractContainerMenu.getCarried())).toList()).filter(l -> !l.isEmpty()).toList();
                }
                LegacyCraftingScreen.this.craftingButtons.get(LegacyCraftingScreen.this.selectedCraftingButton).updateRecipeDisplay();
            } else if (LegacyCraftingScreen.this.getCraftingButtons().size() > LegacyCraftingScreen.this.selectedCraftingButton && (legacyIconHolder = LegacyCraftingScreen.this.getCraftingButtons().get(LegacyCraftingScreen.this.selectedCraftingButton)) instanceof CustomCraftingIconHolder) {
                CustomCraftingIconHolder h = (CustomCraftingIconHolder)legacyIconHolder;
                h.updateRecipe();
            }
        }

        public void dataChanged(AbstractContainerMenu abstractContainerMenu, int i, int j) {
        }
    };

    public LegacyCraftingScreen(LegacyCraftingMenu abstractContainerMenu, Inventory inventory, Component component, boolean is2x2) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
        this.inventory = inventory;
        this.is2x2 = is2x2;
        this.gridDimension = is2x2 ? 2 : 3;
        this.ingredientsGrid = new ArrayList(Collections.nCopies(this.gridDimension * this.gridDimension, Optional.empty()));
        this.container = new TransientCraftingContainer((AbstractContainerMenu)abstractContainerMenu, this.gridDimension, this.gridDimension);
        this.warningSlots = new boolean[this.gridDimension * this.gridDimension];
        if (Minecraft.getInstance().level == null) {
            return;
        }
        CraftingInput input = this.container.asCraftInput();
        List<RecipeInfo> allRecipes = CommonRecipeManager.byType((RecipeType)RecipeType.CRAFTING).stream().map(h -> {
            List<Optional<Ingredient>> list;
            ResourceKey resourceKey = h.id();
            CraftingRecipe craftingRecipe = (CraftingRecipe)h.value();
            Recipe patt0$temp = h.value();
            if (patt0$temp instanceof ShapedRecipe) {
                ShapedRecipe rcp = (ShapedRecipe)patt0$temp;
                list = LegacyCraftingMenu.updateShapedIngredients(new ArrayList<Optional<Ingredient>>(this.ingredientsGrid), LegacyCraftingMenu.getRecipeOptionalIngredients(rcp), this.gridDimension, rcp.getWidth(), rcp.getHeight());
            } else {
                Recipe patt1$temp = h.value();
                if (patt1$temp instanceof ShapelessRecipe) {
                    ShapelessRecipe r = (ShapelessRecipe)patt1$temp;
                    list = LegacyCraftingMenu.getRecipeOptionalIngredients(r);
                } else {
                    list = Collections.emptyList();
                }
            }
            return RecipeInfo.create(resourceKey, craftingRecipe, list, ((CraftingRecipe)h.value()).isSpecial() ? ItemStack.EMPTY : ((CraftingRecipe)h.value()).assemble((RecipeInput)input, (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()));
        }).filter(h -> h.getOptionalIngredients().size() <= this.ingredientsGrid.size()).toList();
        for (Object listing : Legacy4JClient.legacyCraftingListingManager.map().values()) {
            ArrayList groups = new ArrayList();
            ((LegacyCraftingTabListing)listing).craftings().values().forEach(l -> {
                if (l.isEmpty()) {
                    return;
                }
                ArrayList<RecipeInfo> group = new ArrayList<RecipeInfo>();
                l.forEach(v -> v.addRecipes(allRecipes, group::add));
                group.removeIf(i -> i.isInvalid() || i.getOptionalIngredients().size() > this.ingredientsGrid.size());
                if (!group.isEmpty()) {
                    groups.add(group);
                }
            });
            if (groups.isEmpty()) continue;
            this.recipesByTab.add(groups);
            this.craftingTabList.add(LegacyTabButton.Type.MIDDLE, listing.icon(), listing.nameOrEmpty(), t -> this.resetElements());
        }
        Collector<RecipeInfo, ?, Map<String, List<RecipeInfo>>> recipesByGroupsCollector = Collectors.groupingBy(h -> ((CraftingRecipe)h.get()).group().isEmpty() ? h.getId().toString() : ((CraftingRecipe)h.get()).group());
        if (((Boolean)LegacyOptions.vanillaTabs.get()).booleanValue()) {
            allRecipes.stream().collect(Collectors.groupingBy(h -> ((CraftingRecipe)h.get()).category(), () -> new TreeMap(Comparator.comparingInt(Enum::ordinal)), recipesByGroupsCollector)).forEach((category, m) -> {
                if (m.isEmpty()) {
                    return;
                }
                ArrayList groups = new ArrayList();
                m.values().forEach(l -> {
                    l.removeIf(i -> i.isInvalid() || i.getOptionalIngredients().size() > this.ingredientsGrid.size());
                    if (!l.isEmpty()) {
                        groups.add(l);
                    }
                });
                if (groups.isEmpty()) {
                    return;
                }
                this.recipesByTab.add(groups);
                this.craftingTabList.add(LegacyTabButton.Type.MIDDLE, LegacyTabButton.iconOf(VANILLA_CATEGORY_ICONS[category.ordinal()]), this.getTitle(), t -> this.resetElements());
            });
        }
        if (((Boolean)LegacyOptions.modCraftingTabs.get()).booleanValue()) {
            allRecipes.stream().collect(Collectors.groupingBy(h -> h.getId().getNamespace(), () -> new TreeMap(Comparator.naturalOrder()), recipesByGroupsCollector)).forEach((namespace, m) -> {
                ModInfo modInfo = FactoryAPIPlatform.getModInfo((String)namespace);
                if (modInfo == null || namespace.equals("minecraft") || namespace.equals("legacy") || m.isEmpty()) {
                    return;
                }
                ArrayList groups = new ArrayList();
                m.values().forEach(l -> {
                    l.removeIf(i -> i.isInvalid() || i.getOptionalIngredients().size() > this.ingredientsGrid.size());
                    if (!l.isEmpty()) {
                        groups.add(l);
                    }
                });
                if (groups.isEmpty()) {
                    return;
                }
                this.recipesByTab.add(groups);
                this.craftingTabList.add(LegacyTabButton.Type.MIDDLE, LegacyTabButton.iconOf(ModsScreen.modLogosCache.apply(modInfo)), (Component)Component.literal((String)modInfo.getName()), t -> this.resetElements());
            });
        }
        for (TypeCraftingTab value : Legacy4JClient.typeCraftingTabs.map().values()) {
            if (!value.isValid()) continue;
            if (value.is(TypeCraftingTab.CRAFTING)) {
                this.typeTabLists.add(this.craftingTabList);
            } else {
                TabList tabList = new TabList(this.accessor);
                this.typeTabLists.add(tabList);
                for (TypeCraftingTab.CustomTab tab : value.tabs()) {
                    if (!tab.allows2x2Grid() && is2x2) continue;
                    tabList.add(LegacyTabButton.Type.MIDDLE, tab.iconHolder().icon(), CommonComponents.EMPTY, t -> this.resetElements());
                }
            }
            this.typeTabs.add(value);
            this.typeTabList.add(42, 42, LegacyTabButton.Type.MIDDLE, value.icon(), value.nameOrEmpty(), b -> this.resetAll());
        }
        this.addCraftingButtons();
        this.resetElements(false);
        this.accessor.addStatic(UIDefinition.createBeforeInit(a -> {
            this.accessor.putStaticElement("is2x2", (Object)is2x2);
            this.accessor.putStaticElement("craftingButtons.count", (Object)this.getCraftingButtons().size());
        }));
        Consumer<CustomCraftingIconHolder> fireworkStarUpdateRecipe = h -> {
            LegacyCraftingScreen.clearIngredients(this.ingredientsGrid);
            if (this.fireworkStarButtons.isEmpty()) {
                return;
            }
            LegacyCraftingMenu.updateShapedIngredients(this.ingredientsGrid, List.of(Optional.empty(), Optional.of(FactoryIngredient.of((ItemStack[])new ItemStack[]{this.fireworkStarButtons.get((int)0).itemIcon}).toIngredient()), Optional.empty(), Optional.of(FireworkStarRecipeAccessor.getGunpowderIngredient())), this.gridDimension, 2, 2);
            this.fireworkStarButtons.forEach(CustomRecipeIconHolder::applyAddedIngredients);
            this.resultStack = this.fireworkStarButtons.get(0).hasItem() ? h.assembleCraftingResult((Level)this.minecraft.level, this.container) : Items.FIREWORK_STAR.getDefaultInstance();
            this.canCraft(this.ingredientsGrid, true);
        };
        Consumer<CustomCraftingIconHolder> fireworkStarFadeUpdateRecipe = h -> {
            LegacyCraftingScreen.clearIngredients(this.ingredientsGrid);
            if (this.fireworkStarFadeButtons.isEmpty()) {
                return;
            }
            ItemStack item = this.fireworkStarFadeButtons.get((int)0).itemIcon.isEmpty() ? Items.FIREWORK_STAR.getDefaultInstance() : this.fireworkStarFadeButtons.get((int)0).itemIcon.copyWithCount(1);
            LegacyCraftingMenu.updateShapedIngredients(this.ingredientsGrid, List.of(Optional.empty(), Optional.of(FactoryIngredient.of((ItemStack[])new ItemStack[]{this.fireworkStarFadeButtons.get((int)1).itemIcon}).toIngredient()), Optional.empty(), Optional.of(StackIngredient.of((boolean)true, (ItemStack)item))), this.gridDimension, 2, 2);
            this.fireworkStarFadeButtons.get(1).applyAddedIngredients();
            this.resultStack = this.fireworkStarFadeButtons.get((int)0).itemIcon.isEmpty() ? item : h.assembleCraftingResult((Level)Minecraft.getInstance().level, this.container);
            this.canCraft(this.ingredientsGrid, true);
        };
        Consumer<CustomCraftingIconHolder> fireworkRocketUpdateRecipe = h -> {
            LegacyCraftingScreen.clearIngredients(this.ingredientsGrid);
            if (this.fireworkButtons.isEmpty()) {
                return;
            }
            LegacyCraftingMenu.updateShapedIngredients(this.ingredientsGrid, List.of(Optional.empty(), Optional.of(FactoryIngredient.of((ItemStack[])new ItemStack[]{this.fireworkButtons.get((int)0).itemIcon}).toIngredient()), Optional.empty(), Optional.of(FireworkRocketRecipeAccessor.getPaperIngredient())), this.gridDimension, 2, 2);
            this.fireworkButtons.forEach(CustomRecipeIconHolder::applyAddedIngredients);
            this.resultStack = this.fireworkButtons.get(0).hasItem() ? h.assembleCraftingResult((Level)Minecraft.getInstance().level, this.container) : new ItemStack((ItemLike)Items.FIREWORK_ROCKET, 3);
            this.canCraft(this.ingredientsGrid, true);
        };
        Consumer<CustomCraftingIconHolder> dyeArmorUpdateRecipe = h -> {
            LegacyCraftingScreen.clearIngredients(this.ingredientsGrid);
            if (this.dyeArmorButtons.isEmpty()) {
                return;
            }
            ItemStack armor = this.dyeArmorButtons.get((int)0).itemIcon.isEmpty() ? Items.LEATHER_HELMET.getDefaultInstance() : this.dyeArmorButtons.get((int)0).itemIcon.copyWithCount(1);
            LegacyCraftingMenu.updateShapedIngredients(this.ingredientsGrid, List.of(Optional.empty(), Optional.of(Ingredient.of((ItemLike)this.dyeArmorButtons.get((int)1).itemIcon.getItem())), Optional.empty(), Optional.of(StackIngredient.of((boolean)true, (ItemStack)armor))), this.gridDimension, 2, 2);
            this.dyeArmorButtons.forEach(CustomRecipeIconHolder::applyAddedIngredients);
            this.resultStack = this.dyeArmorButtons.get((int)0).itemIcon.isEmpty() || !this.dyeArmorButtons.get(1).hasItem() ? armor : h.assembleCraftingResult((Level)Minecraft.getInstance().level, this.container);
            this.canCraft(this.ingredientsGrid, true);
        };
        Consumer<CustomCraftingIconHolder> dyeItemUpdateRecipe = h -> {
            LegacyCraftingScreen.clearIngredients(this.ingredientsGrid);
            if (this.dyeItemButtons.isEmpty()) {
                return;
            }
            ItemStack item = this.dyeItemButtons.get((int)0).itemIcon.isEmpty() ? Items.WHITE_BED.getDefaultInstance() : this.dyeItemButtons.get((int)0).itemIcon.copyWithCount(1);
            Optional<Ingredient> dyeIngredient = Optional.of(Ingredient.of((ItemLike)this.dyeItemButtons.get((int)1).itemIcon.getItem()));
            LegacyCraftingMenu.updateShapedIngredients(this.ingredientsGrid, List.of(Optional.empty(), dyeIngredient, Optional.empty(), Optional.of(StackIngredient.of((boolean)true, (ItemStack)item))), this.gridDimension, 2, 2);
            ItemStack itemStack = this.resultStack = this.dyeItemButtons.get((int)0).itemIcon.isEmpty() ? item : h.assembleCraftingResult((Level)Minecraft.getInstance().level, this.container);
            if (this.resultStack.isEmpty()) {
                this.resultStack = item;
                this.ingredientsGrid.set(this.ingredientsGrid.indexOf(dyeIngredient), Optional.of(new ImpossibleIngredient(this.dyeItemButtons.get((int)1).itemIcon)));
            }
            this.canCraft(this.ingredientsGrid, true);
        };
        List<ItemStack> dyes = Arrays.stream(DyeColor.values()).map(c -> DyeItem.byColor((DyeColor)c).getDefaultInstance()).toList();
        this.fireworkStarButtons.add(this.craftingButtonByList(LegacyComponents.COLOR_TAB, dyes, fireworkStarUpdateRecipe).enableAddIngredients());
        this.fireworkStarButtons.add(this.craftingButtonByList(LegacyComponents.SHAPE_TAB, FireworkStarRecipeAccessor.getShapeByItem().keySet().stream().map(ItemStack::new).toList(), fireworkStarUpdateRecipe).enableAddIngredients(h -> this.ingredientsGrid.stream().noneMatch(i -> i.isPresent() && Arrays.stream(FactoryIngredient.of((Ingredient)((Ingredient)i.get())).getStacks()).anyMatch(item -> FireworkStarRecipeAccessor.getShapeByItem().containsKey(item.getItem())))));
        this.fireworkStarButtons.add(this.craftingButtonByList(LegacyComponents.EFFECT_TAB, Stream.concat(Arrays.stream(FactoryIngredient.of((Ingredient)FireworkStarRecipeAccessor.getTwinkleIngredient()).getStacks()), Arrays.stream(FactoryIngredient.of((Ingredient)FireworkStarRecipeAccessor.getTrailIngredient()).getStacks())).toList(), fireworkStarUpdateRecipe).enableAddIngredients(h -> this.ingredientsGrid.stream().noneMatch(i -> i.isPresent() && ((Ingredient)i.get()).test(h.itemIcon))));
        this.fireworkStarFadeButtons.add(this.craftingButtonByPredicate(LegacyComponents.SELECT_STAR_TAB, i -> i.is(Items.FIREWORK_STAR), fireworkStarFadeUpdateRecipe));
        this.fireworkStarFadeButtons.add(this.craftingButtonByList(LegacyComponents.ADD_FADE_TAB, dyes, fireworkStarFadeUpdateRecipe).enableAddIngredients());
        this.fireworkButtons.add(this.craftingButtonByList(LegacyComponents.ADD_POWER_TAB, Arrays.stream(FactoryIngredient.of((Ingredient)FireworkRocketRecipeAccessor.getGunpowderIngredient()).getStacks()).toList(), fireworkRocketUpdateRecipe).enableAddIngredients(h -> this.ingredientsGrid.stream().filter(i -> i.isPresent() && ((Ingredient)i.get()).equals((Object)FireworkRocketRecipeAccessor.getGunpowderIngredient())).count() < 3L));
        this.fireworkButtons.add(this.craftingButtonByPredicate(LegacyComponents.SELECT_STAR_TAB, i -> i.is(Items.FIREWORK_STAR) && i.get(DataComponents.FIREWORK_EXPLOSION) != null, fireworkRocketUpdateRecipe).enableAddIngredients());
        this.dyeArmorButtons.add(this.craftingButtonByPredicate((Component)Component.translatable((String)"legacy.container.tab.armour"), i -> i.is(ItemTags.DYEABLE), dyeArmorUpdateRecipe));
        this.dyeArmorButtons.add(this.craftingButtonByList(LegacyComponents.COLOR_TAB, dyes, dyeArmorUpdateRecipe).enableAddIngredients());
        this.dyeItemButtons.add(this.craftingButtonByPredicate((Component)Component.translatable((String)"entity.minecraft.item"), i -> {
            BlockItem b;
            Item patt0$temp;
            return i.getItem() instanceof BedItem || (patt0$temp = i.getItem()) instanceof BlockItem && (b = (BlockItem)patt0$temp).getBlock() instanceof ShulkerBoxBlock || i.getItem() instanceof BundleItem;
        }, dyeItemUpdateRecipe));
        this.dyeItemButtons.add(this.craftingButtonByList(LegacyComponents.COLOR_TAB, dyes, dyeItemUpdateRecipe));
        if (!is2x2) {
            this.bannerButtons.add(this.craftingButtonByRecipes(LegacyComponents.CREATE_BANNER_TAB, Arrays.stream(DyeColor.values()).flatMap(c -> allRecipes.stream().filter(new RecipeInfo.Filter.ItemId(BuiltInRegistries.ITEM.getKey((Object)BannerBlock.byColor((DyeColor)c).asItem())))).toList()));
        }
        this.bannerButtons.add(this.craftingButtonByPredicate(LegacyComponents.COPY_BANNER, i -> i.getItem() instanceof BannerItem && LegacyItemUtil.hasValidPatterns(i), h -> {
            LegacyCraftingScreen.clearIngredients(this.ingredientsGrid);
            if (this.bannerButtons.isEmpty() || h.itemIcon.isEmpty()) {
                return;
            }
            LegacyCraftingMenu.updateShapedIngredients(this.ingredientsGrid, List.of(Optional.empty(), Optional.empty(), Optional.of(StackIngredient.of((boolean)true, (ItemStack)h.itemIcon.getItem().getDefaultInstance())), Optional.of(StackIngredient.of((boolean)true, (ItemStack)h.itemIcon.copyWithCount(1)))), this.gridDimension, 2, 2);
            this.resultStack = h.itemIcon.copyWithCount(1);
            this.canCraft(this.ingredientsGrid, true);
        }));
        Consumer<CustomCraftingIconHolder> decorateShieldUpdateRecipe = h -> {
            LegacyCraftingScreen.clearIngredients(this.ingredientsGrid);
            if (this.decorateShieldButtons.isEmpty()) {
                return;
            }
            ItemStack inputStack = this.decorateShieldButtons.get((int)0).itemIcon.isEmpty() ? Items.SHIELD.getDefaultInstance() : this.decorateShieldButtons.get((int)0).itemIcon.copyWithCount(1);
            LegacyCraftingMenu.updateShapedIngredients(this.ingredientsGrid, List.of(Optional.empty(), Optional.empty(), Optional.of(StackIngredient.of((boolean)true, (ItemStack)inputStack.copy())), Optional.of(StackIngredient.of((boolean)true, (ItemStack)(this.decorateShieldButtons.get((int)1).itemIcon.isEmpty() ? Items.WHITE_BANNER.getDefaultInstance() : this.decorateShieldButtons.get((int)1).itemIcon.copyWithCount(1))))), this.gridDimension, 2, 2);
            this.resultStack = this.decorateShieldButtons.get((int)0).itemIcon.isEmpty() ? inputStack : h.assembleCraftingResult((Level)this.minecraft.level, this.container);
            this.canCraft(this.ingredientsGrid, true);
        };
        this.decorateShieldButtons.add(this.craftingButtonByPredicate(LegacyComponents.SELECT_SHIELD, i -> i.getItem() instanceof ShieldItem && LegacyItemUtil.getPatternsCount(i) == 0, decorateShieldUpdateRecipe));
        this.decorateShieldButtons.add(this.craftingButtonByPredicate(LegacyComponents.SELECT_BANNER_TAB, i -> i.getItem() instanceof BannerItem, decorateShieldUpdateRecipe));
        this.decoratedPotButtons.add(this.craftingButtonByList(LegacyComponents.ADD_SHERD, DecoratedPotPatterns.ITEM_TO_POT_TEXTURE.keySet().stream().map(Item::getDefaultInstance).toList(), h -> {
            LegacyCraftingScreen.clearIngredients(this.ingredientsGrid);
            if (is2x2) {
                return;
            }
            Function<Integer, Item> sherdByIndex = i -> h.addedIngredientsItems.size() > i ? ((ItemStack)h.addedIngredientsItems.get((int)i)).getItem() : Items.BRICK;
            LegacyCraftingMenu.updateShapedIngredients(this.ingredientsGrid, List.of(Optional.empty(), Optional.of(Ingredient.of((ItemLike)((ItemLike)sherdByIndex.apply(0)))), Optional.empty(), Optional.of(Ingredient.of((ItemLike)((ItemLike)sherdByIndex.apply(1)))), Optional.empty(), Optional.of(Ingredient.of((ItemLike)((ItemLike)sherdByIndex.apply(2)))), Optional.empty(), Optional.of(Ingredient.of((ItemLike)((ItemLike)sherdByIndex.apply(3))))), this.gridDimension, 3, 3);
            this.resultStack = h.assembleCraftingResult((Level)this.minecraft.level, this.container);
            this.canCraft(this.ingredientsGrid, true);
        }).enableAddIngredients(h -> h.addedIngredientsItems.size() < 4));
    }

    public static LegacyCraftingScreen craftingScreen(LegacyCraftingMenu abstractContainerMenu, Inventory inventory, Component component) {
        return new LegacyCraftingScreen(abstractContainerMenu, inventory, component, false);
    }

    public static LegacyCraftingScreen playerCraftingScreen(LegacyCraftingMenu abstractContainerMenu, Inventory inventory, Component component) {
        return new LegacyCraftingScreen(abstractContainerMenu, inventory, component, true);
    }

    public static boolean canCraft(List<ItemStack> compactItemStackList, List<Optional<Ingredient>> ings, boolean[] warningSlots) {
        boolean canCraft = true;
        boolean isAllEmpty = true;
        block0: for (int i1 = 0; i1 < ings.size(); ++i1) {
            Optional<Ingredient> ing = ings.get(i1);
            if (ing.isEmpty()) continue;
            isAllEmpty = false;
            block1: for (int c = 0; c < FactoryIngredient.of((Ingredient)ing.get()).getCount(); ++c) {
                for (ItemStack itemStack : compactItemStackList) {
                    if (itemStack.isEmpty() || !ing.get().test(itemStack.copyWithCount(1))) continue;
                    itemStack.shrink(1);
                    if (warningSlots == null) continue block1;
                    warningSlots[i1] = false;
                    continue block1;
                }
                canCraft = false;
                if (warningSlots == null) break block0;
                warningSlots[i1] = true;
            }
        }
        return canCraft && !isAllEmpty;
    }

    public static void clearIngredients(List<Optional<Ingredient>> ingredientsGrid) {
        for (int i = 0; i < ingredientsGrid.size(); ++i) {
            if (!ingredientsGrid.get(i).isPresent()) continue;
            ingredientsGrid.set(i, Optional.empty());
        }
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        ControlTooltip.setupDefaultButtons(renderer, (Screen)this);
        ControlTooltip.Event.super.addControlTooltips(renderer);
        renderer.add(() -> ControlTooltip.EXTRA.get(), () -> {
            Component component;
            if (this.typeTabList.getIndex() == 0) {
                component = LegacyComponents.INFO;
                return component;
            } else {
                GuiEventListener patt0$temp = this.getFocused();
                if (!(patt0$temp instanceof CustomCraftingIconHolder)) return null;
                CustomCraftingIconHolder h = (CustomCraftingIconHolder)patt0$temp;
                if (h.addedIngredientsItems == null) return null;
                if (h.addedIngredientsItems.isEmpty()) return null;
                component = LegacyComponents.REMOVE;
            }
            return component;
        }).add(() -> ControlTooltip.OPTION.get(), () -> this.typeTabList.getIndex() == 0 ? (this.onlyCraftableRecipes ? LegacyComponents.ALL_RECIPES : LegacyComponents.SHOW_CRAFTABLE_RECIPES) : ControlTooltip.getKeyMessage(79, (Screen)this)).add(() -> ControlTooltip.CONTROL_TYPE.get(), () -> this.hasTypeTabList() ? LegacyComponents.TYPE : null).add(() -> ControlTooltip.CONTROL_TAB.get(), () -> LegacyComponents.GROUP).add(() -> ControlTooltip.CONTROL_PAGE.get(), () -> this.page.max > 0 && this.typeTabList.getIndex() == 0 ? LegacyComponents.PAGE : null);
    }

    public void resetElements() {
        this.resetElements(true);
    }

    public void resetElements(boolean reposition) {
        if (!reposition) {
            this.listener.slotChanged(this.menu, -1, ItemStack.EMPTY);
        }
        this.selectedCraftingButton = 0;
        this.infoType.set(Integer.valueOf(0));
        this.craftingButtonsOffset.set(Integer.valueOf(0));
        if (this.typeTabList.getIndex() == 0) {
            this.craftingButtons.get(this.selectedCraftingButton).invalidateFocused();
        }
        if (reposition) {
            this.repositionElements();
        }
    }

    public void resetAll() {
        this.resetElements();
        this.getTabList().resetSelectedTab();
    }

    protected CustomCraftingIconHolder craftingButtonByRecipes(final Component displayName, final List<RecipeInfo<CraftingRecipe>> recipes) {
        final List<ItemStack> results = recipes.stream().map(RecipeInfo::getResultItem).toList();
        return new CustomCraftingIconHolder(results.get(0)){

            @Override
            public Component getDisplayName() {
                return displayName;
            }

            @Override
            public ItemStack nextItem() {
                return this.nextItem(results);
            }

            @Override
            public ItemStack previousItem() {
                return this.previousItem(results);
            }

            @Override
            public int findInventoryMatchSlot() {
                return -1;
            }

            @Override
            public void updateRecipe() {
                LegacyCraftingScreen.this.scrollableRenderer.resetScrolled();
                LegacyCraftingScreen.this.ingredientsGrid.clear();
                LegacyCraftingScreen.this.ingredientsGrid.addAll(((RecipeInfo)recipes.get(results.indexOf(this.itemIcon))).getOptionalIngredients());
                LegacyCraftingScreen.this.resultStack = this.itemIcon.copyWithCount(1);
                LegacyCraftingScreen.this.canCraft(LegacyCraftingScreen.this.ingredientsGrid, true);
            }

            @Override
            protected boolean hasItem(ItemStack stack) {
                return LegacyCraftingScreen.this.canCraft(((RecipeInfo)recipes.get(results.indexOf(stack))).getOptionalIngredients(), false);
            }

            @Override
            public void craft(InputWithModifiers input) {
                LegacySoundUtil.playSimpleUISound(SoundEvents.ITEM_PICKUP, 1.0f);
                CommonNetwork.sendToServer((CommonNetwork.Payload)new ServerMenuCraftPayload((RecipeInfo)recipes.get(results.indexOf(this.itemIcon)), input.hasShiftDown() || ControllerBinding.LEFT_STICK_BUTTON.state().pressed));
            }
        };
    }

    protected CustomCraftingIconHolder craftingButtonByList(final Component displayName, final List<ItemStack> itemStacks, final Consumer<CustomCraftingIconHolder> updateRecipe) {
        return new CustomCraftingIconHolder(itemStacks.get(0)){

            @Override
            public Component getDisplayName() {
                return displayName;
            }

            @Override
            public ItemStack nextItem() {
                return this.nextItem(itemStacks);
            }

            @Override
            public ItemStack previousItem() {
                return this.previousItem(itemStacks);
            }

            @Override
            public int findInventoryMatchSlot() {
                for (int i = 0; i < ((LegacyCraftingMenu)((LegacyCraftingScreen)LegacyCraftingScreen.this).menu).slots.size(); ++i) {
                    if (!((Slot)((LegacyCraftingMenu)((LegacyCraftingScreen)LegacyCraftingScreen.this).menu).slots.get(i)).getItem().is(this.itemIcon.getItem())) continue;
                    return i;
                }
                return 0;
            }

            @Override
            public void updateRecipe() {
                LegacyCraftingScreen.this.scrollableRenderer.resetScrolled();
                updateRecipe.accept(this);
            }
        };
    }

    protected CustomCraftingIconHolder craftingButtonByPredicate(final Component displayName, final Predicate<ItemStack> isValid, final Consumer<CustomCraftingIconHolder> updateRecipe) {
        return new CustomCraftingIconHolder(){

            @Override
            public Component getDisplayName() {
                return displayName;
            }

            @Override
            public ItemStack nextItem() {
                return this.nextItem(LegacyCraftingScreen.this.inventory, isValid);
            }

            @Override
            public ItemStack previousItem() {
                return this.previousItem(LegacyCraftingScreen.this.inventory, isValid);
            }

            @Override
            public boolean applyNextItemIfAbsent() {
                return true;
            }

            @Override
            public int findInventoryMatchSlot() {
                for (int i = 0; i < ((LegacyCraftingMenu)((LegacyCraftingScreen)LegacyCraftingScreen.this).menu).slots.size(); ++i) {
                    if (((Slot)((LegacyCraftingMenu)((LegacyCraftingScreen)LegacyCraftingScreen.this).menu).slots.get(i)).getItem() != this.itemIcon) continue;
                    return i;
                }
                this.itemIcon = this.nextItem;
                return this.itemIcon.isEmpty() ? 0 : this.findInventoryMatchSlot();
            }

            @Override
            void updateRecipe() {
                updateRecipe.accept(this);
            }
        };
    }

    public void setFocused(@Nullable GuiEventListener guiEventListener) {
        if (guiEventListener instanceof TabList) {
            return;
        }
        super.setFocused(guiEventListener);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int i, int j) {
        LegacyIconHolder legacyIconHolder;
        Component component;
        if (this.getTabList() == this.craftingTabList) {
            component = this.getTabList().tabButtons.get(this.getTabList().getIndex()).getMessage();
        } else {
            LegacyIconHolder legacyIconHolder2 = this.getCraftingButtons().get(this.selectedCraftingButton);
            if (legacyIconHolder2 instanceof CustomCraftingIconHolder) {
                CustomCraftingIconHolder h = (CustomCraftingIconHolder)legacyIconHolder2;
                component = h.getDisplayName();
            } else {
                component = CommonComponents.EMPTY;
            }
        }
        Component title = component;
        LegacyFontUtil.applySDFont(b -> guiGraphics.drawString(this.font, title, ((this.typeTabList.getIndex() == 0 ? this.imageWidth : this.imageWidth / 2) - this.font.width((FormattedText)title)) / 2, this.accessor.getInteger("title.y", 17), ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false));
        int inventoryPanelX = this.accessor.getInteger("inventoryPanel.x", 176);
        int bottomPanelY = this.accessor.getInteger("bottomPanel.y", 103);
        int inventoryPanelWidth = this.accessor.getInteger("inventoryPanel.width", 163);
        int bottomPanelHeight = this.accessor.getInteger("bottomPanel.height", 105);
        if ((Integer)this.infoType.get() <= 0) {
            LegacyFontUtil.applySDFont(b -> guiGraphics.drawString(this.font, this.playerInventoryTitle, inventoryPanelX + (inventoryPanelWidth - this.font.width((FormattedText)this.playerInventoryTitle)) / 2, bottomPanelY + this.accessor.getInteger("inventoryTitle.y", 11), ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false));
        } else if (this.selectedCraftingButton < this.getCraftingButtons().size() && (legacyIconHolder = this.getCraftingButtons().get(this.selectedCraftingButton)) instanceof RecipeIconHolder) {
            RecipeIconHolder h = (RecipeIconHolder)legacyIconHolder;
            if ((Integer)this.infoType.get() == 1 && LegacyTipManager.hasTip(h.getFocusedResult())) {
                LegacyFontUtil.applySDFont(b -> {
                    List l = this.font.split((FormattedText)LegacyTipManager.getTipComponent(h.getFocusedResult()), inventoryPanelWidth - 11);
                    int lineSpacing = b != false ? 8 : 12;
                    this.scrollableRenderer.lineHeight = lineSpacing;
                    int lineAmount = (bottomPanelHeight - 21) / lineSpacing;
                    this.scrollableRenderer.scrolled.max = Math.max(0, l.size() - lineAmount);
                    this.scrollableRenderer.render(guiGraphics, inventoryPanelX + 5, bottomPanelY + 2, inventoryPanelWidth - 11, lineAmount * lineSpacing + 2, () -> {
                        for (int i1 = 0; i1 < l.size(); ++i1) {
                            guiGraphics.drawString(this.font, (FormattedCharSequence)l.get(i1), inventoryPanelX + 5, bottomPanelY + 5 + i1 * (b != false ? 8 : 12), ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
                        }
                    });
                });
            } else if ((Integer)this.infoType.get() == 2) {
                LegacyFontUtil.applySDFont(b -> guiGraphics.drawString(this.font, LegacyComponents.INGREDIENTS, inventoryPanelX + (inventoryPanelWidth - this.font.width((FormattedText)LegacyComponents.INGREDIENTS)) / 2, bottomPanelY + this.accessor.getInteger("ingredientsTitle.y", 5), ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false));
                if (h.getFocusedRecipe() != null) {
                    int ingredientSize = this.accessor.getInteger("ingredientSlot.size", 14);
                    int ingredientX = inventoryPanelX + this.accessor.getInteger("ingredientSlot.x", 4);
                    int ingredientY = bottomPanelY + this.accessor.getInteger("ingredientSlot.y", 21);
                    float textScale = LegacyOptions.getUIMode().isFHD() ? 0.6666667f : (LegacyOptions.getUIMode().isSD() ? 0.5f : 1.0f);
                    this.compactItemStackList.clear();
                    RecipeMenu.handleCompactItemStackList(this.compactItemStackList, () -> h.getFocusedRecipe().getOptionalIngredients().stream().map(RecipeIconHolder::getActualItem).iterator());
                    this.scrollableRenderer.scrolled.max = Math.max(0, this.compactItemStackList.size() - 4);
                    this.scrollableRenderer.lineHeight = ingredientSize + 1;
                    this.scrollableRenderer.render(guiGraphics, inventoryPanelX + 2, ingredientY - 2, inventoryPanelWidth - 11, (ingredientSize + 1) * 4 + 1, () -> {
                        for (int i1 = 0; i1 < this.compactItemStackList.size(); ++i1) {
                            ItemStack ing = this.compactItemStackList.get(i1);
                            LegacyRenderUtil.iconHolderRenderer.itemHolder(ingredientX, ingredientY + (ingredientSize + 1) * i1, ingredientSize, ingredientSize, ing, false, Vec2.ZERO).render(guiGraphics, i, j, 0.0f);
                            guiGraphics.pose().pushMatrix();
                            guiGraphics.pose().translate((float)(ingredientX + ingredientSize + this.accessor.getInteger("ingredientText.x", 4)), (float)(ingredientY + ingredientSize / 2 + (ingredientSize + 1) * i1));
                            LegacyFontUtil.applyFontOverrideIf(LegacyOptions.getUIMode().isHD(), LegacyFontUtil.MOJANGLES_11_FONT, b -> {
                                guiGraphics.pose().scale(textScale);
                                guiGraphics.pose().translate(0.0f, -3.0f);
                                LegacyRenderUtil.renderScrollingString(guiGraphics, this.font, ing.getHoverName(), 0, -2, Math.round((float)(inventoryPanelWidth - 22 - 2) / textScale), 7, (int)((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()), false);
                            });
                            guiGraphics.pose().popMatrix();
                        }
                    });
                }
            }
        }
    }

    public void renderContents(GuiGraphics guiGraphics, int i, int j, float f) {
        super.renderContents(guiGraphics, i, j, f);
        this.getCraftingButtons().forEach(b -> b.render(guiGraphics, i, j, 0.0f));
        if (this.selectedCraftingButton < this.getCraftingButtons().size()) {
            this.getCraftingButtons().get(this.selectedCraftingButton).renderSelection(guiGraphics, i, j, 0.0f);
        }
    }

    @Override
    public void bindingStateTick(BindingState state) {
        if (state.pressed && state.canClick()) {
            if ((state.is(ControllerBinding.LEFT_TRIGGER) || state.is(ControllerBinding.RIGHT_TRIGGER)) && this.hasTypeTabList()) {
                this.typeTabList.controlTab(state.is(ControllerBinding.LEFT_TRIGGER), state.is(ControllerBinding.RIGHT_TRIGGER));
            }
            if (state.is(ControllerBinding.RIGHT_STICK) && state instanceof BindingState.Axis) {
                BindingState.Axis s = (BindingState.Axis)state;
                if (this.typeTabList.getIndex() == 0) {
                    this.craftingTabList.controlPage(this.page, s.x < 0.0f && -s.x > Math.abs(s.y), s.x > 0.0f && s.x > Math.abs(s.y));
                }
            }
        }
    }

    @Override
    public int getTabYOffset() {
        return this.accessor.getInteger("tabYOffset", 18);
    }

    @Override
    public int getTabXOffset() {
        return this.hasTypeTabList() ? 21 : 0;
    }

    protected void init() {
        int count;
        this.resultStack = ItemStack.EMPTY;
        this.imageWidth = 348;
        this.imageHeight = 215;
        super.init();
        LegacySlotDisplay display = new LegacySlotDisplay(){

            @Override
            public int getWidth() {
                return 16;
            }

            @Override
            public Vec2 getOffset() {
                return ((LegacyCraftingMenu)((LegacyCraftingScreen)LegacyCraftingScreen.this).menu).inventoryOffset;
            }

            @Override
            public boolean isVisible() {
                return ((LegacyCraftingMenu)((LegacyCraftingScreen)LegacyCraftingScreen.this).menu).inventoryActive;
            }
        };
        for (int i2 = 0; i2 < 36; ++i2) {
            Slot s = (Slot)((LegacyCraftingMenu)this.menu).slots.get(i2);
            if (i2 < 27) {
                LegacySlotDisplay.override(s, 186 + (s.getContainerSlot() - 9) % 9 * 16, 133 + (s.getContainerSlot() - 9) / 9 * 16, display);
                continue;
            }
            LegacySlotDisplay.override(s, 186 + s.getContainerSlot() * 16, 186, display);
        }
        this.leftPos += this.getTabXOffset();
        this.topPos += this.getTabYOffset();
        ((LegacyCraftingMenu)this.menu).addSlotListener(this.listener);
        ((LegacyCraftingMenu)this.menu).inventoryActive = (Integer)this.infoType.get() <= 0;
        this.accessor.putBearer("isInventoryActive", Bearer.of(() -> ((LegacyCraftingMenu)this.menu).inventoryActive, b -> {
            ((LegacyCraftingMenu)this.menu).inventoryActive = b;
        }));
        ((LegacyCraftingMenu)this.menu).inventoryOffset = (Vec2)this.accessor.getElementValue("inventoryOffset", (Object)LegacyCraftingMenu.DEFAULT_INVENTORY_OFFSET, Vec2.class);
        if (this.hasTypeTabList()) {
            this.addWidget(this.typeTabList);
        }
        if (this.selectedCraftingButton < (count = this.getCraftingButtons().size())) {
            this.setFocused(this.getCraftingButtons().get(this.selectedCraftingButton));
        }
        int craftingButtonsX = this.accessor.getInteger("craftingButtons.x", 13);
        int craftingButtonsY = this.accessor.getInteger("craftingButtons.y", 38);
        int craftingButtonsSize = this.accessor.getInteger("craftingButtons.size", 27);
        if (this.typeTabList.getIndex() == 0 || !this.hasTypeTabList()) {
            this.craftingButtonsOffset.max = Math.max(0, this.recipesByTab.get((Integer)this.page.get() * this.getMaxTabCount() + this.craftingTabList.getIndex()).size() - 12);
            this.craftingButtons.forEach(b -> {
                b.width = b.height = craftingButtonsSize;
                b.setPos(this.leftPos + craftingButtonsX + this.craftingButtons.indexOf(b) * b.width, this.topPos + craftingButtonsY);
                this.addWidget((GuiEventListener)b);
            });
        } else {
            int slotX = this.accessor.getInteger("customCraftingButtons.x", count == 1 ? 77 : (count == 2 ? 52 : (count == 3 ? 21 : 8)));
            int xOffset = this.accessor.getInteger("customCraftingButtons.offset.x", count == 2 ? 35 : (count == 3 ? 28 : 18));
            this.getCraftingButtons().forEach(b -> {
                b.width = b.height = craftingButtonsSize;
                int index = this.getCraftingButtons().indexOf(b);
                b.setPos(this.leftPos + slotX + index * (b.width + xOffset), this.topPos + craftingButtonsY);
                if (count == 3) {
                    b.offset = new Vec2((LegacyRenderUtil.hasHorizontalArtifacts() ? 0.0125f : 0.0f) + 0.5f + (float)index * 0.5f, 0.0f);
                }
                b.init();
                this.addWidget((GuiEventListener)b);
            });
        }
        this.addWidget(this.getTabList());
        this.getTabList().init(this.leftPos, this.topPos - 37, this.imageWidth, 43, (t, i) -> {
            int index = this.getTabList().tabButtons.indexOf(t);
            t.type = LegacyTabButton.Type.bySize(index, this.getMaxTabCount());
            t.setWidth(this.accessor.getInteger("tabList.buttonWidth", 51));
            t.offset = t1 -> new Vec2((LegacyRenderUtil.hasHorizontalArtifacts() && index % 2 != 0 ? 0.0125f : 0.0f) + this.accessor.getFloat("tabList.buttonOffset.x", -1.5f) * (float)index, t1.selected ? 0.0f : this.accessor.getFloat("tabList.selectedOffset.y", 4.4f));
        });
        if (this.hasTypeTabList()) {
            this.typeTabList.init((b, i) -> {
                b.setWidth(this.accessor.getInteger("typeTabList.buttonWidth", 42));
                b.setHeight(this.accessor.getInteger("typeTabList.height", 42));
                b.spriteRender = (LegacyTabButton.Render)this.accessor.getElementValue("typeTabList.sprites", (Object)LegacyTabButton.ToggleableTabSprites.VERTICAL, LegacyTabButton.Render.class);
                b.setX(this.leftPos - b.getWidth() + 6);
                b.setY(this.topPos + i + 4);
                b.offset = t1 -> new Vec2(t1.selected ? 0.0f : 3.4f, 0.4f);
            }, true);
        }
        this.listener.slotChanged(this.menu, -1, ItemStack.EMPTY);
    }

    @Override
    public TabList getTabList() {
        return this.hasTypeTabList() ? this.typeTabLists.get(Math.min(this.typeTabList.getIndex(), this.typeTabLists.size() - 1)) : this.craftingTabList;
    }

    public boolean hasTypeTabList() {
        return this.accessor.getBoolean("hasTypeTabList", Boolean.valueOf(true)) != false && !this.typeTabLists.isEmpty();
    }

    protected boolean canCraft(List<Optional<Ingredient>> ingredients, boolean isFocused) {
        this.compactItemStackList.clear();
        RecipeMenu.handleCompactInventoryList(this.compactItemStackList, this.inventory, ((LegacyCraftingMenu)this.menu).getCarried());
        return LegacyCraftingScreen.canCraft(this.compactItemStackList, isFocused ? this.ingredientsGrid : ingredients, isFocused ? this.warningSlots : null);
    }

    protected int getMaxTabCount() {
        return this.accessor.getInteger("maxTabCount", 7);
    }

    protected void addCraftingButtons() {
        for (int i = 0; i < 12; ++i) {
            final int index = i;
            RecipeIconHolder<CraftingRecipe> h = new RecipeIconHolder<CraftingRecipe>(this.leftPos + 13 + i * 27, this.topPos + 38){

                @Override
                public void render(GuiGraphics graphics, int i, int j, float f) {
                    if (this.isFocused()) {
                        LegacyCraftingScreen.this.selectedCraftingButton = index;
                    }
                    super.render(graphics, i, j, f);
                }

                @Override
                protected boolean canCraft(RecipeInfo<CraftingRecipe> rcp) {
                    if (rcp == null || LegacyCraftingScreen.this.onlyCraftableRecipes) {
                        return true;
                    }
                    return LegacyCraftingScreen.this.canCraft(rcp.getOptionalIngredients(), this.isFocused() && this.getFocusedRecipe() == rcp);
                }

                @Override
                protected List<RecipeInfo<CraftingRecipe>> getRecipes() {
                    List<List<RecipeInfo<CraftingRecipe>>> list = LegacyCraftingScreen.this.onlyCraftableRecipes ? LegacyCraftingScreen.this.filteredRecipesByGroup : LegacyCraftingScreen.this.recipesByTab.get((Integer)LegacyCraftingScreen.this.page.get() * LegacyCraftingScreen.this.getMaxTabCount() + LegacyCraftingScreen.this.craftingTabList.getIndex());
                    return list.size() <= (Integer)LegacyCraftingScreen.this.craftingButtonsOffset.get() + index ? Collections.emptyList() : list.get((Integer)LegacyCraftingScreen.this.craftingButtonsOffset.get() + index);
                }

                @Override
                public LegacyScrollRenderer getScrollRenderer() {
                    return LegacyCraftingScreen.this.scrollRenderer;
                }

                @Override
                protected void toggleCraftableRecipes(InputWithModifiers input) {
                    LegacyCraftingScreen.this.onlyCraftableRecipes = !LegacyCraftingScreen.this.onlyCraftableRecipes;
                    LegacyCraftingScreen.this.listener.slotChanged(LegacyCraftingScreen.this.menu, 0, ItemStack.EMPTY);
                }

                @Override
                public boolean keyPressed(KeyEvent keyEvent) {
                    if (this.controlCyclicNavigation(keyEvent.key(), index, LegacyCraftingScreen.this.craftingButtons, LegacyCraftingScreen.this.craftingButtonsOffset, LegacyCraftingScreen.this.scrollRenderer, (Screen)LegacyCraftingScreen.this)) {
                        return true;
                    }
                    if (keyEvent.key() == 88 && (LegacyCraftingScreen.this.typeTabList.getIndex() == 0 || LegacyCraftingScreen.this.hasTypeTabList())) {
                        LegacyCraftingScreen.this.infoType.add(1, true);
                        ((LegacyCraftingMenu)((LegacyCraftingScreen)LegacyCraftingScreen.this).menu).inventoryActive = (Integer)LegacyCraftingScreen.this.infoType.get() <= 0;
                        LegacySoundUtil.playSimpleUISound((SoundEvent)LegacyRegistries.FOCUS.get(), true);
                        return true;
                    }
                    return super.keyPressed(keyEvent);
                }

                @Override
                protected void updateRecipeDisplay(RecipeInfo<CraftingRecipe> rcp) {
                    LegacyCraftingScreen.this.scrollableRenderer.resetScrolled();
                    LegacyCraftingScreen.this.resultStack = this.getFocusedResult();
                    LegacyCraftingScreen.clearIngredients(LegacyCraftingScreen.this.ingredientsGrid);
                    if (rcp == null) {
                        return;
                    }
                    for (int i = 0; i < rcp.getOptionalIngredients().size(); ++i) {
                        LegacyCraftingScreen.this.ingredientsGrid.set(i, rcp.getOptionalIngredients().get(i));
                    }
                }

                @Override
                public void craft(InputWithModifiers input) {
                    LegacySoundUtil.playSimpleUISound(SoundEvents.ITEM_PICKUP, 1.0f);
                    super.craft(input);
                }
            };
            this.craftingButtons.add(h);
            h.offset = LegacyCraftingMenu.DEFAULT_INVENTORY_OFFSET;
        }
    }

    public boolean mouseScrolled(double d, double e, double f, double g) {
        if (this.getChildAt(d, e).filter(guiEventListener -> guiEventListener.mouseScrolled(d, e, f, g)).isPresent()) {
            return true;
        }
        if (super.mouseScrolled(d, e, f, g)) {
            return true;
        }
        if (this.scrollableRenderer.mouseScrolled(g)) {
            return true;
        }
        int scroll = (int)Math.signum(g);
        if (((Integer)this.craftingButtonsOffset.get() > 0 && scroll < 0 || scroll > 0 && this.craftingButtonsOffset.max > 0) && this.craftingButtonsOffset.add(scroll, false) != 0) {
            this.repositionElements();
            return true;
        }
        return false;
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBg(guiGraphics, f, i, j);
    }

    protected void renderBg(GuiGraphics guiGraphics, float f, int i, int j) {
        if (this.hasTypeTabList()) {
            this.typeTabList.render(guiGraphics, i, j, f);
        }
        this.getTabList().render(guiGraphics, i, j, f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(this.accessor.getResourceLocation("imageSprite", LegacySprites.SMALL_PANEL), this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        this.getTabList().renderSelected(guiGraphics, i, j, f);
        if (this.hasTypeTabList()) {
            this.typeTabList.renderSelected(guiGraphics, i, j, f);
        }
        int bottomPanelHeight = this.accessor.getInteger("bottomPanel.height", 105);
        int panelWidth = this.accessor.getInteger("craftingGridPanel.width", 163);
        int bottomPanelY = this.accessor.getInteger("bottomPanel.y", 103);
        int craftingGridPanelX = this.accessor.getInteger("craftingGridPanel.x", 9);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.leftPos + craftingGridPanelX, this.topPos + bottomPanelY, panelWidth, bottomPanelHeight);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.leftPos + this.accessor.getInteger("inventoryPanel.x", 176), this.topPos + bottomPanelY, this.accessor.getInteger("inventoryPanel.width", 163), bottomPanelHeight);
        int descriptionPanelWidth = this.accessor.getInteger("descriptionPanel.width", 163);
        int descriptionPanelHeight = this.accessor.getInteger("descriptionPanel.height", 93);
        int descriptionPanelX = this.accessor.getInteger("descriptionPanel.x", 176);
        int descriptionPanelY = this.accessor.getInteger("descriptionPanel.y", 8);
        if (this.typeTabList.getIndex() != 0 && this.hasTypeTabList()) {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.leftPos + descriptionPanelX, this.topPos + descriptionPanelY, descriptionPanelWidth, descriptionPanelHeight);
        }
        int slotSize = this.accessor.getInteger("craftingGridSlot.size", 23);
        int xDiff = this.leftPos + craftingGridPanelX;
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SMALL_ARROW, xDiff + this.accessor.getInteger("craftingArrow.x", 77) + (this.is2x2 ? 0 : slotSize / 2), this.topPos + bottomPanelY + this.accessor.getInteger("craftingArrow.y", 57), 16, 14);
        if (this.typeTabList.getIndex() == 0 || !this.hasTypeTabList()) {
            if ((Integer)this.craftingButtonsOffset.get() > 0) {
                this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.LEFT, this.leftPos + this.accessor.getInteger("horizontalScroll.x", 5), this.topPos + this.accessor.getInteger("horizontalScroll.y", 45));
            }
            if (this.craftingButtonsOffset.max > 0 && (Integer)this.craftingButtonsOffset.get() < this.craftingButtonsOffset.max) {
                this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.RIGHT, this.leftPos + this.imageWidth - 6 - this.accessor.getInteger("horizontalScroll.x", 5), this.topPos + this.accessor.getInteger("horizontalScroll.y", 45));
            }
        }
        int resultSlotSize = this.accessor.getInteger("craftingResultSlot.size", 36);
        int yDiff = this.topPos + bottomPanelY;
        int craftingGridSlotX = this.accessor.getInteger("craftingGridSlot.x", this.is2x2 ? 24 : 12);
        int craftingGridSlotY = this.accessor.getInteger("craftingGridSlot.y", 30);
        boolean anyWarning = false;
        for (int index = 0; index < this.ingredientsGrid.size(); ++index) {
            LegacyIconHolder holder = LegacyRenderUtil.iconHolderRenderer.itemHolder(xDiff + craftingGridSlotX + index % this.gridDimension * slotSize, yDiff + craftingGridSlotY + (this.is2x2 ? slotSize / 2 : 0) + index / this.gridDimension * slotSize, slotSize, slotSize, RecipeIconHolder.getActualItem(this.ingredientsGrid.get(index)), (!this.onlyCraftableRecipes || this.typeTabList.getIndex() != 0) && !RecipeIconHolder.getActualItem(this.ingredientsGrid.get(index)).isEmpty() && this.warningSlots[index], new Vec2(this.is2x2 ? 0.0f : (LegacyRenderUtil.hasHorizontalArtifacts() ? 0.4f : 0.5f), this.is2x2 ? 0.0f : 0.4f));
            if (holder.isWarning()) {
                anyWarning = true;
            }
            holder.render(guiGraphics, i, j, f);
            holder.renderTooltip(this.minecraft, guiGraphics, i, j);
        }
        LegacyIconHolder holder = LegacyRenderUtil.iconHolderRenderer.itemHolder(xDiff + this.accessor.getInteger("resultSlot.x", 104) + (this.is2x2 ? 0 : slotSize / 2), yDiff + this.accessor.getInteger("resultSlot.y", 48), resultSlotSize, resultSlotSize, this.resultStack, anyWarning, new Vec2(LegacyRenderUtil.hasHorizontalArtifacts() ? 0.4f : 0.5f, 0.0f));
        holder.render(guiGraphics, i, j, f);
        holder.renderTooltip(this.minecraft, guiGraphics, i, j);
        if (!this.resultStack.isEmpty()) {
            RecipeIconHolder h;
            RecipeIconHolder h2;
            LegacyIconHolder legacyIconHolder = this.getCraftingButtons().get(this.selectedCraftingButton);
            Component resultName = legacyIconHolder instanceof RecipeIconHolder && (h2 = (RecipeIconHolder)legacyIconHolder).isValidIndex() ? h2.getFocusedRecipe().getName() : this.resultStack.getHoverName();
            LegacyIconHolder legacyIconHolder2 = this.getCraftingButtons().get(this.selectedCraftingButton);
            Component description = legacyIconHolder2 instanceof RecipeIconHolder && (h = (RecipeIconHolder)legacyIconHolder2).isValidIndex() ? h.getFocusedRecipe().getDescription() : null;
            int titleY = bottomPanelY + this.accessor.getInteger("craftingTitle.y", 11) - (description == null ? 0 : 6);
            LegacyFontUtil.applySDFont(b -> LegacyRenderUtil.renderScrollingString(guiGraphics, this.font, resultName, xDiff + 2 + Math.max(panelWidth - this.font.width((FormattedText)resultName), 0) / 2, this.topPos + titleY, xDiff + panelWidth - 2, this.topPos + titleY + 11, (int)((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()), false));
            if (description != null) {
                LegacyFontUtil.applySDFont(b -> LegacyRenderUtil.renderScrollingString(guiGraphics, this.font, (Component)description.copy().setStyle(Style.EMPTY), xDiff + 2 + Math.max(panelWidth - this.font.width((FormattedText)description), 0) / 2, this.topPos + titleY + 12, xDiff + panelWidth - 2, this.topPos + titleY + 23, (int)((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()), false));
            }
            LegacyFontUtil.applySDFont(b -> {
                if (this.typeTabList.getIndex() != 0) {
                    int descriptionTextXOffset = this.accessor.getInteger("descriptionText.x", 4);
                    int descriptionTextYOffset = this.accessor.getInteger("descriptionText.y", 7);
                    int descriptionTextWidth = descriptionPanelWidth - descriptionTextXOffset * 2;
                    int lineSpacing = b != false ? 8 : 12;
                    this.scrollableRenderer.lineHeight = lineSpacing;
                    int lineAmount = (descriptionPanelHeight - descriptionTextYOffset * 2 - 7) / lineSpacing;
                    List<FormattedCharSequence> list = LegacyRenderUtil.getTooltip(this.resultStack, descriptionTextWidth);
                    this.scrollableRenderer.scrolled.max = Math.max(0, list.size() - lineAmount);
                    this.scrollableRenderer.render(guiGraphics, this.leftPos + descriptionPanelX + descriptionTextXOffset, this.topPos + descriptionPanelY + descriptionTextYOffset, descriptionTextWidth, lineAmount * lineSpacing, () -> {
                        for (int i1 = 0; i1 < list.size(); ++i1) {
                            FormattedCharSequence sequence = (FormattedCharSequence)list.get(i1);
                            guiGraphics.drawString(this.font, sink -> sequence.accept((i2, style, j1) -> sink.accept(i2, Style.EMPTY, j1)), this.leftPos + descriptionPanelX + descriptionTextXOffset, this.topPos + descriptionPanelY + descriptionTextYOffset + i1 * lineSpacing, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
                        }
                    });
                }
            });
        }
    }

    @Override
    public boolean disableCursorOnInit() {
        return true;
    }

    @Override
    public boolean onceClickBindings(BindingState state) {
        return !state.is(ControllerBinding.DOWN_BUTTON) && Controller.Event.super.onceClickBindings(state);
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        if (this.hasTypeTabList() && keyEvent.hasShiftDown() && this.typeTabList.controlTab(keyEvent.key())) {
            return true;
        }
        this.getTabList().controlTab(keyEvent.key());
        if (keyEvent.hasShiftDown() && this.typeTabList.getIndex() == 0 && this.craftingTabList.controlPage(this.page, keyEvent.isLeft(), keyEvent.isRight())) {
            return true;
        }
        return super.keyPressed(keyEvent);
    }

    public List<? extends LegacyIconHolder> getCraftingButtons() {
        TabList tabList = this.getTabList();
        if (!this.typeTabs.isEmpty()) {
            TypeCraftingTab tab = this.typeTabs.get(this.typeTabList.getIndex());
            if (tab.is(TypeCraftingTab.BANNER)) {
                return tabList.getIndex() == 0 ? this.bannerButtons : this.decorateShieldButtons;
            }
            if (tab.is(TypeCraftingTab.FIREWORK)) {
                return tabList.getIndex() == 0 ? this.fireworkStarButtons : (tabList.getIndex() == 1 ? this.fireworkStarFadeButtons : this.fireworkButtons);
            }
            if (tab.is(TypeCraftingTab.DYING)) {
                return tabList.getIndex() == 0 ? this.dyeArmorButtons : (tabList.getIndex() == 1 ? this.dyeItemButtons : this.decoratedPotButtons);
            }
        }
        return this.craftingButtons;
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        super.render(guiGraphics, i, j, f);
        this.getCraftingButtons().forEach(h -> h.renderTooltip(this.minecraft, guiGraphics, i, j));
        this.renderTooltip(guiGraphics, i, j);
    }

    protected abstract class CustomCraftingIconHolder
    extends CustomRecipeIconHolder {
        public CustomCraftingIconHolder(ItemStack itemStack) {
            super(itemStack);
        }

        public CustomCraftingIconHolder() {
        }

        @Override
        LegacyScrollRenderer getScrollRenderer() {
            return LegacyCraftingScreen.this.scrollRenderer;
        }

        @Override
        public boolean canCraft() {
            return LegacyCraftingScreen.this.canCraft(this.getIngredientsGrid(), false);
        }

        @Override
        public List<Optional<Ingredient>> getIngredientsGrid() {
            return LegacyCraftingScreen.this.ingredientsGrid;
        }

        @Override
        public void render(GuiGraphics graphics, int i, int j, float f) {
            if (this.isFocused()) {
                LegacyCraftingScreen.this.selectedCraftingButton = LegacyCraftingScreen.this.getCraftingButtons().indexOf(this);
            }
            super.render(graphics, i, j, f);
        }

        @Override
        public void craft(InputWithModifiers input) {
            LegacySoundUtil.playSimpleUISound(SoundEvents.ITEM_PICKUP, 1.0f);
            super.craft(input);
        }
    }
}

