/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.narration.NarrationThunk;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class MultilineTooltip
extends Tooltip {
    protected final List<FormattedCharSequence> lines;
    protected List<Component> narrationLines;

    public MultilineTooltip(List<FormattedCharSequence> message, Component narration) {
        super((Component)Component.empty(), narration);
        this.lines = message;
    }

    public MultilineTooltip(List<FormattedCharSequence> message) {
        this(message, (Component)Component.empty());
    }

    public MultilineTooltip(Component message, int width) {
        this(Minecraft.getInstance().font.split((FormattedText)message, width), message);
    }

    public MultilineTooltip(List<Component> content, int width) {
        this(content.stream().map(c -> Minecraft.getInstance().font.split((FormattedText)c, width)).flatMap(Collection::stream).toList());
    }

    public MultilineTooltip(int width, Component ... message) {
        this(Arrays.stream(message).toList(), width);
    }

    public void updateNarration(NarrationElementOutput narrationElementOutput) {
        if (this.narrationLines != null) {
            narrationElementOutput.add(NarratedElementType.HINT, NarrationThunk.from(this.narrationLines));
        } else {
            super.updateNarration(narrationElementOutput);
        }
    }

    public List<FormattedCharSequence> toCharSequence(Minecraft minecraft) {
        return this.lines;
    }
}

