/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CartographyTableMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.util.FactoryItemUtil;
import wily.legacy.inventory.RenameItemMenu;

@Mixin(value={CartographyTableMenu.class})
public abstract class CartographyTableMenuMixin
extends AbstractContainerMenu
implements RenameItemMenu {
    @Shadow
    @Final
    private ResultContainer resultContainer;
    @Shadow
    @Final
    private ContainerLevelAccess access;
    private String itemName;

    protected CartographyTableMenuMixin(@Nullable MenuType<?> menuType, int i) {
        super(menuType, i);
    }

    @Shadow
    public abstract void slotsChanged(Container var1);

    @Override
    public String getResultItemName() {
        return this.itemName;
    }

    @Override
    public void setResultItemName(String name) {
        this.itemName = name;
        this.slotsChanged((Container)this.resultContainer);
    }

    @Inject(method={"slotsChanged"}, at={@At(value="HEAD")})
    private void slotsChanged(Container container, CallbackInfo ci) {
        super.slotsChanged(container);
    }

    @Redirect(method={"slotsChanged"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isEmpty()Z", ordinal=2))
    private boolean slotsChangedIsSecondSlotEmpty(ItemStack instance) {
        return false;
    }

    @Redirect(method={"slotsChanged"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isEmpty()Z", ordinal=4))
    private boolean slotsChangedIsSecondSlotEmpty2(ItemStack instance) {
        return false;
    }

    @Inject(method={"setupResultSlot"}, at={@At(value="RETURN")})
    private void setupResultSlot(ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, CallbackInfo ci) {
        this.access.execute((level, blockPos) -> {
            MapItemSavedData data = MapItem.getSavedData((ItemStack)itemStack, (Level)level);
            if (data == null || data.locked) {
                return;
            }
            ItemStack result = this.resultContainer.getItem(0);
            if (this.resultContainer.getItem(0).isEmpty() && itemStack.is(Items.FILLED_MAP) && itemStack2.isEmpty()) {
                result = itemStack.copyWithCount(1);
                if (RenameItemMenu.validateName(this.itemName) != null) {
                    FactoryItemUtil.setCustomName((ItemStack)result, (Component)Component.literal((String)this.itemName));
                }
                this.resultContainer.setItem(0, result);
                return;
            }
            if (RenameItemMenu.validateName(this.itemName) != null) {
                if (!itemStack3.getHoverName().getString().equals(this.itemName)) {
                    FactoryItemUtil.setCustomName((ItemStack)result, (Component)Component.literal((String)this.itemName));
                    this.broadcastChanges();
                }
            } else if (FactoryItemUtil.hasCustomName((ItemStack)result)) {
                FactoryItemUtil.setCustomName((ItemStack)result, null);
                this.broadcastChanges();
            }
        });
    }
}

