/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.legacy.client.LegacyGamma;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacySaveCache;
import wily.legacy.entity.PlayerYBobbing;
import wily.legacy.util.client.LegacyRenderUtil;

@Mixin(value={GameRenderer.class})
public abstract class GameRendererMixin {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    private boolean hasWorldScreenshot;

    @Shadow
    protected abstract void takeAutoScreenshot(Path var1);

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/toasts/ToastManager;render(Lnet/minecraft/client/gui/GuiGraphics;)V", shift=At.Shift.AFTER)})
    private void render(CallbackInfo ci, @Local(ordinal=0) GuiGraphics graphics) {
        LegacyRenderUtil.renderGameOverlay(graphics);
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/render/GuiRenderer;render(Lcom/mojang/blaze3d/buffers/GpuBufferSlice;)V", shift=At.Shift.AFTER)})
    private void render(DeltaTracker deltaTracker, boolean bl, CallbackInfo ci) {
        if (this.minecraft.isGameLoadFinished() && ((Boolean)LegacyOptions.displayLegacyGamma.get()).booleanValue()) {
            LegacyGamma.INSTANCE.render();
        }
    }

    @Inject(method={"bobView"}, at={@At(value="RETURN")})
    private void bobView(PoseStack poseStack, float f, CallbackInfo ci) {
        float xAngle = PlayerYBobbing.getAngle(this.minecraft, f);
        if (xAngle != 0.0f) {
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(xAngle));
        }
    }

    @Inject(method={"shouldRenderBlockOutline"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderLevel(CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)LegacyOptions.displayHUD.get()).booleanValue()) {
            cir.setReturnValue((Object)false);
        }
    }

    @WrapWithCondition(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;renderItemInHand(FZLorg/joml/Matrix4f;)V")})
    private boolean renderLevel(GameRenderer instance, float matrix4fstack, boolean b, Matrix4f f) {
        return (Boolean)LegacyOptions.displayHand.get();
    }

    @ModifyExpressionValue(method={"tryTakeScreenshotIfNeeded"}, at={@At(value="FIELD", opcode=180, target="Lnet/minecraft/client/renderer/GameRenderer;hasWorldScreenshot:Z")})
    private boolean canTakeWorldIcon(boolean original) {
        return original && !LegacySaveCache.retakeWorldIcon;
    }

    @Redirect(method={"tryTakeScreenshotIfNeeded"}, at=@At(value="INVOKE", target="Ljava/util/Optional;ifPresent(Ljava/util/function/Consumer;)V"))
    private void tryTakeScreenshotIfNeeded(Optional<Path> instance, Consumer<? super Path> action) {
        instance.ifPresent(path -> {
            if (!LegacySaveCache.retakeWorldIcon && Files.isRegularFile(path, new LinkOption[0])) {
                this.hasWorldScreenshot = true;
            } else {
                this.takeAutoScreenshot((Path)path);
                LegacySaveCache.retakeWorldIcon = false;
            }
        });
    }
}

