/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.client.gui.screens.inventory.LecternScreen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.WidgetPanel;
import wily.legacy.util.LegacyComponents;

public class BookPanel
extends WidgetPanel {
    public BookPanel(Screen screen) {
        super(screen);
    }

    @Override
    public void init(String name) {
        super.init(name);
        this.size(201, 248);
        this.pos(this.centeredLeftPos(this.accessor.getScreen()), this.centeredTopPos(this.accessor.getScreen()) - 30);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.getX(), (float)this.getY(), 0.0f);
        guiGraphics.pose().scale((float)this.getWidth() / 146.0f, (float)this.getHeight() / 180.0f, 1.0f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(BookViewScreen.BOOK_LOCATION, 0, 0, 20, 1, 146, 180);
        guiGraphics.pose().popPose();
    }

    public boolean keyPressed(int i, int j, int k) {
        if (this.canTakeBook(i)) {
            Minecraft.getInstance().gameMode.handleInventoryButtonClick(Minecraft.getInstance().player.containerMenu.containerId, 3);
            return true;
        }
        return super.keyPressed(i, j, k);
    }

    public boolean canTakeBook(int key) {
        return key == 257 && this.accessor.getScreen() instanceof LecternScreen && Minecraft.getInstance().player.mayBuild();
    }

    public PageButton createLegacyPageButton(int i, int j, boolean bl, Button.OnPress onPress, boolean bl2) {
        return new PageButton(this, i, j, bl, onPress, bl2){
            private long lastPressTime;

            public void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
                this.isHovered = Util.getMillis() - this.lastPressTime <= 300L || this.isMouseOver(i, j);
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate((float)this.getX(), (float)this.getY(), 1.5f);
                guiGraphics.pose().scale(1.5f, 1.5f, 1.5f);
                guiGraphics.pose().translate((float)(-this.getX()), (float)(-this.getY()), 1.5f);
                super.renderWidget(guiGraphics, i, j, f);
                guiGraphics.pose().popPose();
            }

            public void onPress() {
                super.onPress();
                this.lastPressTime = Util.getMillis();
            }

            @Nullable
            public ComponentPath nextFocusPath(FocusNavigationEvent focusNavigationEvent) {
                return null;
            }

            public boolean isMouseOver(double d, double e) {
                return this.active && this.visible && d >= (double)this.getX() && e >= (double)this.getY() && d < (double)(this.getX() + this.getWidth() * 3 / 2) && e < (double)(this.getY() + this.getHeight() * 3 / 2);
            }
        };
    }

    @Override
    @Nullable
    public Component getAction(ControlTooltip.ActionHolder.Context context) {
        return this.isFocused() ? context.actionOfContext(ControlTooltip.ActionHolder.KeyContext.class, c -> this.canTakeBook(c.key()) ? LegacyComponents.TAKE_BOOK : null) : super.getAction(context);
    }
}

