/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.screens.NoticeWithLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.validation.ContentValidationException;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.PlayGameScreen;
import wily.legacy.util.LegacyComponents;

public class SaveOptionsScreen
extends ConfirmationScreen {
    protected final PlayGameScreen parent;
    private LevelSummary summary;

    public SaveOptionsScreen(PlayGameScreen parent, LevelSummary summary) {
        super(parent, 230, 129, LegacyComponents.SAVE_OPTIONS, LegacyComponents.SAVE_OPTIONS_MESSAGE, b -> {});
        this.parent = parent;
        this.summary = summary;
    }

    @Override
    protected void addButtons() {
        this.renderableVList.addRenderable((Renderable)Button.builder((Component)Component.translatable((String)"gui.cancel"), b -> this.minecraft.setScreen((Screen)this.parent)).bounds(this.panel.x + 15, this.panel.y + this.panel.height - 96, 200, 20).build());
        final EditBox renameBox = new EditBox(this.font, this.width / 2 - 100, 0, 200, 20, (Component)Component.translatable((String)"selectWorld.enterName"));
        renameBox.setValue(this.summary.getLevelName());
        this.renderableVList.addRenderable((Renderable)Button.builder((Component)Component.translatable((String)"legacy.menu.rename_save"), b -> this.minecraft.setScreen((Screen)new ConfirmationScreen(this, this.parent, 230, 121, (Component)Component.translatable((String)"legacy.menu.rename_save_title"), (Component)Component.translatable((String)"legacy.menu.rename_save_message"), p -> {
            String id = this.summary.getLevelId();
            try {
                LevelStorageSource.LevelStorageAccess levelStorageAccess = this.minecraft.getLevelSource().validateAndCreateAccess(id);
                levelStorageAccess.renameLevel(renameBox.getValue());
                levelStorageAccess.close();
                this.parent.saveRenderableList.reloadSaveList();
                this.minecraft.setScreen((Screen)this.parent);
            }
            catch (IOException iOException) {
                SystemToast.onWorldAccessFailure((Minecraft)this.minecraft, (String)id);
                this.parent.saveRenderableList.reloadSaveList();
            }
            catch (ContentValidationException contentValidationException) {
                Legacy4J.LOGGER.warn("{}", (Object)contentValidationException.getMessage());
                this.minecraft.setScreen(NoticeWithLinkScreen.createWorldSymlinkWarningScreen(() -> this.minecraft.setScreen((Screen)this.parent)));
            }
        }){

            @Override
            protected void init() {
                super.init();
                renameBox.setResponder(s -> {
                    this.okButton.active = !s.isBlank();
                });
                renameBox.setPosition(this.panel.x + 15, this.panel.y + 45);
                this.addRenderableWidget((GuiEventListener)renameBox);
            }
        })).bounds(this.panel.x + 15, this.panel.getRectangle().bottom() - 74, 200, 20).build());
        this.renderableVList.addRenderable((Renderable)Button.builder((Component)Component.translatable((String)"selectWorld.delete"), b -> this.minecraft.setScreen((Screen)new ConfirmationScreen((Screen)this.parent, (Component)Component.translatable((String)"selectWorld.delete"), (Component)Component.translatable((String)"selectWorld.deleteQuestion"), b1 -> this.parent.saveRenderableList.deleteSave(this.summary)))).bounds(this.panel.x + 15, this.panel.getRectangle().bottom() - 52, 200, 20).build());
        this.renderableVList.addRenderable((Renderable)Button.builder((Component)Component.translatable((String)"legacy.menu.copySave"), b -> this.minecraft.setScreen((Screen)new ConfirmationScreen((Screen)this.parent, (Component)Component.translatable((String)"legacy.menu.copySave"), (Component)Component.translatable((String)"legacy.menu.copySaveMessage"), b1 -> {
            String id = this.summary.getLevelId();
            Legacy4JClient.copySaveFile(this.minecraft.getLevelSource().getBaseDir().resolve(id), this.minecraft.getLevelSource(), id);
            this.parent.saveRenderableList.reloadSaveList();
            this.minecraft.setScreen((Screen)this.parent);
        }))).bounds(this.panel.x + 15, this.panel.getRectangle().bottom() - 30, 200, 20).build());
    }
}

