/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.Arrays;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.network.chat.Component;
import wily.legacy.client.CommonColor;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.LegacySliderButton;
import wily.legacy.client.screen.PlayGameScreen;

public class ServerEditScreen
extends ConfirmationScreen {
    protected EditBox nameBox;
    protected EditBox ipBox;
    private final ServerData serverData;

    public ServerEditScreen(PlayGameScreen parent, ServerData serverData, boolean add) {
        super(parent, 230, 187, (Component)Component.translatable((String)"addServer.title"), (Component)Component.translatable((String)"addServer.enterName"), b -> {});
        this.serverData = serverData;
        this.okAction = s -> {
            serverData.name = this.nameBox.getValue();
            serverData.ip = this.ipBox.getValue();
            if (add) {
                ServerData data = parent.getServers().unhide(serverData.ip);
                if (data != null) {
                    data.copyNameIconFrom(serverData);
                } else {
                    parent.getServers().add(serverData, false);
                }
            }
            parent.getServers().save();
            parent.serverRenderableList.updateServers();
            this.onClose();
        };
    }

    public void repositionElements() {
        String string = this.ipBox.getValue();
        String string2 = this.nameBox.getValue();
        super.repositionElements();
        this.ipBox.setValue(string);
        this.nameBox.setValue(string2);
    }

    @Override
    protected void init() {
        super.init();
        this.nameBox = new EditBox(this.font, this.width / 2 - 100, this.panel.y + 47, 200, 20, (Component)Component.empty());
        this.ipBox = new EditBox(this.font, this.width / 2 - 100, this.panel.y + 87, 200, 20, (Component)Component.translatable((String)"addServer.enterIp"));
        this.nameBox.setValue(this.serverData.name);
        this.ipBox.setValue(this.serverData.ip);
        this.ipBox.setMaxLength(128);
        this.nameBox.setResponder(s -> this.updateAddButtonStatus());
        this.ipBox.setResponder(s -> this.updateAddButtonStatus());
        this.addRenderableWidget((GuiEventListener)this.nameBox);
        this.addRenderableWidget((GuiEventListener)this.ipBox);
        this.addRenderableWidget((GuiEventListener)new LegacySliderButton<ServerData.ServerPackStatus>(this.width / 2 - 100, this.panel.y + 112, 200, 16, b -> b.getDefaultMessage((Component)Component.translatable((String)"addServer.resourcePack"), ((ServerData.ServerPackStatus)b.getObjectValue()).getName()), b -> null, this.serverData.getResourcePackStatus(), () -> Arrays.stream(ServerData.ServerPackStatus.values()).toList(), b -> this.serverData.setResourcePackStatus((ServerData.ServerPackStatus)b.objectValue)));
        this.setInitialFocus((GuiEventListener)this.nameBox);
        this.updateAddButtonStatus();
    }

    @Override
    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        super.render(guiGraphics, i, j, f);
        guiGraphics.drawString(this.font, this.ipBox.getMessage(), this.panel.x + 15, this.panel.y + 73, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
    }

    private void updateAddButtonStatus() {
        this.okButton.active = ServerAddress.isValidAddress((String)this.ipBox.getValue()) && !this.nameBox.getValue().isEmpty();
    }
}

