/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.factoryapi.util.CompoundTagUtil;
import wily.legacy.inventory.LegacyMerchantOffer;

@Mixin(value={MerchantOffer.class})
public abstract class MerchantOfferMixin
implements LegacyMerchantOffer {
    private int requiredLevel;

    @Shadow
    public abstract ItemStack getResult();

    @Redirect(method={"<clinit>"}, at=@At(value="INVOKE", target="Lcom/mojang/serialization/codecs/RecordCodecBuilder;create(Ljava/util/function/Function;)Lcom/mojang/serialization/Codec;", remap=false))
    private static Codec<MerchantOffer> init(Function<RecordCodecBuilder.Instance<MerchantOffer>, ? extends App<RecordCodecBuilder.Mu<MerchantOffer>, MerchantOffer>> builder) {
        return RecordCodecBuilder.create(instance -> instance.group((App)ItemCost.CODEC.fieldOf("buy").forGetter(MerchantOffer::getItemCostA), (App)ItemCost.CODEC.lenientOptionalFieldOf("buyB").forGetter(MerchantOffer::getItemCostB), (App)ItemStack.CODEC.fieldOf("sell").forGetter(MerchantOffer::getResult), (App)Codec.INT.lenientOptionalFieldOf("uses", (Object)0).forGetter(MerchantOffer::getUses), (App)Codec.INT.lenientOptionalFieldOf("maxUses", (Object)4).forGetter(MerchantOffer::getMaxUses), (App)Codec.BOOL.lenientOptionalFieldOf("rewardExp", (Object)true).forGetter(MerchantOffer::shouldRewardExp), (App)Codec.INT.lenientOptionalFieldOf("specialPrice", (Object)0).forGetter(MerchantOffer::getSpecialPriceDiff), (App)Codec.INT.lenientOptionalFieldOf("demand", (Object)0).forGetter(MerchantOffer::getDemand), (App)Codec.FLOAT.lenientOptionalFieldOf("priceMultiplier", (Object)Float.valueOf(0.0f)).forGetter(MerchantOffer::getPriceMultiplier), (App)Codec.INT.lenientOptionalFieldOf("xp", (Object)1).forGetter(MerchantOffer::getXp), (App)Codec.INT.lenientOptionalFieldOf("requiredLevel", (Object)0).forGetter(o -> ((LegacyMerchantOffer)o).getRequiredLevel())).apply((Applicative)instance, (a, b, c, d, e, f, g, h, i, j, k) -> {
            MerchantOffer offer = new MerchantOffer(a, b, c, d.intValue(), e.intValue(), j.intValue(), i.floatValue(), h.intValue());
            ((LegacyMerchantOffer)offer).setRequiredLevel((int)k);
            offer.rewardExp = f;
            offer.setSpecialPriceDiff(g.intValue());
            return offer;
        }));
    }

    @Inject(method={"createFromStream"}, at={@At(value="RETURN")})
    private static void createFromStream(RegistryFriendlyByteBuf registryFriendlyByteBuf, CallbackInfoReturnable<MerchantOffer> cir) {
        CompoundTag copy;
        Optional requiredLevel;
        MerchantOffer offer = (MerchantOffer)cir.getReturnValue();
        int level = 0;
        CustomData data = (CustomData)offer.getResult().get(DataComponents.CUSTOM_DATA);
        if (data != null && (requiredLevel = CompoundTagUtil.getInt((CompoundTag)(copy = data.copyTag()), (String)"requiredLevel")).isPresent()) {
            level = (Integer)requiredLevel.get();
            copy.remove("requiredLevel");
            if (copy.isEmpty()) {
                offer.getResult().set(DataComponents.CUSTOM_DATA, null);
            }
        }
        ((LegacyMerchantOffer)offer).setRequiredLevel(level);
    }

    @Redirect(method={"writeToStream"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/codec/StreamCodec;encode(Ljava/lang/Object;Ljava/lang/Object;)V", ordinal=1, remap=false))
    private static void writeFromStream(StreamCodec<RegistryFriendlyByteBuf, ItemStack> instance, Object b, Object i, RegistryFriendlyByteBuf buf, MerchantOffer offer) {
        ItemStack result = offer.getResult().copy();
        CompoundTag customData = result.has(DataComponents.CUSTOM_DATA) ? ((CustomData)result.get(DataComponents.CUSTOM_DATA)).copyTag() : new CompoundTag();
        customData.putInt("requiredLevel", ((LegacyMerchantOffer)offer).getRequiredLevel());
        result.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)customData));
        instance.encode((Object)buf, (Object)result);
    }

    @Inject(method={"copy"}, at={@At(value="RETURN")})
    private void copy(CallbackInfoReturnable<MerchantOffer> cir) {
        ((LegacyMerchantOffer)cir.getReturnValue()).setRequiredLevel(this.requiredLevel);
    }

    @Override
    public void setRequiredLevel(int requiredLevel) {
        this.requiredLevel = requiredLevel;
    }

    @Override
    public int getRequiredLevel() {
        return this.requiredLevel;
    }
}

